/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JComboBoxBinding;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.rb.command.RbClearBstAuSwUpgradeParams;
import com.bwanms.rb.command.RbClearBstSuSwUpgradeParams;
import com.bwanms.rb.gui.configuration.SwMBSUpgradeSettingsPanel;
import com.bwanms.rb.gui.configuration.SwUpgradeSettingsConfigForm;
import com.bwanms.rb.mo.RbSwRegisteredSuEntry;
import com.bwanms.rb.mo.RbSwRegisteredSuTable;
import com.bwanms.rb.mo.RbSwUpgrade;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FormUtil;
import com.bwanms.util.MacAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwMBSUpgradeSettingsConfigForm
extends ManagedObjectsConfigForm<SwMBSUpgradeSettingsPanel> {
    private static final Logger logger = Logger.getLogger(SwUpgradeSettingsConfigForm.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(SwUpgradeSettingsConfigForm.class);

    protected List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("BS", RbSwUpgrade.class));
        ret.add(this.ctx.createRequest("BS", RbSwRegisteredSuTable.class));
        return ret;
    }

    public void clearAllBstAuSwUpgradeParams() {
        RbClearBstAuSwUpgradeParams command = new RbClearBstAuSwUpgradeParams();
        command.setRbBstClearAllAuSwUpgradeParams(2);
        command.setEquipmentId(this.ctx.getEquipment().getId());
        this.fireCommand(command);
    }

    public void clearAllBstSuSwUpgradeParams() {
        RbClearBstSuSwUpgradeParams command = new RbClearBstSuSwUpgradeParams();
        command.setRbBstClearAllSuSwUpgradeParams(2);
        command.setEquipmentId(this.ctx.getEquipment().getId());
        this.fireCommand(command);
    }

    protected SwMBSUpgradeSettingsPanel initUIComponent() {
        SwMBSUpgradeSettingsPanel panel = new SwMBSUpgradeSettingsPanel(this);
        return panel;
    }

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        DefaultBinder binder = new DefaultBinder((Object)this.getUI(), managedObjects.get(0));
        binder.add((Binding)new JComboBoxBinding(i18n, "cmbCPE16siActivation", "RbSwSuSiDefaultAction"));
        binders.add((Binder)binder);
    }

    public void fillUI(List<Object> managedObjects) {
        RbSwUpgrade swUpgrade = (RbSwUpgrade)((Object)managedObjects.get(0));
        if (swUpgrade != null) {
            String[] auFiles = this.getFiles(swUpgrade.getRbSwAuFiles());
            String[] suFiles = this.getFiles(swUpgrade.getRbSwSuFiles());
            JComboBox<String> auFilesCombo = new JComboBox<String>(auFiles);
            auFilesCombo.addItem(i18n.translateString("none"));
            JComboBox<String> suFilesCombo = new JComboBox<String>(suFiles);
            suFilesCombo.addItem(i18n.translateString("none"));
            this.fillComboBox(swUpgrade.getRbSwSuSiDefaultFile(), suFiles, ((SwMBSUpgradeSettingsPanel)this.getUI()).getCmbCPE16siFileName());
            FormUtil.cancelTableEditing((JTable)((SwMBSUpgradeSettingsPanel)this.getUI()).getTblCPE());
            ((SwMBSUpgradeSettingsPanel)this.getUI()).getTblCPE().getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(suFilesCombo));
            ((SwMBSUpgradeSettingsPanel)this.getUI()).getTblCPEModel().clearTable();
            RbSwRegisteredSuTable swRegisteredSuTable = (RbSwRegisteredSuTable)((Object)managedObjects.get(1));
            if (swRegisteredSuTable != null) {
                int row = 0;
                for (RbSwRegisteredSuEntry entry : swRegisteredSuTable.getEntries()) {
                    int col = 0;
                    ((SwMBSUpgradeSettingsPanel)this.getUI()).getTblCPEModel().addNewRow(entry.getRowKey(), true);
                    ((SwMBSUpgradeSettingsPanel)this.getUI()).getTblCPEModel().setInitialValueAt((Object)entry.getRbSuSysName(), row, col++);
                    ((SwMBSUpgradeSettingsPanel)this.getUI()).getTblCPEModel().setInitialValueAt((Object)MacAddress.fromOctetString((String)entry.getRbSuMacAddr()).toString(), row, col++);
                    if (entry.getRbSuUpgradeSwFileName().trim().length() == 0 || swUpgrade.getRbSwSuFiles().indexOf(entry.getRbSuUpgradeSwFileName()) == -1) {
                        ((SwMBSUpgradeSettingsPanel)this.getUI()).getTblCPEModel().setInitialValueAt((Object)i18n.translateString("none"), row, col++);
                    } else {
                        ((SwMBSUpgradeSettingsPanel)this.getUI()).getTblCPEModel().setInitialValueAt((Object)entry.getRbSuUpgradeSwFileName(), row, col++);
                    }
                    ((SwMBSUpgradeSettingsPanel)this.getUI()).getTblCPEModel().setInitialValueAt((Object)entry.getRbSuUnitControl(), row, col);
                    ((SwMBSUpgradeSettingsPanel)this.getUI()).getTblCPEModel().setRowState(row++, 0);
                }
            }
            ((SwMBSUpgradeSettingsPanel)this.getUI()).getTblCPEModel().sort();
        }
    }

    private String[] getFiles(String files) {
        StringTokenizer filesTokenizer = new StringTokenizer(files, ";");
        String[] ret = new String[filesTokenizer.countTokens()];
        int i = 0;
        while (filesTokenizer.hasMoreTokens()) {
            String fileName = filesTokenizer.nextToken();
            if (fileName == null) continue;
            ret[i++] = fileName;
        }
        return ret;
    }

    private void fillComboBox(String defaultFile, String[] files, JComboBox combo) {
        boolean addDefault = true;
        combo.removeAllItems();
        combo.addItem(i18n.translateString("none"));
        for (String file : files) {
            if (file.equals(defaultFile)) {
                addDefault = false;
            }
            combo.addItem(file);
        }
        if (addDefault && defaultFile != null && defaultFile.trim().length() != 0) {
            combo.addItem(defaultFile);
        }
        combo.setSelectedItem(defaultFile);
    }

    protected void configureMOs(List<Object> managedObjects) {
        RbSwUpgrade swUpgrade = (RbSwUpgrade)((Object)managedObjects.get(0));
        String fileName = ((SwMBSUpgradeSettingsPanel)this.getUI()).getCmbCPE16siFileName().getSelectedItem().toString();
        swUpgrade.setRbSwSuSiDefaultFile(fileName.equals(i18n.translateString("none")) ? "" : fileName);
        SimpleRowTableModel model = ((SwMBSUpgradeSettingsPanel)this.getUI()).getTblCPEModel();
        FormUtil.stopTableEditing((JTable)((SwMBSUpgradeSettingsPanel)this.getUI()).getTblCPE());
        RbSwRegisteredSuTable suTable = (RbSwRegisteredSuTable)((Object)managedObjects.get(1));
        for (int i = 0; i < model.getRowCount(); ++i) {
            if (model.getRowState(i) != 3) continue;
            RbSwRegisteredSuEntry entry = (RbSwRegisteredSuEntry)suTable.findEntry(MacAddress.fromDashedString((String)model.getValueAt(i, 1).toString()).toOctetString());
            if (entry != null) {
                entry.setRbSuUpgradeSwFileName((String)model.getValueAt(i, 2));
                entry.setRbSuUnitControl((Integer)model.getValueAt(i, 3));
                continue;
            }
            logger.error((Object)("SwUpgradeSettingsConfigForm - configureMOs(List) - System inconsistency. The modified RbSwRegisteredSuEntry at line " + (i + 1) + " was already removed from system."));
        }
    }

    public String getHelpTopic() {
        return "ngnms.rb.help.bs_tdd_software_upgrade_settings";
    }
}

