/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.View;
import com.bwanms.gui.binding.translators.MACAddressTranslator;
import com.bwanms.gui.binding.translators.TranslateException;
import com.bwanms.gui.configuration.ConfigApplicationView;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.FormsConfigSectionView;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.mo.DuplicateEntryException;
import com.bwanms.mo.EquipmentConfiguration;
import com.bwanms.mo.TableRowMO;
import com.bwanms.rb.ddi.RbRegisteredSuEntryAssemblerFactory;
import com.bwanms.rb.gui.configuration.SubscriberUnitsPanel;
import com.bwanms.rb.mo.RbRegisteredSuEntry;
import com.bwanms.rb.mo.RbRegisteredSuTable;
import com.bwanms.rb.mo.services.RbServiceConfigEntry;
import com.bwanms.rb.mo.services.RbServiceConfigTable;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FormUtil;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.MacAddress;
import com.bwanms.util.PlatformConfiguration;
import com.bwanms.util.TableUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriberUnitsConfigForm
extends ManagedObjectsConfigForm<SubscriberUnitsPanel> {
    private static final Logger log = Logger.getLogger(SubscriberUnitsConfigForm.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(SubscriberUnitsConfigForm.class);
    private List<RbRegisteredSuEntry> entrys;
    private String filterString = "";
    private KeyAdapter theListener = new KeyAdapter(){

        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                JComponent comp = (JComponent)e.getComponent();
                JFrame frame = (JFrame)comp.getTopLevelAncestor();
                frame.dispose();
            }
        }
    };

    public SubscriberUnitsPanel initUIComponent() {
        return this.getFormPanel(true);
    }

    protected SubscriberUnitsPanel getFormPanel(boolean auColFlag) {
        final SubscriberUnitsPanel subscriberUnitsPanel = new SubscriberUnitsPanel(auColFlag);
        subscriberUnitsPanel.setOpenAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SubscriberUnitsConfigForm.this.actionOpenSU();
            }
        });
        subscriberUnitsPanel.getTxtFilter().getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
            }

            public void insertUpdate(DocumentEvent e) {
                this.updateTable(e);
            }

            public void removeUpdate(DocumentEvent e) {
                this.updateTable(e);
            }

            private void updateTable(DocumentEvent e) {
                try {
                    SubscriberUnitsConfigForm.this.filterString = e.getDocument().getText(0, e.getDocument().getLength()).trim().toUpperCase();
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
                SubscriberUnitsConfigForm.this.fillTableRows();
            }
        });
        subscriberUnitsPanel.getCmbFilterBy().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                subscriberUnitsPanel.getCmbRegistrationStatus().setVisible(((JComboBox)e.getSource()).getSelectedIndex() == 2);
                subscriberUnitsPanel.getCmbPermanenceStatus().setVisible(((JComboBox)e.getSource()).getSelectedIndex() == 3);
                subscriberUnitsPanel.getTxtFilter().setVisible(!subscriberUnitsPanel.getCmbRegistrationStatus().isVisible() && !subscriberUnitsPanel.getCmbPermanenceStatus().isVisible());
                subscriberUnitsPanel.revalidate();
                SubscriberUnitsConfigForm.this.fillTableRows();
            }
        });
        subscriberUnitsPanel.getCmbRegistrationStatus().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SubscriberUnitsConfigForm.this.fillTableRows();
            }
        });
        subscriberUnitsPanel.getCmbPermanenceStatus().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SubscriberUnitsConfigForm.this.fillTableRows();
            }
        });
        return subscriberUnitsPanel;
    }

    public List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("BS", RbRegisteredSuTable.class));
        ret.add(this.ctx.createRequest("BS", RbServiceConfigTable.class));
        return ret;
    }

    public void fillUI(List<Object> managedObjects) {
        this.entrys = ((RbRegisteredSuTable)((Object)managedObjects.get(0))).getEntries();
        this.fillTableRows();
        ((SubscriberUnitsPanel)this.getUI()).getBtnAdd().setEnabled(true);
    }

    private void fillTableRows() {
        SubscriberUnitsPanel panel = (SubscriberUnitsPanel)this.getUI();
        if (this.entrys != null) {
            SimpleRowTableModel model = panel.getTable2Model();
            FormUtil.cancelTableEditing((JTable)panel.getTable2());
            model.clearTable();
            int row = 0;
            for (RbRegisteredSuEntry entry : this.entrys) {
                String stringMacAddress = MacAddress.fromOctetString((String)entry.getRbSuMacAddr()).toString();
                String stringRbAuId = entry.getRbAuId() != 255 ? String.valueOf(entry.getRbAuId()) : i18n.translateString("none");
                if (!(panel.getCmbFilterBy().getSelectedIndex() != 2 && panel.getCmbFilterBy().getSelectedIndex() != 3 && (this.filterString == null || this.filterString.length() == 0 || panel.getCmbFilterBy().getSelectedIndex() == 0 && entry.getRbSuSysName().toUpperCase().indexOf(this.filterString) != -1 || panel.getCmbFilterBy().getSelectedIndex() == 1 && stringMacAddress.toUpperCase().indexOf(this.filterString.toUpperCase()) != -1 || panel.getCmbFilterBy().getSelectedIndex() == 4 && stringRbAuId.toUpperCase().indexOf(this.filterString.toUpperCase()) != -1) || panel.getCmbFilterBy().getSelectedIndex() == 2 && entry.getRbSuRegistrationState().equals(((ComboItem)panel.getCmbRegistrationStatus().getSelectedItem()).getValue())) && (panel.getCmbFilterBy().getSelectedIndex() != 3 || !entry.getRbSuPersistence().equals(((ComboItem)panel.getCmbPermanenceStatus().getSelectedItem()).getValue()))) continue;
                int col = 0;
                model.addNewRow(entry.getRbSuMacAddr(), true);
                log.debug((Object)("Adding instance " + entry.getRbSuMacAddr()));
                model.setInitialValueAt((Object)(row + 1), row, col++);
                model.setInitialValueAt((Object)entry.getRbSuSysName(), row, col++);
                model.setInitialValueAt((Object)stringMacAddress, row, col++);
                model.setInitialValueAt((Object)entry.getRbSuRegistrationState(), row, col++);
                model.setInitialValueAt((Object)entry.getRbSuPersistence(), row, col++);
                if (((SubscriberUnitsPanel)this.getUI()).getTable2Model().findColumn(i18n.translateString("AssociatedAU")) == col) {
                    model.setInitialValueAt((Object)stringRbAuId, row, col++);
                }
                ++row;
            }
            panel.getLblStatus().setText(i18n.translateString("displayedUnitsOf", new Object[]{row, this.entrys.size()}));
            model.sort();
        } else {
            panel.getLblStatus().setText(i18n.translateString("noUnitsToDisplay"));
        }
        TableUtil.autoResizeColumn((JTable)((SubscriberUnitsPanel)this.getUI()).getTable2(), (int)0, (boolean)true);
        FormsConfigSectionView formsConfigSectionView = (FormsConfigSectionView)this.getConfigSectionView();
        String rowKey = String.valueOf(formsConfigSectionView.getAttribute("subscriberUnitId"));
        if (rowKey != null) {
            String dottedRowKey = null;
            try {
                MacAddress macAddress = MacAddress.fromDashedString((String)rowKey);
                dottedRowKey = macAddress.toOctetString();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (dottedRowKey != null) {
                for (int i = 0; i < ((SubscriberUnitsPanel)this.getUI()).getTable2Model().getRowCount(); ++i) {
                    if (!dottedRowKey.equals(((SubscriberUnitsPanel)this.getUI()).getTable2Model().getRowKey(i))) continue;
                    TableUtil.selectAndScrollToRow((JTable)((SubscriberUnitsPanel)this.getUI()).getTable2(), (int)i);
                    break;
                }
            }
        }
    }

    protected void configureMOs(List<Object> managedObjects, List<InvalidValue> invalidValues) {
        SimpleRowTableModel model = ((SubscriberUnitsPanel)this.getUI()).getTable2Model();
        FormUtil.stopTableEditing((JTable)((SubscriberUnitsPanel)this.getUI()).getTable2());
        ArrayList<RbRegisteredSuEntry> temporarySuUnassociated = new ArrayList<RbRegisteredSuEntry>();
        temporarySuUnassociated.clear();
        RbRegisteredSuTable table = (RbRegisteredSuTable)((Object)managedObjects.get(0));
        block9: for (int i = 0; i < model.getRowCount(); ++i) {
            String instance;
            block25: {
                instance = "";
                if (model.getValueAt(i, 2) != null) {
                    try {
                        int firstBit;
                        String mac = (String)model.getValueAt(i, 2);
                        new MACAddressTranslator().convertToBeanValue((Object)mac);
                        if (mac.equals("00-00-00-00-00-00".trim())) {
                            invalidValues.add(new InvalidValue(i18n.translateString("subscriberUnitsInvalidMACAddress", new Object[]{String.valueOf(i + 1)}), RbRegisteredSuEntry.class, "MAC", (Object)((String)model.getValueAt(i, 2)), (Object)this));
                        }
                        if ((firstBit = Integer.parseInt(mac.substring(0, 1), 16)) <= 7) break block25;
                        invalidValues.add(new InvalidValue(i18n.translateString("subscriberUnitsInvalidMACAddress", new Object[]{String.valueOf(i + 1)}), RbRegisteredSuEntry.class, "MAC", (Object)((String)model.getValueAt(i, 2)), (Object)this));
                        break block25;
                    }
                    catch (TranslateException e) {
                        invalidValues.add(new InvalidValue(i18n.translateString("subscriberUnitsInvalidMACAddress", new Object[]{String.valueOf(i + 1)}), RbRegisteredSuEntry.class, "MAC", (Object)((String)model.getValueAt(i, 2)), (Object)this));
                        continue;
                    }
                }
                invalidValues.add(new InvalidValue(i18n.translateString("subscriberUnitsInvalidMACAddress", new Object[]{String.valueOf(i + 1)}), RbRegisteredSuEntry.class, "MAC", (Object)"", (Object)this));
                continue;
            }
            instance = MacAddress.fromString((String)((String)model.getValueAt(i, 2))).toOctetString();
            log.debug((Object)("Instance is :" + instance));
            RbServiceConfigEntry service = null;
            switch (model.getRowState(i)) {
                case 3: {
                    RbRegisteredSuEntry entry = (RbRegisteredSuEntry)table.findEntry(instance);
                    log.debug((Object)("Retreiving instance " + instance));
                    Integer permanenceStatus = (Integer)model.getValueAt(i, 4);
                    service = this.checkServicesForSubscriber(entry, (RbServiceConfigTable)((Object)managedObjects.get(1)));
                    if (Integer.valueOf(1).equals(permanenceStatus)) {
                        if (permanenceStatus != null && !permanenceStatus.equals(entry.getRbSuPersistence()) && service != null) {
                            invalidValues.add(new InvalidValue(i18n.translateString("cpeHasServicesDefined"), RbRegisteredSuEntry.class, i18n.translateString("operationOnCpe"), (Object)entry.getRbSuSysName(), null));
                            permanenceStatus = entry.getRbSuPersistence();
                        } else if (entry.getRbAuId() == 255) {
                            temporarySuUnassociated.add(entry);
                        }
                    }
                    entry.setRbSuPersistence(permanenceStatus);
                    continue block9;
                }
                case 1: {
                    RbRegisteredSuEntry entry = (RbRegisteredSuEntry)table.findEntry(instance);
                    if (entry != null) {
                        if (Integer.valueOf(2).equals(entry.getRbSuRegistrationState())) {
                            invalidValues.add(new InvalidValue(i18n.translateString("SubscriberRegistredCantBeDeleted"), RbRegisteredSuEntry.class, "", (Object)entry.getRbSuSysName(), null));
                            continue block9;
                        }
                        service = this.checkServicesForSubscriber(entry, (RbServiceConfigTable)((Object)managedObjects.get(1)));
                    }
                    if (service == null) {
                        table.removeEntry(instance);
                        continue block9;
                    }
                    invalidValues.add(new InvalidValue(i18n.translateString("subscriberHasService", new Object[]{entry.getRbSuSysName(), service.getRbServiceName()}), RbRegisteredSuEntry.class, "", (Object)"", null));
                    continue block9;
                }
                case 2: {
                    RbRegisteredSuEntry entry = new RbRegisteredSuEntry();
                    entry.setRbSuMacAddr(instance);
                    entry.setRbSuPersistence((Integer)model.getValueAt(i, 4));
                    try {
                        table.addEntry((TableRowMO)entry);
                        continue block9;
                    }
                    catch (DuplicateEntryException deea) {
                        invalidValues.add(new InvalidValue(i18n.translateString("entryAlreadyInTable"), RbRegisteredSuEntry.class, "rbSuMacAddr", model.getValueAt(i, 2), null));
                    }
                }
            }
        }
        if (temporarySuUnassociated.size() != 0) {
            StringBuffer sb = new StringBuffer();
            if (temporarySuUnassociated.size() == 1) {
                sb.append(i18n.translateString("theFollowingSuIsNotAssociatedAndWillBeRemovedPermanently"));
            } else {
                sb.append(i18n.translateString("theFollowingSuAreNotAssociatedAndWillBeRemovedPermanently"));
                int n = temporarySuUnassociated.size() - 1;
                for (int i = 0; i < n; ++i) {
                    sb.append(" " + ((RbRegisteredSuEntry)((Object)temporarySuUnassociated.get(i))).getRbSuSysName() + ",");
                }
            }
            sb.append(" " + ((RbRegisteredSuEntry)((Object)temporarySuUnassociated.get(temporarySuUnassociated.size() - 1))).getRbSuSysName() + ".");
            boolean yesOption = this.showWarning(sb.toString()) == 0;
            int n = temporarySuUnassociated.size();
            for (int i = 0; i < n; ++i) {
                if (yesOption) {
                    ((RbRegisteredSuEntry)((Object)temporarySuUnassociated.get(i))).setRbSuSysName(null);
                    continue;
                }
                ((RbRegisteredSuEntry)((Object)temporarySuUnassociated.get(i))).getChangeStrategy().reset();
            }
        }
    }

    private RbServiceConfigEntry checkServicesForSubscriber(RbRegisteredSuEntry entry, RbServiceConfigTable table) {
        for (RbServiceConfigEntry service : table.getEntries()) {
            if (!service.getRbServiceSuMacAddress().toLowerCase().equals(entry.getRbSuMacAddr().toLowerCase())) continue;
            return service;
        }
        return null;
    }

    public String getTitle() {
        return "SubscriberUnits";
    }

    public String getHelpTopic() {
        return "ngnms.rb.help.subscriber_units";
    }

    public void actionOpenSU() {
        block10: {
            SimpleRowTableModel model = ((SubscriberUnitsPanel)this.getUI()).getTable2Model();
            int row = ((SubscriberUnitsPanel)this.getUI()).getTable2().getSelectedRow();
            if (row < 0 || row >= model.getRowCount()) {
                return;
            }
            String euid = (String)model.getValueAt(row, 2);
            String name = (String)model.getValueAt(row, 1);
            try {
                new MACAddressTranslator().convertToBeanValue((Object)euid);
                String instance = MacAddress.fromDashedString((String)euid).toOctetString();
                euid = MacAddress.fromDashedString((String)euid).toSimpleString();
                RbRegisteredSuEntry entry = null;
                for (RbRegisteredSuEntry e : this.entrys) {
                    if (!instance.equals(e.getRowKey())) continue;
                    entry = e;
                    break;
                }
                try {
                    RbRegisteredSuEntryAssemblerFactory.RbRegisteredSuAssembly assembly = (RbRegisteredSuEntryAssemblerFactory.RbRegisteredSuAssembly)ServiceRegistry.getEntityManagerService().get(RbRegisteredSuEntry.class, entry.getId(), null);
                    EquipmentConfiguration configuration = assembly.getSu().findCurrentConfiguration();
                    if (null == configuration) {
                        throw new RuntimeException("Configuration does not exist for equipment with euid = " + euid);
                    }
                    if (PlatformConfiguration.isLocalPlatform()) {
                        JComponent component = (JComponent)((SubscriberUnitsPanel)this.getUI()).getComponent(0);
                        JFrame cfr_ignored_0 = (JFrame)component.getTopLevelAncestor();
                        Frame[] frames = JFrame.getFrames();
                        boolean isUnique = true;
                        for (int i = 0; i < frames.length; ++i) {
                            if (!frames[i].getTitle().equals(name) || !frames[i].isVisible()) continue;
                            frames[i].setState(0);
                            frames[i].toFront();
                            isUnique = false;
                        }
                        if (isUnique) {
                            this.createSUFrame(name, configuration);
                        }
                        break block10;
                    }
                    this.createSUFrame(name, configuration);
                }
                catch (ServiceException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
            catch (TranslateException e) {
                FrameUtil.showAlert((JComponent)this.getUI(), (String)e.getMessage());
            }
        }
    }

    private void createSUFrame(String name, EquipmentConfiguration configuration) {
        JFrame frame = FrameUtil.createFrame();
        FrameUtil.runFrame((JFrame)frame, (String)name, (View)new ConfigApplicationView(configuration), (int)1024, (int)768, (boolean)true);
        if (PlatformConfiguration.isLocalPlatform()) {
            FrameUtil.addKeyListenerRecursively((Component)frame, (KeyAdapter)this.theListener);
        }
    }

    public int showWarning(String message) {
        Object[] options = new String[]{i18n.translateString("Yes"), i18n.translateString("No")};
        JTextArea jta = new JTextArea();
        jta.setBorder(null);
        jta.setEditable(false);
        jta.setWrapStyleWord(true);
        jta.setLineWrap(true);
        jta.setText(message);
        jta.setOpaque(false);
        JScrollPane jsp = new JScrollPane(jta);
        jsp.setPreferredSize(new Dimension(250, 50));
        jsp.setBorder(null);
        jta.setSelectionStart(0);
        jta.setSelectionEnd(0);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)jsp, "Center");
        panel.add((Component)new JLabel(i18n.translateString("DoYouWantToProceed")), "South");
        return JOptionPane.showOptionDialog(this.getUI(), panel, i18n.translateString("Warning"), 0, 2, null, options, options[0]);
    }
}

