/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.binding.ReadOnlyBinder;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.rb.gui.configuration.SuUnitControlPanel;
import com.bwanms.rb.mo.RbLicenseBankEntry;
import com.bwanms.rb.mo.RbLicenseBankTable;
import com.bwanms.rb.mo.RbRegisteredSuEntry;
import com.bwanms.rb.mo.RbRegisteredSuTable;
import com.bwanms.rb.mo.RbSuLicenseCommand;
import com.bwanms.rb.mo.RbSuLicensesTable;
import com.bwanms.rb.mo.RbSwUpgrade;
import com.bwanms.rb.model.RbSU;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.util.FormUtil;
import com.bwanms.util.MacAddress;
import com.bwanms.util.MessageBox;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuUnitControlConfigForm
extends ManagedObjectsConfigForm<SuUnitControlPanel> {
    private static final Log log = LogFactory.getLog(SuUnitControlConfigForm.class);
    private String shadowFileName = null;
    private RbSU su;

    public List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest(((RbSU)this.ctx.getEquipment()).getManagerBS().getId(), "BS", RbSwUpgrade.class));
        ret.add(this.ctx.createRequest(((RbSU)this.ctx.getEquipment()).getManagerBS().getId(), "BS", RbRegisteredSuTable.class));
        if (this.hasLimittedCapabilities()) {
            ret.add(this.ctx.createRequest("SU", RbSuLicensesTable.class));
            ret.add(this.ctx.createRequest(((RbSU)this.ctx.getEquipment()).getManagerBS().getId(), "BS", RbLicenseBankTable.class));
        }
        return ret;
    }

    protected SuUnitControlPanel initUIComponent() {
        SuUnitControlPanel suPanel = new SuUnitControlPanel(this);
        this.su = (RbSU)this.ctx.getEquipment();
        if (!this.hasLimittedCapabilities()) {
            suPanel.getBtnLicense().setVisible(false);
            suPanel.getSprLicense().setVisible(false);
            suPanel.getLblLicense().setVisible(false);
        }
        return suPanel;
    }

    private boolean hasLimittedCapabilities() {
        return this.su != null && this.su.hasLimittedCapabilities();
    }

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        if (this.su == null) {
            return;
        }
        RbRegisteredSuTable cfgTbl = (RbRegisteredSuTable)((Object)managedObjects.get(1));
        ReadOnlyBinder binder = new ReadOnlyBinder((Object)this.getUI(), (Object)cfgTbl.findEntry(MacAddress.fromSimpleString((String)this.su.getMacAddress()).toOctetString()));
        binder.add((Binding)new JTextFieldBinding("txtRuningSwVersion", "runingSwVersion"));
        binder.add((Binding)new JTextFieldBinding("txtMainSwVersion", "rbSuOperSwVersion"));
        binder.add((Binding)new JTextFieldBinding("txtShadowSwVersion", "rbSuShadowSwVersion"));
        binders.add((Binder)binder);
    }

    public void reset() {
        if (this.su != null) {
            this.fireCommand(this.su.createResetCommand());
        }
    }

    public void perform() {
        int cmd = (Integer)((ComboItem)((SuUnitControlPanel)this.getUI()).getCmbAction().getSelectedItem()).getValue();
        String fileName = (String)FormUtil.getSelectedValue((JComboBox)((SuUnitControlPanel)this.getUI()).getCmbFileName());
        if (this.su != null) {
            if (cmd == 3 && fileName.equalsIgnoreCase("")) {
                MessageBox.Info.showOption((Component)this.getUI(), SuUnitControlPanel.i18n.translateString("CannotLoadVersionToShadow") + "\n" + SuUnitControlPanel.i18n.translateString("VersionIsEmpty"));
                return;
            }
            if (cmd == 4 && fileName.equals("")) {
                fileName = this.shadowFileName;
            }
            if (cmd == 5 && fileName.equals("")) {
                fileName = this.shadowFileName;
            }
            this.fireCommand(this.su.createCommand(cmd, fileName));
        }
    }

    public void makeLicenseUnlimited() {
        if (this.su != null) {
            RbSuLicenseCommand command = new RbSuLicenseCommand();
            command.setEquipmentId(this.su.getId());
            command.setRbSuMacAddr(MacAddress.fromSimpleString((String)this.su.getMacAddress()).toOctetString());
            command.setRbSuLicenseIdx(1);
            command.setRbSuLicenseId(1);
            command.setRbSuLicenseValue(0L);
            this.fireCommand(command);
        }
    }

    public void loadFactoryDflt() {
        if (this.su != null) {
            this.fireCommand(this.su.createLoadFactoryDfltCommand());
        }
    }

    public void fillUI(List<Object> managedObjects) {
        if (this.hasLimittedCapabilities()) {
            RbSuLicensesTable licenseTable = (RbSuLicensesTable)((Object)managedObjects.get(2));
            if (licenseTable.getEntries().isEmpty()) {
                ((SuUnitControlPanel)this.getUI()).getBtnLicense().setEnabled(true);
            } else {
                ((SuUnitControlPanel)this.getUI()).getBtnLicense().setEnabled(false);
            }
            RbLicenseBankTable bsBankTable = (RbLicenseBankTable)((Object)managedObjects.get(3));
            String key = String.valueOf(1) + "." + String.valueOf(0L);
            RbLicenseBankEntry bsBankEntry = (RbLicenseBankEntry)bsBankTable.findEntry(key);
            if (bsBankEntry == null || bsBankEntry.getRbLicenseCount() == 0L) {
                ((SuUnitControlPanel)this.getUI()).getLblLicense().setText(SuUnitControlPanel.i18n.translateString("NoAvailableLicenses"));
                ((SuUnitControlPanel)this.getUI()).getBtnLicense().setEnabled(false);
            } else {
                ((SuUnitControlPanel)this.getUI()).getLblLicense().setText(SuUnitControlPanel.i18n.translateString("LicenseCount", new Object[]{bsBankEntry.getRbLicenseCount()}));
            }
        }
        RbSwUpgrade swUpgrade = (RbSwUpgrade)((Object)managedObjects.get(0));
        RbRegisteredSuTable cfgTbl = (RbRegisteredSuTable)((Object)managedObjects.get(1));
        int oldSelectedIndex = ((SuUnitControlPanel)this.getUI()).getCmbFileName().getSelectedIndex();
        ((SuUnitControlPanel)this.getUI()).getCmbFileName().removeAllItems();
        ((SuUnitControlPanel)this.getUI()).getCmbFileName().addItem(new ComboItem((Object)"", SuUnitControlPanel.i18n.translateString("none")));
        if (swUpgrade != null && swUpgrade.getRbSwSuFiles().trim().length() > 0) {
            String[] fileNames;
            for (String fileName : fileNames = swUpgrade.getRbSwSuFiles().split(";")) {
                ((SuUnitControlPanel)this.getUI()).getCmbFileName().addItem(new ComboItem((Object)fileName, fileName));
            }
        }
        if (oldSelectedIndex != -1) {
            ((SuUnitControlPanel)this.getUI()).getCmbFileName().setSelectedIndex(oldSelectedIndex);
        }
        RbRegisteredSuEntry suEntry = null;
        if (null != this.su) {
            suEntry = (RbRegisteredSuEntry)cfgTbl.findEntry(MacAddress.fromSimpleString((String)this.su.getMacAddress()).toOctetString());
            this.shadowFileName = suEntry.getRbSuShadowSwFileName();
        }
        if (this.su == null || suEntry == null || !suEntry.isConnected() || Integer.valueOf(5).equals(suEntry.getRbSuFaultStatus())) {
            this.enableForm(false);
            ((SuUnitControlPanel)this.getUI()).getTxtStatus().setText(SuUnitControlPanel.i18n.translateString("disconnected"));
        } else {
            this.enableForm(true);
            ((SuUnitControlPanel)this.getUI()).getTxtStatus().setText(SuUnitControlPanel.i18n.translateString("connected"));
        }
    }

    private void enableForm(boolean enabled) {
        ((SuUnitControlPanel)this.getUI()).getLblMainSwVersion().setEnabled(enabled);
        ((SuUnitControlPanel)this.getUI()).getLblRuningSwVersion().setEnabled(enabled);
        ((SuUnitControlPanel)this.getUI()).getLblShadowSwVersion().setEnabled(enabled);
        ((SuUnitControlPanel)this.getUI()).getBtnReset().setEnabled(enabled);
        ((SuUnitControlPanel)this.getUI()).getBtnPerform().setEnabled(enabled);
        ((SuUnitControlPanel)this.getUI()).getBtnLoadFactoryDefaults().setEnabled(enabled);
        ((SuUnitControlPanel)this.getUI()).getCmbAction().setEnabled(enabled);
        ((SuUnitControlPanel)this.getUI()).getCmbFileName().setEnabled(enabled);
    }

    public boolean canApply() {
        return false;
    }

    protected void handleDisconnectedEquipment() {
        this.enableForm(false);
        ((SuUnitControlPanel)this.getUI()).getTxtStatus().setText(SuUnitControlPanel.i18n.translateString("disconnected"));
    }

    public String getHelpTopic() {
        if (VersionFactory.getInstance().createVersion(((RbSU)this.ctx.getEquipment()).getManagerBS().getRunningSoftwareVersion()).isOlderThan((Version)new DefaultVersion("4.0"))) {
            return "ngnms.rb.help.su_unit_control";
        }
        return "ngnms.rb.help.su_tdd_unit_control";
    }
}

