/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.binding.ReadOnlyBinder;
import com.bwanms.gui.binding.translators.ParserValueTranslator;
import com.bwanms.gui.binding.translators.TranslateException;
import com.bwanms.gui.binding.translators.ValueTranslator;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.rb.gui.configuration.SuSummaryPanelSw25;
import com.bwanms.rb.mo.RbRegisteredSuEntry;
import com.bwanms.rb.mo.RbRegisteredSuSummaryEntry;
import com.bwanms.rb.mo.RbSiSuInfoEntry;
import com.bwanms.rb.mo.RbSuBestBstAuParamsEntry;
import com.bwanms.rb.mo.RbSuFreqScanningEntry;
import com.bwanms.rb.mo.RbSuHwComponentsInfoSummaryEntry;
import com.bwanms.rb.mo.RbSuMultirateParametersGroup;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbSU;
import com.bwanms.rb.util.RbVersions;
import com.bwanms.util.MacAddress;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuSummaryConfigFormSw25
extends ManagedObjectsConfigForm<SuSummaryPanelSw25> {
    private static final double DIVIDE_BY_10_CT = 10.0;
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(SuSummaryConfigFormSw25.class);
    private static final Log logger = LogFactory.getLog(SuSummaryConfigFormSw25.class);

    public SuSummaryPanelSw25 initUIComponent() {
        boolean isIpCsMode = ((RbSU)this.ctx.getEquipment()).getManagerBS().getSwitchingMode() == RbBaseStationEquipment.SWITCHING_MODE_IP_CS;
        boolean isVersion45 = ((RbSU)this.ctx.getEquipment()).getSoftwareVersion().compareTo((Object)RbVersions.V_4_5) >= 0;
        return new SuSummaryPanelSw25(isIpCsMode, isVersion45);
    }

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        ReadOnlyBinder binder = new ReadOnlyBinder((Object)this.getUI(), managedObjects.get(0));
        binder.add((Binding)new JTextFieldBinding("txtCumulativePowerOnTime", "rbSuCumulativePowerOnTime", (ValueTranslator)new ValueTranslator<Long, String>(){

            public String convertToUIValue(Long beanValue) throws TranslateException {
                if (beanValue == 0L) {
                    return i18n.translateString("unknown");
                }
                return beanValue.toString();
            }

            public Long convertToBeanValue(String uiBeanValue) throws TranslateException {
                return null;
            }
        }));
        binder.add((Binding)new JTextFieldBinding("txtID", "rbSuID", (ValueTranslator)new ParserValueTranslator(Integer.class)));
        binders.add((Binder)binder);
    }

    public ArrayList<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("SU", RbRegisteredSuSummaryEntry.class));
        ret.add(this.ctx.createRequest("SU", RbSuMultirateParametersGroup.class));
        ret.add(this.ctx.createRequest("SU", RbSuHwComponentsInfoSummaryEntry.class));
        ret.add(this.ctx.createRequest("SU", RbSuFreqScanningEntry.class));
        ret.add(this.ctx.createRequest("SU", RbSuBestBstAuParamsEntry.class));
        if (((RbSU)this.ctx.getEquipment()).isSI()) {
            ret.add(this.ctx.createRequest("SU", RbSiSuInfoEntry.class));
        }
        return ret;
    }

    public void fillUI(List<Object> managedObjects) {
        RbSU su;
        RbRegisteredSuSummaryEntry entry = (RbRegisteredSuSummaryEntry)managedObjects.get(0);
        RbSuFreqScanningEntry suFreq = null;
        if (managedObjects.size() > 3) {
            suFreq = (RbSuFreqScanningEntry)((Object)managedObjects.get(3));
        }
        RbSuMultirateParametersGroup multirateParams = null;
        if (managedObjects.size() > 1) {
            multirateParams = (RbSuMultirateParametersGroup)((Object)managedObjects.get(1));
        }
        if ((su = (RbSU)this.ctx.getEquipment()) != null) {
            RbSuHwComponentsInfoSummaryEntry hwInfo = null;
            if (managedObjects.size() > 2) {
                hwInfo = (RbSuHwComponentsInfoSummaryEntry)((Object)managedObjects.get(2));
            }
            RbSuBestBstAuParamsEntry bestAu = null;
            if (managedObjects.size() > 4) {
                bestAu = (RbSuBestBstAuParamsEntry)((Object)managedObjects.get(4));
            }
            RbSiSuInfoEntry siSuEntry = null;
            if (managedObjects.size() > 5) {
                siSuEntry = (RbSiSuInfoEntry)managedObjects.get(5);
            }
            if (entry != null) {
                ((SuSummaryPanelSw25)this.getUI()).getTxtMAC().setText(MacAddress.fromOctetString((String)entry.getRbSuMacAddr()).toString());
                ((SuSummaryPanelSw25)this.getUI()).getTxtName().setText(entry.getRbSuSysName());
                ((SuSummaryPanelSw25)this.getUI()).getTxtPermanenceStatus().setText(i18n.translateString(RbRegisteredSuEntry.toStringRbSuPersistence(entry.getRbSuPersistence())));
                ((SuSummaryPanelSw25)this.getUI()).getTxtRegistrationStatus().setText(i18n.translateString(entry.toStringRbSuRegistrationState(entry.getRbSuRegistrationState())));
                ((SuSummaryPanelSw25)this.getUI()).getTxtFaultStatus().setText(i18n.translateString(entry.toStringRbSuFaultStatus(entry.getRbSuFaultStatus())));
                ((SuSummaryPanelSw25)this.getUI()).getTxtSWVersion().setText(i18n.translateString(entry.toStringRbSuRunningSoftware(entry.getRbSuRunningSoftware())));
                ((SuSummaryPanelSw25)this.getUI()).getTxtSWVersion().setSelectionStart(0);
                ((SuSummaryPanelSw25)this.getUI()).getTxtSWVersion().setSelectionEnd(0);
                ((SuSummaryPanelSw25)this.getUI()).getTxtOperationalSwVersion().setText(entry.getRbSuOperSwVersion());
                ((SuSummaryPanelSw25)this.getUI()).getTxtOperationalSwVersion().setSelectionStart(0);
                ((SuSummaryPanelSw25)this.getUI()).getTxtOperationalSwVersion().setSelectionEnd(0);
                ((SuSummaryPanelSw25)this.getUI()).getTxtShadowSwVersion().setText(entry.getRbSuShadowSwVersion());
                ((SuSummaryPanelSw25)this.getUI()).getTxtShadowSwVersion().setSelectionStart(0);
                ((SuSummaryPanelSw25)this.getUI()).getTxtShadowSwVersion().setSelectionEnd(0);
                ((SuSummaryPanelSw25)this.getUI()).getTxtAUID().setText(entry.getRbAuId().toString());
                ((SuSummaryPanelSw25)this.getUI()).getTxtSerial().setText(entry.getRbSuSerialNo());
                if (((RbSU)this.ctx.getEquipment()).getManagerBS().getSwitchingMode() == RbBaseStationEquipment.SWITCHING_MODE_ETHERNET_CS) {
                    ((SuSummaryPanelSw25)this.getUI()).getTxtIDUType().setText(i18n.translateString(entry.toStringRbSuIduType(entry.getRbSuIduType())));
                    ((SuSummaryPanelSw25)this.getUI()).getTxtNrOfGateways().setText(entry.getRbSuExternalDevNumber().toString());
                } else {
                    ((SuSummaryPanelSw25)this.getUI()).getTxtIDUType().setText(i18n.translateString("NA"));
                    ((SuSummaryPanelSw25)this.getUI()).getTxtNrOfGateways().setText(i18n.translateString("NA"));
                }
                ((SuSummaryPanelSw25)this.getUI()).getTxtHWRevision().setText(entry.getRbSuHwRevision());
                ((SuSummaryPanelSw25)this.getUI()).getTxtHWDesc().setText(entry.getRbSuHwConfigDescription());
                String serviceFaultStatus = "";
                for (String status : entry.getRbSuServiceFaultStatus().split(";")) {
                    if (serviceFaultStatus.length() > 0) {
                        serviceFaultStatus = serviceFaultStatus + "; ";
                    }
                    serviceFaultStatus = serviceFaultStatus + i18n.translateString(status);
                }
                ((SuSummaryPanelSw25)this.getUI()).getTxtServiceFaultStatus().setText(serviceFaultStatus);
                if (hwInfo != null) {
                    ((SuSummaryPanelSw25)this.getUI()).getTxtBootRevision().setText(hwInfo.getRbSuBootVersion());
                    ((SuSummaryPanelSw25)this.getUI()).getTxtRFRevision().setText(hwInfo.getRbSuRfCardRevision());
                    ((SuSummaryPanelSw25)this.getUI()).getTxtCpeType().setText(i18n.translateString(RbSuHwComponentsInfoSummaryEntry.toStringRbSuType(hwInfo.getRbSuType())));
                }
                ((SuSummaryPanelSw25)this.getUI()).getTxtAirInterfaceType().setText(i18n.translateString(RbRegisteredSuEntry.toStringRbSuAirInterfaceType(su.getOperationMode())));
            }
            if (suFreq != null) {
                ((SuSummaryPanelSw25)this.getUI()).getTxtBandwidth().setText(i18n.translateString(RbSuFreqScanningEntry.toStringRbSuCurrentBandwidth(suFreq.getRbSuCurrentBandwidth())));
            }
            if (bestAu != null) {
                ((SuSummaryPanelSw25)this.getUI()).getTxtRxFrequency().setText(bestAu.getRbSuSelectedRxFrequency());
            }
            if (multirateParams != null) {
                ((SuSummaryPanelSw25)this.getUI()).getTxtTxPower().setText(multirateParams.getRbSuTxPower());
                ((SuSummaryPanelSw25)this.getUI()).getTxtEstimatedDist().setText(multirateParams.getRbSuEstDistance().toString());
                ((SuSummaryPanelSw25)this.getUI()).getTxtUplinkSNR().setText(multirateParams.getRbSuUlSNR());
                ((SuSummaryPanelSw25)this.getUI()).getTxtUplinkRSSI().setText(multirateParams.getRbSuUlRSSI());
                ((SuSummaryPanelSw25)this.getUI()).getTxtUplinkRate().setText(i18n.translateString(RbSuMultirateParametersGroup.toStringRbSuUlCurrentRate(multirateParams.getRbSuUlCurrentRate())));
                ((SuSummaryPanelSw25)this.getUI()).getTxtDownlinkSNR().setText(multirateParams.getRbSuDlSNR());
                ((SuSummaryPanelSw25)this.getUI()).getTxtDownlinkRSSI().setText(multirateParams.getRbSuDlRSSI());
                ((SuSummaryPanelSw25)this.getUI()).getTxtDownlinkRate().setText(i18n.translateString(RbSuMultirateParametersGroup.toStringRbSuDlCurrentRate(multirateParams.getRbSuDlCurrentRate())));
                Version softwareVersion = ((RbSU)this.ctx.getEquipment()).getSoftwareVersion();
                if (RbVersions.V_4_5.isOlderOrEqualWith(softwareVersion)) {
                    JTextField txtChannel1 = ((SuSummaryPanelSw25)this.getUI()).getTxtChannel1();
                    Double rbSuUlCh1RSSIValue2 = (double)multirateParams.getRbSuUlCh1RSSIValue().intValue() / 10.0;
                    String rbSuUlCh1RSSIValue = "";
                    if (null != rbSuUlCh1RSSIValue2) {
                        rbSuUlCh1RSSIValue = rbSuUlCh1RSSIValue2.toString();
                    }
                    txtChannel1.setText(rbSuUlCh1RSSIValue);
                    JTextField txtChannel2 = ((SuSummaryPanelSw25)this.getUI()).getTxtChannel2();
                    Double rbSuUlCh2RSSIValue2 = (double)multirateParams.getRbSuUlCh2RSSIValue().intValue() / 10.0;
                    String rbSuUlCh2RSSIValue = "";
                    if (null != rbSuUlCh2RSSIValue2) {
                        rbSuUlCh2RSSIValue = rbSuUlCh2RSSIValue2.toString();
                    }
                    txtChannel2.setText(rbSuUlCh2RSSIValue.toString());
                    JTextField txtChannel3 = ((SuSummaryPanelSw25)this.getUI()).getTxtChannel3();
                    Double rbSuUlCh3RSSIValue2 = (double)multirateParams.getRbSuUlCh3RSSIValue().intValue() / 10.0;
                    String rbSuUlCh3RSSIValue = "";
                    if (null != rbSuUlCh3RSSIValue2) {
                        rbSuUlCh3RSSIValue = rbSuUlCh3RSSIValue2.toString();
                    }
                    txtChannel3.setText(rbSuUlCh3RSSIValue);
                    JTextField txtChannel4 = ((SuSummaryPanelSw25)this.getUI()).getTxtChannel4();
                    Double rbSuUlCh4RSSIValue2 = (double)multirateParams.getRbSuUlCh4RSSIValue().intValue() / 10.0;
                    String rbSuUlCh4RSSIValue = "";
                    if (null != rbSuUlCh4RSSIValue2) {
                        rbSuUlCh4RSSIValue = rbSuUlCh4RSSIValue2.toString();
                    }
                    txtChannel4.setText(rbSuUlCh4RSSIValue);
                }
            }
            if (Integer.valueOf(5).equals(entry.getRbSuFaultStatus())) {
                String translatedUnknown = i18n.translateString("unknown");
                ((SuSummaryPanelSw25)this.getUI()).getTxtSmartCardStatus().setText(translatedUnknown);
                ((SuSummaryPanelSw25)this.getUI()).getTxtAntennaSelection().setText(translatedUnknown);
                ((SuSummaryPanelSw25)this.getUI()).getTxtInterfaceType().setText(translatedUnknown);
            } else {
                this.siParamsVisibility(siSuEntry != null);
            }
            if (siSuEntry != null) {
                ((SuSummaryPanelSw25)this.getUI()).getTxtAntennaSelection().setText(i18n.translateString(RbSiSuInfoEntry.toStringRbSiSuAntennaSelection(siSuEntry.getRbSiSuAntennaSelection())));
                ((SuSummaryPanelSw25)this.getUI()).getTxtSmartCardStatus().setText(i18n.translateString(RbSiSuInfoEntry.toStringRbSiSuSmartCardStatus(siSuEntry.getRbSiSuSmartCardStatus())));
                ((SuSummaryPanelSw25)this.getUI()).getTxtInterfaceType().setText(i18n.translateString(RbSiSuInfoEntry.toStringRbSiSuInterfaceType(siSuEntry.getRbSiSuInterfaceType())));
            }
        }
    }

    private void siParamsVisibility(boolean b) {
        ((SuSummaryPanelSw25)this.getUI()).getTxtSmartCardStatus().setVisible(b);
        ((SuSummaryPanelSw25)this.getUI()).getTxtAntennaSelection().setVisible(b);
        ((SuSummaryPanelSw25)this.getUI()).getTxtInterfaceType().setVisible(b);
        ((SuSummaryPanelSw25)this.getUI()).getLblSmartCardStatus().setVisible(b);
        ((SuSummaryPanelSw25)this.getUI()).getLblAntennaSelection().setVisible(b);
        ((SuSummaryPanelSw25)this.getUI()).getLblInterfaceType().setVisible(b);
        ((SuSummaryPanelSw25)this.getUI()).getSprSIParameters().setVisible(b);
    }

    public String getTitle() {
        return "SuSummaryForm";
    }

    public boolean canApply() {
        return false;
    }

    public String getHelpTopic() {
        if (VersionFactory.getInstance().createVersion(((RbSU)this.ctx.getEquipment()).getManagerBS().getRunningSoftwareVersion()).isOlderThan((Version)new DefaultVersion("4.0"))) {
            return "ngnms.rb.help.su_general_parameters";
        }
        return "ngnms.rb.help.su_tdd_general_parameters";
    }
}

