/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.binding.ReadOnlyBinder;
import com.bwanms.gui.binding.translators.ParserValueTranslator;
import com.bwanms.gui.binding.translators.TranslateException;
import com.bwanms.gui.binding.translators.ValueTranslator;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.rb.gui.configuration.SuSummaryPanel;
import com.bwanms.rb.mo.RbRegisteredSuEntry;
import com.bwanms.rb.mo.RbRegisteredSuSummaryEntry;
import com.bwanms.rb.mo.RbSuHwComponentsInfoSummaryEntry;
import com.bwanms.rb.mo.RbSuMultirateParametersGroup;
import com.bwanms.rb.mo.RbSuPhyParametersGroup;
import com.bwanms.rb.model.RbSU;
import com.bwanms.util.MacAddress;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuSummaryConfigForm
extends ManagedObjectsConfigForm<SuSummaryPanel> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(SuSummaryConfigForm.class);

    public SuSummaryPanel initUIComponent() {
        return new SuSummaryPanel();
    }

    public List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("SU", RbSuPhyParametersGroup.class));
        ret.add(this.ctx.createRequest("SU", RbSuMultirateParametersGroup.class));
        ret.add(this.ctx.createRequest(RbRegisteredSuSummaryEntry.class));
        ret.add(this.ctx.createRequest("SU", RbSuHwComponentsInfoSummaryEntry.class));
        return ret;
    }

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        ReadOnlyBinder binder = new ReadOnlyBinder((Object)this.getUI(), managedObjects.get(2));
        binder.add((Binding)new JTextFieldBinding("txtCumulativePowerOnTime", "rbSuCumulativePowerOnTime", (ValueTranslator)new ValueTranslator<Long, String>(){

            public String convertToUIValue(Long beanValue) throws TranslateException {
                if (beanValue == 0L) {
                    return i18n.translateString("unknown");
                }
                return beanValue.toString();
            }

            public Long convertToBeanValue(String uiBeanValue) throws TranslateException {
                return null;
            }
        }));
        binder.add((Binding)new JTextFieldBinding("txtID", "rbSuID", (ValueTranslator)new ParserValueTranslator(Integer.class)));
        binders.add((Binder)binder);
    }

    public void fillUI(List<Object> managedObjects) {
        RbSuPhyParametersGroup phyParams = (RbSuPhyParametersGroup)((Object)managedObjects.get(0));
        RbSuMultirateParametersGroup multirateParams = (RbSuMultirateParametersGroup)((Object)managedObjects.get(1));
        if (this.ctx.getEquipment() != null) {
            RbRegisteredSuSummaryEntry entry = (RbRegisteredSuSummaryEntry)managedObjects.get(2);
            RbSuHwComponentsInfoSummaryEntry hwInfo = (RbSuHwComponentsInfoSummaryEntry)((Object)managedObjects.get(3));
            if (entry != null) {
                ((SuSummaryPanel)this.getUI()).getTxtMAC().setText(MacAddress.fromOctetString((String)entry.getRbSuMacAddr()).toString());
                ((SuSummaryPanel)this.getUI()).getTxtName().setText(entry.getRbSuSysName());
                ((SuSummaryPanel)this.getUI()).getTxtPermanenceStatus().setText(i18n.translateString(RbRegisteredSuEntry.toStringRbSuPersistence(entry.getRbSuPersistence())));
                ((SuSummaryPanel)this.getUI()).getTxtRegistrationStatus().setText(i18n.translateString(entry.toStringRbSuRegistrationState(entry.getRbSuRegistrationState())));
                ((SuSummaryPanel)this.getUI()).getTxtFaultStatus().setText(i18n.translateString(entry.toStringRbSuFaultStatus(entry.getRbSuFaultStatus())));
                ((SuSummaryPanel)this.getUI()).getTxtRunningSwVersion().setText(i18n.translateString(entry.toStringRbSuRunningSoftware(entry.getRbSuRunningSoftware())));
                ((SuSummaryPanel)this.getUI()).getTxtRunningSwVersion().setSelectionStart(0);
                ((SuSummaryPanel)this.getUI()).getTxtRunningSwVersion().setSelectionEnd(0);
                ((SuSummaryPanel)this.getUI()).getTxtOperationalSwVersion().setText(entry.getRbSuOperSwVersion());
                ((SuSummaryPanel)this.getUI()).getTxtOperationalSwVersion().setSelectionStart(0);
                ((SuSummaryPanel)this.getUI()).getTxtOperationalSwVersion().setSelectionEnd(0);
                ((SuSummaryPanel)this.getUI()).getTxtShadowSwVersion().setText(entry.getRbSuShadowSwVersion());
                ((SuSummaryPanel)this.getUI()).getTxtShadowSwVersion().setSelectionStart(0);
                ((SuSummaryPanel)this.getUI()).getTxtShadowSwVersion().setSelectionEnd(0);
                ((SuSummaryPanel)this.getUI()).getTxtAUID().setText(entry.getRbAuId().toString());
                ((SuSummaryPanel)this.getUI()).getTxtSerial().setText(entry.getRbSuSerialNo());
                ((SuSummaryPanel)this.getUI()).getTxtIDUType().setText(i18n.translateString(entry.toStringRbSuIduType(entry.getRbSuIduType())));
                ((SuSummaryPanel)this.getUI()).getTxtHWRevision().setText(entry.getRbSuHwRevision());
                ((SuSummaryPanel)this.getUI()).getTxtHWDesc().setText(entry.getRbSuHwConfigDescription());
                ((SuSummaryPanel)this.getUI()).getTxtNrOfGateways().setText(entry.getRbSuExternalDevNumber().toString());
                String serviceFaultStatus = "";
                for (String status : entry.getRbSuServiceFaultStatus().split(";")) {
                    if (serviceFaultStatus.length() > 0) {
                        serviceFaultStatus = serviceFaultStatus + "; ";
                    }
                    serviceFaultStatus = serviceFaultStatus + i18n.translateString(status);
                }
                ((SuSummaryPanel)this.getUI()).getTxtServiceFaultStatus().setText(serviceFaultStatus);
                ((SuSummaryPanel)this.getUI()).getTxtBootRevision().setText(hwInfo.getRbSuBootVersion());
                ((SuSummaryPanel)this.getUI()).getTxtRFRevision().setText(hwInfo.getRbSuRfCardRevision());
                ((SuSummaryPanel)this.getUI()).getTxtCpeType().setText(i18n.translateString(RbSuHwComponentsInfoSummaryEntry.toStringRbSuType(hwInfo.getRbSuType())));
            }
            if (phyParams != null) {
                ((SuSummaryPanel)this.getUI()).getTxtBandwidth().setText(i18n.translateString(RbSuPhyParametersGroup.toStringSuPhyCurrentBandwidth(phyParams.getSuPhyCurrentBandwidth())));
                ((SuSummaryPanel)this.getUI()).getTxtTxFreq().setText(phyParams.getSuPhyConfiguredTxFrequencyChannel());
            }
            if (multirateParams != null) {
                ((SuSummaryPanel)this.getUI()).getTxtTxPower().setText(multirateParams.getRbSuTxPower());
                ((SuSummaryPanel)this.getUI()).getTxtEstimatedDist().setText(multirateParams.getRbSuEstDistance().toString());
                ((SuSummaryPanel)this.getUI()).getTxtUplinkSNR().setText(multirateParams.getRbSuUlSNR());
                ((SuSummaryPanel)this.getUI()).getTxtUplinkRSSI().setText(multirateParams.getRbSuUlRSSI());
                ((SuSummaryPanel)this.getUI()).getTxtUplinkRate().setText(i18n.translateString(RbSuMultirateParametersGroup.toStringRbSuUlCurrentRate(multirateParams.getRbSuUlCurrentRate())));
                ((SuSummaryPanel)this.getUI()).getTxtDownlinkSNR().setText(multirateParams.getRbSuDlSNR());
                ((SuSummaryPanel)this.getUI()).getTxtDownlinkRSSI().setText(multirateParams.getRbSuDlRSSI());
                ((SuSummaryPanel)this.getUI()).getTxtDownlinkRate().setText(i18n.translateString(RbSuMultirateParametersGroup.toStringRbSuDlCurrentRate(multirateParams.getRbSuDlCurrentRate())));
            }
        }
    }

    public String getTitle() {
        return "SuSummaryForm";
    }

    public boolean canApply() {
        return false;
    }

    public String getHelpTopic() {
        if (VersionFactory.getInstance().createVersion(((RbSU)this.ctx.getEquipment()).getManagerBS().getRunningSoftwareVersion()).isOlderThan((Version)new DefaultVersion("4.0"))) {
            return "ngnms.rb.help.su_general_parameters";
        }
        return "ngnms.rb.help.tdd_su_general_parameters";
    }
}

