/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JComboBoxBinding;
import com.bwanms.gui.binding.JSpinnerBinding;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.binding.ReadOnlyBinder;
import com.bwanms.gui.binding.translators.ParserValueTranslator;
import com.bwanms.gui.binding.translators.TranslateException;
import com.bwanms.gui.binding.translators.ValueTranslator;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.mo.TableRowMO;
import com.bwanms.mo.snmp.StaticTableMO;
import com.bwanms.mo.snmp.StaticTableRowMO;
import com.bwanms.rb.command.RbSuRadioParametersCommand;
import com.bwanms.rb.gui.configuration.SuFrequencyScanningPanel402;
import com.bwanms.rb.mo.RbAuChannelConfigEntry;
import com.bwanms.rb.mo.RbAuChannelConfigTable;
import com.bwanms.rb.mo.RbFrequencyBandsEntry;
import com.bwanms.rb.mo.RbFrequencyBandsTable;
import com.bwanms.rb.mo.RbMBSTChannelConfigEntry;
import com.bwanms.rb.mo.RbMBSTChannelConfigTable;
import com.bwanms.rb.mo.RbMBSTFrequencyBandsEntry;
import com.bwanms.rb.mo.RbMBSTFrequencyBandsTable;
import com.bwanms.rb.mo.RbOduConfigEntry;
import com.bwanms.rb.mo.RbOduConfigTable;
import com.bwanms.rb.mo.RbSuFreqScanningEntry;
import com.bwanms.rb.mo.RbSuPhyParametersGroup;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbMBS;
import com.bwanms.rb.model.RbSU;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FormUtil;
import com.bwanms.util.MacAddress;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuFrequencyScanningConfigForm402
extends ManagedObjectsConfigForm<SuFrequencyScanningPanel402> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(SuFrequencyScanningPanel402.class);
    private int cfgBandwidth = -1;
    private Long startRxFreqLowerLimit = null;
    private Long endRxFreqLowerLimit = 0L;
    private Long startRxFreqUpperLimit = null;
    private Long endRxFreqUpperLimit = 0L;
    private Long freqBandStep = null;
    private boolean initCompleted = false;
    private boolean swUnder4115;

    public String getTitle() {
        return "FrequencyScanning";
    }

    protected List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("SU", RbSuFreqScanningEntry.class));
        if (new DefaultVersion("4.0.2").isNewerThan(((RbSU)this.ctx.getEquipment()).getManagerBS().getSoftwareVersion())) {
            ret.add(this.ctx.createRequest("SU", RbSuPhyParametersGroup.class));
        }
        RbBaseStationEquipment bs = ((RbSU)this.ctx.getEquipment()).getManagerBS();
        ret.add(this.ctx.createRequest(bs.getId(), "BS", bs instanceof RbBS ? RbAuChannelConfigTable.class : RbMBSTChannelConfigTable.class));
        ret.add(this.ctx.createRequest(bs.getId(), "BS", RbOduConfigTable.class));
        ret.add(this.ctx.createRequest(bs.getId(), "BS", bs instanceof RbBS ? RbFrequencyBandsTable.class : RbMBSTFrequencyBandsTable.class));
        return ret;
    }

    protected SuFrequencyScanningPanel402 initUIComponent() {
        SuFrequencyScanningPanel402 suFrequencyScanningPanel = new SuFrequencyScanningPanel402(this);
        this.swUnder4115 = ((RbSU)this.ctx.getEquipment()).getManagerBS().getSoftwareVersion().isOlderThan(VersionFactory.getInstance().createVersion("4.1.1.5"));
        suFrequencyScanningPanel.getSpnCfgScanningMainStep().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SuFrequencyScanningConfigForm402.this.check875KHz();
            }
        });
        suFrequencyScanningPanel.getChkCfg875KHz().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SuFrequencyScanningConfigForm402.this.check875KHz();
            }
        });
        ChangeListener spinnerChangeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SuFrequencyScanningConfigForm402.this.roundStep((JSpinner)e.getSource());
            }
        };
        suFrequencyScanningPanel.getSpnCfgScanningMainStep().addChangeListener(spinnerChangeListener);
        suFrequencyScanningPanel.getSpnCfgStartRxFrequency().addChangeListener(spinnerChangeListener);
        suFrequencyScanningPanel.getSpnCfgEndRxFrequency().addChangeListener(spinnerChangeListener);
        suFrequencyScanningPanel.getComboCfgBandwidth().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SuFrequencyScanningConfigForm402.this.comboCfgBandwidthChanged();
            }
        });
        return suFrequencyScanningPanel;
    }

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        ReadOnlyBinder binder = new ReadOnlyBinder((Object)this.getUI(), managedObjects.get(0));
        binder.add((Binding)new JTextFieldBinding("txtCrtBandwidth", "rbSuCurrentBandwidth", (ValueTranslator)new ParserValueTranslator<Integer>(Integer.class){

            public String convertToUIValue(Integer beanValue) {
                return i18n.translateString(RbSuFreqScanningEntry.toStringRbSuCurrentBandwidth(beanValue));
            }
        }, i18n.translateString("Bandwidth")));
        binder.add((Binding)new JTextFieldBinding("txtCrtStartRxFrequency", "rbSuCurrentScanStartFreq", i18n.translateString("ScanningStartFrequency")));
        binder.add((Binding)new JTextFieldBinding("txtCrtEndRxFrequency", "rbSuCurrentScanEndFreq", i18n.translateString("ScanningEndFrequency")));
        binder.add((Binding)new JTextFieldBinding("txtCrtScanningMainStep", "rbSuCurrentScanStep", (ValueTranslator)new ParserValueTranslator<String>(String.class){

            public String convertToUIValue(String beanValue) {
                try {
                    Float f = Float.valueOf(Float.valueOf(beanValue).floatValue() * 1000.0f);
                    return String.valueOf(f.intValue());
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }, i18n.translateString("ScanningMainStep")));
        binders.add((Binder)binder);
        binder = new DefaultBinder((Object)this.getUI(), managedObjects.get(0));
        binder.add((Binding)new JComboBoxBinding(i18n, "comboCfgBandwidth", "rbSuConfiguredBandwidth", i18n.translateString("Bandwidth")));
        binder.add((Binding)new JSpinnerBinding("spnCfgStartRxFrequency", "rbSuConfiguredScanStartFreq", (ValueTranslator)new ValueTranslator<String, Float>(){

            public String convertToBeanValue(Float uiBeanValue) throws TranslateException {
                if ((double)(uiBeanValue.floatValue() - (float)uiBeanValue.intValue()) == 0.0) {
                    return String.format(Locale.ENGLISH, "%.0f", uiBeanValue);
                }
                return String.format(Locale.ENGLISH, "%.3f", uiBeanValue);
            }

            public Float convertToUIValue(String beanValue) throws TranslateException {
                try {
                    return Float.valueOf(beanValue);
                }
                catch (NumberFormatException e) {
                    throw new TranslateException((Throwable)e);
                }
            }
        }, i18n.translateString("ScanningStartFrequency")));
        binder.add((Binding)new JSpinnerBinding("spnCfgEndRxFrequency", "rbSuConfiguredScanEndFreq", (ValueTranslator)new ValueTranslator<String, Float>(){

            public String convertToBeanValue(Float uiBeanValue) throws TranslateException {
                if ((double)(uiBeanValue.floatValue() - (float)uiBeanValue.intValue()) == 0.0) {
                    return String.format(Locale.ENGLISH, "%.0f", uiBeanValue);
                }
                return String.format(Locale.ENGLISH, "%.3f", uiBeanValue);
            }

            public Float convertToUIValue(String beanValue) throws TranslateException {
                try {
                    return Float.valueOf(beanValue);
                }
                catch (NumberFormatException e) {
                    throw new TranslateException((Throwable)e);
                }
            }
        }, i18n.translateString("ScanningEndFrequency")));
        binder.add((Binding)new JSpinnerBinding("spnCfgScanningMainStep", "rbSuConfiguredScanStep", (ValueTranslator)new ValueTranslator<String, Float>(){

            public String convertToBeanValue(Float uiBeanValue) throws TranslateException {
                Float f = Float.valueOf(uiBeanValue.floatValue() / 1000.0f);
                if ((double)(f.floatValue() - (float)f.intValue()) == 0.0) {
                    return String.format(Locale.ENGLISH, "%.0f", f);
                }
                return String.format(Locale.ENGLISH, "%.3f", f);
            }

            public Float convertToUIValue(String beanValue) throws TranslateException {
                try {
                    return Float.valueOf(Float.valueOf(beanValue).floatValue() * 1000.0f);
                }
                catch (NumberFormatException e) {
                    throw new TranslateException((Throwable)e);
                }
            }
        }, i18n.translateString("ScanningMainStep")));
        binders.add((Binder)binder);
    }

    public void fillUI(List<Object> managedObjects) {
        Float startFreqValue = (Float)((SuFrequencyScanningPanel402)this.getUI()).getSpnCfgStartRxFrequency().getValue();
        if (((RbSU)this.ctx.getEquipment()).getManagerBS() instanceof RbMBS && startFreqValue.compareTo(Float.valueOf(Float.parseFloat("5150.0"))) >= 0 && startFreqValue.compareTo(Float.valueOf(Float.parseFloat("5350.0"))) <= 0) {
            ((SuFrequencyScanningPanel402)this.getUI()).enableMainStepIntermediateFreq(false);
        } else {
            ((SuFrequencyScanningPanel402)this.getUI()).enableMainStepIntermediateFreq(true);
        }
        this.initCompleted = false;
        if (this.ctx.getEquipment() != null) {
            Integer currentBandWidth;
            boolean softwarwUnder402;
            boolean bl = softwarwUnder402 = ((RbSU)this.ctx.getEquipment()).getManagerBS().getSoftwareVersion().compareTo((Object)new DefaultVersion("4.0.2")) < 0;
            if (this.startRxFreqLowerLimit == null) {
                this.setRbFrequencyBandsEntry(managedObjects);
                if (this.freqBandStep != null) {
                    ((SpinnerNumberModel)((SuFrequencyScanningPanel402)this.getUI()).getSpnCfgScanningMainStep().getModel()).setStepSize(this.freqBandStep);
                    ((SpinnerNumberModel)((SuFrequencyScanningPanel402)this.getUI()).getSpnCfgStartRxFrequency().getModel()).setStepSize(Float.valueOf(this.freqBandStep.floatValue() / 1000.0f));
                    ((SpinnerNumberModel)((SuFrequencyScanningPanel402)this.getUI()).getSpnCfgEndRxFrequency().getModel()).setStepSize(Float.valueOf(this.freqBandStep.floatValue() / 1000.0f));
                }
            }
            RbSuFreqScanningEntry freqEntry = (RbSuFreqScanningEntry)((Object)managedObjects.get(0));
            if (softwarwUnder402) {
                RbSuPhyParametersGroup phyParametersGroup = (RbSuPhyParametersGroup)((Object)managedObjects.get(1));
                this.cfgBandwidth = phyParametersGroup.getSuPhyConfiguredBandwidth();
                FormUtil.setSelectedValue((JComboBox)((SuFrequencyScanningPanel402)this.getUI()).getComboCfgBandwidth(), (Object)this.cfgBandwidth);
                ((SuFrequencyScanningPanel402)this.getUI()).getComboCfgBandwidth().setEnabled(false);
                currentBandWidth = phyParametersGroup.getSuPhyCurrentBandwidth();
                ((SuFrequencyScanningPanel402)this.getUI()).getTxtCrtBandwidth().setText(i18n.translateString(RbSuPhyParametersGroup.toStringSuPhyCurrentBandwidth(currentBandWidth)));
            } else {
                this.cfgBandwidth = freqEntry.getRbSuConfiguredBandwidth();
                currentBandWidth = freqEntry.getRbSuCurrentBandwidth();
            }
            FormUtil.setSelectedValue((JComboBox)((SuFrequencyScanningPanel402)this.getUI()).getComboCfgBandwidth(), (Object)this.cfgBandwidth);
            if (currentBandWidth != null) {
                switch (currentBandWidth) {
                    default: {
                        ((SuFrequencyScanningPanel402)this.getUI()).getChkCrt875KHz().setText(i18n.translateString("+875KHz"));
                        break;
                    }
                    case 3: 
                    case 5: {
                        ((SuFrequencyScanningPanel402)this.getUI()).getChkCrt875KHz().setText(i18n.translateString("+1250KHz"));
                    }
                }
            }
            if (freqEntry != null) {
                boolean flag;
                int i;
                int mask = Integer.valueOf(freqEntry.getRbSuCurrentScanMask(), 16);
                for (i = 0; i < ((SuFrequencyScanningPanel402)this.getUI()).getChkRbSuCurrentScanMask().size(); ++i) {
                    flag = (mask & (int)Math.pow(2.0, i)) != 0;
                    ((SuFrequencyScanningPanel402)this.getUI()).getChkRbSuCurrentScanMask().get(i).setSelected(flag);
                }
                mask = Integer.valueOf(freqEntry.getRbSuConfiguredScanMask(), 16);
                for (i = 0; i < ((SuFrequencyScanningPanel402)this.getUI()).getChkRbSuConfiguredScanMask().size(); ++i) {
                    flag = (mask & (int)Math.pow(2.0, i)) != 0;
                    ((SuFrequencyScanningPanel402)this.getUI()).getChkRbSuConfiguredScanMask().get(i).setSelected(flag);
                }
                SimpleRowTableModel tableModel = ((SuFrequencyScanningPanel402)this.getUI()).getTableModel();
                tableModel.clearTable();
                for (int i2 = 0; i2 < 10; ++i2) {
                    tableModel.addNewRow(String.valueOf(i2 + 1), true);
                    tableModel.setInitialValueAt((Object)(i2 + 1), i2, 0);
                    tableModel.setInitialValueAt((Object)freqEntry.getRbSuDiscreteF(i2 + 1), i2, 1);
                    if (this.swUnder4115) continue;
                    tableModel.setInitialValueAt((Object)freqEntry.getRbSuConfiguredDiscreteF(i2 + 1), i2, 2);
                }
                tableModel.sort();
            }
        }
        this.initCompleted = true;
    }

    protected void configureMOs(List<Object> managedObjects, List<InvalidValue> invalidValues) {
        RbSuFreqScanningEntry freqEntry = (RbSuFreqScanningEntry)((Object)managedObjects.get(0));
        int scanMask = 0;
        for (int i = 0; i < ((SuFrequencyScanningPanel402)this.getUI()).getChkRbSuConfiguredScanMask().size(); ++i) {
            if (!((SuFrequencyScanningPanel402)this.getUI()).getChkRbSuConfiguredScanMask().get(i).isSelected()) continue;
            scanMask = (int)((double)scanMask + Math.pow(2.0, i));
        }
        StringBuilder scanMaskString = new StringBuilder(Integer.toHexString(scanMask));
        if (scanMaskString.length() < 2) {
            scanMaskString.insert(0, '0');
        }
        freqEntry.setRbSuConfiguredScanMask(scanMaskString.toString());
        this.verifyStartEndScanningFrequency(invalidValues);
        this.verifyMainStepScanningFrequency(invalidValues);
        Integer configuredBandwidth = (Integer)FormUtil.getSelectedValue((JComboBox)((SuFrequencyScanningPanel402)this.getUI()).getComboCfgBandwidth());
        if (((SuFrequencyScanningPanel402)this.getUI()).getComboCfgBandwidth().isEnabled() && ((RbSU)this.ctx.getEquipment()).getManagerBS().getSoftwareVersion().compareTo((Object)new DefaultVersion("4.1")) < 0 && !Integer.valueOf(2).equals(configuredBandwidth) && !Integer.valueOf(3).equals(configuredBandwidth)) {
            invalidValues.add(new InvalidValue(i18n.translateString("InvalidValueForSoftwareVersionUnder41"), JComboBox.class, i18n.translateString("Bandwidth"), (Object)i18n.translateString(RbSuFreqScanningEntry.toStringRbSuConfiguredBandwidth(configuredBandwidth)), (Object)((SuFrequencyScanningPanel402)this.getUI()).getComboCfgBandwidth()));
        }
        SimpleRowTableModel model = ((SuFrequencyScanningPanel402)this.getUI()).getTableModel();
        FormUtil.stopTableEditing((JTable)((SuFrequencyScanningPanel402)this.getUI()).getTblDiscreteFreq());
        if (((RbSU)this.ctx.getEquipment()).getManagerBS().getSoftwareVersion().compareTo((Object)new DefaultVersion("4.1.1.5")) >= 0) {
            HashSet<String> frequnciesSet = new HashSet<String>();
            for (int i = 0; i < model.getRowCount(); ++i) {
                String frequency = String.valueOf(model.getValueAt(i, 2)).trim();
                if (!this.verifyDiscreteFrequency(invalidValues, frequency, String.valueOf(model.getValueAt(i, 0)))) continue;
                switch (model.getRowState(i)) {
                    case 3: {
                        freqEntry.setRbSuConfiguredDiscreteF(frequency, Integer.valueOf(model.getRowKey(i)));
                        break;
                    }
                    case 1: {
                        freqEntry.setRbSuConfiguredDiscreteF("", Integer.valueOf(model.getRowKey(i)));
                    }
                }
                if ("0".equals(freqEntry.getRbSuConfiguredDiscreteF(i + 1)) || frequnciesSet.add(freqEntry.getRbSuConfiguredDiscreteF(i + 1))) continue;
                invalidValues.add(new InvalidValue(i18n.translateString("CantHaveTheSameFrequencyTwice"), RbSuFreqScanningEntry.class, i18n.translateString("DiscreteFrequency"), (Object)freqEntry.getRbSuConfiguredDiscreteF(i + 1), null));
            }
        }
        managedObjects.remove(managedObjects.size() - 1);
        managedObjects.remove(managedObjects.size() - 1);
        managedObjects.remove(managedObjects.size() - 1);
    }

    public String getHelpTopic() {
        return "ngnms.rb.help.su_tdd_frequency_scan";
    }

    private void setRbFrequencyBandsEntry(List<Object> managedObjects) {
        block10: {
            String bandName;
            TableRowMO freqBandEntry;
            StaticTableMO bandsTable;
            block11: {
                StaticTableRowMO channelEntry;
                int i;
                int n;
                StaticTableMO auChannelTable;
                int slot = ((RbSU)this.ctx.getEquipment()).getServingAUId();
                RbOduConfigTable oduTable = (RbOduConfigTable)((Object)managedObjects.get(managedObjects.size() - 2));
                bandsTable = (StaticTableMO)managedObjects.get(managedObjects.size() - 1);
                RbOduConfigEntry oduEntry = null;
                boolean found = false;
                if (((RbSU)this.ctx.getEquipment()).getManagerBS() instanceof RbBS) {
                    auChannelTable = (RbAuChannelConfigTable)((Object)managedObjects.get(managedObjects.size() - 3));
                    n = auChannelTable.getEntries().size();
                    block0: for (i = 0; i < n && !found; ++i) {
                        channelEntry = (RbAuChannelConfigEntry)((Object)auChannelTable.getEntries().get(i));
                        if (channelEntry.getRbSlotNumber() != slot || Integer.valueOf(0).equals(channelEntry.getRbAuChannelOduActualFrequencyBand())) continue;
                        for (RbOduConfigEntry e : oduTable.getEntries()) {
                            if (!e.getRbOduConfigId().equals(channelEntry.getRbAuChannelAssociatedOduId())) continue;
                            oduEntry = e;
                            found = true;
                            continue block0;
                        }
                    }
                } else {
                    auChannelTable = (RbMBSTChannelConfigTable)((Object)managedObjects.get(managedObjects.size() - 3));
                    n = auChannelTable.getEntries().size();
                    block2: for (i = 0; i < n && !found; ++i) {
                        channelEntry = (RbMBSTChannelConfigEntry)((Object)auChannelTable.getEntries().get(i));
                        if (Integer.valueOf(0).equals(channelEntry.getRbMBSTChannelOduActualFrequencyBand())) continue;
                        for (RbOduConfigEntry e : oduTable.getEntries()) {
                            if (!e.getRbOduConfigId().equals(channelEntry.getRbMBSTChannelAssociatedOduId())) continue;
                            oduEntry = e;
                            found = true;
                            continue block2;
                        }
                    }
                }
                TableRowMO tableRowMO = freqBandEntry = oduEntry != null && oduEntry.getRbOduConfigFrequencyBand() != null ? bandsTable.findEntry(oduEntry.getRbOduConfigFrequencyBand().toString()) : null;
                if (freqBandEntry == null) break block10;
                bandName = null;
                if (!(freqBandEntry instanceof RbFrequencyBandsEntry)) break block11;
                RbFrequencyBandsEntry fbEntry = (RbFrequencyBandsEntry)freqBandEntry;
                bandName = fbEntry.getRbFrequencyBandName();
                this.freqBandStep = fbEntry.getRbFrequencyBandStep();
                this.startRxFreqLowerLimit = fbEntry.getRbFrequencyBandStartFrequency();
                this.startRxFreqUpperLimit = fbEntry.getRbFrequencyBandStopFrequency();
                this.endRxFreqLowerLimit = fbEntry.getRbFrequencyBandStartFrequency();
                this.endRxFreqUpperLimit = fbEntry.getRbFrequencyBandStopFrequency();
                RbFrequencyBandsTable rbFrequencyBandsTable = (RbFrequencyBandsTable)bandsTable;
                for (StaticTableRowMO entry : rbFrequencyBandsTable.getEntries()) {
                    if (!entry.getRbFrequencyBandGroupId().equals(fbEntry.getRbFrequencyBandGroupId())) continue;
                    if (entry.getRbFrequencyBandStartFrequency() < this.startRxFreqLowerLimit) {
                        this.startRxFreqLowerLimit = this.endRxFreqLowerLimit = entry.getRbFrequencyBandStartFrequency();
                    }
                    if (entry.getRbFrequencyBandStopFrequency() <= this.startRxFreqUpperLimit) continue;
                    this.startRxFreqUpperLimit = this.endRxFreqUpperLimit = entry.getRbFrequencyBandStopFrequency();
                }
                break block10;
            }
            if (!(freqBandEntry instanceof RbMBSTFrequencyBandsEntry)) break block10;
            RbMBSTFrequencyBandsEntry fbEntry = (RbMBSTFrequencyBandsEntry)freqBandEntry;
            bandName = fbEntry.getRbMBSTFrequencyBandName();
            this.freqBandStep = fbEntry.getRbMBSTFrequencyBandStep();
            this.startRxFreqLowerLimit = fbEntry.getRbMBSTFrequencyBandStartFrequency();
            this.startRxFreqUpperLimit = fbEntry.getRbMBSTFrequencyBandStopFrequency();
            this.endRxFreqLowerLimit = fbEntry.getRbMBSTFrequencyBandStartFrequency();
            this.endRxFreqUpperLimit = fbEntry.getRbMBSTFrequencyBandStopFrequency();
            RbMBSTFrequencyBandsTable rbMBSTFrequencyBandsTable = (RbMBSTFrequencyBandsTable)bandsTable;
            for (StaticTableRowMO entry : rbMBSTFrequencyBandsTable.getEntries()) {
                if (!entry.getRbMBSTFrequencyBandGroupId().equals(fbEntry.getRbMBSTFrequencyBandGroupId())) continue;
                if (entry.getRbMBSTFrequencyBandStartFrequency() < this.startRxFreqLowerLimit) {
                    this.startRxFreqLowerLimit = this.endRxFreqLowerLimit = entry.getRbMBSTFrequencyBandStartFrequency();
                    continue;
                }
                if (entry.getRbMBSTFrequencyBandStopFrequency() <= this.startRxFreqUpperLimit) continue;
                this.startRxFreqUpperLimit = this.endRxFreqUpperLimit = entry.getRbMBSTFrequencyBandStopFrequency();
            }
        }
    }

    private void check875KHz() {
        ((SuFrequencyScanningPanel402)this.getUI()).getChkCfg875KHz().setSelected(((SuFrequencyScanningPanel402)this.getUI()).getChkCfg875KHz().isSelected() || this.cfgBandwidth == 1 && ((Float)((SuFrequencyScanningPanel402)this.getUI()).getSpnCfgScanningMainStep().getValue()).intValue() == 1750);
    }

    private void roundStep(JSpinner spinner) {
        float intSpinnerStep;
        float intSpinnerValue;
        Number spinerValue = (Number)spinner.getValue();
        Number spinerStep = ((SpinnerNumberModel)spinner.getModel()).getStepSize();
        if (spinerValue != null && spinerStep != null && (intSpinnerValue = spinerValue.floatValue()) % (intSpinnerStep = spinerStep.floatValue()) != 0.0f) {
            spinner.setValue(Float.valueOf(intSpinnerValue - intSpinnerValue % intSpinnerStep));
        }
    }

    private void comboCfgBandwidthChanged() {
        Integer newCfgBandwidth = (Integer)FormUtil.getSelectedValue((JComboBox)((SuFrequencyScanningPanel402)this.getUI()).getComboCfgBandwidth());
        if (newCfgBandwidth != null) {
            this.cfgBandwidth = newCfgBandwidth;
            switch (this.cfgBandwidth) {
                case 2: {
                    ((SuFrequencyScanningPanel402)this.getUI()).getChkCfg875KHz().setText(i18n.translateString("+875KHz"));
                    if (!this.initCompleted) break;
                    ((SuFrequencyScanningPanel402)this.getUI()).getSpnCfgScanningMainStep().setValue(new Float(875.0f));
                    break;
                }
                case 3: {
                    ((SuFrequencyScanningPanel402)this.getUI()).getChkCfg875KHz().setText(i18n.translateString("+1250KHz"));
                    if (!this.initCompleted) break;
                    ((SuFrequencyScanningPanel402)this.getUI()).getSpnCfgScanningMainStep().setValue(new Float(2500.0f));
                    break;
                }
                case 5: {
                    ((SuFrequencyScanningPanel402)this.getUI()).getChkCfg875KHz().setText(i18n.translateString("+1250KHz"));
                    if (!this.initCompleted) break;
                    ((SuFrequencyScanningPanel402)this.getUI()).getSpnCfgScanningMainStep().setValue(new Float(5000.0f));
                    break;
                }
                default: {
                    ((SuFrequencyScanningPanel402)this.getUI()).getChkCfg875KHz().setText(i18n.translateString("+875KHz"));
                    if (!this.initCompleted) break;
                    ((SuFrequencyScanningPanel402)this.getUI()).getSpnCfgScanningMainStep().setValue(new Float(1750.0f));
                }
            }
        }
    }

    private void verifyStartEndScanningFrequency(List<InvalidValue> invalidValues) {
        Integer comboCfgBandwidth;
        boolean isBandwidthMultipleOf1_75 = this.cfgBandwidth != 3 && this.cfgBandwidth != 5;
        Float startFrequencyFloat = Float.valueOf(((Float)((SuFrequencyScanningPanel402)this.getUI()).getSpnCfgStartRxFrequency().getValue()).floatValue() * 1000.0f);
        long startRxFrequencyLong = startFrequencyFloat.longValue();
        Float endFrequencyFloat = Float.valueOf(((Float)((SuFrequencyScanningPanel402)this.getUI()).getSpnCfgEndRxFrequency().getValue()).floatValue() * 1000.0f);
        long endRxFrequencyLong = endFrequencyFloat.longValue();
        if (endRxFrequencyLong < startRxFrequencyLong) {
            invalidValues.add(new InvalidValue(i18n.translateString("ScanningStartFrequencyBiggerThanScanningEndFrequency"), JSpinner.class, i18n.translateString("ScanningEndFrequency"), ((SuFrequencyScanningPanel402)this.getUI()).getSpnCfgEndRxFrequency().getValue(), (Object)((SuFrequencyScanningPanel402)this.getUI()).getSpnCfgEndRxFrequency()));
        }
        if ((comboCfgBandwidth = (Integer)FormUtil.getSelectedValue((JComboBox)((SuFrequencyScanningPanel402)this.getUI()).getComboCfgBandwidth())) != null && this.startRxFreqLowerLimit != null && this.startRxFreqUpperLimit != null && this.freqBandStep != null) {
            double adjust = 0.0;
            switch (comboCfgBandwidth) {
                case 1: {
                    adjust = 0.875;
                    break;
                }
                case 2: {
                    adjust = 1.75;
                    break;
                }
                case 3: {
                    adjust = 2.5;
                    break;
                }
                case 4: {
                    adjust = 3.5;
                    break;
                }
                case 5: {
                    adjust = 5.0;
                }
            }
            long adjustLong = (long)(adjust * 1000.0);
            Long adjustedStartRxFreqLowerLimit = this.startRxFreqLowerLimit + adjustLong;
            Long adjustedStartRxFreqUpperLimit = this.startRxFreqUpperLimit - adjustLong;
            if (startRxFrequencyLong < adjustedStartRxFreqLowerLimit || startRxFrequencyLong > adjustedStartRxFreqUpperLimit || (startRxFrequencyLong - adjustedStartRxFreqLowerLimit) % this.freqBandStep != 0L) {
                invalidValues.add(new InvalidValue(i18n.translateString("ScanFrequencyValueBetween", new Object[]{adjustedStartRxFreqLowerLimit.doubleValue() / 1000.0, adjustedStartRxFreqUpperLimit.doubleValue() / 1000.0, this.freqBandStep.doubleValue() / 1000.0}), JSpinner.class, i18n.translateString("ScanningStartFrequency"), ((SuFrequencyScanningPanel402)this.getUI()).getSpnCfgStartRxFrequency().getValue(), (Object)((SuFrequencyScanningPanel402)this.getUI()).getSpnCfgStartRxFrequency()));
            }
            Long adjustedEndRxFreqLowerLimit = this.endRxFreqLowerLimit + adjustLong;
            Long adjustedEndRxFreqUpperLimit = this.endRxFreqUpperLimit - adjustLong;
            if (endRxFrequencyLong < adjustedEndRxFreqLowerLimit || endRxFrequencyLong > adjustedEndRxFreqUpperLimit || (endRxFrequencyLong - adjustedEndRxFreqLowerLimit) % this.freqBandStep != 0L) {
                invalidValues.add(new InvalidValue(i18n.translateString("ScanFrequencyValueBetween", new Object[]{adjustedEndRxFreqLowerLimit.doubleValue() / 1000.0, adjustedEndRxFreqUpperLimit.doubleValue() / 1000.0, this.freqBandStep.doubleValue() / 1000.0}), JSpinner.class, i18n.translateString("ScanningEndFrequency"), ((SuFrequencyScanningPanel402)this.getUI()).getSpnCfgEndRxFrequency().getValue(), (Object)((SuFrequencyScanningPanel402)this.getUI()).getSpnCfgEndRxFrequency()));
            }
            int scanningMainStepStartLimit = 125;
            int scanningMainStepEndLimit = isBandwidthMultipleOf1_75 ? 1750 : 5000;
            float scanningMainStep = ((Float)((SuFrequencyScanningPanel402)this.getUI()).getSpnCfgScanningMainStep().getValue()).floatValue();
            if (scanningMainStep < (float)scanningMainStepStartLimit || scanningMainStep > (float)scanningMainStepEndLimit || ((float)scanningMainStepEndLimit - scanningMainStep) % (float)this.freqBandStep.longValue() != 0.0f) {
                invalidValues.add(new InvalidValue(i18n.translateString("ScanFrequencyValueBetween", new Object[]{scanningMainStepStartLimit, scanningMainStepEndLimit, this.freqBandStep}), JSpinner.class, i18n.translateString("ScanningMainStep"), ((SuFrequencyScanningPanel402)this.getUI()).getSpnCfgScanningMainStep().getValue(), (Object)((SuFrequencyScanningPanel402)this.getUI()).getSpnCfgScanningMainStep()));
            }
        }
    }

    private boolean verifyDiscreteFrequency(List<InvalidValue> invalidValues, String frequency, String row) {
        boolean valid = true;
        try {
            Double frequencyDouble = new Double(frequency) * 1000.0;
            if (frequencyDouble == 0.0) {
                return valid;
            }
            long frequencyLong = frequencyDouble.longValue();
            Integer comboCfgBandwidth = (Integer)FormUtil.getSelectedValue((JComboBox)((SuFrequencyScanningPanel402)this.getUI()).getComboCfgBandwidth());
            if (comboCfgBandwidth != null && this.freqBandStep != null && this.startRxFreqLowerLimit != null && this.startRxFreqUpperLimit != null) {
                double adjust = 0.0;
                switch (comboCfgBandwidth) {
                    case 1: {
                        adjust = 0.875;
                        break;
                    }
                    case 2: {
                        adjust = 1.75;
                        break;
                    }
                    case 3: {
                        adjust = 2.5;
                        break;
                    }
                    case 4: {
                        adjust = 3.5;
                        break;
                    }
                    case 5: {
                        adjust = 5.0;
                    }
                }
                long adjustLong = (long)(adjust * 1000.0);
                Long adjustedStartFreqLimit = this.startRxFreqLowerLimit + adjustLong;
                Long adjustedStopFreqLimit = this.startRxFreqUpperLimit - adjustLong;
                if (frequencyLong < adjustedStartFreqLimit || adjustedStopFreqLimit < frequencyLong || (frequencyLong - adjustedStartFreqLimit) % this.freqBandStep != 0L) {
                    valid = false;
                    invalidValues.add(new InvalidValue(i18n.translateString("ScanFrequencyValueBetween", new Object[]{adjustedStartFreqLimit.doubleValue() / 1000.0, adjustedStopFreqLimit.doubleValue() / 1000.0, this.freqBandStep.doubleValue() / 1000.0}), RbSuFreqScanningEntry.class, i18n.translateString("DiscreteScanningFrequencyAtRow", new Object[]{row}), (Object)((double)frequencyLong / 1000.0), null));
                }
            }
        }
        catch (NumberFormatException nfe) {
            valid = false;
            invalidValues.add(new InvalidValue(i18n.translateString("DiscreteScanningFrequencyNotNumber", new Object[]{row}), RbSuFreqScanningEntry.class, i18n.translateString("DiscreteScanningFrequencies"), (Object)frequency, null));
        }
        return valid;
    }

    private void verifyMainStepScanningFrequency(List<InvalidValue> invalidValues) {
        int maxIntermediateStep = 0;
        if (((SuFrequencyScanningPanel402)this.getUI()).getChkCfg875KHz().isSelected()) {
            maxIntermediateStep = ((SuFrequencyScanningPanel402)this.getUI()).getChkCfg875KHz().getText().equals(i18n.translateString("+1250KHz")) ? 1250 : 875;
        } else if (((SuFrequencyScanningPanel402)this.getUI()).getChkCfg750KHz().isSelected()) {
            maxIntermediateStep = 750;
        } else if (((SuFrequencyScanningPanel402)this.getUI()).getChkCfg625KHz().isSelected()) {
            maxIntermediateStep = 625;
        } else if (((SuFrequencyScanningPanel402)this.getUI()).getChkCfg500KHz().isSelected()) {
            maxIntermediateStep = 500;
        } else if (((SuFrequencyScanningPanel402)this.getUI()).getChkCfg375KHz().isSelected()) {
            maxIntermediateStep = 375;
        } else if (((SuFrequencyScanningPanel402)this.getUI()).getChkCfg250KHz().isSelected()) {
            maxIntermediateStep = 250;
        } else if (((SuFrequencyScanningPanel402)this.getUI()).getChkCfg125KHz().isSelected()) {
            maxIntermediateStep = 125;
        }
        if ((float)maxIntermediateStep > ((Float)((SuFrequencyScanningPanel402)this.getUI()).getSpnCfgScanningMainStep().getValue()).floatValue()) {
            invalidValues.add(new InvalidValue(i18n.translateString("IntermediateStepGreaterThanMainStep"), JSpinner.class, i18n.translateString("ScanningIntermediateStepMask"), (Object)maxIntermediateStep, (Object)((SuFrequencyScanningPanel402)this.getUI()).getSpnCfgScanningMainStep()));
        }
    }

    public void perform(int param) {
        RbSuRadioParametersCommand command = new RbSuRadioParametersCommand();
        command.setEquipmentId(this.ctx.getEquipment().getId());
        command.setRbSuMacAddr(MacAddress.fromSimpleString((String)((RbSU)this.ctx.getEquipment()).getMacAddress()).toOctetString());
        command.setRbSuRadioParametersCommand(param);
        this.fireCommand(command);
    }
}

