/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JComboBoxBinding;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.binding.ReadOnlyBinder;
import com.bwanms.gui.binding.translators.TranslateException;
import com.bwanms.gui.binding.translators.ValueTranslator;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.rb.gui.configuration.SuEthPortPanel;
import com.bwanms.rb.mo.RbEthIfConfig;
import com.bwanms.rb.mo.RbEthIfConfigEntry;
import com.bwanms.rb.mo.RbIfInfoEntry;
import com.bwanms.rb.mo.RbIfInfoTable;
import com.bwanms.rb.mo.RbSuEthIfConfigEntry;
import com.bwanms.rb.mo.RbSuEthIfConfigTable;
import com.bwanms.rb.mo.RbSuIfInfoTable;
import com.bwanms.rb.model.RbSU;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuEthPortConfigForm
extends ManagedObjectsConfigForm<SuEthPortPanel> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(SuEthPortConfigForm.class);
    private static final Log log = LogFactory.getLog(SuEthPortConfigForm.class);

    public SuEthPortPanel initUIComponent() {
        return new SuEthPortPanel();
    }

    public List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("SU", RbSuEthIfConfigTable.class));
        ret.add(this.ctx.createRequest("SU", RbSuIfInfoTable.class));
        return ret;
    }

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        RbSuEthIfConfigTable eth = (RbSuEthIfConfigTable)((Object)managedObjects.get(0));
        ReadOnlyBinder binder = new ReadOnlyBinder((Object)this.getUI(), (Object)eth.findEntry("1"));
        binder.add((Binding)new JTextFieldBinding("txtCrtAutoNegotiation", "ethConfigCurrentdAutoNegotiation", (ValueTranslator)new ValueTranslator<Integer, String>(){

            public String convertToUIValue(Integer beanValue) throws TranslateException {
                return i18n.translateString(RbEthIfConfigEntry.toStringEthConfigCurrentdAutoNegotiation(beanValue));
            }

            public Integer convertToBeanValue(String uiBeanValue) throws TranslateException {
                return null;
            }
        }));
        binder.add((Binding)new JTextFieldBinding("txtCrtSpeedAndDuplex", "ethConfigCurrentLinkSpeedAndDuplex", (ValueTranslator)new ValueTranslator<Integer, String>(){

            public String convertToUIValue(Integer beanValue) throws TranslateException {
                return i18n.translateString(RbEthIfConfigEntry.toStringEthConfigCurrentLinkSpeedAndDuplex(beanValue));
            }

            public Integer convertToBeanValue(String uiBeanValue) throws TranslateException {
                return null;
            }
        }));
        binders.add((Binder)binder);
        binder = new DefaultBinder((Object)this.getUI(), (Object)eth.findEntry("1"));
        binder.add((Binding)new JComboBoxBinding(i18n, "cmbCfgAutoNegotiation", "ethConfigAutoNegotiation"));
        binder.add((Binding)new JComboBoxBinding(i18n, "cmbCfgSpeedAndDuplex", "ethConfigLinkSpeedAndDuplex"));
        binders.add((Binder)binder);
        RbIfInfoTable ifTable = (RbIfInfoTable)((Object)managedObjects.get(1));
        binder = new ReadOnlyBinder((Object)this.getUI(), (Object)ifTable.findEntry("1"));
        binder.add((Binding)new JTextFieldBinding("txtOperationalStatus", "ifOperStatus", (ValueTranslator)new ValueTranslator<Integer, String>(){

            public String convertToUIValue(Integer beanValue) throws TranslateException {
                return i18n.translateString(RbIfInfoEntry.toStringIfOperStatus(beanValue));
            }

            public Integer convertToBeanValue(String uiBeanValue) throws TranslateException {
                return null;
            }
        }));
        binders.add((Binder)binder);
    }

    protected void configureMOs(List<Object> managedObjects) {
        RbSuEthIfConfigTable ethIfCfgTbl = (RbSuEthIfConfigTable)((Object)managedObjects.get(0));
        RbSuEthIfConfigEntry ethIfCfgEntry = (RbSuEthIfConfigEntry)ethIfCfgTbl.findEntry("1");
        Object negotiation = ((ComboItem)((SuEthPortPanel)this.getUI()).getCmbCfgAutoNegotiation().getSelectedItem()).getValue();
        Object speed = ((ComboItem)((SuEthPortPanel)this.getUI()).getCmbCfgSpeedAndDuplex().getSelectedItem()).getValue();
        managedObjects.remove((Object)ethIfCfgTbl);
        if (!ethIfCfgEntry.getEthConfigAutoNegotiation().equals(negotiation) || !ethIfCfgEntry.getEthConfigLinkSpeedAndDuplex().equals(speed)) {
            RbEthIfConfig ethIfCfg = new RbEthIfConfig();
            ethIfCfg.setEthConfigAutoNegotiation((Integer)negotiation);
            ethIfCfg.setEthConfigLinkSpeedAndDuplex((Integer)speed);
            ethIfCfg.setEquipmentId(this.ctx.getEquipment().getId());
            ethIfCfg.setEthConfigIfIndex(1);
            this.fireCommand(ethIfCfg);
        }
    }

    public String getTitle() {
        return "EthPort";
    }

    public String getHelpTopic() {
        if (VersionFactory.getInstance().createVersion(((RbSU)this.ctx.getEquipment()).getManagerBS().getRunningSoftwareVersion()).isOlderThan((Version)new DefaultVersion("4.0"))) {
            return "ngnms.rb.help.su_Ethernet_Port";
        }
        return "ngnms.rb.help.su_tdd_Ethernet_Port";
    }
}

