/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.rb.command.RbPMBurstCountersReset;
import com.bwanms.rb.gui.configuration.SuBurstCountersPanel;
import com.bwanms.rb.mo.RbPMBursErrorRateEntry;
import com.bwanms.rb.mo.RbPMBurstErrorRateTable;
import com.bwanms.rb.model.RbSU;
import com.bwanms.util.MacAddress;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuBurstCountersConfigForm
extends ManagedObjectsConfigForm<SuBurstCountersPanel> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(SuBurstCountersConfigForm.class);
    private static final Logger logger = Logger.getLogger(SuBurstCountersConfigForm.class);
    private boolean isSw41OrMore;

    public SuBurstCountersPanel initUIComponent() {
        this.isSw41OrMore = new DefaultVersion("4.1").isOlderOrEqualWith(((RbSU)this.ctx.getEquipment()).getManagerBS().getSoftwareVersion());
        return new SuBurstCountersPanel(this);
    }

    public List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("SU", RbPMBurstErrorRateTable.class));
        return ret;
    }

    protected void fillUI(List<Object> managedObjects) {
        if (((SuBurstCountersPanel)this.getUI()).getTblDownLink().getModel().getRowCount() < 8) {
            ((DefaultTableModel)((SuBurstCountersPanel)this.getUI()).getTblDownLink().getModel()).insertRow(1, new Object[4]);
        }
        if (((SuBurstCountersPanel)this.getUI()).getTblUpLink().getModel().getRowCount() < 8) {
            ((DefaultTableModel)((SuBurstCountersPanel)this.getUI()).getTblUpLink().getModel()).insertRow(1, new Object[4]);
        }
        DefaultTableModel[] linkTables = new DefaultTableModel[]{(DefaultTableModel)((SuBurstCountersPanel)this.getUI()).getTblDownLink().getModel(), (DefaultTableModel)((SuBurstCountersPanel)this.getUI()).getTblUpLink().getModel()};
        RbPMBurstErrorRateTable burstErrorRateTable = (RbPMBurstErrorRateTable)((Object)managedObjects.get(0));
        List burstErrorRates = burstErrorRateTable.findEntriesByRowKeyPrefix(MacAddress.fromSimpleString((String)((RbSU)this.ctx.getEquipment()).getMacAddress()).toInstanceString());
        for (RbPMBursErrorRateEntry entry : burstErrorRates) {
            linkTables[entry.getRbPMBurstDirection() - 1].setValueAt(entry.getRbPMBurstError(), entry.getRbPMBurstRate() - 1, 1);
            linkTables[entry.getRbPMBurstDirection() - 1].setValueAt(entry.getRbPMBurstTotal(), entry.getRbPMBurstRate() - 1, 2);
            linkTables[entry.getRbPMBurstDirection() - 1].setValueAt(entry.getRbPMBurstErrorRate(), entry.getRbPMBurstRate() - 1, 3);
        }
        if (this.isSw41OrMore) {
            ((DefaultTableModel)((SuBurstCountersPanel)this.getUI()).getTblDownLink().getModel()).removeRow(1);
            ((DefaultTableModel)((SuBurstCountersPanel)this.getUI()).getTblUpLink().getModel()).removeRow(1);
        }
    }

    public void resetCounters() {
        RbPMBurstCountersReset command = new RbPMBurstCountersReset();
        RbSU su = (RbSU)this.ctx.getEquipment();
        command.setEquipmentId(su.getId());
        command.setRbPMBurstSuMacAddr(MacAddress.fromSimpleString((String)su.getMacAddress()).toOctetString());
        command.setRbPMBurstCountersReset(1);
        for (int direction = 1; direction <= 2; ++direction) {
            command.setRbPMBurstDirection(direction);
            for (int rate = 1; rate <= 8; ++rate) {
                if (this.isSw41OrMore && rate == 2) continue;
                command.setRbPMBurstRate(rate);
                this.fireCommand(command.clone());
            }
        }
    }

    public boolean canApply() {
        return false;
    }

    public String getTitle() {
        return "BurstCounters";
    }

    public String getHelpTopic() {
        if (VersionFactory.getInstance().createVersion(((RbSU)this.ctx.getEquipment()).getManagerBS().getRunningSoftwareVersion()).isOlderThan((Version)new DefaultVersion("4.0"))) {
            return "ngnms.rb.help.su_burst_counters";
        }
        return "ngnms.rb.help.su_tdd_burst_counters";
    }
}

