/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JComboBoxBinding;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.binding.translators.ValueTranslator;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.rb.command.RbSuClearBestBstAuData;
import com.bwanms.rb.gui.binding.IdValueTranslator;
import com.bwanms.rb.gui.configuration.SuBestBSTAUSelectionPanel;
import com.bwanms.rb.mo.RbSuBestBstAuDataEntry;
import com.bwanms.rb.mo.RbSuBestBstAuDataTable;
import com.bwanms.rb.mo.RbSuBestBstAuParamsEntry;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbSU;
import com.bwanms.rb.util.RbVersions;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.util.MacAddress;
import com.bwanms.util.OctetString;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuBestBSTAUSelectionConfigForm
extends ManagedObjectsConfigForm<SuBestBSTAUSelectionPanel> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(SuBestBSTAUSelectionConfigForm.class);
    private static final Logger logger = Logger.getLogger(SuBestBSTAUSelectionConfigForm.class);
    private ComboItem notDefItem = new ComboItem((Object)0, i18n.translateString(RbSuBestBstAuParamsEntry.toStringRbSuConfiguredBestBstAuSupport(0)));
    private static final Pattern idPattern = Pattern.compile("(?:\\d{1,3}\\.\\d{1,3}.\\d{1,3}.\\d{1,3}\\.\\d{1,3}.\\d{1,3})");

    public SuBestBSTAUSelectionPanel initUIComponent() {
        SuBestBSTAUSelectionPanel panel = new SuBestBSTAUSelectionPanel(this);
        RbBaseStationEquipment bs = ((RbSU)this.ctx.getEquipment()).getManagerBS();
        Version softwareVersion = bs.getSoftwareVersion();
        if (softwareVersion.isOlderThan(VersionFactory.getInstance().createVersion("4.0.2"))) {
            panel.getLblCrtBSTAUID().setVisible(false);
            panel.getTxtCrtBSTAUID().setVisible(false);
            panel.getLblCfgBSTAUID().setVisible(false);
            panel.getFtfCfgBSTAUID().setVisible(false);
            panel.getLblCrtBSTAUIDMask().setVisible(false);
            panel.getTxtCrtBSTAUIDMask().setVisible(false);
            panel.getLblCfgBSTAUIDMask().setVisible(false);
            panel.getFtfCfgBSTAUIDMask().setVisible(false);
        }
        return panel;
    }

    public List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("SU", RbSuBestBstAuParamsEntry.class));
        ret.add(this.ctx.createRequest("SU", RbSuBestBstAuDataTable.class));
        return ret;
    }

    public void fillUI(List<Object> managedObjects) {
        RbSU bs;
        Version softwareVersion;
        RbSuBestBstAuParamsEntry params = (RbSuBestBstAuParamsEntry)((Object)managedObjects.get(0));
        RbSuBestBstAuDataTable dataTbl = (RbSuBestBstAuDataTable)((Object)managedObjects.get(1));
        SuBestBSTAUSelectionPanel ui = (SuBestBSTAUSelectionPanel)this.getUI();
        if (params != null) {
            ui.getTxtCrtBestBSTAUSupport().setText(i18n.translateString(RbSuBestBstAuParamsEntry.toStringRbSuCurrentBestBstAuSupport(params.getRbSuCurrentBestBstAuSupport())));
            ui.getTxtCrtBSTAUID().setText(OctetString.toDottedDecimalForm((String)params.getRbSuCurrentBstAuId()));
            ui.getTxtCrtBSTAUIDMask().setText(OctetString.toDottedDecimalForm((String)params.getRbSuCurrentBstAuMask()));
            ui.getTxtCrtPreferredBSTAUID().setText(OctetString.toDottedDecimalForm((String)params.getRbSuCurrentPreferredBstAuId()));
            ui.getTxtCrtPreferredBSTAUIDMask().setText(OctetString.toDottedDecimalForm((String)params.getRbSuCurrentPreferredBstAuMask()));
            ui.getTxtSelectedBSTAUID().setText(OctetString.toDottedDecimalForm((String)params.getRbSuSelectedAu()));
            ui.getTxtSelectedRxFrequency().setText(params.getRbSuSelectedRxFrequency());
            ui.getTxtSelectedTxFrequency().setText(params.getRbSuSelectedTxFrequency());
            if (dataTbl != null) {
                DefaultTableModel tblBestBSTAUModel = ui.getTblBestBSTAUModel();
                tblBestBSTAUModel.setRowCount(0);
                RbBaseStationEquipment bs2 = ((RbSU)this.ctx.getEquipment()).getManagerBS();
                boolean useTenthDb = bs2.getSoftwareVersion().isNewerOrEqualWith(VersionFactory.getInstance().createVersion("4.0.2"));
                for (RbSuBestBstAuDataEntry entry : dataTbl.getEntries()) {
                    String snrStr = entry.getRbBstAuSNR().toString();
                    if (useTenthDb && snrStr.length() > 0) {
                        snrStr = 1 == snrStr.length() ? "0." + snrStr : snrStr.substring(0, snrStr.length() - 1) + '.' + snrStr.charAt(snrStr.length() - 1);
                    }
                    tblBestBSTAUModel.addRow(new Object[]{OctetString.toDottedDecimalForm((String)entry.getRbBstAuId()), entry.getRbBstAuRxFrequency(), snrStr, RbSuBestBstAuDataEntry.toStringRbBstAuRxAntennaNumber(entry.getRbBstAuRxAntennaNumber())});
                }
            }
            if (params.getRbSuConfiguredBestBstAuSupport().equals(0)) {
                this.enableForm(false);
            }
        }
        if ((softwareVersion = (bs = (RbSU)this.ctx.getEquipment()).getSoftwareVersion()).compareTo((Object)RbVersions.V_4_5) >= 0) {
            JComboBox cmbCfgBestBSTAUSupport = ui.getCmbCfgBestBSTAUSupport();
            cmbCfgBestBSTAUSupport.setSelectedIndex(1);
            cmbCfgBestBSTAUSupport.setEnabled(false);
            ui.getLblMobilityMode().setVisible(true);
            ui.getCmbMobilityMode().setVisible(true);
        } else {
            ui.getLblMobilityMode().setVisible(false);
            ui.getCmbMobilityMode().setVisible(false);
        }
    }

    public String getTitle() {
        return "BestBSTAUSelection";
    }

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        RbSuBestBstAuParamsEntry params = (RbSuBestBstAuParamsEntry)((Object)managedObjects.get(0));
        if (params.getRbSuConfiguredBestBstAuSupport().equals(0)) {
            ((SuBestBSTAUSelectionPanel)this.getUI()).getCmbCfgBestBSTAUSupport().addItem(this.notDefItem);
        } else {
            ((SuBestBSTAUSelectionPanel)this.getUI()).getCmbCfgBestBSTAUSupport().removeItem(this.notDefItem);
        }
        DefaultBinder binder = new DefaultBinder((Object)this.getUI(), (Object)params);
        binder.add((Binding)new JComboBoxBinding(i18n, "cmbCfgBestBSTAUSupport", "rbSuConfiguredBestBstAuSupport", i18n.translateString("BestBST/AUSupport")));
        binder.add((Binding)new JTextFieldBinding("ftfCfgPreferredBSTAUID", "rbSuConfiguredPreferredBstAuId", (ValueTranslator)new IdValueTranslator(6), i18n.translateString("PreferredBST/AUID"), i18n.translateString("InvalidIDValue", new Object[]{6})));
        binder.add((Binding)new JTextFieldBinding("ftfCfgPreferredBSTAUIDMask", "rbSuConfiguredPreferredBstAuMask", (ValueTranslator)new IdValueTranslator(6), i18n.translateString("PreferredBST/AUIDMask"), i18n.translateString("InvalidIDValue", new Object[]{6})));
        RbBaseStationEquipment bs = ((RbSU)this.ctx.getEquipment()).getManagerBS();
        if (bs.getSoftwareVersion().isNewerOrEqualWith(VersionFactory.getInstance().createVersion("4.0.2"))) {
            binder.add((Binding)new JTextFieldBinding("ftfCfgBSTAUID", "rbSuConfiguredBstAuId", (ValueTranslator)new IdValueTranslator(6), i18n.translateString("BST/AUID"), i18n.translateString("InvalidIDValue", new Object[]{6})));
            binder.add((Binding)new JTextFieldBinding("ftfCfgBSTAUIDMask", "rbSuConfiguredBstAuMask", (ValueTranslator)new IdValueTranslator(6), i18n.translateString("BST/AUIDMask"), i18n.translateString("InvalidIDValue", new Object[]{6})));
        }
        if (bs.getSoftwareVersion().isNewerOrEqualWith(VersionFactory.getInstance().createVersion("4.5"))) {
            binder.add((Binding)new JComboBoxBinding(i18n, "cmbMobilityMode", "rbSuMobilityMode", i18n.translateString("mobilityMode")));
        }
        binders.add((Binder)binder);
    }

    public String getHelpTopic() {
        return "ngnms.rb.help.su_tdd_best_bs_au_selection";
    }

    private void enableForm(boolean enable) {
        ((SuBestBSTAUSelectionPanel)this.getUI()).getFtfCfgPreferredBSTAUID().setEnabled(enable);
        ((SuBestBSTAUSelectionPanel)this.getUI()).getFtfCfgPreferredBSTAUIDMask().setEnabled(enable);
    }

    public void perform() {
        RbSuClearBestBstAuData command = new RbSuClearBestBstAuData();
        command.setRbSuClearBestBstAuData(2);
        command.setEquipmentId(this.ctx.getEquipment().getId());
        command.setRbSuMacAddr(MacAddress.fromSimpleString((String)((RbSU)this.ctx.getEquipment()).getMacAddress()).toOctetString());
        this.fireCommand(command);
    }

    private boolean checkMask(String mask) {
        String[] splittedValues = mask.split("\\.");
        if (splittedValues.length != 6) {
            return false;
        }
        for (String value : splittedValues) {
            try {
                int castValue = Integer.parseInt(value);
                if (castValue <= 255 && castValue >= 0) continue;
                return false;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        return true;
    }
}

