/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.configuration.FormsConfigSectionView;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.rb.gui.configuration.SuBerTestPanel;
import com.bwanms.rb.mo.RbBerTestResults;
import com.bwanms.rb.mo.RbBerTestSetup;
import com.bwanms.rb.model.RbSU;
import com.bwanms.services.UnifiedMORequest;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.util.FormUtil;
import com.bwanms.util.MacAddress;
import com.bwanms.util.MessageBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuBerTestConfigForm
extends ManagedObjectsConfigForm<SuBerTestPanel> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(SuBerTestConfigForm.class);
    private static final Logger logger = Logger.getLogger(SuBerTestConfigForm.class);
    private boolean receiving = false;
    private Object mutex = new Object();

    public SuBerTestPanel initUIComponent() {
        final SuBerTestPanel panel = new SuBerTestPanel();
        panel.getBtnStart().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (panel.getBtnStart().getText().equals(i18n.translateString("Start"))) {
                    SuBerTestConfigForm.this.startTest();
                } else {
                    SuBerTestConfigForm.this.stopTest();
                }
            }
        });
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean shouldStop = false;
                while (!shouldStop) {
                    try {
                        Thread.sleep(15000L);
                    }
                    catch (InterruptedException ie) {
                        logger.error((Object)ie, (Throwable)ie);
                    }
                    shouldStop = null == panel.getParent() || ((FormsConfigSectionView)SuBerTestConfigForm.this.getConfigSectionView()).isShouldStop();
                    Object object = SuBerTestConfigForm.this.mutex;
                    synchronized (object) {
                        if (!SuBerTestConfigForm.this.receiving && !shouldStop) {
                            SuBerTestConfigForm.this.receiving = true;
                            try {
                                SuBerTestConfigForm.this.getConfigSectionView().refresh(false);
                            }
                            catch (Throwable t) {
                                logger.error((Object)t, t);
                            }
                        }
                    }
                }
            }
        }).start();
        return panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UnifiedMORequest> getManagedObjectRequests() {
        Object object = this.mutex;
        synchronized (object) {
            ArrayList<UnifiedMORequest> ret = new ArrayList<UnifiedMORequest>();
            ret.add((UnifiedMORequest)this.ctx.createRequest("SU", RbBerTestResults.class));
            ret.add((UnifiedMORequest)this.ctx.createRequest("SU", RbBerTestSetup.class));
            return ret;
        }
    }

    public String getTitle() {
        return "BERTest";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillUI(List<Object> managedObjects) {
        RbBerTestResults results = (RbBerTestResults)managedObjects.get(0);
        RbSU su = (RbSU)this.ctx.getEquipment();
        String crtSu = MacAddress.fromSimpleString((String)su.getMacAddress()).toOctetString().toUpperCase();
        String testedSu = results.getRbBerTestResultsSU().toUpperCase();
        boolean wrongSu = !testedSu.equals(crtSu) && !testedSu.equals("00:00:00:00:00:00");
        String warnLblText = i18n.translateString("TestIsRunningOnAnotherSU", new Object[]{testedSu});
        Color warnLblColor = Color.red;
        if (wrongSu) {
            ((SuBerTestPanel)this.getUI()).getTxtDLBER().setText("");
            ((SuBerTestPanel)this.getUI()).getTxtULBER().setText("");
        } else {
            ((SuBerTestPanel)this.getUI()).getTxtDLBER().setText(results.getRbBerTestDownlinkBER());
            ((SuBerTestPanel)this.getUI()).getTxtULBER().setText(results.getRbBerTestUplinkBER());
        }
        Object object = this.mutex;
        synchronized (object) {
            RbBerTestSetup setup = (RbBerTestSetup)managedObjects.get(1);
            if (setup.getRbBerTestStatus().equals(3)) {
                warnLblText = i18n.translateString("LastRunOnAnotherSU", new Object[]{testedSu});
                warnLblColor = Color.blue;
            }
            ((SuBerTestPanel)this.getUI()).getLblWarning().setText(warnLblText);
            ((SuBerTestPanel)this.getUI()).getLblWarning().setVisible(wrongSu);
            ((SuBerTestPanel)this.getUI()).getLblWarning().setForeground(warnLblColor);
            ((SuBerTestPanel)this.getUI()).getTxtStatus().setText(i18n.translateString(RbBerTestSetup.toStringRbBerTestStatus(setup.getRbBerTestStatus())));
            String startBtnText = i18n.translateString("Start");
            if (setup.getRbBerTestStatus().equals(2)) {
                startBtnText = i18n.translateString("Stop");
                this.enableBerTestSetupFields(false);
            } else {
                this.enableBerTestSetupFields(true);
            }
            ((SuBerTestPanel)this.getUI()).getBtnStart().setText(startBtnText);
            if (!this.receiving) {
                ((SuBerTestPanel)this.getUI()).getSpnDataSize().setValue(setup.getRbBerTestDataSize());
                ((SuBerTestPanel)this.getUI()).getSpnIterationNumber().setValue(setup.getRbBerTestIterationNumber());
                FormUtil.setSelectedValue((JComboBox)((SuBerTestPanel)this.getUI()).getCmbModulation(), (Object)setup.getRbBerTestModulation());
                ((SuBerTestPanel)this.getUI()).getCmbSubChannelsNumber().setSelectedItem(setup.getRbBerTestSubChannelsNumber());
                FormUtil.setSelectedValue((JComboBox)((SuBerTestPanel)this.getUI()).getCmbTrafficPriority(), (Object)setup.getRbBerTestTrafficPriority());
            }
            this.receiving = false;
        }
    }

    private void enableBerTestSetupFields(boolean enabled) {
        ((SuBerTestPanel)this.getUI()).getSpnDataSize().setEnabled(enabled);
        ((SuBerTestPanel)this.getUI()).getSpnIterationNumber().setEnabled(enabled);
        ((SuBerTestPanel)this.getUI()).getCmbModulation().setEnabled(enabled);
        ((SuBerTestPanel)this.getUI()).getCmbSubChannelsNumber().setEnabled(enabled);
        ((SuBerTestPanel)this.getUI()).getCmbTrafficPriority().setEnabled(enabled);
    }

    private void stopTest() {
        RbBerTestSetup setup = new RbBerTestSetup();
        setup.setEquipmentId(this.ctx.getEquipment().getId());
        setup.setRbBerTestAction(2);
        this.fireCommand(setup);
    }

    private void startTest() {
        int dataSize = (Integer)((SuBerTestPanel)this.getUI()).getSpnDataSize().getValue();
        if (dataSize < 1000 || dataSize > 2000000) {
            MessageBox.Error.quickShow((Component)this.getUI(), i18n.translateString("InvalidDataSize"));
            return;
        }
        int iterationNo = (Integer)((SuBerTestPanel)this.getUI()).getSpnIterationNumber().getValue();
        if (iterationNo < 1 || iterationNo > 1000) {
            MessageBox.Error.quickShow((Component)this.getUI(), i18n.translateString("InvalidIterationNo"));
            return;
        }
        ComboItem item = (ComboItem)((SuBerTestPanel)this.getUI()).getCmbModulation().getSelectedItem();
        Integer modulation = (Integer)item.getValue();
        Integer sc = (Integer)((SuBerTestPanel)this.getUI()).getCmbSubChannelsNumber().getSelectedItem();
        if (sc.equals(1) && modulation.equals(1)) {
            MessageBox.Error.quickShow((Component)this.getUI(), i18n.translateString("WrongScAndModulation"));
            return;
        }
        RbBerTestSetup setup = new RbBerTestSetup();
        setup.setEquipmentId(this.ctx.getEquipment().getId());
        setup.setRbBerTestAction(1);
        setup.setRbBerTestDataSize(dataSize);
        setup.setRbBerTestIterationNumber(iterationNo);
        setup.setRbBerTestModulation(modulation);
        setup.setRbBerTestSubChannelsNumber(sc);
        item = (ComboItem)((SuBerTestPanel)this.getUI()).getCmbTrafficPriority().getSelectedItem();
        setup.setRbBerTestTrafficPriority((Integer)item.getValue());
        this.fireCommand(setup);
    }

    public String getHelpTopic() {
        return "ngnms.rb.help.subscriber_units";
    }

    public boolean canApply() {
        return false;
    }
}

