/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.domain.logic.Helpers;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.configuration.FormsConfigSectionView;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.mediation.FileTransferEvent;
import com.bwanms.mediation.FileTransferRequest;
import com.bwanms.mediation.FileTransferService;
import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.mediation.MediationServiceRegistry;
import com.bwanms.mediation.TftpFileTransferRequest;
import com.bwanms.mediation.TftpFileTransferService;
import com.bwanms.mediation.filetransfer.SynchronousFileTransfer;
import com.bwanms.mo.ManagedObject;
import com.bwanms.model.Equipment;
import com.bwanms.model.SNMPManagementInterface;
import com.bwanms.persistence.RunnableDatastoreDecorator;
import com.bwanms.protocols.snmp.SNMPTimeoutException;
import com.bwanms.protocols.tftp.TftpTimeoutException;
import com.bwanms.rb.command.RbMbsCommand;
import com.bwanms.rb.command.RbNpuCommand;
import com.bwanms.rb.command.RbSwDeleteFiles;
import com.bwanms.rb.gui.configuration.SoftwareUpgradePanel;
import com.bwanms.rb.gui.configuration.SoftwareUpgradePanelLog;
import com.bwanms.rb.mo.RbAuConfigEntry;
import com.bwanms.rb.mo.RbAuConfigTable;
import com.bwanms.rb.mo.RbNpuConfigEntry;
import com.bwanms.rb.mo.RbNpuConfigTable;
import com.bwanms.rb.mo.RbRegisteredSuEntry;
import com.bwanms.rb.mo.RbRegisteredSuTable;
import com.bwanms.rb.mo.RbSwAuConfigEntry;
import com.bwanms.rb.mo.RbSwRegisteredSuEntry;
import com.bwanms.rb.mo.RbSwUpgrade;
import com.bwanms.rb.mo.RbSysMicroBSTConfig;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbMBS;
import com.bwanms.rb.tasks.softwareupgrade.RbSwUpgradeLogEntry;
import com.bwanms.services.UnifiedMORequest;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.SimpleFileChooser;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.ui.components.TextAreaMultiThreading;
import com.bwanms.util.ExecutorUtils;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.IpAddress;
import com.bwanms.util.MacAddress;
import com.bwanms.util.MessageBox;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.text.BadLocationException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoftwareUpgradeConfigForm
extends ManagedObjectsConfigForm<SoftwareUpgradePanel> {
    private static final Logger logger = Logger.getLogger(SoftwareUpgradeConfigForm.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(SoftwareUpgradeConfigForm.class);
    public static final int OP_NONE = 0;
    public static final int OP_RESET = 1;
    public static final int OP_LOAD_TO_BS = 2;
    public static final int OP_LOAD_TO_SHADOW = 3;
    public static final int OP_RUN_FROM_SHADOW = 4;
    public static final int OP_SET_MAIN = 5;
    public static final int MAX_VERSION_NUMBER = 10000;
    public static final int MAX_UPLOAD_FILE_SIZE = 0x1400000;
    private static String DEFAULT_FIRMWARE_PATH = System.getProperty("com.bwanms.home") + "/filesystem/firmware/rb";
    private static String DEFAULT_FIRMWARE_LOG_PATH = System.getProperty("com.bwanms.home") + "/filesystem/firmware";
    private static String LINE_SEPARATOR;
    private static final int FIXED_POOL_THREADS_NUM = 10;
    private static final int THREAD_WAIT_SECONDS = 600;
    private static final int UNIT_WAIT_SECONDS = 600;
    private String filterString = "";
    private List<RbRegisteredSuEntry> entriesSU;
    private HashMap<String, Object[]> selectedEntriesSU = new HashMap();
    private HashMap<String, Integer> entriesSUIndex = new HashMap();
    private List<RbAuConfigEntry> entriesAU;
    private HashMap<String, Object[]> selectedEntriesAU = new HashMap();
    private HashMap<String, Integer> entriesAUIndex = new HashMap();
    private RbNpuConfigEntry npu;
    private RbSysMicroBSTConfig mbs;
    private boolean fromCommand = false;
    SoftwareUpgradePanelLog panelLog;
    private ExecutorService executor;
    private boolean swupIsRunning = false;
    private boolean swupAbort = false;
    private boolean isBS = true;
    private boolean skipTempSUs = false;
    private TextAreaMultiThreading multiLog;
    private SimpleFileChooser npuFileChooser = new SimpleFileChooser(DEFAULT_FIRMWARE_PATH, new FileFilter(){

        public String getDescription() {
            return i18n.translateString("SWUPFileFilterNPU");
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return f.getName().startsWith("npu");
        }
    });
    private SimpleFileChooser mbsFileChooser = new SimpleFileChooser(DEFAULT_FIRMWARE_PATH, new FileFilter(){

        public String getDescription() {
            return i18n.translateString("SWUPFileFilterMBS");
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return f.getName().startsWith("micro");
        }
    });
    private SimpleFileChooser auFileChooser = new SimpleFileChooser(DEFAULT_FIRMWARE_PATH, new FileFilter(){

        public String getDescription() {
            return i18n.translateString("SWUPFileFilterAU");
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return f.getName().startsWith("au");
        }
    });
    private SimpleFileChooser suFileChooser = new SimpleFileChooser(DEFAULT_FIRMWARE_PATH, new FileFilter(){

        public String getDescription() {
            return i18n.translateString("SWUPFileFilterSU");
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return f.getName().startsWith("su");
        }
    });

    public boolean forceRefresh() {
        ((SoftwareUpgradePanel)this.getUI()).getBtnRun().setEnabled(false);
        ((SoftwareUpgradePanel)this.getUI()).getBtnLog().setEnabled(false);
        return true;
    }

    public boolean canApply() {
        return false;
    }

    public String getTitle() {
        return "SWUPSoftwareUpgrade";
    }

    public List<UnifiedMORequest> getManagedObjectRequests() {
        ArrayList<UnifiedMORequest> ret = new ArrayList<UnifiedMORequest>();
        ret.add((UnifiedMORequest)this.ctx.createRequest("BS", RbSwUpgrade.class));
        if (!this.fromCommand) {
            ret.add((UnifiedMORequest)this.ctx.createRequest("BS", RbRegisteredSuTable.class));
            if (this.isBS) {
                ret.add((UnifiedMORequest)this.ctx.createRequest("BS", RbNpuConfigTable.class));
                ret.add((UnifiedMORequest)this.ctx.createRequest("BS", RbAuConfigTable.class));
            } else {
                ret.add((UnifiedMORequest)this.ctx.createRequest("BS", RbSysMicroBSTConfig.class));
            }
        }
        return ret;
    }

    protected SoftwareUpgradePanel initUIComponent() {
        RbBaseStationEquipment bsEq = (RbBaseStationEquipment)this.ctx.getEquipment();
        this.isBS = bsEq instanceof RbBS;
        this.skipTempSUs = bsEq.getSoftwareVersion().compareTo((Object)new DefaultVersion("4.1")) < 0;
        final SoftwareUpgradePanel softwareUpgradePanel = new SoftwareUpgradePanel(this);
        if (!this.isBS) {
            softwareUpgradePanel.getTableNPUFilesAU().setEnabled(false);
            softwareUpgradePanel.getLblAu().setEnabled(false);
            softwareUpgradePanel.getCmbAUFiles().setEnabled(false);
            softwareUpgradePanel.getCmbAUOp().setEnabled(false);
            softwareUpgradePanel.getLblNpuMbs().setText(i18n.translateString("SWUPMBS"));
            softwareUpgradePanel.getPanelNPUandAU().setBorder(new TitledBorder(i18n.translateString("SWUPMBS")));
        }
        softwareUpgradePanel.getTxtFilter().getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
            }

            public void insertUpdate(DocumentEvent e) {
                this.updateTable(e);
            }

            public void removeUpdate(DocumentEvent e) {
                this.updateTable(e);
            }

            private void updateTable(DocumentEvent e) {
                try {
                    SoftwareUpgradeConfigForm.this.filterString = e.getDocument().getText(0, e.getDocument().getLength()).trim();
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
                SoftwareUpgradeConfigForm.this.fillTableSU();
            }
        });
        softwareUpgradePanel.getCmbFilterBy().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                softwareUpgradePanel.getCmbRegistrationStatus().setVisible(((JComboBox)e.getSource()).getSelectedItem().equals(2));
                softwareUpgradePanel.getCmbPersistenceStatus().setVisible(((JComboBox)e.getSource()).getSelectedItem().equals(3));
                softwareUpgradePanel.getTxtFilter().setVisible(!softwareUpgradePanel.getCmbRegistrationStatus().isVisible() && !softwareUpgradePanel.getCmbPersistenceStatus().isVisible());
                softwareUpgradePanel.revalidate();
                SoftwareUpgradeConfigForm.this.fillTableSU();
            }
        });
        softwareUpgradePanel.getCmbRegistrationStatus().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SoftwareUpgradeConfigForm.this.fillTableSU();
            }
        });
        softwareUpgradePanel.getCmbPersistenceStatus().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SoftwareUpgradeConfigForm.this.fillTableSU();
            }
        });
        softwareUpgradePanel.getTableSUModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                int row = e.getFirstRow();
                try {
                    String result = (String)softwareUpgradePanel.getTableSUModel().getValueAt(row, 9);
                    boolean select = (Boolean)softwareUpgradePanel.getTableSUModel().getValueAt(row, 8);
                    SoftwareUpgradeConfigForm.this.selectedEntriesSU.put((String)softwareUpgradePanel.getTableSUModel().getValueAt(row, 1), new Object[]{select, result});
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        softwareUpgradePanel.getTableNPUandAUModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                int row = e.getFirstRow();
                try {
                    String result = (String)softwareUpgradePanel.getTableNPUandAUModel().getValueAt(row, 7);
                    boolean select = (Boolean)softwareUpgradePanel.getTableNPUandAUModel().getValueAt(row, 6);
                    SoftwareUpgradeConfigForm.this.selectedEntriesAU.put((String)softwareUpgradePanel.getTableNPUandAUModel().getValueAt(row, 1), new Object[]{select, result});
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        softwareUpgradePanel.getBtnRun().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SoftwareUpgradeConfigForm.this.openRunFrame();
            }
        });
        softwareUpgradePanel.getBtnLog().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SoftwareUpgradeConfigForm.this.openLogFrame();
            }
        });
        softwareUpgradePanel.getBtnDeleteAuFile().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SoftwareUpgradeConfigForm.this.btnDeleteFilesActionPerformed(ae, softwareUpgradePanel, true);
            }
        });
        softwareUpgradePanel.getBtnDeleteSuFile().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SoftwareUpgradeConfigForm.this.btnDeleteFilesActionPerformed(ae, softwareUpgradePanel, false);
            }
        });
        softwareUpgradePanel.getTableSU().addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                this.showPopup(e);
            }

            public void mousePressed(MouseEvent e) {
                this.showPopup(e);
            }

            public void showPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JTable source = (JTable)e.getSource();
                    int row = source.rowAtPoint(e.getPoint());
                    int column = source.columnAtPoint(e.getPoint());
                    source.changeSelection(row, column, false, false);
                    SoftwareUpgradeConfigForm.this.enableSUPopup();
                    softwareUpgradePanel.getPopupMenuSU().show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        softwareUpgradePanel.getItemSUSelectAll().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SoftwareUpgradeConfigForm.this.actionItemSUSelectAll();
            }
        });
        softwareUpgradePanel.getItemSUUnselectAll().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SoftwareUpgradeConfigForm.this.actionItemSUUnselectAll();
            }
        });
        softwareUpgradePanel.getItemSUInvertSelection().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SoftwareUpgradeConfigForm.this.actionItemSUInvertSelection();
            }
        });
        softwareUpgradePanel.getItemSUSelectUp().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SoftwareUpgradeConfigForm.this.actionItemSUSelectUp();
            }
        });
        softwareUpgradePanel.getItemSUUnselectUp().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SoftwareUpgradeConfigForm.this.actionItemSUUnselectUp();
            }
        });
        softwareUpgradePanel.getItemSUSelectDown().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SoftwareUpgradeConfigForm.this.actionItemSUSelectDown();
            }
        });
        softwareUpgradePanel.getItemSUUnselectDown().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SoftwareUpgradeConfigForm.this.actionItemSUUnselectDown();
            }
        });
        softwareUpgradePanel.getItemSUSelectAllForAU().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SoftwareUpgradeConfigForm.this.actionItemSUSelectAllForAU();
            }
        });
        softwareUpgradePanel.getItemSUUnselectAllForAU().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SoftwareUpgradeConfigForm.this.actionItemSUUnselectAllForAU();
            }
        });
        softwareUpgradePanel.getItemSUSelectAllWithVersion().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SoftwareUpgradeConfigForm.this.actionItemSUSelectAllWithVersion();
            }
        });
        softwareUpgradePanel.getItemSUSelectAllWithVersionAndNewer().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SoftwareUpgradeConfigForm.this.actionItemSUSelectAllWithVersionAndNewer();
            }
        });
        softwareUpgradePanel.getItemSUSelectAllWithVersionAndOlder().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SoftwareUpgradeConfigForm.this.actionItemSUSelectAllWithVersionAndOlder();
            }
        });
        softwareUpgradePanel.getItemSUSelectAllWithShadowVersion().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SoftwareUpgradeConfigForm.this.actionItemSUSelectAllWithShadowVersion();
            }
        });
        softwareUpgradePanel.getItemSUSelectAllWithShadowVersionAndNewer().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SoftwareUpgradeConfigForm.this.actionItemSUSelectAllWithShadowVersionAndNewer();
            }
        });
        softwareUpgradePanel.getItemSUSelectAllWithShadowVersionAndOlder().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SoftwareUpgradeConfigForm.this.actionItemSUSelectAllWithShadowVersionAndOlder();
            }
        });
        softwareUpgradePanel.getItemSUSelectAllWithRunningVersion().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SoftwareUpgradeConfigForm.this.actionItemSUSelectAllWithRunningVersion();
            }
        });
        softwareUpgradePanel.getItemSUSelectAllWithRunningVersionAndNewer().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SoftwareUpgradeConfigForm.this.actionItemSUSelectAllWithRunningVersionAndNewer();
            }
        });
        softwareUpgradePanel.getItemSUSelectAllWithRunningVersionAndOlder().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SoftwareUpgradeConfigForm.this.actionItemSUSelectAllWithRunningVersionAndOlder();
            }
        });
        return softwareUpgradePanel;
    }

    private void btnDeleteFilesActionPerformed(ActionEvent e, SoftwareUpgradePanel panel, boolean isAU) {
        int idx;
        int[] selRows;
        SimpleRowTableModel model;
        String deviceType = "";
        if (isAU) {
            model = panel.getTableNPUFilesAUModel();
            selRows = panel.getTableNPUFilesAU().getSelectedRows();
            deviceType = "AU";
        } else {
            model = panel.getTableNPUFilesSUModel();
            selRows = panel.getTableNPUFilesSU().getSelectedRows();
            deviceType = "SU";
        }
        StringBuffer cmdBuffer = new StringBuffer();
        StringBuffer msgBuffer = new StringBuffer();
        String swFile = null;
        for (idx = 0; idx < selRows.length - 1; ++idx) {
            swFile = (String)model.getValueAt(selRows[idx], 0);
            cmdBuffer.append(swFile + ";");
            msgBuffer.append(swFile + ", ");
        }
        swFile = (String)model.getValueAt(selRows[idx], 0);
        cmdBuffer.append(swFile + ";");
        msgBuffer.append(swFile);
        if (MessageBox.Confirm.showResult((Component)panel, i18n.translateString("AreYouSureYouWantToDeleteSwFiles", new Object[]{deviceType, msgBuffer.toString()}))) {
            if (this.isBS) {
                this.deleteNPUSwFiles(cmdBuffer.toString());
            } else {
                this.deleteMBSSwFiles(cmdBuffer.toString());
            }
        }
    }

    public void deleteNPUSwFiles(String swFile) {
        RbSwDeleteFiles command = new RbSwDeleteFiles();
        command.setEquipmentId(this.ctx.getEquipment().getId());
        command.setRbSwDeleteFiles(swFile);
        this.fromCommand = true;
        ((FormsConfigSectionView)this.getConfigSectionView()).setMoRequestsNull();
        this.fireCommand(command);
    }

    public List<? extends UnifiedMORequest> getCachedManagedObjectRequests() {
        return this.getManagedObjectRequests();
    }

    public void deleteMBSSwFiles(String swFile) {
        RbMBS mbs = (RbMBS)this.ctx.getEquipment();
        if (mbs != null) {
            this.fromCommand = true;
            ((FormsConfigSectionView)this.getConfigSectionView()).setMoRequestsNull();
            this.fireCommand(mbs.createDeleteSwFilesCommand(swFile));
        }
    }

    private void actionItemSUSelectAll() {
        int rows = ((SoftwareUpgradePanel)this.getUI()).getTableSU().getRowCount();
        for (int i = 0; i < rows; ++i) {
            ((SoftwareUpgradePanel)this.getUI()).getTableSU().setValueAt(true, i, 8);
        }
    }

    private void actionItemSUUnselectAll() {
        int rows = ((SoftwareUpgradePanel)this.getUI()).getTableSU().getRowCount();
        for (int i = 0; i < rows; ++i) {
            ((SoftwareUpgradePanel)this.getUI()).getTableSU().setValueAt(false, i, 8);
        }
    }

    private void actionItemSUInvertSelection() {
        int rows = ((SoftwareUpgradePanel)this.getUI()).getTableSU().getRowCount();
        for (int i = 0; i < rows; ++i) {
            ((SoftwareUpgradePanel)this.getUI()).getTableSU().setValueAt(this.getTableSUSelectedStatus(i) == false, i, 8);
        }
    }

    private void actionItemSUSelectUp() {
        int row = ((SoftwareUpgradePanel)this.getUI()).getTableSU().getSelectedRow();
        for (int i = 0; i <= row; ++i) {
            ((SoftwareUpgradePanel)this.getUI()).getTableSU().setValueAt(true, i, 8);
        }
    }

    private void actionItemSUUnselectUp() {
        int row = ((SoftwareUpgradePanel)this.getUI()).getTableSU().getSelectedRow();
        for (int i = 0; i <= row; ++i) {
            ((SoftwareUpgradePanel)this.getUI()).getTableSU().setValueAt(false, i, 8);
        }
    }

    private void actionItemSUSelectDown() {
        int row;
        int rows = ((SoftwareUpgradePanel)this.getUI()).getTableSU().getRowCount();
        for (int i = row = ((SoftwareUpgradePanel)this.getUI()).getTableSU().getSelectedRow(); i < rows; ++i) {
            ((SoftwareUpgradePanel)this.getUI()).getTableSU().setValueAt(true, i, 8);
        }
    }

    private void actionItemSUUnselectDown() {
        int row;
        int rows = ((SoftwareUpgradePanel)this.getUI()).getTableSU().getRowCount();
        for (int i = row = ((SoftwareUpgradePanel)this.getUI()).getTableSU().getSelectedRow(); i < rows; ++i) {
            ((SoftwareUpgradePanel)this.getUI()).getTableSU().setValueAt(false, i, 8);
        }
    }

    private void actionItemSUSelectAllForAU() {
        this.setForAU(this.getTableSUAssociatedAU(((SoftwareUpgradePanel)this.getUI()).getTableSU().getSelectedRow()), true);
    }

    private void actionItemSUUnselectAllForAU() {
        this.setForAU(this.getTableSUAssociatedAU(((SoftwareUpgradePanel)this.getUI()).getTableSU().getSelectedRow()), false);
    }

    private void setForAU(String idAU, boolean set) {
        int rows = ((SoftwareUpgradePanel)this.getUI()).getTableSU().getRowCount();
        for (int i = 0; i < rows; ++i) {
            try {
                if (Integer.parseInt(idAU) != Integer.parseInt(this.getTableSUAssociatedAU(i))) continue;
                ((SoftwareUpgradePanel)this.getUI()).getTableSU().setValueAt(set, i, 8);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private RbRegisteredSuEntry getSUfromRow(int row) {
        String macAddr = this.getTableSUMAC(row);
        Integer index = this.entriesSUIndex.get(macAddr);
        return this.entriesSU.get(index);
    }

    private RbAuConfigEntry getAUfromRow(int row) {
        String slot = this.getTableAUSlot(row);
        Integer index = this.entriesAUIndex.get(slot);
        return this.entriesAU.get(index);
    }

    private void actionItemSUSelectAllWithVersion() {
        int rows = ((SoftwareUpgradePanel)this.getUI()).getTableSU().getRowCount();
        int row = ((SoftwareUpgradePanel)this.getUI()).getTableSU().getSelectedRow();
        String swver = this.getSUfromRow(row).getRbSuOperSwVersion();
        for (int i = 0; i < rows; ++i) {
            try {
                if (swver.equals(this.getSUfromRow(i).getRbSuOperSwVersion())) {
                    ((SoftwareUpgradePanel)this.getUI()).getTableSU().setValueAt(true, i, 8);
                    continue;
                }
                ((SoftwareUpgradePanel)this.getUI()).getTableSU().setValueAt(false, i, 8);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void actionItemSUSelectAllWithVersionAndNewer() {
        int rows = ((SoftwareUpgradePanel)this.getUI()).getTableSU().getRowCount();
        int row = ((SoftwareUpgradePanel)this.getUI()).getTableSU().getSelectedRow();
        long swVer = this.getSoftwareVersionAsLong(this.getSUfromRow(row).getRbSuOperSwVersion());
        for (int i = 0; i < rows; ++i) {
            try {
                if (swVer <= this.getSoftwareVersionAsLong(this.getSUfromRow(i).getRbSuOperSwVersion())) {
                    ((SoftwareUpgradePanel)this.getUI()).getTableSU().setValueAt(true, i, 8);
                    continue;
                }
                ((SoftwareUpgradePanel)this.getUI()).getTableSU().setValueAt(false, i, 8);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void actionItemSUSelectAllWithVersionAndOlder() {
        int rows = ((SoftwareUpgradePanel)this.getUI()).getTableSU().getRowCount();
        int row = ((SoftwareUpgradePanel)this.getUI()).getTableSU().getSelectedRow();
        long swVer = this.getSoftwareVersionAsLong(this.getSUfromRow(row).getRbSuOperSwVersion());
        for (int i = 0; i < rows; ++i) {
            try {
                long ver = this.getSoftwareVersionAsLong(this.getSUfromRow(i).getRbSuOperSwVersion());
                if (swVer >= ver && ver > 0L) {
                    ((SoftwareUpgradePanel)this.getUI()).getTableSU().setValueAt(true, i, 8);
                    continue;
                }
                ((SoftwareUpgradePanel)this.getUI()).getTableSU().setValueAt(false, i, 8);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void actionItemSUSelectAllWithShadowVersion() {
        int rows = ((SoftwareUpgradePanel)this.getUI()).getTableSU().getRowCount();
        int row = ((SoftwareUpgradePanel)this.getUI()).getTableSU().getSelectedRow();
        long swVer = this.getSoftwareVersionAsLong(this.getSUfromRow(row).getRbSuShadowSwVersion());
        for (int i = 0; i < rows; ++i) {
            try {
                if (swVer == this.getSoftwareVersionAsLong(this.getSUfromRow(i).getRbSuShadowSwVersion())) {
                    ((SoftwareUpgradePanel)this.getUI()).getTableSU().setValueAt(true, i, 8);
                    continue;
                }
                ((SoftwareUpgradePanel)this.getUI()).getTableSU().setValueAt(false, i, 8);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void actionItemSUSelectAllWithShadowVersionAndNewer() {
        int rows = ((SoftwareUpgradePanel)this.getUI()).getTableSU().getRowCount();
        int row = ((SoftwareUpgradePanel)this.getUI()).getTableSU().getSelectedRow();
        long swVer = this.getSoftwareVersionAsLong(this.getSUfromRow(row).getRbSuShadowSwVersion());
        for (int i = 0; i < rows; ++i) {
            try {
                if (swVer <= this.getSoftwareVersionAsLong(this.getSUfromRow(i).getRbSuShadowSwVersion())) {
                    ((SoftwareUpgradePanel)this.getUI()).getTableSU().setValueAt(true, i, 8);
                    continue;
                }
                ((SoftwareUpgradePanel)this.getUI()).getTableSU().setValueAt(false, i, 8);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void actionItemSUSelectAllWithShadowVersionAndOlder() {
        int rows = ((SoftwareUpgradePanel)this.getUI()).getTableSU().getRowCount();
        int row = ((SoftwareUpgradePanel)this.getUI()).getTableSU().getSelectedRow();
        long swVer = this.getSoftwareVersionAsLong(this.getSUfromRow(row).getRbSuShadowSwVersion());
        for (int i = 0; i < rows; ++i) {
            try {
                long ver = this.getSoftwareVersionAsLong(this.getSUfromRow(i).getRbSuShadowSwVersion());
                if (swVer >= ver && ver > 0L) {
                    ((SoftwareUpgradePanel)this.getUI()).getTableSU().setValueAt(true, i, 8);
                    continue;
                }
                ((SoftwareUpgradePanel)this.getUI()).getTableSU().setValueAt(false, i, 8);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void actionItemSUSelectAllWithRunningVersion() {
        int rows = ((SoftwareUpgradePanel)this.getUI()).getTableSU().getRowCount();
        int row = ((SoftwareUpgradePanel)this.getUI()).getTableSU().getSelectedRow();
        long swVer = this.getSoftwareVersionAsLong(this.getTableSURunningSW(row));
        for (int i = 0; i < rows; ++i) {
            try {
                if (swVer == this.getSoftwareVersionAsLong(this.getTableSURunningSW(i))) {
                    ((SoftwareUpgradePanel)this.getUI()).getTableSU().setValueAt(true, i, 8);
                    continue;
                }
                ((SoftwareUpgradePanel)this.getUI()).getTableSU().setValueAt(false, i, 8);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void actionItemSUSelectAllWithRunningVersionAndNewer() {
        int rows = ((SoftwareUpgradePanel)this.getUI()).getTableSU().getRowCount();
        int row = ((SoftwareUpgradePanel)this.getUI()).getTableSU().getSelectedRow();
        long swVer = this.getSoftwareVersionAsLong(this.getTableSURunningSW(row));
        for (int i = 0; i < rows; ++i) {
            try {
                if (swVer <= this.getSoftwareVersionAsLong(this.getTableSURunningSW(i))) {
                    ((SoftwareUpgradePanel)this.getUI()).getTableSU().setValueAt(true, i, 8);
                    continue;
                }
                ((SoftwareUpgradePanel)this.getUI()).getTableSU().setValueAt(false, i, 8);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void actionItemSUSelectAllWithRunningVersionAndOlder() {
        int rows = ((SoftwareUpgradePanel)this.getUI()).getTableSU().getRowCount();
        int row = ((SoftwareUpgradePanel)this.getUI()).getTableSU().getSelectedRow();
        long swVer = this.getSoftwareVersionAsLong(this.getTableSURunningSW(row));
        for (int i = 0; i < rows; ++i) {
            try {
                long ver = this.getSoftwareVersionAsLong(this.getTableSURunningSW(i));
                if (swVer >= ver && ver > 0L) {
                    ((SoftwareUpgradePanel)this.getUI()).getTableSU().setValueAt(true, i, 8);
                    continue;
                }
                ((SoftwareUpgradePanel)this.getUI()).getTableSU().setValueAt(false, i, 8);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void enableSUPopup() {
        ((SoftwareUpgradePanel)this.getUI()).getItemSUSelectAll().setText(i18n.translateString("SWUPSelectAll"));
        ((SoftwareUpgradePanel)this.getUI()).getItemSUSelectAll().setEnabled(true);
        ((SoftwareUpgradePanel)this.getUI()).getItemSUUnselectAll().setText(i18n.translateString("SWUPUnselectAll"));
        ((SoftwareUpgradePanel)this.getUI()).getItemSUUnselectAll().setEnabled(true);
        ((SoftwareUpgradePanel)this.getUI()).getItemSUInvertSelection().setText(i18n.translateString("SWUPInvertSelection"));
        ((SoftwareUpgradePanel)this.getUI()).getItemSUInvertSelection().setEnabled(true);
        int row = ((SoftwareUpgradePanel)this.getUI()).getTableSU().getSelectedRow();
        ((SoftwareUpgradePanel)this.getUI()).getItemSUSelectUp().setText(i18n.translateString("SWUPSelectUp"));
        ((SoftwareUpgradePanel)this.getUI()).getItemSUSelectUp().setEnabled(true);
        ((SoftwareUpgradePanel)this.getUI()).getItemSUUnselectUp().setText(i18n.translateString("SWUPUnselectUp"));
        ((SoftwareUpgradePanel)this.getUI()).getItemSUUnselectUp().setEnabled(true);
        ((SoftwareUpgradePanel)this.getUI()).getItemSUSelectDown().setText(i18n.translateString("SWUPSelectDown"));
        ((SoftwareUpgradePanel)this.getUI()).getItemSUSelectDown().setEnabled(true);
        ((SoftwareUpgradePanel)this.getUI()).getItemSUUnselectDown().setText(i18n.translateString("SWUPUnselectDown"));
        ((SoftwareUpgradePanel)this.getUI()).getItemSUUnselectDown().setEnabled(true);
        String idAU = this.getTableSUAssociatedAU(row);
        ((SoftwareUpgradePanel)this.getUI()).getItemSUSelectAllForAU().setText(i18n.translateString("SWUPSelectAllForAU", new Object[]{idAU}));
        ((SoftwareUpgradePanel)this.getUI()).getItemSUSelectAllForAU().setEnabled(false);
        ((SoftwareUpgradePanel)this.getUI()).getItemSUUnselectAllForAU().setText(i18n.translateString("SWUPUnselectAllForAU", new Object[]{idAU}));
        ((SoftwareUpgradePanel)this.getUI()).getItemSUUnselectAllForAU().setEnabled(false);
        try {
            int intIdAU = Integer.parseInt(idAU);
            if (intIdAU > 0 && intIdAU < 255) {
                ((SoftwareUpgradePanel)this.getUI()).getItemSUSelectAllForAU().setEnabled(true);
                ((SoftwareUpgradePanel)this.getUI()).getItemSUUnselectAllForAU().setEnabled(true);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String swVer = this.getTableSUMainSW(row);
        ((SoftwareUpgradePanel)this.getUI()).getItemSUSelectAllWithVersion().setText(i18n.translateString("SWUPSelectAllWithVersion", new Object[]{swVer}));
        ((SoftwareUpgradePanel)this.getUI()).getItemSUSelectAllWithVersion().setEnabled(false);
        ((SoftwareUpgradePanel)this.getUI()).getItemSUSelectAllWithVersionAndNewer().setText(i18n.translateString("SWUPSelectAllWithVersionAndNewer", new Object[]{swVer}));
        ((SoftwareUpgradePanel)this.getUI()).getItemSUSelectAllWithVersionAndNewer().setEnabled(false);
        ((SoftwareUpgradePanel)this.getUI()).getItemSUSelectAllWithVersionAndOlder().setText(i18n.translateString("SWUPSelectAllWithVerisonAndOlder", new Object[]{swVer}));
        ((SoftwareUpgradePanel)this.getUI()).getItemSUSelectAllWithVersionAndOlder().setEnabled(false);
        if (this.getSoftwareVersionAsLong(swVer) > 0L) {
            ((SoftwareUpgradePanel)this.getUI()).getItemSUSelectAllWithVersion().setEnabled(true);
            ((SoftwareUpgradePanel)this.getUI()).getItemSUSelectAllWithVersionAndNewer().setEnabled(true);
            ((SoftwareUpgradePanel)this.getUI()).getItemSUSelectAllWithVersionAndOlder().setEnabled(true);
        }
        swVer = this.getTableSUShadowSW(row);
        ((SoftwareUpgradePanel)this.getUI()).getItemSUSelectAllWithShadowVersion().setText(i18n.translateString("SWUPSelectAllWithShadowVersion", new Object[]{swVer}));
        ((SoftwareUpgradePanel)this.getUI()).getItemSUSelectAllWithShadowVersion().setEnabled(false);
        ((SoftwareUpgradePanel)this.getUI()).getItemSUSelectAllWithShadowVersionAndNewer().setText(i18n.translateString("SWUPSelectAllWithShadowVersionAndNewer", new Object[]{swVer}));
        ((SoftwareUpgradePanel)this.getUI()).getItemSUSelectAllWithShadowVersionAndNewer().setEnabled(false);
        ((SoftwareUpgradePanel)this.getUI()).getItemSUSelectAllWithShadowVersionAndOlder().setText(i18n.translateString("SWUPSelectAllWithShadowVersionAndOlder", new Object[]{swVer}));
        ((SoftwareUpgradePanel)this.getUI()).getItemSUSelectAllWithShadowVersionAndOlder().setEnabled(false);
        if (this.getSoftwareVersionAsLong(swVer) > 0L) {
            ((SoftwareUpgradePanel)this.getUI()).getItemSUSelectAllWithShadowVersion().setEnabled(true);
            ((SoftwareUpgradePanel)this.getUI()).getItemSUSelectAllWithShadowVersionAndNewer().setEnabled(true);
            ((SoftwareUpgradePanel)this.getUI()).getItemSUSelectAllWithShadowVersionAndOlder().setEnabled(true);
        }
        swVer = this.getTableSURunningSW(row);
        ((SoftwareUpgradePanel)this.getUI()).getItemSUSelectAllWithRunningVersion().setText(i18n.translateString("SWUPSelectAllWithRunningVersion", new Object[]{swVer}));
        ((SoftwareUpgradePanel)this.getUI()).getItemSUSelectAllWithRunningVersion().setEnabled(false);
        ((SoftwareUpgradePanel)this.getUI()).getItemSUSelectAllWithRunningVersionAndNewer().setText(i18n.translateString("SWUPSelectAllWithRunningVersionAndNewer", new Object[]{swVer}));
        ((SoftwareUpgradePanel)this.getUI()).getItemSUSelectAllWithRunningVersionAndNewer().setEnabled(false);
        ((SoftwareUpgradePanel)this.getUI()).getItemSUSelectAllWithRunningVersionAndOlder().setText(i18n.translateString("SWUPSelectAllWithRunningVersionAndOlder", new Object[]{swVer}));
        ((SoftwareUpgradePanel)this.getUI()).getItemSUSelectAllWithRunningVersionAndOlder().setEnabled(false);
        if (this.getSoftwareVersionAsLong(swVer) > 0L) {
            ((SoftwareUpgradePanel)this.getUI()).getItemSUSelectAllWithRunningVersion().setEnabled(true);
            ((SoftwareUpgradePanel)this.getUI()).getItemSUSelectAllWithRunningVersionAndNewer().setEnabled(true);
            ((SoftwareUpgradePanel)this.getUI()).getItemSUSelectAllWithRunningVersionAndOlder().setEnabled(true);
        }
    }

    public long getSoftwareVersionAsLong(String swver) {
        return this.getFormattedSoftwareVersionAsLong(this.formatSoftwareVersion(swver));
    }

    public long getFormattedSoftwareVersionAsLong(String swver) {
        if ("".equals(swver)) {
            return 0L;
        }
        long ret = 1L;
        String[] vers = swver.split("[.]");
        for (int i = 0; i < vers.length; ++i) {
            ret *= 10000L;
            try {
                ret += (long)Integer.parseInt(vers[i]);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return ret;
    }

    public String formatSoftwareVersion(String swver) {
        swver = swver.replaceAll("[^01-9]+", " ");
        swver = swver.trim();
        swver = swver.replace(' ', '.');
        return swver;
    }

    private Window getParentWindow(Component comp) {
        Window w = null;
        for (comp = comp.getParent(); comp != null; comp = comp.getParent()) {
            if (!Window.class.isAssignableFrom(comp.getClass())) continue;
            w = (Window)comp;
            break;
        }
        return w;
    }

    private SoftwareUpgradePanelLog getPanelLog() {
        if (this.panelLog == null) {
            this.panelLog = new SoftwareUpgradePanelLog();
            this.panelLog.getBtnLogAbort().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SoftwareUpgradeConfigForm.this.swupAbort = true;
                }
            });
            this.panelLog.getBtnLogOpen().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFileChooser fc = new JFileChooser(DEFAULT_FIRMWARE_LOG_PATH);
                    int returnVal = fc.showOpenDialog(SoftwareUpgradeConfigForm.this.panelLog);
                    if (returnVal == 0) {
                        File file = fc.getSelectedFile();
                        SoftwareUpgradeConfigForm.this.multiLog.setText(file.getAbsolutePath() + LINE_SEPARATOR + LINE_SEPARATOR + new String(SoftwareUpgradeConfigForm.this.getFileContentAsByte(file)));
                        DEFAULT_FIRMWARE_LOG_PATH = file.getParent();
                    }
                }
            });
        }
        return this.panelLog;
    }

    private void initMultiLog() {
        if (this.multiLog == null) {
            this.multiLog = new TextAreaMultiThreading(this.panelLog.getTxtAreaLog());
        }
    }

    private void openRunFrame() {
        this.panelLog = this.getPanelLog();
        this.panelLog.getBtnLogStart().setEnabled(false);
        this.panelLog.getBtnLogStart().setVisible(false);
        this.panelLog.getBtnLogAbort().setEnabled(true);
        this.panelLog.getBtnLogAbort().setVisible(true);
        this.panelLog.getBtnLogOpen().setEnabled(false);
        this.panelLog.getBtnLogOpen().setVisible(false);
        this.panelLog.getBtnLogSave().setEnabled(false);
        this.panelLog.getBtnLogSave().setVisible(false);
        this.panelLog.getBtnLogClose().setEnabled(true);
        this.panelLog.getBtnLogClose().setVisible(true);
        this.panelLog.getProgressBar().setVisible(true);
        this.panelLog.getCheckAutoscroll().setVisible(true);
        this.panelLog.getCheckAutoscroll().setEnabled(true);
        IpAddress ipAddr = new IpAddress(this.ctx.getEquipment().getIpAddr().longValue());
        SimpleDateFormat df = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
        String logFile = DEFAULT_FIRMWARE_LOG_PATH + "/" + (ipAddr + "_" + df.format(new Date())).replaceAll("[ .:/]+", "_") + ".log";
        this.initMultiLog();
        Window parent = this.getParentWindow(this.getUI());
        Object[] options = new Object[]{i18n.translateString("SWUPLogSaveYes"), i18n.translateString("SWUPLogSaveNo"), i18n.translateString("SWUPLogSaveCancel")};
        int n = JOptionPane.showOptionDialog(parent, i18n.translateString("SWUPLogSaveTo"), i18n.translateString("SWUPRun"), 1, 3, null, options, options[2]);
        JFrame mf = FrameUtil.createModalFrame((Window)parent);
        switch (n) {
            case 0: {
                JFileChooser fc = new JFileChooser();
                fc.setSelectedFile(new File(logFile));
                int returnVal = fc.showSaveDialog(parent);
                File file = null;
                if (returnVal == 0) {
                    file = fc.getSelectedFile();
                    logFile = file.getAbsolutePath();
                    DEFAULT_FIRMWARE_LOG_PATH = file.getParent();
                    file = new File(logFile);
                    if (file.getName().length() > 104) {
                        FrameUtil.showError((Component)parent, (String)i18n.translateString("invalidFileName"), (String)i18n.translateString("Error"));
                        break;
                    }
                    this.multiLog.setText(logFile + LINE_SEPARATOR + LINE_SEPARATOR);
                    try {
                        final FileWriter logBuff = new FileWriter(logFile);
                        new Thread(){

                            public void run() {
                                SoftwareUpgradeConfigForm.this.runSoftwareUpgrade(logBuff);
                            }
                        }.start();
                        this.displayFrame(mf, i18n.translateString("SWUPRun"), this.panelLog, 400, 400);
                        logBuff.close();
                    }
                    catch (IOException ioe) {
                        logger.error((Object)"can't open log file", (Throwable)ioe);
                    }
                    this.doRefresh();
                    break;
                }
            }
            case 1: {
                this.multiLog.setText(i18n.translateString("SWUPLogNoFile") + LINE_SEPARATOR + LINE_SEPARATOR);
                new Thread(){

                    public void run() {
                        SoftwareUpgradeConfigForm.this.runSoftwareUpgrade(null);
                    }
                }.start();
                this.displayFrame(mf, i18n.translateString("SWUPRun"), this.panelLog, 400, 400);
                this.doRefresh();
            }
        }
    }

    private void openLogFrame() {
        JFrame mf = FrameUtil.createModalFrame((Window)this.getParentWindow(this.getUI()));
        this.panelLog = this.getPanelLog();
        this.panelLog.getBtnLogStart().setEnabled(false);
        this.panelLog.getBtnLogStart().setVisible(false);
        this.panelLog.getBtnLogAbort().setEnabled(false);
        this.panelLog.getBtnLogAbort().setVisible(false);
        this.panelLog.getBtnLogOpen().setEnabled(true);
        this.panelLog.getBtnLogOpen().setVisible(true);
        this.panelLog.getBtnLogSave().setEnabled(false);
        this.panelLog.getBtnLogSave().setVisible(false);
        this.panelLog.getBtnLogClose().setEnabled(true);
        this.panelLog.getBtnLogClose().setVisible(true);
        this.panelLog.getProgressBar().setVisible(false);
        this.panelLog.getCheckAutoscroll().setVisible(false);
        this.panelLog.getCheckAutoscroll().setEnabled(false);
        this.initMultiLog();
        this.displayFrame(mf, i18n.translateString("SWUPLog"), this.panelLog, 400, 400);
    }

    private void displayFrame(final JFrame frame, String title, JPanel panel, final int width, final int height) {
        frame.setTitle(title);
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (!SoftwareUpgradeConfigForm.this.swupIsRunning) {
                    frame.dispose();
                }
            }
        });
        this.removeActionListeners(this.panelLog.getBtnLogClose());
        this.panelLog.getBtnLogClose().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!SoftwareUpgradeConfigForm.this.swupIsRunning) {
                    frame.dispose();
                }
            }
        });
        this.removeActionListeners(this.panelLog.getCheckAutoscroll());
        this.panelLog.getCheckAutoscroll().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SoftwareUpgradeConfigForm.this.multiLog.setAutoscroll(((JCheckBox)e.getSource()).isSelected());
            }
        });
        frame.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                if (frame.getWidth() < width || frame.getHeight() < height) {
                    frame.setSize(width, height);
                }
            }
        });
        frame.getContentPane().add(panel);
        int maxWidth = (int)frame.getGraphicsConfiguration().getBounds().getWidth();
        int maxHeight = (int)frame.getGraphicsConfiguration().getBounds().getHeight();
        frame.setSize(width, height);
        frame.setMinimumSize(new Dimension(width, height));
        frame.setLocation((maxWidth - width) / 2, (maxHeight - height) / 2);
        try {
            frame.setVisible(true);
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
    }

    private void removeActionListeners(AbstractButton ab) {
        for (ActionListener al : ab.getActionListeners()) {
            ab.removeActionListener(al);
        }
    }

    private void doRefresh() {
        ((FormsConfigSectionView)this.getActionCommandCallback()).refresh(true);
    }

    private Boolean getTableSUSelectedStatus(int row) {
        return (Boolean)((SoftwareUpgradePanel)this.getUI()).getTableSUModel().getValueAt(row, 8);
    }

    private String getTableSUMAC(int row) {
        return (String)((SoftwareUpgradePanel)this.getUI()).getTableSUModel().getValueAt(row, 1);
    }

    private String getTableSUName(int row) {
        return (String)((SoftwareUpgradePanel)this.getUI()).getTableSUModel().getValueAt(row, 0);
    }

    private String getTableSUMainSW(int row) {
        return (String)((SoftwareUpgradePanel)this.getUI()).getTableSUModel().getValueAt(row, 5);
    }

    private String getTableSUShadowSW(int row) {
        return (String)((SoftwareUpgradePanel)this.getUI()).getTableSUModel().getValueAt(row, 6);
    }

    private String getTableSURunningSW(int row) {
        return (String)((SoftwareUpgradePanel)this.getUI()).getTableSUModel().getValueAt(row, 7);
    }

    private String getTableSUAssociatedAU(int row) {
        return ((SoftwareUpgradePanel)this.getUI()).getTableSUModel().getValueAt(row, 4).toString();
    }

    private String getTableAUSlot(int row) {
        return ((SoftwareUpgradePanel)this.getUI()).getTableNPUandAUModel().getValueAt(row, 1).toString();
    }

    private String getTableNPUandAUType(int row) {
        return (String)((SoftwareUpgradePanel)this.getUI()).getTableNPUandAUModel().getValueAt(row, 0);
    }

    private Boolean getTableNPUandAUSelectedStatus(int row) {
        return (Boolean)((SoftwareUpgradePanel)this.getUI()).getTableNPUandAUModel().getValueAt(row, 6);
    }

    private synchronized void addToLog(StringBuffer buff, String id, String str) {
        buff.append(str);
        this.multiLog.insert(id, str);
    }

    private synchronized void appendToLogFile(FileWriter logFile, String str) {
        if (logFile != null) {
            try {
                logFile.write(str);
            }
            catch (IOException ioe) {
                logger.error((Object)"can't append to log file", (Throwable)ioe);
            }
        }
    }

    private void runSoftwareUpgrade(final FileWriter logFile) {
        this.swupIsRunning = true;
        this.swupAbort = false;
        this.panelLog.getProgressBar().setIndeterminate(true);
        try {
            Boolean selected;
            int i;
            this.multiLog.append(this.logStatus("", "SWUPmsgStarted", 2));
            this.appendToLogFile(logFile, this.logStatus("", "SWUPmsgStarted", 2));
            int rows = ((SoftwareUpgradePanel)this.getUI()).getTableNPUandAUModel().getRowCount();
            for (i = 0; i < rows; ++i) {
                selected = this.getTableNPUandAUSelectedStatus(i);
                if (selected != null && selected.booleanValue()) {
                    this.setRowStatusNPUandAU("SWUPmsgWAIT", i);
                    continue;
                }
                this.setRowStatusNPUandAU("", i);
            }
            rows = ((SoftwareUpgradePanel)this.getUI()).getTableSUModel().getRowCount();
            for (i = 0; i < rows; ++i) {
                selected = this.getTableSUSelectedStatus(i);
                if (selected != null && selected.booleanValue()) {
                    this.setRowStatusSU("SWUPmsgWAIT", i);
                    continue;
                }
                this.setRowStatusSU("", i);
            }
            final String[] files = new String[]{((SoftwareUpgradePanel)this.getUI()).getCmbNPUFiles().getSelectedIndex() == 1 ? ((SimpleFileChooser)((SoftwareUpgradePanel)this.getUI()).getCmbNPUFiles().getSelectedItem()).getText() : (String)((SoftwareUpgradePanel)this.getUI()).getCmbNPUFiles().getSelectedItem(), ((SoftwareUpgradePanel)this.getUI()).getCmbAUFiles().getSelectedIndex() == 1 ? ((SimpleFileChooser)((SoftwareUpgradePanel)this.getUI()).getCmbAUFiles().getSelectedItem()).getText() : (String)((SoftwareUpgradePanel)this.getUI()).getCmbAUFiles().getSelectedItem(), ((SoftwareUpgradePanel)this.getUI()).getCmbSUFiles().getSelectedIndex() == 1 ? ((SimpleFileChooser)((SoftwareUpgradePanel)this.getUI()).getCmbSUFiles().getSelectedItem()).getText() : (String)((SoftwareUpgradePanel)this.getUI()).getCmbSUFiles().getSelectedItem()};
            boolean someOp = false;
            Integer oper = (Integer)((ComboItem)((SoftwareUpgradePanel)this.getUI()).getCmbSUOp().getSelectedItem()).getValue();
            File f = new File(files[2]);
            String status = "";
            String message = "";
            if (oper >= 2 && !"".equals(f.getName())) {
                someOp = true;
                this.appendToLogFile(logFile, this.logStatus("SWUPFileStr", new Object[]{f.getName()}, ""));
                this.multiLog.append(this.logStatus("SWUPFileStr", new Object[]{f.getName()}, ""));
                this.appendToLogFile(logFile, this.logStatus("SWUPopLoadToBS", ""));
                this.multiLog.append(this.logStatus("SWUPopLoadToBS", ""));
                if (f.isAbsolute()) {
                    if (!this.isFileOnNPU(f.getName())) {
                        if (this.isSpaceToUploadFileOnNPU(((SoftwareUpgradePanel)this.getUI()).getTableNPUFilesSU())) {
                            try {
                                RbBaseStationEquipment baseStation = (RbBaseStationEquipment)this.ctx.getEquipment();
                                logger.debug((Object)"SU Loading to NPU...");
                                TftpFileTransferService fts = MediationServiceRegistry.getTftpFileTransferService();
                                SynchronousFileTransfer syncFTS = new SynchronousFileTransfer((FileTransferService)fts, "topic/TftpMediationTopic");
                                byte[] fileData = this.getFileContentAsByte(f);
                                if (fileData != null) {
                                    FileTransferEvent res = syncFTS.executeTransfer((FileTransferRequest)new TftpFileTransferRequest(baseStation.getIPAddress(), 3, 5000, fileData, f.getName()), 600000L);
                                    if (res == null || res.getEventType() != 3) {
                                        status = "SWUPmsgFAIL";
                                        message = "SWUPopLoadToBS";
                                        logger.debug((Object)"SU Tftp failed");
                                    } else {
                                        status = "SWUPmsgOK";
                                        message = "SWUPopLoadToBS";
                                        this.addFileToSUTableFilesNPU(f.getName());
                                        logger.debug((Object)"SU Load to NPU OK");
                                    }
                                } else {
                                    status = "SWUPmsgFAIL";
                                    message = "SWUPmsgErrReadingFile";
                                    logger.debug((Object)"SU Error reading file");
                                }
                            }
                            catch (Exception e) {
                                status = "SWUPmsgFAIL";
                                message = "SWUPmsgErrDevice";
                                logger.debug((Object)e);
                            }
                            this.appendToLogFile(logFile, this.logStatus(status, message, 2));
                            this.multiLog.append(this.logStatus(status, message, 2));
                        } else {
                            this.appendToLogFile(logFile, this.logStatus("SWUPmsgFAIL", "SWUPmsgNoSpaceOnNPU", 2));
                            this.multiLog.append(this.logStatus("SWUPmsgFAIL", "SWUPmsgNoSpaceOnNPU", 2));
                        }
                    } else {
                        this.appendToLogFile(logFile, this.logStatus("SWUPmsgSKIP", "SWUPmsgFileOnNPU", 2));
                        this.multiLog.append(this.logStatus("SWUPmsgSKIP", "SWUPmsgFileOnNPU", 2));
                    }
                } else {
                    this.appendToLogFile(logFile, this.logStatus("SWUPmsgSKIP", "SWUPmsgFileOnNPU", 2));
                    this.multiLog.append(this.logStatus("SWUPmsgSKIP", "SWUPmsgFileOnNPU", 2));
                }
            }
            this.executor = Executors.newFixedThreadPool(10);
            rows = ((SoftwareUpgradePanel)this.getUI()).getTableSUModel().getRowCount();
            this.selectedEntriesSU.clear();
            int threadsCount = 0;
            for (int i2 = 0; i2 < rows; ++i2) {
                Boolean selected2 = this.getTableSUSelectedStatus(i2);
                if (selected2 != null && selected2.booleanValue()) {
                    final int j = i2;
                    try {
                        this.executor.execute(new Runnable(){

                            public void run() {
                                SoftwareUpgradeConfigForm.this.runSUSoftwareUpgrade(j, files[2], (Integer)((ComboItem)((SoftwareUpgradePanel)SoftwareUpgradeConfigForm.this.getUI()).getCmbSUOp().getSelectedItem()).getValue(), logFile);
                            }
                        });
                        someOp = true;
                        ++threadsCount;
                    }
                    catch (Exception e) {
                        this.setRowStatusSU("SWUPmsgNOTSTARTED", i2);
                        logger.error((Object)e);
                    }
                    continue;
                }
                this.setRowStatusSU("", i2);
            }
            ExecutorUtils.shutdownAndWait((String)"SWUP SU", (ExecutorService)this.executor, (int)(((threadsCount - 1) / 10 + 1) * 600));
            oper = (Integer)((ComboItem)((SoftwareUpgradePanel)this.getUI()).getCmbAUOp().getSelectedItem()).getValue();
            f = new File(files[1]);
            if (oper >= 2 && !"".equals(f.getName())) {
                someOp = true;
                this.appendToLogFile(logFile, this.logStatus("SWUPFileStr", new Object[]{f.getName()}, ""));
                this.multiLog.append(this.logStatus("SWUPFileStr", new Object[]{f.getName()}, ""));
                this.appendToLogFile(logFile, this.logStatus("SWUPopLoadToBS", ""));
                this.multiLog.append(this.logStatus("SWUPopLoadToBS", ""));
                if (f.isAbsolute()) {
                    if (!this.isFileOnNPU(f.getName())) {
                        if (this.isSpaceToUploadFileOnNPU(((SoftwareUpgradePanel)this.getUI()).getTableNPUFilesAU())) {
                            try {
                                RbBaseStationEquipment baseStation = (RbBaseStationEquipment)this.ctx.getEquipment();
                                logger.debug((Object)"AU Loading to NPU...");
                                TftpFileTransferService fts = MediationServiceRegistry.getTftpFileTransferService();
                                SynchronousFileTransfer syncFTS = new SynchronousFileTransfer((FileTransferService)fts, "topic/TftpMediationTopic");
                                byte[] fileData = this.getFileContentAsByte(f);
                                if (fileData != null) {
                                    FileTransferEvent res = syncFTS.executeTransfer((FileTransferRequest)new TftpFileTransferRequest(baseStation.getIPAddress(), 3, 5000, fileData, f.getName()), 600000L);
                                    if (res == null || res.getEventType() != 3) {
                                        status = "SWUPmsgFAIL";
                                        message = "SWUPopLoadToBS";
                                        logger.debug((Object)"AU Tftp failed");
                                    } else {
                                        status = "SWUPmsgOK";
                                        message = "SWUPopLoadToBS";
                                        this.addFileToAUTableFilesNPU(f.getName());
                                        logger.debug((Object)"AU Load to NPU OK");
                                    }
                                } else {
                                    status = "SWUPmsgFAIL";
                                    message = "SWUPmsgErrReadingFile";
                                    logger.debug((Object)"AU Error reading file");
                                }
                            }
                            catch (Exception e) {
                                status = "SWUPmsgFAIL";
                                message = "SWUPmsgErrDevice";
                                logger.debug((Object)e);
                            }
                            this.appendToLogFile(logFile, this.logStatus(status, message, 2));
                            this.multiLog.append(this.logStatus(status, message, 2));
                        } else {
                            this.appendToLogFile(logFile, this.logStatus("SWUPmsgFAIL", "SWUPmsgNoSpaceOnNPU", 2));
                            this.multiLog.append(this.logStatus("SWUPmsgFAIL", "SWUPmsgNoSpaceOnNPU", 2));
                        }
                    } else {
                        this.appendToLogFile(logFile, this.logStatus("SWUPmsgSKIP", "SWUPmsgFileOnNPU", 2));
                        this.multiLog.append(this.logStatus("SWUPmsgSKIP", "SWUPmsgFileOnNPU", 2));
                    }
                } else {
                    this.appendToLogFile(logFile, this.logStatus("SWUPmsgSKIP", "SWUPmsgFileOnNPU", 2));
                    this.multiLog.append(this.logStatus("SWUPmsgSKIP", "SWUPmsgFileOnNPU", 2));
                }
            }
            this.executor = Executors.newFixedThreadPool(10);
            int rowNPU = -1;
            rows = ((SoftwareUpgradePanel)this.getUI()).getTableNPUandAUModel().getRowCount();
            threadsCount = 0;
            for (int i3 = 0; i3 < rows; ++i3) {
                Boolean selected3 = this.getTableNPUandAUSelectedStatus(i3);
                if (selected3 == null || !selected3.booleanValue()) continue;
                if (this.getTableNPUandAUType(i3).equals(i18n.translateString("SWUPAU"))) {
                    final int j = i3;
                    try {
                        this.executor.execute(new Runnable(){

                            public void run() {
                                SoftwareUpgradeConfigForm.this.runAUSoftwareUpgrade(j, files[1], (Integer)((ComboItem)((SoftwareUpgradePanel)SoftwareUpgradeConfigForm.this.getUI()).getCmbAUOp().getSelectedItem()).getValue(), logFile);
                            }
                        });
                        someOp = true;
                        ++threadsCount;
                    }
                    catch (Exception e) {
                        this.setRowStatusSU("SWUPmsgNOTSTARTED", i3);
                        logger.error((Object)e);
                    }
                    continue;
                }
                rowNPU = i3;
            }
            ExecutorUtils.shutdownAndWait((String)"SWUP AU", (ExecutorService)this.executor, (int)(((threadsCount - 1) / 10 + 1) * 600));
            if (rowNPU >= 0) {
                if (this.isBS) {
                    this.runNPUSoftwareUpgrade(rowNPU, files[0], (Integer)((ComboItem)((SoftwareUpgradePanel)this.getUI()).getCmbNPUOp().getSelectedItem()).getValue(), logFile);
                } else {
                    this.runMBSSoftwareUpgrade(rowNPU, files[0], (Integer)((ComboItem)((SoftwareUpgradePanel)this.getUI()).getCmbNPUOp().getSelectedItem()).getValue(), logFile);
                }
                someOp = true;
            }
            if (this.swupAbort) {
                this.multiLog.append(this.logStatus("", "SWUPmsgAborted", 2));
                this.appendToLogFile(logFile, this.logStatus("", "SWUPmsgAborted"));
            } else if (!someOp) {
                this.multiLog.append(this.logStatus("", "SWUPmsgNoOp", 2));
                this.appendToLogFile(logFile, this.logStatus("", "SWUPmsgNoOp", 2));
            }
            this.multiLog.append(this.logStatus("", "SWUPmsgFinished"));
            this.appendToLogFile(logFile, this.logStatus("", "SWUPmsgFinished"));
            this.panelLog.getBtnLogAbort().setEnabled(false);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        this.swupIsRunning = false;
        this.panelLog.getProgressBar().setIndeterminate(false);
        this.panelLog.getBtnLogClose().setEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runNPUSoftwareUpgrade(int row, String file, int oper, FileWriter logFile) {
        StringBuffer buff = new StringBuffer();
        String mac = "NPU";
        this.multiLog.insertSeparator(mac, LINE_SEPARATOR);
        this.addToLog(buff, mac, this.logStatus("SWUPmsgNPU", ""));
        this.setRowStatusNPUandAU("SWUPmsgPROGRESS", row);
        File f = new File(file);
        String status = "";
        String message = "";
        if (this.swupAbort) {
            status = "SWUPmsgABORT";
            message = "";
            logger.debug((Object)"NPU Aborted");
        } else if (!this.npu.isConnected()) {
            status = "SWUPmsgSKIP";
            message = "SWUPmsgNPUUnreachable";
            logger.debug((Object)"NPU Unreachable");
        } else if (oper == 0) {
            status = "SWUPmsgSKIP";
            message = "SWUPmsgNoOp";
            logger.debug((Object)"NPU No operation");
        } else if ("".equals(file) && oper != 1) {
            status = "SWUPmsgSKIP";
            message = "SWUPmsgNoFile";
            logger.debug((Object)"NPU No file");
        } else if (oper >= 3 && f.getName().equals(this.npu.getRbNpuOperSwFileName())) {
            this.addToLog(buff, mac, this.logStatus("SWUPFileStr", new Object[]{f.getName()}, ""));
            this.addToLog(buff, mac, this.logStatus("SWUPopLoadToBS", ""));
            status = "SWUPmsgSKIP";
            message = "SWUPmsgSameMainVer";
            logger.debug((Object)"NPU File same with main");
        } else if (oper == 3 && f.getName().equals(this.npu.getRbNpuShadowSwFileName())) {
            this.addToLog(buff, mac, this.logStatus("SWUPFileStr", new Object[]{f.getName()}, ""));
            this.addToLog(buff, mac, this.logStatus("SWUPopLoadToBS", ""));
            status = "SWUPmsgSKIP";
            message = "SWUPmsgSameShadowVer";
            logger.debug((Object)"NPU File same with shadow");
        } else if (oper == 4 && f.getName().equals(this.npu.getRbNpuShadowSwFileName()) && this.npu.getRbNpuRunningSoftware() == 2) {
            this.addToLog(buff, mac, this.logStatus("SWUPFileStr", new Object[]{f.getName()}, ""));
            this.addToLog(buff, mac, this.logStatus("SWUPopRunFromShadow", ""));
            status = "SWUPmsgSKIP";
            message = "SWUPmsgRunningFromShadow";
            logger.debug((Object)"NPU File already running from shadow");
        } else if (oper >= 3 && !f.getName().equals(this.npu.getRbNpuShadowSwFileName()) && this.npu.getRbNpuRunningSoftware() == 2) {
            this.addToLog(buff, mac, this.logStatus("SWUPFileStr", new Object[]{f.getName()}, ""));
            switch (oper) {
                case 3: {
                    this.addToLog(buff, mac, this.logStatus("SWUPopLoadToShadow", ""));
                    break;
                }
                case 4: {
                    this.addToLog(buff, mac, this.logStatus("SWUPopRunFromShadow", ""));
                    break;
                }
                case 5: {
                    this.addToLog(buff, mac, this.logStatus("SWUPopSetMain", ""));
                }
            }
            status = "SWUPmsgFAIL";
            message = "SWUPmsgAlreadyRunningFromShadow";
            logger.debug((Object)"NPU running from shadow");
        } else {
            MOAccessSession access = null;
            try {
                RbBaseStationEquipment baseStation = (RbBaseStationEquipment)this.ctx.getEquipment();
                access = MediationServiceRegistry.getMOSession((SNMPManagementInterface)baseStation.getManagementInterface(), null);
                if (oper == 1) {
                    this.addToLog(buff, mac, this.logStatus("SWUPopReset", ""));
                    this.setRowStatusNPUandAU("SWUPopReset", row);
                    logger.debug((Object)"NPU Reset...");
                    RbNpuCommand command = this.createNPUCommand(this.npu.getRbSlotNumber(), 2);
                    access.commitObject(null, (Object)command);
                    String[] result = new String[]{""};
                    this.waitForUnit((ManagedObject)this.npu, ((Object)((Object)this.npu)).getClass(), result);
                    status = result[0];
                    message = "SWUPopReset";
                    logger.debug((Object)("NPU " + status));
                } else if (oper >= 3) {
                    boolean cont = true;
                    this.addToLog(buff, mac, this.logStatus("SWUPFileStr", new Object[]{f.getName()}, ""));
                    if (!f.getName().equals(this.npu.getRbNpuShadowSwFileName())) {
                        logger.debug((Object)"NPU Loading to shadow...");
                        this.addToLog(buff, mac, this.logStatus("SWUPopLoadToBS", ""));
                        this.setRowStatusNPUandAU("SWUPopLoadToBS", row);
                        TftpFileTransferService fts = MediationServiceRegistry.getTftpFileTransferService();
                        SynchronousFileTransfer syncFTS = new SynchronousFileTransfer((FileTransferService)fts, "topic/TftpMediationTopic");
                        byte[] fileData = this.getFileContentAsByte(f);
                        if (fileData != null) {
                            FileTransferEvent res = syncFTS.executeTransfer((FileTransferRequest)new TftpFileTransferRequest(baseStation.getIPAddress(), 3, 5000, fileData, f.getName()), 600000L);
                            if (res == null || res.getEventType() != 3) {
                                status = "SWUPmsgFAIL";
                                message = "SWUPopLoadToBS";
                                logger.debug((Object)"NPU Tftp failed");
                                cont = false;
                            } else {
                                status = "SWUPmsgOK";
                                message = "SWUPopLoadToBS";
                                logger.debug((Object)"NPU Load to NPU OK");
                                String[] result = new String[]{""};
                                cont = this.waitForUnit((ManagedObject)this.npu, ((Object)((Object)this.npu)).getClass(), result);
                                status = result[0];
                                message = "SWUPopLoadToBS";
                                logger.debug((Object)("NPU " + status));
                            }
                        } else {
                            status = "SWUPmsgFAIL";
                            message = "SWUPmsgErrReadingFile";
                            logger.debug((Object)"NPU Error reading file");
                            cont = false;
                        }
                    }
                    if (cont && oper >= 4) {
                        String[] result;
                        RbNpuCommand command;
                        if (!f.getName().equals(this.npu.getRbNpuShadowSwFileName()) || this.npu.getRbNpuRunningSoftware() != 2) {
                            this.addToLog(buff, mac, this.logStatus("SWUPopRunFromShadow", ""));
                            this.setRowStatusNPUandAU("SWUPopRunFromShadow", row);
                            logger.debug((Object)"NPU Running from shadow...");
                            command = this.createNPUCommand(this.npu.getRbSlotNumber(), 4);
                            access.commitObject(null, (Object)command);
                            result = new String[]{""};
                            cont = this.waitForUnit((ManagedObject)this.npu, ((Object)((Object)this.npu)).getClass(), result);
                            status = result[0];
                            message = "SWUPopRunFromShadow";
                            logger.debug((Object)("NPU " + status));
                        } else {
                            logger.debug((Object)"NPU File already running from shadow");
                        }
                        if (cont && oper >= 5) {
                            this.addToLog(buff, mac, this.logStatus("SWUPopSetMain", ""));
                            this.setRowStatusNPUandAU("SWUPopSetMain", row);
                            logger.debug((Object)"NPU Setting main...");
                            command = this.createNPUCommand(this.npu.getRbSlotNumber(), 5);
                            access.commitObject(null, (Object)command);
                            result = new String[]{""};
                            cont = this.waitForUnit((ManagedObject)this.npu, ((Object)((Object)this.npu)).getClass(), result);
                            status = result[0];
                            message = "SWUPopSetMain";
                            logger.debug((Object)("NPU " + status));
                        }
                    }
                }
                logger.debug((Object)("NPU " + status + " " + message));
            }
            catch (MediationException e) {
                status = "SWUPmsgFAIL";
                message = "SWUPmsgErrDevice";
                logger.debug((Object)e);
            }
            finally {
                if (access != null) {
                    access.close();
                }
            }
        }
        this.addToLog(buff, mac, this.logStatus(status, message));
        this.setRowStatusNPUandAU(status, row);
        this.appendToLogFile(logFile, buff.toString() + LINE_SEPARATOR);
        try {
            logFile.flush();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runMBSSoftwareUpgrade(int row, String file, int oper, FileWriter logFile) {
        StringBuffer buff = new StringBuffer();
        String mac = "MBS";
        this.multiLog.insertSeparator(mac, LINE_SEPARATOR);
        this.addToLog(buff, mac, this.logStatus("SWUPmsgMBS", ""));
        this.setRowStatusNPUandAU("SWUPmsgPROGRESS", row);
        File f = new File(file);
        String status = "";
        String message = "";
        if (this.swupAbort) {
            status = "SWUPmsgABORT";
            message = "";
            logger.debug((Object)"MBS Aborted");
        } else if (!this.mbs.isConnected()) {
            status = "SWUPmsgSKIP";
            message = "SWUPmsgMBSUnreachable";
            logger.debug((Object)"MBS Unreachable");
        } else if (oper == 0) {
            status = "SWUPmsgSKIP";
            message = "SWUPmsgNoOp";
            logger.debug((Object)"MBS No operation");
        } else if ("".equals(file) && oper != 1) {
            status = "SWUPmsgSKIP";
            message = "SWUPmsgNoFile";
            logger.debug((Object)"MBS No file");
        } else if (oper >= 3 && f.getName().equals(this.mbs.getRbMBSTOperSwFileName())) {
            this.addToLog(buff, mac, this.logStatus("SWUPFileStr", new Object[]{f.getName()}, ""));
            this.addToLog(buff, mac, this.logStatus("SWUPopLoadToMBS", ""));
            status = "SWUPmsgSKIP";
            message = "SWUPmsgSameMainVer";
            logger.debug((Object)"MBS File same with main");
        } else if (oper == 3 && f.getName().equals(this.mbs.getRbMBSTShadowSwFileName())) {
            this.addToLog(buff, mac, this.logStatus("SWUPFileStr", new Object[]{f.getName()}, ""));
            this.addToLog(buff, mac, this.logStatus("SWUPopLoadToMBS", ""));
            status = "SWUPmsgSKIP";
            message = "SWUPmsgSameShadowVer";
            logger.debug((Object)"MBS File same with shadow");
        } else if (oper == 4 && f.getName().equals(this.mbs.getRbMBSTShadowSwFileName()) && this.mbs.getRbMBSTRunningSoftware() == 2) {
            this.addToLog(buff, mac, this.logStatus("SWUPFileStr", new Object[]{f.getName()}, ""));
            this.addToLog(buff, mac, this.logStatus("SWUPopRunFromShadow", ""));
            status = "SWUPmsgSKIP";
            message = "SWUPmsgRunningFromShadow";
            logger.debug((Object)"MBS File already running from shadow");
        } else if (oper >= 3 && !f.getName().equals(this.mbs.getRbMBSTShadowSwFileName()) && this.mbs.getRbMBSTRunningSoftware() == 2) {
            this.addToLog(buff, mac, this.logStatus("SWUPFileStr", new Object[]{f.getName()}, ""));
            switch (oper) {
                case 3: {
                    this.addToLog(buff, mac, this.logStatus("SWUPopLoadToShadow", ""));
                    break;
                }
                case 4: {
                    this.addToLog(buff, mac, this.logStatus("SWUPopRunFromShadow", ""));
                    break;
                }
                case 5: {
                    this.addToLog(buff, mac, this.logStatus("SWUPopSetMain", ""));
                }
            }
            status = "SWUPmsgFAIL";
            message = "SWUPmsgAlreadyRunningFromShadow";
            logger.debug((Object)"MBS running from shadow");
        } else {
            MOAccessSession access = null;
            try {
                RbBaseStationEquipment baseStation = (RbBaseStationEquipment)this.ctx.getEquipment();
                access = MediationServiceRegistry.getMOSession((SNMPManagementInterface)baseStation.getManagementInterface(), null);
                if (oper == 1) {
                    this.addToLog(buff, mac, this.logStatus("SWUPopReset", ""));
                    this.setRowStatusNPUandAU("SWUPopReset", row);
                    logger.debug((Object)"MBS Reset...");
                    RbMbsCommand command = this.createMBSCommand(2);
                    access.commitObject(null, (Object)command);
                    String[] result = new String[]{""};
                    this.waitForUnit((ManagedObject)this.mbs, ((Object)((Object)this.mbs)).getClass(), result);
                    status = result[0];
                    message = "SWUPopReset";
                    logger.debug((Object)("MBS " + status));
                } else if (oper >= 3) {
                    boolean cont = true;
                    this.addToLog(buff, mac, this.logStatus("SWUPFileStr", new Object[]{f.getName()}, ""));
                    if (!f.getName().equals(this.mbs.getRbMBSTShadowSwFileName())) {
                        logger.debug((Object)"MBS Loading to shadow...");
                        this.addToLog(buff, mac, this.logStatus("SWUPopLoadToMBS", ""));
                        this.setRowStatusNPUandAU("SWUPopLoadToMBS", row);
                        TftpFileTransferService fts = MediationServiceRegistry.getTftpFileTransferService();
                        SynchronousFileTransfer syncFTS = new SynchronousFileTransfer((FileTransferService)fts, "topic/TftpMediationTopic");
                        byte[] fileData = this.getFileContentAsByte(f);
                        if (fileData != null) {
                            FileTransferEvent res = syncFTS.executeTransfer((FileTransferRequest)new TftpFileTransferRequest(baseStation.getIPAddress(), 3, 5000, fileData, f.getName()), 600000L);
                            if (res == null || res.getEventType() != 3) {
                                status = "SWUPmsgFAIL";
                                message = "SWUPopLoadToMBS";
                                logger.debug((Object)"MBS Tftp failed");
                                cont = false;
                            } else {
                                status = "SWUPmsgOK";
                                message = "SWUPopLoadToMBS";
                                logger.debug((Object)"MBS Load to MBS OK");
                                String[] result = new String[]{""};
                                cont = this.waitForUnit((ManagedObject)this.mbs, ((Object)((Object)this.mbs)).getClass(), result);
                                status = result[0];
                                message = "SWUPopLoadToMBS";
                                logger.debug((Object)("MBS " + status));
                            }
                        } else {
                            status = "SWUPmsgFAIL";
                            message = "SWUPmsgErrReadingFile";
                            logger.debug((Object)"MBS Error reading file");
                            cont = false;
                        }
                    }
                    if (cont && oper >= 4) {
                        String[] result;
                        RbMbsCommand command;
                        if (!f.getName().equals(this.mbs.getRbMBSTShadowSwFileName()) || this.mbs.getRbMBSTRunningSoftware() != 2) {
                            this.addToLog(buff, mac, this.logStatus("SWUPopRunFromShadow", ""));
                            this.setRowStatusNPUandAU("SWUPopRunFromShadow", row);
                            logger.debug((Object)"MBS Running from shadow...");
                            command = this.createMBSCommand(4);
                            access.commitObject(null, (Object)command);
                            result = new String[]{""};
                            cont = this.waitForUnit((ManagedObject)this.mbs, ((Object)((Object)this.mbs)).getClass(), result);
                            status = result[0];
                            message = "SWUPopRunFromShadow";
                            logger.debug((Object)("MBS " + status));
                        } else {
                            logger.debug((Object)"MBS File already running from shadow");
                        }
                        if (cont && oper >= 5) {
                            this.addToLog(buff, mac, this.logStatus("SWUPopSetMain", ""));
                            this.setRowStatusNPUandAU("SWUPopSetMain", row);
                            logger.debug((Object)"MBS Setting main...");
                            command = this.createMBSCommand(5);
                            access.commitObject(null, (Object)command);
                            result = new String[]{""};
                            cont = this.waitForUnit((ManagedObject)this.mbs, ((Object)((Object)this.mbs)).getClass(), result);
                            status = result[0];
                            message = "SWUPopSetMain";
                            logger.debug((Object)("MBS " + status));
                        }
                    }
                }
                logger.debug((Object)("MBS " + status + " " + message));
            }
            catch (MediationException e) {
                status = "SWUPmsgFAIL";
                message = "SWUPmsgErrDevice";
                logger.debug((Object)e);
            }
            finally {
                if (access != null) {
                    access.close();
                }
            }
        }
        this.addToLog(buff, mac, this.logStatus(status, message));
        this.setRowStatusNPUandAU(status, row);
        this.appendToLogFile(logFile, buff.toString() + LINE_SEPARATOR);
        try {
            logFile.flush();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAUSoftwareUpgrade(int row, String file, int oper, FileWriter logFile) {
        StringBuffer buff = new StringBuffer();
        RbAuConfigEntry au = this.getAUfromRow(row);
        String mac = "AU" + au.getRbSlotNumber();
        this.multiLog.insertSeparator(mac, LINE_SEPARATOR);
        this.addToLog(buff, mac, this.logStatus("SWUPmsgAU", new Object[]{au.getRbSlotNumber()}, ""));
        this.setRowStatusNPUandAU("SWUPmsgPROGRESS", row);
        String status = "";
        String message = "";
        File f = new File(file);
        if (this.swupAbort) {
            status = "SWUPmsgABORT";
            message = "";
            logger.debug((Object)"AU Aborted");
        } else if (!au.isConnected()) {
            status = "SWUPmsgSKIP";
            message = "SWUPmsgAUDisc";
            logger.debug((Object)"AU Disconnected");
        } else if (oper == 0) {
            status = "SWUPmsgSKIP";
            message = "SWUPmsgNoOp";
            logger.debug((Object)"AU No operation");
        } else if ("".equals(file) && oper != 1) {
            status = "SWUPmsgSKIP";
            message = "SWUPmsgNoFile";
            logger.debug((Object)"AU No file");
        } else if (oper == 2) {
            this.addToLog(buff, mac, this.logStatus("SWUPFileStr", new Object[]{f.getName()}, ""));
            this.addToLog(buff, mac, this.logStatus("SWUPopLoadToBS", ""));
            if (this.isFileOnNPU(f.getName())) {
                status = "SWUPmsgSKIP";
                message = "SWUPmsgFileOnNPU";
                logger.debug((Object)"AU File already on NPU");
            } else {
                status = "SWUPmsgFAIL";
                message = "SWUPopLoadToBS";
                logger.debug((Object)"AU File not on NPU");
            }
        } else if (oper != 1 && !this.isFileOnNPU(f.getName())) {
            this.addToLog(buff, mac, this.logStatus("SWUPFileStr", new Object[]{f.getName()}, ""));
            status = "SWUPmsgFAIL";
            logger.debug((Object)"AU File not on NPU");
            switch (oper) {
                case 3: {
                    this.addToLog(buff, mac, this.logStatus("SWUPopLoadToShadow", ""));
                    message = "SWUPopLoadToShadow";
                    break;
                }
                case 4: {
                    this.addToLog(buff, mac, this.logStatus("SWUPopRunFromShadow", ""));
                    message = "SWUPopRunFromShadow";
                    break;
                }
                case 5: {
                    this.addToLog(buff, mac, this.logStatus("SWUPopSetMain", ""));
                    message = "SWUPopSetMain";
                }
            }
        } else if (oper == 3 && f.getName().equals(au.getRbAuShadowSwFileName())) {
            this.addToLog(buff, mac, this.logStatus("SWUPFileStr", new Object[]{f.getName()}, ""));
            this.addToLog(buff, mac, this.logStatus("SWUPopLoadToShadow", ""));
            status = "SWUPmsgSKIP";
            message = "SWUPmsgSameShadowVer";
            logger.debug((Object)"AU File same with shadow");
        } else if (oper >= 3 && f.getName().equals(au.getRbAuOperSwFileName())) {
            this.addToLog(buff, mac, this.logStatus("SWUPFileStr", new Object[]{f.getName()}, ""));
            this.addToLog(buff, mac, this.logStatus("SWUPopLoadToShadow", ""));
            status = "SWUPmsgSKIP";
            message = "SWUPmsgSameMainVer";
            logger.debug((Object)"AU File same with main");
        } else if (oper == 4 && au.getRbAuRunningSoftware() == 2 && f.getName().equals(au.getRbAuShadowSwFileName())) {
            this.addToLog(buff, mac, this.logStatus("SWUPFileStr", new Object[]{f.getName()}, ""));
            this.addToLog(buff, mac, this.logStatus("SWUPopRunFromShadow", ""));
            status = "SWUPmsgSKIP";
            message = "SWUPmsgRunningFromShadow";
            logger.debug((Object)"AU File already running from shadow");
        } else if (oper >= 3 && !f.getName().equals(au.getRbAuShadowSwFileName()) && au.getRbAuRunningSoftware() == 2) {
            this.addToLog(buff, mac, this.logStatus("SWUPFileStr", new Object[]{f.getName()}, ""));
            switch (oper) {
                case 3: {
                    this.addToLog(buff, mac, this.logStatus("SWUPopLoadToShadow", ""));
                    break;
                }
                case 4: {
                    this.addToLog(buff, mac, this.logStatus("SWUPopRunFromShadow", ""));
                    break;
                }
                case 5: {
                    this.addToLog(buff, mac, this.logStatus("SWUPopSetMain", ""));
                }
            }
            status = "SWUPmsgFAIL";
            message = "SWUPmsgAlreadyRunningFromShadow";
            logger.debug((Object)"AU running from shadow");
        } else {
            MOAccessSession access = null;
            try {
                RbBaseStationEquipment baseStation = (RbBaseStationEquipment)this.ctx.getEquipment();
                access = MediationServiceRegistry.getMOSession((SNMPManagementInterface)baseStation.getManagementInterface(), null);
                if (oper == 1) {
                    this.addToLog(buff, mac, this.logStatus("SWUPopReset", ""));
                    this.setRowStatusNPUandAU("SWUPopReset", row);
                    logger.debug((Object)"AU Reset...");
                    RbSwAuConfigEntry command = this.createAUCommand(au.getRbSlotNumber(), 2, null);
                    access.commitObject(null, (Object)command);
                    String[] result = new String[]{""};
                    this.waitForUnit((ManagedObject)au, ((Object)((Object)au)).getClass(), result);
                    status = result[0];
                    message = "SWUPopReset";
                    logger.debug((Object)("AU " + status));
                } else if (oper > 2) {
                    this.addToLog(buff, mac, this.logStatus("SWUPFileStr", new Object[]{f.getName()}, ""));
                    switch (oper) {
                        case 3: {
                            if (!f.getName().equals(au.getRbAuShadowSwFileName())) {
                                this.addToLog(buff, mac, this.logStatus("SWUPopLoadToShadow", ""));
                                this.setRowStatusNPUandAU("SWUPopLoadToShadow", row);
                                logger.debug((Object)"AU Loading to shadow...");
                                RbSwAuConfigEntry command = this.createAUCommand(au.getRbSlotNumber(), 3, f.getName());
                                access.commitObject(null, (Object)command);
                                String[] result = new String[]{""};
                                this.waitForUpgradeLogStatus("1." + au.getRbSlotNumber(), access, 10, 30, result);
                                status = result[0];
                                message = "SWUPopLoadToShadow";
                                logger.debug((Object)("AU " + status));
                                break;
                            }
                            logger.debug((Object)"AU File already on shadow");
                            break;
                        }
                        case 4: {
                            if (au.getRbAuRunningSoftware() != 2 || !f.getName().equals(au.getRbAuShadowSwFileName())) {
                                this.addToLog(buff, mac, this.logStatus("SWUPopRunFromShadow", ""));
                                this.setRowStatusNPUandAU("SWUPopRunFromShadow", row);
                                logger.debug((Object)"AU Running from shadow...");
                                RbSwAuConfigEntry command = this.createAUCommand(au.getRbSlotNumber(), 4, f.getName());
                                access.commitObject(null, (Object)command);
                                String[] result = new String[]{""};
                                this.waitForUpgradeLogStatus("1." + au.getRbSlotNumber(), access, 10, 30, result);
                                status = result[0];
                                message = "SWUPopRunFromShadow";
                                logger.debug((Object)("AU " + status));
                                break;
                            }
                            logger.debug((Object)"AU File already running from shadow");
                            break;
                        }
                        case 5: {
                            this.addToLog(buff, mac, this.logStatus("SWUPopSetMain", ""));
                            this.setRowStatusNPUandAU("SWUPopSetMain", row);
                            logger.debug((Object)"AU Setting main...");
                            RbSwAuConfigEntry command = this.createAUCommand(au.getRbSlotNumber(), 5, f.getName());
                            access.commitObject(null, (Object)command);
                            String[] result = new String[]{""};
                            this.waitForUpgradeLogStatus("1." + au.getRbSlotNumber(), access, 2, 30, result);
                            status = result[0];
                            message = "SWUPopSetMain";
                            logger.debug((Object)("AU " + status));
                        }
                    }
                    logger.debug((Object)("AU " + status + " " + message));
                }
            }
            catch (MediationException e) {
                status = "SWUPmsgFAIL";
                message = "SWUPmsgErrDevice";
                logger.debug((Object)e);
            }
            finally {
                if (access != null) {
                    access.close();
                }
            }
        }
        this.addToLog(buff, mac, this.logStatus(status, message));
        this.setRowStatusNPUandAU(status, row);
        this.appendToLogFile(logFile, buff.toString() + LINE_SEPARATOR);
        try {
            logFile.flush();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSUSoftwareUpgrade(int row, String file, int oper, FileWriter logFile) {
        RbRegisteredSuEntry su = this.getSUfromRow(row);
        StringBuffer buff = new StringBuffer();
        String mac = this.getTableSUMAC(row);
        this.multiLog.insertSeparator(mac, LINE_SEPARATOR);
        this.addToLog(buff, mac, this.logStatus("SWUPmsgSU", new Object[]{this.getTableSUName(row) + " " + mac}, ""));
        this.setRowStatusSU("SWUPmsgPROGRESS", row);
        File f = new File(file);
        String status = "";
        String message = "";
        if (this.swupAbort) {
            status = "SWUPmsgABORT";
            message = "";
            logger.debug((Object)"SU Aborted");
        } else if (!su.isConnected()) {
            status = "SWUPmsgSKIP";
            message = "SWUPmsgSUDisc";
            logger.debug((Object)"SU Disconnected");
        } else if (oper == 0) {
            status = "SWUPmsgSKIP";
            message = "SWUPmsgNoOp";
            logger.debug((Object)"SU No operation");
        } else if ("".equals(file) && oper != 1) {
            status = "SWUPmsgSKIP";
            message = "SWUPmsgNoFile";
            logger.debug((Object)"SU No file");
        } else if (oper == 2) {
            this.addToLog(buff, mac, this.logStatus("SWUPFileStr", new Object[]{f.getName()}, ""));
            this.addToLog(buff, mac, this.logStatus("SWUPopLoadToBS", ""));
            if (this.isFileOnNPU(f.getName())) {
                status = "SWUPmsgSKIP";
                message = this.isBS ? "SWUPmsgFileOnNPU" : "SWUPmsgFileOnMBS";
                logger.debug((Object)"SU File already on NPU");
            } else {
                status = "SWUPmsgFAIL";
                message = "SWUPopLoadToBS";
                logger.debug((Object)"SU File not on NPU");
            }
        } else if (oper != 1 && !this.isFileOnNPU(f.getName())) {
            this.addToLog(buff, mac, this.logStatus("SWUPFileStr", new Object[]{f.getName()}, ""));
            status = "SWUPmsgFAIL";
            logger.debug((Object)"SU File not on NPU");
            switch (oper) {
                case 3: {
                    this.addToLog(buff, mac, this.logStatus("SWUPopLoadToShadow", ""));
                    message = "SWUPopLoadToShadow";
                    break;
                }
                case 4: {
                    this.addToLog(buff, mac, this.logStatus("SWUPopRunFromShadow", ""));
                    message = "SWUPopRunFromShadow";
                    break;
                }
                case 5: {
                    this.addToLog(buff, mac, this.logStatus("SWUPopSetMain", ""));
                    message = "SWUPopSetMain";
                }
            }
        } else if (oper == 3 && f.getName().equals(su.getRbSuShadowSwFileName())) {
            this.addToLog(buff, mac, this.logStatus("SWUPFileStr", new Object[]{f.getName()}, ""));
            this.addToLog(buff, mac, this.logStatus("SWUPopLoadToShadow", ""));
            status = "SWUPmsgSKIP";
            message = "SWUPmsgSameShadowVer";
            logger.debug((Object)"SU File same with shadow");
        } else if (oper >= 3 && f.getName().equals(su.getRbSuOperSwFileName())) {
            this.addToLog(buff, mac, this.logStatus("SWUPFileStr", new Object[]{f.getName()}, ""));
            this.addToLog(buff, mac, this.logStatus("SWUPopLoadToShadow", ""));
            status = "SWUPmsgSKIP";
            message = "SWUPmsgSameMainVer";
            logger.debug((Object)"SU File same with main");
        } else if (oper == 4 && su.getRbSuRunningSoftware() == 2 && f.getName().equals(su.getRbSuShadowSwFileName())) {
            this.addToLog(buff, mac, this.logStatus("SWUPFileStr", new Object[]{f.getName()}, ""));
            this.addToLog(buff, mac, this.logStatus("SWUPopRunFromShadow", ""));
            status = "SWUPmsgSKIP";
            message = "SWUPmsgRunningFromShadow";
            logger.debug((Object)"SU File already running from shadow");
        } else if (oper >= 3 && !f.getName().equals(su.getRbSuShadowSwFileName()) && su.getRbSuRunningSoftware() == 2) {
            this.addToLog(buff, mac, this.logStatus("SWUPFileStr", new Object[]{f.getName()}, ""));
            switch (oper) {
                case 3: {
                    this.addToLog(buff, mac, this.logStatus("SWUPopLoadToShadow", ""));
                    break;
                }
                case 4: {
                    this.addToLog(buff, mac, this.logStatus("SWUPopRunFromShadow", ""));
                    break;
                }
                case 5: {
                    this.addToLog(buff, mac, this.logStatus("SWUPopSetMain", ""));
                }
            }
            status = "SWUPmsgFAIL";
            message = "SWUPmsgAlreadyRunningFromShadow";
            logger.debug((Object)"SU running from shadow");
        } else {
            MOAccessSession access = null;
            try {
                RbBaseStationEquipment baseStation = (RbBaseStationEquipment)this.ctx.getEquipment();
                access = MediationServiceRegistry.getMOSession((SNMPManagementInterface)baseStation.getManagementInterface(), null);
                if (oper == 1) {
                    this.addToLog(buff, mac, this.logStatus("SWUPopReset", ""));
                    this.setRowStatusSU("SWUPopReset", row);
                    logger.debug((Object)"SU Reset...");
                    RbSwRegisteredSuEntry command = this.createSUCommand(su.getRbSuMacAddr(), 2, null);
                    access.commitObject(null, (Object)command);
                    String[] result = new String[]{""};
                    this.waitForUnit((ManagedObject)su, ((Object)((Object)su)).getClass(), result);
                    status = result[0];
                    message = "SWUPopReset";
                    logger.debug((Object)("SU " + status));
                } else if (oper > 2) {
                    this.addToLog(buff, mac, this.logStatus("SWUPFileStr", new Object[]{f.getName()}, ""));
                    switch (oper) {
                        case 3: {
                            if (!f.getName().equals(su.getRbSuShadowSwFileName())) {
                                this.addToLog(buff, mac, this.logStatus("SWUPopLoadToShadow", ""));
                                this.setRowStatusSU("SWUPopLoadToShadow", row);
                                logger.debug((Object)"SU Loading to shadow...");
                                RbSwRegisteredSuEntry command = this.createSUCommand(su.getRbSuMacAddr(), 3, f.getName());
                                access.commitObject(null, (Object)command);
                                String[] result = new String[]{""};
                                this.waitForUpgradeLogStatus("2." + MacAddress.fromOctetString((String)su.getRbSuMacAddr()).toInstanceString(), access, 10, 30, result);
                                status = result[0];
                                message = "SWUPopLoadToShadow";
                                logger.debug((Object)("SU " + status));
                                break;
                            }
                            logger.debug((Object)"SU File already on shadow");
                            break;
                        }
                        case 4: {
                            if (su.getRbSuRunningSoftware() != 2 || !f.getName().equals(su.getRbSuShadowSwFileName())) {
                                this.addToLog(buff, mac, this.logStatus("SWUPopRunFromShadow", ""));
                                this.setRowStatusSU("SWUPopRunFromShadow", row);
                                logger.debug((Object)"SU Running from shadow...");
                                RbSwRegisteredSuEntry command = this.createSUCommand(su.getRbSuMacAddr(), 4, f.getName());
                                access.commitObject(null, (Object)command);
                                String[] result = new String[]{""};
                                this.waitForUpgradeLogStatus("2." + MacAddress.fromOctetString((String)su.getRbSuMacAddr()).toInstanceString(), access, 10, 30, result);
                                status = result[0];
                                message = "SWUPopRunFromShadow";
                                logger.debug((Object)("SU " + status));
                                break;
                            }
                            logger.debug((Object)"SU File already running from shadow");
                            break;
                        }
                        case 5: {
                            this.addToLog(buff, mac, this.logStatus("SWUPopSetMain", ""));
                            this.setRowStatusSU("SWUPopSetMain", row);
                            logger.debug((Object)"SU Setting main...");
                            RbSwRegisteredSuEntry command = this.createSUCommand(su.getRbSuMacAddr(), 5, f.getName());
                            access.commitObject(null, (Object)command);
                            String[] result = new String[]{""};
                            this.waitForUpgradeLogStatus("2." + MacAddress.fromOctetString((String)su.getRbSuMacAddr()).toInstanceString(), access, 10, 30, result);
                            status = result[0];
                            message = "SWUPopSetMain";
                            logger.debug((Object)("SU " + status));
                        }
                    }
                    logger.debug((Object)("SU " + status + " " + message));
                }
            }
            catch (MediationException e) {
                status = "SWUPmsgFAIL";
                message = "SWUPmsgErrDevice";
                logger.debug((Object)e);
            }
            finally {
                if (access != null) {
                    access.close();
                }
            }
        }
        this.addToLog(buff, mac, this.logStatus(status, message));
        this.setRowStatusSU(status, row);
        this.appendToLogFile(logFile, buff.toString() + LINE_SEPARATOR);
        try {
            logFile.flush();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private RbNpuCommand createNPUCommand(Integer slot, Integer cmd) {
        RbNpuCommand controlCommand = new RbNpuCommand();
        controlCommand.setRbSlotNumber(slot);
        controlCommand.setRbNpuUnitControl(cmd);
        return controlCommand;
    }

    private RbMbsCommand createMBSCommand(Integer cmd) {
        RbMbsCommand controlCommand = new RbMbsCommand();
        controlCommand.setRbMBSTUnitControl(cmd);
        return controlCommand;
    }

    private RbSwAuConfigEntry createAUCommand(Integer slot, Integer cmd, String file) {
        RbSwAuConfigEntry command = new RbSwAuConfigEntry();
        command.setRbSlotNumber(slot);
        command.setRbAuUnitControl(cmd);
        if (file != null && !file.equals("")) {
            command.setRbAuUpgradeSwFileName(file);
        }
        return command;
    }

    private RbSwRegisteredSuEntry createSUCommand(String mac, Integer cmd, String file) {
        RbSwRegisteredSuEntry command = new RbSwRegisteredSuEntry();
        command.setRbSuMacAddr(mac);
        command.setRbSuUnitControl(cmd);
        if (file != null && !file.equals("")) {
            command.setRbSuUpgradeSwFileName(file);
        }
        return command;
    }

    private boolean waitForUnit(ManagedObject unit, Class<? extends ManagedObject> unitClass, String[] result) {
        int secs = 10;
        boolean cont = false;
        long pollingStart = System.currentTimeMillis();
        while (!cont && System.currentTimeMillis() - pollingStart < 600000L) {
            try {
                logger.debug((Object)("waitForUnit: Sleeping for " + secs + " seconds"));
                Thread.sleep(secs * 1000);
            }
            catch (InterruptedException e) {
                logger.debug((Object)"", (Throwable)e);
            }
            result[0] = "SWUPmsgTIMEOUT";
            List<ManagedObject> mos = SoftwareUpgradeConfigForm.getMOsFromEquipment(this.ctx.getEquipment(), unitClass, unit.getRowKey());
            try {
                int runningSoftware;
                ManagedObject mo = mos.get(0);
                result[0] = "SWUPmsgFAIL";
                if (!((Boolean)unitClass.getMethod("isConnected", new Class[0]).invoke((Object)mo, new Object[0])).booleanValue()) continue;
                if (mo instanceof RbNpuConfigEntry && ((runningSoftware = ((RbNpuConfigEntry)mo).getRbNpuRunningSoftware().intValue()) == 2 || runningSoftware == 1)) {
                    result[0] = "SWUPmsgOK";
                    cont = true;
                    break;
                }
                if (mo instanceof RbSysMicroBSTConfig) {
                    runningSoftware = ((RbSysMicroBSTConfig)mo).getRbMBSTRunningSoftware();
                    if (runningSoftware != 2 && runningSoftware != 1) continue;
                    result[0] = "SWUPmsgOK";
                    cont = true;
                    break;
                }
                if (unit instanceof RbAuConfigEntry) {
                    runningSoftware = ((RbAuConfigEntry)mo).getRbAuRunningSoftware();
                    if (runningSoftware != 2 && runningSoftware != 1) continue;
                    result[0] = "SWUPmsgOK";
                    cont = true;
                    break;
                }
                runningSoftware = ((RbRegisteredSuEntry)mo).getRbSuRunningSoftware();
                if (runningSoftware != 2 && runningSoftware != 1) continue;
                result[0] = "SWUPmsgOK";
                cont = true;
                break;
            }
            catch (Exception e) {
            }
        }
        return cont;
    }

    public static List<ManagedObject> getMOsFromEquipment(final Equipment equipment, final Class<? extends ManagedObject> moClass, final String key) {
        final ArrayList<ManagedObject> mos = new ArrayList<ManagedObject>();
        new RunnableDatastoreDecorator(new Runnable(){

            public void run() {
                try {
                    mos.add((ManagedObject)Helpers.getConfigurationHelper().retrieveCurrentConfiguration(equipment.getId(), "BS", moClass, key, true).get(0));
                }
                catch (MediationException ex) {
                    logger.debug((Object)"getMOsFromEquipment", (Throwable)ex);
                }
            }
        }).run();
        return mos;
    }

    private boolean waitForUpgradeLogStatus(String instance, MOAccessSession access, int secs, int retries, String[] result) {
        boolean success = false;
        try {
            boolean done = false;
            long pollingStart = System.currentTimeMillis();
            while (!done && System.currentTimeMillis() - pollingStart < (long)(secs * retries * 1000)) {
                List swUpgradeLog;
                try {
                    logger.debug((Object)("waitForUpgradeLogStatus: Sleeping for " + secs + " seconds"));
                    Thread.sleep(secs * 1000);
                }
                catch (InterruptedException e) {
                    logger.debug((Object)"", (Throwable)e);
                }
                if ((swUpgradeLog = access.fetchObject(null, RbSwUpgradeLogEntry.class, null, instance)) == null || swUpgradeLog.isEmpty()) continue;
                RbSwUpgradeLogEntry entry = (RbSwUpgradeLogEntry)((Object)swUpgradeLog.get(0));
                switch (entry.getRbSwUpgradeStatus()) {
                    case 4: {
                        result[0] = "SWUPmsgFAIL";
                        done = true;
                        break;
                    }
                    case 2: {
                        result[0] = "SWUPmsgOK";
                        success = true;
                        done = true;
                    }
                }
            }
            if (!done) {
                result[0] = "SWUPmsgTIMEOUT";
            }
        }
        catch (MediationException e) {
            logger.debug((Object)"", (Throwable)e);
            result[0] = "SWUPmsgErrDevice";
        }
        return success;
    }

    public byte[] getFileContentAsByte(File f) {
        if (!f.isFile()) {
            return null;
        }
        byte[] fileData = null;
        try {
            long flen = f.length();
            if (flen < 0x1400000L) {
                fileData = new byte[(int)flen];
                FileInputStream fis = new FileInputStream(f);
                fis.read(fileData);
            }
        }
        catch (Exception e) {
            logger.debug((Object)"", (Throwable)e);
        }
        return fileData;
    }

    protected String getTftpMessage(Throwable e) {
        Throwable cause = e.getCause();
        String message = cause instanceof SNMPTimeoutException ? "SWUPmsgSNMPTimeoutError" : (cause instanceof TftpTimeoutException ? "SWUPmsgTFTPTimeoutError" : (cause != null ? cause.getMessage() : e.getMessage()));
        if (message == null) {
            return "SWUPmsgTFTPErr";
        }
        return message;
    }

    private String logStatus(String status, Object[] statusVars, String message, Object[] msgVars, int newLines) {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        String ret = sdf.format(new Date()) + " --- ";
        if (!"".equals(status)) {
            ret = ret + i18n.translateString(status, statusVars);
        }
        if (!"".equals(message)) {
            if (!"".equals(status)) {
                ret = ret + ": ";
            }
            ret = ret + i18n.translateString(message, msgVars);
        }
        for (int i = 0; i < newLines; ++i) {
            ret = ret + LINE_SEPARATOR;
        }
        return ret;
    }

    private String logStatus(String status, Object[] vars, String message) {
        return this.logStatus(status, vars, message, null, 1);
    }

    private String logStatus(String status, String message) {
        return this.logStatus(status, null, message, null, 1);
    }

    private String logStatus(String status, String message, int newLines) {
        return this.logStatus(status, null, message, null, newLines);
    }

    private void setRowStatus(SimpleRowTableModel model, String status, int row, int column) {
        model.setValueAt((Object)i18n.translateString(status), row, column);
    }

    private void setRowStatusNPUandAU(String status, int row) {
        this.setRowStatus(((SoftwareUpgradePanel)this.getUI()).getTableNPUandAUModel(), status, row, 7);
    }

    private void setRowStatusSU(String status, int row) {
        this.setRowStatus(((SoftwareUpgradePanel)this.getUI()).getTableSUModel(), status, row, 9);
    }

    private boolean isFileOnNPU(String fileName) {
        int i;
        int rows = ((SoftwareUpgradePanel)this.getUI()).getTableNPUFilesAUModel().getRowCount();
        for (i = 0; i < rows; ++i) {
            if (!((SoftwareUpgradePanel)this.getUI()).getTableNPUFilesAUModel().getValueAt(i, 0).equals(fileName)) continue;
            return true;
        }
        rows = ((SoftwareUpgradePanel)this.getUI()).getTableNPUFilesSUModel().getRowCount();
        for (i = 0; i < rows; ++i) {
            if (!((SoftwareUpgradePanel)this.getUI()).getTableNPUFilesSUModel().getValueAt(i, 0).equals(fileName)) continue;
            return true;
        }
        return false;
    }

    private void addFileToAUTableFilesNPU(String file) {
        int row = ((SoftwareUpgradePanel)this.getUI()).getTableNPUFilesAUModel().getRowCount();
        ((SoftwareUpgradePanel)this.getUI()).getTableNPUFilesAUModel().addNewRow(file, true);
        ((SoftwareUpgradePanel)this.getUI()).getTableNPUFilesAUModel().setInitialValueAt((Object)file, row, 0);
    }

    private void addFileToSUTableFilesNPU(String file) {
        int row = ((SoftwareUpgradePanel)this.getUI()).getTableNPUFilesSUModel().getRowCount();
        ((SoftwareUpgradePanel)this.getUI()).getTableNPUFilesSUModel().addNewRow(file, true);
        ((SoftwareUpgradePanel)this.getUI()).getTableNPUFilesSUModel().setInitialValueAt((Object)file, row, 0);
    }

    private boolean isSpaceToUploadFileOnNPU(JTable filesTable) {
        RbBaseStationEquipment bs = (RbBaseStationEquipment)this.ctx.getEquipment();
        if (bs.getSoftwareVersion().compareTo((Object)VersionFactory.getInstance().createVersion("4.0")) >= 0) {
            return filesTable.getRowCount() < 4;
        }
        return filesTable.getRowCount() < 3;
    }

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
    }

    private void fillComboFiles(final JComboBox cmb, Object[] fileList, SimpleFileChooser sfc) {
        cmb.setMaximumRowCount(5);
        cmb.removeAllItems();
        cmb.addItem("");
        cmb.addItem(sfc);
        cmb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (ae.getSource() == cmb) {
                    if (cmb.getSelectedIndex() == 1) {
                        cmb.setEditor(new BasicComboBoxEditor(){

                            public Component getEditorComponent() {
                                return (Component)cmb.getSelectedItem();
                            }
                        });
                        cmb.setEditable(true);
                    } else {
                        cmb.setEditor(new BasicComboBoxEditor());
                        cmb.setEditable(false);
                    }
                }
            }
        });
        if (fileList != null) {
            for (int i = 0; i < fileList.length; ++i) {
                cmb.addItem(fileList[i]);
            }
        }
        cmb.setSelectedIndex(0);
    }

    private void fillTableSU() {
        SoftwareUpgradePanel panel = (SoftwareUpgradePanel)this.getUI();
        panel.getTableSUModel().clearTable();
        int totalSUsCount = 0;
        int filteredSUsCount = 0;
        if (this.entriesSU != null) {
            int row = 0;
            for (RbRegisteredSuEntry entry : this.entriesSU) {
                String shadowSW;
                if (this.skipTempSUs && new Integer(1).equals(entry.getRbSuPersistence())) continue;
                ++totalSUsCount;
                String stringMacAddress = MacAddress.fromOctetString((String)entry.getRbSuMacAddr()).toString();
                String stringRbAuId = entry.getRbAuId() != 255 ? String.valueOf(entry.getRbAuId()) : i18n.translateString("SWUPnone");
                String runningSW = i18n.translateString("SWUPnone");
                String operSW = this.formatSoftwareVersion(entry.getRbSuOperSwVersion());
                if (operSW.equals("")) {
                    operSW = runningSW;
                }
                if ((shadowSW = this.formatSoftwareVersion(entry.getRbSuShadowSwVersion())).equals("")) {
                    shadowSW = runningSW;
                }
                switch (entry.getRbSuRunningSoftware()) {
                    case 1: {
                        runningSW = operSW;
                        break;
                    }
                    case 2: {
                        runningSW = shadowSW;
                    }
                }
                if (!(!panel.getCmbFilterBy().getSelectedItem().equals(2) && !panel.getCmbFilterBy().getSelectedItem().equals(3) && (this.filterString == null || this.filterString.length() == 0 || panel.getCmbFilterBy().getSelectedItem().equals(0) && entry.getRbSuSysName().toUpperCase().indexOf(this.filterString.toUpperCase()) != -1 || panel.getCmbFilterBy().getSelectedItem().equals(1) && stringMacAddress.toUpperCase().indexOf(this.filterString.toUpperCase()) != -1 || panel.getCmbFilterBy().getSelectedItem().equals(5) && operSW.toUpperCase().indexOf(this.filterString.toUpperCase()) != -1 || panel.getCmbFilterBy().getSelectedItem().equals(6) && shadowSW.toUpperCase().indexOf(this.filterString.toUpperCase()) != -1 || panel.getCmbFilterBy().getSelectedItem().equals(7) && runningSW.toUpperCase().indexOf(this.filterString.toUpperCase()) != -1 || panel.getCmbFilterBy().getSelectedItem().equals(4) && stringRbAuId.toUpperCase().indexOf(this.filterString.toUpperCase()) != -1) || panel.getCmbFilterBy().getSelectedItem().equals(2) && entry.getRbSuRegistrationState().equals(((ComboItem)panel.getCmbRegistrationStatus().getSelectedItem()).getValue())) && (!panel.getCmbFilterBy().getSelectedItem().equals(3) || !entry.getRbSuPersistence().equals(((ComboItem)panel.getCmbPersistenceStatus().getSelectedItem()).getValue()))) continue;
                int col = 0;
                panel.getTableSUModel().addNewRow(entry.getRbSuMacAddr(), true);
                panel.getTableSUModel().setInitialValueAt((Object)entry.getRbSuSysName(), row, col);
                col = 1;
                panel.getTableSUModel().setInitialValueAt((Object)stringMacAddress, row, col);
                col = 2;
                panel.getTableSUModel().setInitialValueAt((Object)entry.getRbSuRegistrationState(), row, col);
                col = 3;
                panel.getTableSUModel().setInitialValueAt((Object)entry.getRbSuPersistence(), row, col);
                col = 4;
                panel.getTableSUModel().setInitialValueAt((Object)stringRbAuId, row, col);
                col = 5;
                panel.getTableSUModel().setInitialValueAt((Object)operSW, row, col);
                col = 6;
                panel.getTableSUModel().setInitialValueAt((Object)shadowSW, row, col);
                col = 7;
                panel.getTableSUModel().setInitialValueAt((Object)runningSW, row, col);
                Object[] ent = this.selectedEntriesSU.get(stringMacAddress);
                if (ent != null) {
                    col = 8;
                    panel.getTableSUModel().setInitialValueAt(ent[0], row, col);
                    col = 9;
                    panel.getTableSUModel().setInitialValueAt(ent[1], row, col);
                }
                ++row;
                ++filteredSUsCount;
            }
        }
        if (totalSUsCount > 0) {
            String msg = this.skipTempSUs ? "SWUPSUPermanentdisplayedUnitsOf" : "SWUPSUdisplayedUnitsOf";
            panel.getLabelStatusSU().setText(i18n.translateString(msg, new Object[]{filteredSUsCount, totalSUsCount}));
            panel.getTableSUModel().sort();
        } else {
            String msg = this.skipTempSUs ? "SWUPSUPermanentnoUnitsToDisplay" : "SWUPSUnoUnitsToDisplay";
            panel.getLabelStatusSU().setText(i18n.translateString(msg));
        }
    }

    private void fillTableNPUandAU() {
        Object[] ent;
        String shadowSW;
        String operSW;
        String runningSW;
        int col;
        int row;
        SoftwareUpgradePanel panel = (SoftwareUpgradePanel)this.getUI();
        panel.getTableNPUandAUModel().clearTable();
        if (this.npu != null) {
            row = 0;
            panel.getTableNPUandAUModel().addNewRow(this.npu.getRbNpuSysName(), true);
            col = 0;
            panel.getTableNPUandAUModel().setInitialValueAt((Object)i18n.translateString("SWUPNPU"), row, col);
            col = 1;
            panel.getTableNPUandAUModel().setInitialValueAt((Object)this.npu.getRbSlotNumber().toString(), row, col);
            col = 2;
            panel.getTableNPUandAUModel().setInitialValueAt((Object)(this.npu.getRbNpuFaultStatus() == 1 ? i18n.translateString("SWUPStatusConnected") : i18n.translateString("SWUPStatusDisconnected")), row, col);
            runningSW = i18n.translateString("SWUPnone");
            operSW = this.formatSoftwareVersion(this.npu.getRbNpuOperSwVersion());
            if (operSW.equals("")) {
                operSW = runningSW;
            }
            if ((shadowSW = this.formatSoftwareVersion(this.npu.getRbNpuShadowSwVersion())).equals("")) {
                shadowSW = runningSW;
            }
            switch (this.npu.getRbNpuRunningSoftware()) {
                case 1: {
                    runningSW = operSW;
                    break;
                }
                case 2: {
                    runningSW = shadowSW;
                }
            }
            col = 3;
            panel.getTableNPUandAUModel().setInitialValueAt((Object)operSW, row, col);
            col = 4;
            panel.getTableNPUandAUModel().setInitialValueAt((Object)shadowSW, row, col);
            col = 5;
            panel.getTableNPUandAUModel().setInitialValueAt((Object)runningSW, row, col);
            ent = this.selectedEntriesAU.get(this.npu.getRbSlotNumber().toString());
            if (ent != null) {
                col = 6;
                panel.getTableNPUandAUModel().setInitialValueAt(ent[0], row, col);
                col = 7;
                panel.getTableNPUandAUModel().setInitialValueAt(ent[1], row, col);
            }
            ++row;
            for (RbAuConfigEntry entry : this.entriesAU) {
                runningSW = i18n.translateString("SWUPnone");
                operSW = this.formatSoftwareVersion(entry.getRbAuOperSwVersion());
                shadowSW = this.formatSoftwareVersion(entry.getRbAuShadowSwVersion());
                switch (entry.getRbAuRunningSoftware()) {
                    case 1: {
                        runningSW = operSW;
                        break;
                    }
                    case 2: {
                        runningSW = shadowSW;
                    }
                }
                panel.getTableNPUandAUModel().addNewRow(entry.getRowKey(), true);
                col = 0;
                panel.getTableNPUandAUModel().setInitialValueAt((Object)i18n.translateString("SWUPAU"), row, col);
                col = 1;
                panel.getTableNPUandAUModel().setInitialValueAt((Object)entry.getRbSlotNumber().toString(), row, col);
                col = 2;
                panel.getTableNPUandAUModel().setInitialValueAt((Object)(entry.isConnected() ? i18n.translateString("SWUPStatusConnected") : i18n.translateString("SWUPStatusDisconnected")), row, col);
                col = 3;
                panel.getTableNPUandAUModel().setInitialValueAt((Object)this.formatSoftwareVersion(operSW), row, col);
                col = 4;
                panel.getTableNPUandAUModel().setInitialValueAt((Object)this.formatSoftwareVersion(shadowSW), row, col);
                col = 5;
                panel.getTableNPUandAUModel().setInitialValueAt((Object)this.formatSoftwareVersion(runningSW), row, col);
                ent = this.selectedEntriesAU.get(entry.getRbSlotNumber().toString());
                if (ent != null) {
                    col = 6;
                    panel.getTableNPUandAUModel().setInitialValueAt(ent[0], row, col);
                    col = 7;
                    panel.getTableNPUandAUModel().setInitialValueAt(ent[1], row, col);
                }
                ++row;
            }
            panel.getTableNPUandAUModel().sort();
        }
        if (this.mbs != null) {
            row = 0;
            panel.getTableNPUandAUModel().addNewRow("mbs", true);
            col = 0;
            panel.getTableNPUandAUModel().setInitialValueAt((Object)i18n.translateString("SWUPMBS"), row, col);
            col = 1;
            panel.getTableNPUandAUModel().setInitialValueAt((Object)"", row, col);
            col = 2;
            panel.getTableNPUandAUModel().setInitialValueAt((Object)(this.mbs.getRbSysFaultStatus() == 1 ? i18n.translateString("SWUPStatusConnected") : i18n.translateString("SWUPStatusDisconnected")), row, col);
            runningSW = i18n.translateString("SWUPnone");
            operSW = this.formatSoftwareVersion(this.mbs.getRbMBSTOperSwVersion());
            if (operSW.equals("")) {
                operSW = runningSW;
            }
            if ((shadowSW = this.formatSoftwareVersion(this.mbs.getRbMBSTShadowSwVersion())).equals("")) {
                shadowSW = runningSW;
            }
            switch (this.mbs.getRbMBSTRunningSoftware()) {
                case 1: {
                    runningSW = operSW;
                    break;
                }
                case 2: {
                    runningSW = shadowSW;
                }
            }
            col = 3;
            panel.getTableNPUandAUModel().setInitialValueAt((Object)operSW, row, col);
            col = 4;
            panel.getTableNPUandAUModel().setInitialValueAt((Object)shadowSW, row, col);
            col = 5;
            panel.getTableNPUandAUModel().setInitialValueAt((Object)runningSW, row, col);
            ent = this.selectedEntriesAU.get("");
            if (ent != null) {
                col = 6;
                panel.getTableNPUandAUModel().setInitialValueAt(ent[0], row, col);
                col = 7;
                panel.getTableNPUandAUModel().setInitialValueAt(ent[1], row, col);
            }
            panel.getTableNPUandAUModel().sort();
        }
    }

    private void fillTableFilesNPU(RbSwUpgrade swUpgrade) {
        ((SoftwareUpgradePanel)this.getUI()).getTableNPUFilesAUModel().clearTable();
        int row = 0;
        if (swUpgrade.getRbSwAuFiles().trim().length() > 0) {
            String[] auFiles;
            for (String file : auFiles = swUpgrade.getRbSwAuFiles().split(";")) {
                ((SoftwareUpgradePanel)this.getUI()).getTableNPUFilesAUModel().addNewRow(file, true);
                ((SoftwareUpgradePanel)this.getUI()).getTableNPUFilesAUModel().setInitialValueAt((Object)file, row++, 0);
                ((SoftwareUpgradePanel)this.getUI()).getCmbAUFiles().addItem(file);
            }
        }
        ((SoftwareUpgradePanel)this.getUI()).getTableNPUFilesAUModel().sort();
        ((SoftwareUpgradePanel)this.getUI()).getTableNPUFilesSUModel().clearTable();
        row = 0;
        if (swUpgrade.getRbSwSuFiles().trim().length() > 0) {
            String[] suFiles;
            for (String file : suFiles = swUpgrade.getRbSwSuFiles().split(";")) {
                ((SoftwareUpgradePanel)this.getUI()).getTableNPUFilesSUModel().addNewRow(file, true);
                ((SoftwareUpgradePanel)this.getUI()).getTableNPUFilesSUModel().setInitialValueAt((Object)file, row++, 0);
                ((SoftwareUpgradePanel)this.getUI()).getCmbSUFiles().addItem(file);
                ((SoftwareUpgradePanel)this.getUI()).getCmbTempSUFiles().addItem(file);
            }
        }
        ((SoftwareUpgradePanel)this.getUI()).getTableNPUFilesSUModel().sort();
    }

    public void fillUI(List<Object> managedObjects) {
        this.fillComboFiles(((SoftwareUpgradePanel)this.getUI()).getCmbAUFiles(), null, this.auFileChooser);
        this.fillComboFiles(((SoftwareUpgradePanel)this.getUI()).getCmbSUFiles(), null, this.suFileChooser);
        this.fillComboFiles(((SoftwareUpgradePanel)this.getUI()).getCmbTempSUFiles(), null, this.suFileChooser);
        this.fillTableFilesNPU((RbSwUpgrade)((Object)managedObjects.get(0)));
        if (this.fromCommand) {
            ((FormsConfigSectionView)this.getConfigSectionView()).setMoRequestsNull();
            this.fromCommand = false;
        } else {
            try {
                this.npu = (RbNpuConfigEntry)((Object)((RbNpuConfigTable)((Object)managedObjects.get(2))).getEntries().get(0));
            }
            catch (Exception e) {
                this.npu = null;
            }
            try {
                this.mbs = (RbSysMicroBSTConfig)((Object)managedObjects.get(2));
            }
            catch (Exception e) {
                this.mbs = null;
            }
            if (this.isBS) {
                Object[] objectArray;
                JComboBox jComboBox = ((SoftwareUpgradePanel)this.getUI()).getCmbNPUFiles();
                if (this.npu == null) {
                    objectArray = null;
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = this.npu.getRbNpuShadowSwFileName();
                }
                this.fillComboFiles(jComboBox, objectArray, this.npuFileChooser);
            } else {
                Object[] objectArray;
                JComboBox jComboBox = ((SoftwareUpgradePanel)this.getUI()).getCmbNPUFiles();
                if (this.mbs == null) {
                    objectArray = null;
                } else {
                    Object[] objectArray3 = new Object[1];
                    objectArray = objectArray3;
                    objectArray3[0] = this.mbs.getRbMBSTShadowSwFileName();
                }
                this.fillComboFiles(jComboBox, objectArray, this.mbsFileChooser);
            }
            if (this.isBS) {
                this.entriesAU = ((RbAuConfigTable)((Object)managedObjects.get(3))).getEntries();
                this.entriesAUIndex.clear();
                int row = 0;
                for (RbAuConfigEntry rbAuConfigEntry : this.entriesAU) {
                    this.entriesAUIndex.put(rbAuConfigEntry.getRbSlotNumber().toString(), row++);
                }
            }
            this.fillTableNPUandAU();
            this.entriesSU = ((RbRegisteredSuTable)((Object)managedObjects.get(1))).getEntries();
            this.entriesSUIndex.clear();
            int row = 0;
            for (RbRegisteredSuEntry rbRegisteredSuEntry : this.entriesSU) {
                String mac = MacAddress.fromOctetString((String)rbRegisteredSuEntry.getRbSuMacAddr()).toString();
                this.entriesSUIndex.put(mac, row++);
            }
            this.fillTableSU();
        }
        ((SoftwareUpgradePanel)this.getUI()).getBtnRun().setEnabled(true);
        ((SoftwareUpgradePanel)this.getUI()).getBtnLog().setEnabled(true);
    }

    private void resetForm() {
        ((SoftwareUpgradePanel)this.getUI()).getCmbNPUOp().setSelectedIndex(0);
        ((SoftwareUpgradePanel)this.getUI()).getCmbAUOp().setSelectedIndex(0);
        ((SoftwareUpgradePanel)this.getUI()).getCmbSUOp().setSelectedIndex(0);
        ((SoftwareUpgradePanel)this.getUI()).getCmbTempSUOp().setSelectedIndex(0);
        ((SoftwareUpgradePanel)this.getUI()).getBtnRun().setEnabled(false);
        ((SoftwareUpgradePanel)this.getUI()).getBtnLog().setEnabled(false);
    }

    protected void configureMOs(List<Object> managedObjects) {
    }

    public String getHelpTopic() {
        if (this.npu == null) {
            return "ngnms.rb.help.mbs_fdd_software_upgrade";
        }
        if (VersionFactory.getInstance().createVersion(this.ctx.getEquipment().getRunningSoftwareVersion()).isOlderThan((Version)new DefaultVersion("4.0"))) {
            return "bs_fdd_software_upgrade";
        }
        return "bs_tdd_software_upgrade";
    }

    public boolean isBS() {
        return this.isBS;
    }

    public boolean isSkipTempSUs() {
        return this.skipTempSUs;
    }

    static {
        String separator = System.getProperty("line.separator");
        if (null == separator) {
            separator = "\n";
        }
        LINE_SEPARATOR = separator;
    }
}

