/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.rb.gui.configuration.SURegistrationParameters;
import com.bwanms.rb.mo.RbSuSystemEntry;
import com.bwanms.rb.model.RbSU;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionException;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SURegistrationParamConfigForm
extends ManagedObjectsConfigForm<SURegistrationParameters> {
    public SURegistrationParameters initUIComponent() {
        return new SURegistrationParameters();
    }

    public List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("SU", RbSuSystemEntry.class));
        return ret;
    }

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        DefaultBinder binder = new DefaultBinder((Object)this.getUI(), managedObjects.get(0));
        binder.add((Binding)new JTextFieldBinding("txtInstallerPassword", "rbSuInstallerPassword", SURegistrationParameters.i18n.translateString("InstallerPassword")));
        binder.add((Binding)new JTextFieldBinding("txtName", "rbSuSysName", SURegistrationParameters.i18n.translateString("rbSuSysName")));
        binders.add((Binder)binder);
    }

    protected void fillUI(List<Object> managedObjects) {
        RbSU su = (RbSU)this.ctx.getEquipment();
        Version VERSION_2_0 = VersionFactory.getInstance().createVersion("2.0.0.0");
        String vers = su.getRunningSoftwareVersion().replace("Rel", "");
        Version suVersion = null;
        try {
            suVersion = VersionFactory.getInstance().createVersion(vers, "_");
        }
        catch (VersionException ve) {
            suVersion = VersionFactory.getInstance().createVersion(vers, ".");
        }
        if (suVersion.isNewerOrEqualWith(VERSION_2_0)) {
            ((SURegistrationParameters)this.getUI()).getTxtName().setEditable(!su.getOperationMode().equals(2));
        }
        if (su != null) {
            RbSuSystemEntry entry = (RbSuSystemEntry)((Object)managedObjects.get(0));
            ((SURegistrationParameters)this.getUI()).getTxtOrganisation().setText(entry.getRbSuOrganizationName());
            ((SURegistrationParameters)this.getUI()).getTxtAddress().setText(entry.getRbSuAddress());
            ((SURegistrationParameters)this.getUI()).getTxtCountry().setText(entry.getRbSuCountry());
        }
    }

    public String getHelpTopic() {
        if (VersionFactory.getInstance().createVersion(((RbSU)this.ctx.getEquipment()).getManagerBS().getRunningSoftwareVersion()).isOlderThan((Version)new DefaultVersion("4.0"))) {
            return "ngnms.rb.help.su_registration_params";
        }
        return "ngnms.rb.help.su_tdd_registration_params";
    }
}

