/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.ddi.CutThroughNotSupportedException;
import com.bwanms.gui.Internationalizer;
import com.bwanms.rb.gui.configuration.SuGatewaysPanelController;
import com.bwanms.ui.components.SimpleRowTable;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.ui.components.SimpleRowTableModelPanelController;
import com.bwanms.util.CutThroughPluginUtil;
import com.bwanms.util.MessageBox;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;

public class SUGatewaysPanel
extends JPanel {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(SUGatewaysPanel.class);
    private SuGatewaysPanelController controller = new SuGatewaysPanelController(this);
    private SimpleRowTableModel tableModel;
    private JButton btnCutThrough;
    private JScrollPane scrollPane2;
    private JTable table2;

    public SUGatewaysPanel(boolean swVersionOlderOrEqualWith42, boolean isGatewayInvisible) {
        this.initComponents();
        this.postInitComponents(swVersionOlderOrEqualWith42, isGatewayInvisible);
    }

    private void postInitComponents(boolean swVersionOlderOrEqualWith42, boolean isGatewayInvisible) {
        i18n.getSwingInternationalizer().translateComponent((Component)this);
        ArrayList<SimpleRowTableModel.ColumnDefinition> columnDefinitions = new ArrayList<SimpleRowTableModel.ColumnDefinition>();
        columnDefinitions.add(new SimpleRowTableModel.ColumnDefinition(i18n.translateString("IPAddress"), String.class));
        if (!isGatewayInvisible) {
            columnDefinitions.add(new SimpleRowTableModel.ColumnDefinition(i18n.translateString("DeviceType"), String.class));
        }
        columnDefinitions.add(new SimpleRowTableModel.ColumnDefinition(i18n.translateString("VLANId"), String.class));
        if (swVersionOlderOrEqualWith42) {
            columnDefinitions.add(new SimpleRowTableModel.ColumnDefinition(i18n.translateString("SubDeviceProtocol"), String.class));
        }
        this.tableModel = new SimpleRowTableModel(columnDefinitions);
        SimpleRowTable srTable = new SimpleRowTable(this.table2, this.tableModel, (SimpleRowTableModelPanelController)this.controller);
        for (int i = 0; i < this.tableModel.getColumnCount(); ++i) {
            this.tableModel.setColumnReadonly(i, true);
        }
        this.tableModel.setNewRowReadOnlyOverride(false);
        this.table2.setSelectionMode(0);
    }

    private void initComponents() {
        this.btnCutThrough = new JButton();
        this.scrollPane2 = new JScrollPane();
        this.table2 = new JTable();
        CellConstraints cc = new CellConstraints();
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.dluX((int)45)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.CENTER, (Size)Sizes.dluX((int)45), 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.dluX((int)63))}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.MINIMUM, 1.0)}));
        this.btnCutThrough.setText("CutThrough");
        this.btnCutThrough.setEnabled(false);
        this.btnCutThrough.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SUGatewaysPanel.this.btnCutThroughActionPerformed(e);
            }
        });
        this.add((Component)this.btnCutThrough, cc.xy(7, 1));
        this.table2.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                SUGatewaysPanel.this.table2MouseClicked(e);
            }
        });
        this.table2.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                SUGatewaysPanel.this.table2KeyReleased(e);
            }
        });
        this.scrollPane2.setViewportView(this.table2);
        this.add((Component)this.scrollPane2, cc.xywh(1, 5, 7, 1));
    }

    private void table2MouseClicked(MouseEvent e) {
        this.controller.controlTableButtons();
    }

    private void table2KeyReleased(KeyEvent e) {
        this.controller.controlTableButtons();
    }

    private void btnCutThroughActionPerformed(ActionEvent e) {
        int row = this.table2.getSelectedRow();
        String ip = (String)this.table2.getValueAt(row, 0);
        try {
            CutThroughPluginUtil.performCutThrough((String)ip.toString());
        }
        catch (CutThroughNotSupportedException ex) {
            MessageBox.Alert.quickShow(ex.getMessage());
        }
        catch (Exception ex) {
            MessageBox.Error.quickShow("Failed to launch cut through!");
        }
    }

    public SimpleRowTableModel getTableModel() {
        return this.tableModel;
    }

    public JTable getTable2() {
        return this.table2;
    }

    public JButton getBtnCutThrough() {
        return this.btnCutThrough;
    }
}

