/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.rb.gui.configuration.SUGatewaysPanel;
import com.bwanms.rb.gui.configuration.TrapsControlConfigForm;
import com.bwanms.rb.mo.RbSuSubDevicesEntry;
import com.bwanms.rb.mo.RbSuSubDevicesTable;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbSU;
import com.bwanms.rb.util.RbVersions;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FormUtil;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SUGatewaysConfigForm
extends ManagedObjectsConfigForm<SUGatewaysPanel> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(TrapsControlConfigForm.class);
    private boolean swVersionOlderOrEqualWith42;
    private boolean swVersionNewerOrEqualWith45;
    private boolean bsIPSwitchingMode;
    private boolean suSoftwareVersionNewerOrEqualWith45;
    private boolean isGatewayInvisible;

    public SUGatewaysPanel initUIComponent() {
        RbBaseStationEquipment managerBS = ((RbSU)this.ctx.getEquipment()).getManagerBS();
        this.swVersionOlderOrEqualWith42 = RbVersions.V_4_2.isOlderOrEqualWith(managerBS.getSoftwareVersion());
        this.swVersionNewerOrEqualWith45 = RbVersions.V_4_5.isOlderOrEqualWith(managerBS.getSoftwareVersion());
        this.bsIPSwitchingMode = managerBS.getSwitchingMode() == RbBaseStationEquipment.SWITCHING_MODE_IP_CS;
        this.suSoftwareVersionNewerOrEqualWith45 = RbVersions.V_4_5.isOlderOrEqualWith(((RbSU)this.ctx.getEquipment()).getSoftwareVersion());
        this.isGatewayInvisible = this.swVersionNewerOrEqualWith45 & this.bsIPSwitchingMode && this.suSoftwareVersionNewerOrEqualWith45;
        return new SUGatewaysPanel(this.swVersionOlderOrEqualWith42, this.isGatewayInvisible);
    }

    public List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("SU", RbSuSubDevicesTable.class));
        return ret;
    }

    protected void fillUI(List<Object> managedObjects) {
        SimpleRowTableModel tableModel = ((SUGatewaysPanel)this.getUI()).getTableModel();
        FormUtil.cancelTableEditing((JTable)((SUGatewaysPanel)this.getUI()).getTable2());
        tableModel.clearTable();
        RbSuSubDevicesTable table = (RbSuSubDevicesTable)((Object)managedObjects.get(0));
        int row = 0;
        for (RbSuSubDevicesEntry entry : table.getEntries()) {
            int col = 0;
            tableModel.addNewRow(null, true);
            tableModel.setRowState(row, 0);
            tableModel.setInitialValueAt((Object)entry.getRbSubDeviceIpAddress(), row, col++);
            if (!this.isGatewayInvisible) {
                tableModel.setInitialValueAt((Object)i18n.translateString(RbSuSubDevicesEntry.toStringRbSubDeviceType(entry.getRbSubDeviceType())), row, col++);
            }
            tableModel.setInitialValueAt((Object)entry.getRbSubDeviceVlanID(), row, col++);
            if (this.swVersionOlderOrEqualWith42) {
                tableModel.setInitialValueAt((Object)i18n.translateString(RbSuSubDevicesEntry.toStringRbSubDeviceProtocol(entry.getRbSubDeviceProtocol())), row, col++);
            }
            ++row;
        }
    }

    public String getHelpTopic() {
        if (VersionFactory.getInstance().createVersion(((RbSU)this.ctx.getEquipment()).getManagerBS().getRunningSoftwareVersion()).isOlderThan((Version)new DefaultVersion("4.0"))) {
            return "ngnms.rb.help.su_Gateways";
        }
        return "ngnms.rb.help.su_tdd_Gateways";
    }
}

