/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JSpinnerBinding;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.rb.gui.configuration.SUBridgingParam;
import com.bwanms.rb.mo.RbMACBehindSUListEntry;
import com.bwanms.rb.mo.RbMACBehindSUListTable;
import com.bwanms.rb.mo.RbSuBridgingParameters;
import com.bwanms.rb.model.RbSU;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FormUtil;
import com.bwanms.util.MacAddress;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SUBridgingParamConfigForm
extends ManagedObjectsConfigForm<SUBridgingParam> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(SUBridgingParamConfigForm.class);

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        DefaultBinder binder = new DefaultBinder((Object)this.getUI(), managedObjects.get(0));
        binder.add((Binding)new JSpinnerBinding("spnrMaximumDevicesLimit", "rbSuMaxNumberOfSupportedDevices", i18n.translateString("MaximumDevicesLimit")));
        binder.add((Binding)new JSpinnerBinding("spnrAgingTime", "rbSuBridgeAgingTime", i18n.translateString("AgingTime")));
        binders.add((Binder)binder);
    }

    public SUBridgingParam initUIComponent() {
        return new SUBridgingParam();
    }

    public List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("SU", RbSuBridgingParameters.class));
        ret.add(this.ctx.createRequest("SU", RbMACBehindSUListTable.class));
        return ret;
    }

    protected void fillUI(List<Object> managedObjects) {
        RbSU su = (RbSU)this.ctx.getEquipment();
        if (su != null) {
            RbSuBridgingParameters bridging = (RbSuBridgingParameters)((Object)managedObjects.get(0));
            FormUtil.setSelectedValue((JComboBox)((SUBridgingParam)this.getUI()).getComboDevicesLimitSupport(), (Object)bridging.getRbSuSupportDevicesLimit());
            ((SUBridgingParam)this.getUI()).getSpnrMaximumDevicesLimit().setValue(bridging.getRbSuMaxNumberOfSupportedDevices());
            ((SUBridgingParam)this.getUI()).getSpnrAgingTime().setValue(bridging.getRbSuBridgeAgingTime());
            ((SUBridgingParam)this.getUI()).getController().comboDevicesLimitSupportItemStateChanged();
        }
        SimpleRowTableModel tableModel = ((SUBridgingParam)this.getUI()).getTableModel();
        FormUtil.cancelTableEditing((JTable)((SUBridgingParam)this.getUI()).getTable2());
        tableModel.clearTable();
        RbMACBehindSUListTable table = (RbMACBehindSUListTable)((Object)managedObjects.get(1));
        int row = 0;
        for (RbMACBehindSUListEntry entry : table.getEntries()) {
            int col = 0;
            tableModel.addNewRow(null, true);
            tableModel.setRowState(row, 0);
            tableModel.setInitialValueAt((Object)MacAddress.fromOctetString((String)entry.getRbMacBehindSuAddr()).toDashedString(), row, col++);
            tableModel.setInitialValueAt((Object)entry.getRbMacBehindSuVlan(), row, col++);
            ++row;
        }
    }

    protected void configureMOs(List<Object> managedObjects) {
        RbSU su = (RbSU)this.ctx.getEquipment();
        if (su != null) {
            RbSuBridgingParameters bridging = (RbSuBridgingParameters)((Object)managedObjects.get(0));
            bridging.setRbSuMaxNumberOfSupportedDevices((Integer)((SUBridgingParam)this.getUI()).getSpnrMaximumDevicesLimit().getValue());
            bridging.setRbSuBridgeAgingTime((Integer)((SUBridgingParam)this.getUI()).getSpnrAgingTime().getValue());
            bridging.setRbSuSupportDevicesLimit((Integer)FormUtil.getSelectedValue((JComboBox)((SUBridgingParam)this.getUI()).getComboDevicesLimitSupport()));
        }
    }

    public String getHelpTopic() {
        if (VersionFactory.getInstance().createVersion(((RbSU)this.ctx.getEquipment()).getManagerBS().getRunningSoftwareVersion()).isOlderThan((Version)new DefaultVersion("4.0"))) {
            return "ngnms.rb.help.su_bridging";
        }
        return "ngnms.rb.help.su_tdd_bridging";
    }
}

