/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.binding.translators.ValueTranslator;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.mo.snmp.StaticTableRowMO;
import com.bwanms.rb.gui.binding.IdValueTranslator;
import com.bwanms.rb.gui.configuration.SUAirIFPanel402;
import com.bwanms.rb.mo.RbAuChannelConfigEntry;
import com.bwanms.rb.mo.RbAuChannelConfigTable;
import com.bwanms.rb.mo.RbBsRadioParameters;
import com.bwanms.rb.mo.RbFrequencyBandsEntry;
import com.bwanms.rb.mo.RbFrequencyBandsTable;
import com.bwanms.rb.mo.RbMBSTChannelConfigEntry;
import com.bwanms.rb.mo.RbMBSTChannelConfigTable;
import com.bwanms.rb.mo.RbMBSTFrequencyBandsEntry;
import com.bwanms.rb.mo.RbMBSTFrequencyBandsTable;
import com.bwanms.rb.mo.RbOduConfigEntry;
import com.bwanms.rb.mo.RbOduConfigTable;
import com.bwanms.rb.mo.RbRegisteredSuSummaryEntry;
import com.bwanms.rb.mo.RbSuATPCParameters;
import com.bwanms.rb.mo.RbSuFreqScanningEntry;
import com.bwanms.rb.mo.RbSuMACParametersGroup;
import com.bwanms.rb.mo.RbSuMultirateParametersGroup;
import com.bwanms.rb.mo.RbSuPhyParametersGroup;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbSU;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.util.FormUtil;
import com.bwanms.util.OctetString;
import com.bwanms.util.version.impl.DefaultVersion;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SUAirIFConfigForm402
extends ManagedObjectsConfigForm<SUAirIFPanel402> {
    private StaticTableRowMO frequencyBandEntry = null;
    private RbRegisteredSuSummaryEntry suEntry;
    private boolean isSwitchngModeEthCS;

    public SUAirIFPanel402 initUIComponent() {
        this.isSwitchngModeEthCS = ((RbSU)this.ctx.getEquipment()).getManagerBS().getSwitchingMode() == RbBaseStationEquipment.SWITCHING_MODE_ETHERNET_CS;
        boolean isSwOlderThat41 = new DefaultVersion("4.1").isNewerThan(((RbSU)this.ctx.getEquipment()).getManagerBS().getSoftwareVersion());
        SUAirIFPanel402 panel = new SUAirIFPanel402();
        panel.getComboUplinkRate().addItem(new ComboItem((Object)0, SUAirIFPanel402.i18n.translateString(RbSuMultirateParametersGroup.toStringRbSuUlCurrentRate(0))));
        panel.getComboUplinkRate().addItem(new ComboItem((Object)1, SUAirIFPanel402.i18n.translateString(RbSuMultirateParametersGroup.toStringRbSuUlCurrentRate(1))));
        if (isSwOlderThat41) {
            panel.getComboUplinkRate().addItem(new ComboItem((Object)2, SUAirIFPanel402.i18n.translateString(RbSuMultirateParametersGroup.toStringRbSuUlCurrentRate(2))));
        }
        panel.getComboUplinkRate().addItem(new ComboItem((Object)3, SUAirIFPanel402.i18n.translateString(RbSuMultirateParametersGroup.toStringRbSuUlCurrentRate(3))));
        panel.getComboUplinkRate().addItem(new ComboItem((Object)4, SUAirIFPanel402.i18n.translateString(RbSuMultirateParametersGroup.toStringRbSuUlCurrentRate(4))));
        panel.getComboUplinkRate().addItem(new ComboItem((Object)5, SUAirIFPanel402.i18n.translateString(RbSuMultirateParametersGroup.toStringRbSuUlCurrentRate(5))));
        panel.getComboUplinkRate().addItem(new ComboItem((Object)6, SUAirIFPanel402.i18n.translateString(RbSuMultirateParametersGroup.toStringRbSuUlCurrentRate(6))));
        panel.getComboUplinkRate().addItem(new ComboItem((Object)7, SUAirIFPanel402.i18n.translateString(RbSuMultirateParametersGroup.toStringRbSuUlCurrentRate(7))));
        panel.getComboUplinkRate().addItem(new ComboItem((Object)8, SUAirIFPanel402.i18n.translateString(RbSuMultirateParametersGroup.toStringRbSuUlCurrentRate(8))));
        panel.getComboDownlinkRate().addItem(new ComboItem((Object)0, SUAirIFPanel402.i18n.translateString(RbSuMultirateParametersGroup.toStringRbSuDlCurrentRate(0))));
        panel.getComboDownlinkRate().addItem(new ComboItem((Object)1, SUAirIFPanel402.i18n.translateString(RbSuMultirateParametersGroup.toStringRbSuDlCurrentRate(1))));
        if (isSwOlderThat41) {
            panel.getComboDownlinkRate().addItem(new ComboItem((Object)2, SUAirIFPanel402.i18n.translateString(RbSuMultirateParametersGroup.toStringRbSuDlCurrentRate(2))));
        }
        panel.getComboDownlinkRate().addItem(new ComboItem((Object)3, SUAirIFPanel402.i18n.translateString(RbSuMultirateParametersGroup.toStringRbSuDlCurrentRate(3))));
        panel.getComboDownlinkRate().addItem(new ComboItem((Object)4, SUAirIFPanel402.i18n.translateString(RbSuMultirateParametersGroup.toStringRbSuDlCurrentRate(4))));
        panel.getComboDownlinkRate().addItem(new ComboItem((Object)5, SUAirIFPanel402.i18n.translateString(RbSuMultirateParametersGroup.toStringRbSuDlCurrentRate(5))));
        panel.getComboDownlinkRate().addItem(new ComboItem((Object)6, SUAirIFPanel402.i18n.translateString(RbSuMultirateParametersGroup.toStringRbSuDlCurrentRate(6))));
        panel.getComboDownlinkRate().addItem(new ComboItem((Object)7, SUAirIFPanel402.i18n.translateString(RbSuMultirateParametersGroup.toStringRbSuDlCurrentRate(7))));
        panel.getComboDownlinkRate().addItem(new ComboItem((Object)8, SUAirIFPanel402.i18n.translateString(RbSuMultirateParametersGroup.toStringRbSuDlCurrentRate(8))));
        panel.getComboCfgBandwidth().addItem(new ComboItem((Object)1, SUAirIFPanel402.i18n.translateString(RbSuPhyParametersGroup.toStringSuPhyConfiguredBandwidth(1))));
        panel.getComboCfgBandwidth().addItem(new ComboItem((Object)2, SUAirIFPanel402.i18n.translateString(RbSuPhyParametersGroup.toStringSuPhyConfiguredBandwidth(2))));
        panel.getComboCfgBandwidth().addItem(new ComboItem((Object)3, SUAirIFPanel402.i18n.translateString(RbSuPhyParametersGroup.toStringSuPhyConfiguredBandwidth(3))));
        panel.getComboCfgBandwidth().addItem(new ComboItem((Object)4, SUAirIFPanel402.i18n.translateString(RbSuPhyParametersGroup.toStringSuPhyConfiguredBandwidth(4))));
        panel.getComboCfgBandwidth().addItem(new ComboItem((Object)5, SUAirIFPanel402.i18n.translateString(RbSuPhyParametersGroup.toStringSuPhyConfiguredBandwidth(5))));
        return panel;
    }

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        if (this.isSwitchngModeEthCS) {
            DefaultBinder binder = new DefaultBinder((Object)this.getUI(), managedObjects.get(1));
            binder.add((Binding)new JTextFieldBinding("txtCfgBaseStationID", "rbSuConfiguredBaseStationId", (ValueTranslator)new IdValueTranslator(6), SUAirIFPanel402.i18n.translateString("BaseStationID")));
            binder.add((Binding)new JTextFieldBinding("txtCfgBaseStationIDMask", "rbSuConfiguredBaseStationIdMask", (ValueTranslator)new IdValueTranslator(6), SUAirIFPanel402.i18n.translateString("BaseStationIDMask")));
            binders.add((Binder)binder);
        }
    }

    public List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        RbSU su = (RbSU)this.ctx.getEquipment();
        if (su != null) {
            RbBaseStationEquipment bs = su.getManagerBS();
            ret.add(this.ctx.createRequest(bs.getId(), "BS", RbBsRadioParameters.class));
            if (this.isSwitchngModeEthCS) {
                ret.add(this.ctx.createRequest("SU", RbSuMACParametersGroup.class));
                ret.add(this.ctx.createRequest("SU", RbSuPhyParametersGroup.class));
            }
            ret.add(this.ctx.createRequest("SU", RbSuATPCParameters.class));
            ret.add(this.ctx.createRequest("SU", RbSuMultirateParametersGroup.class));
            if (bs instanceof RbBS) {
                ret.add(this.ctx.createRequest(bs.getId(), "BS", RbAuChannelConfigTable.class));
                ret.add(this.ctx.createRequest(bs.getId(), "BS", RbFrequencyBandsTable.class));
            } else {
                ret.add(this.ctx.createRequest(bs.getId(), "BS", RbMBSTChannelConfigTable.class));
                ret.add(this.ctx.createRequest(bs.getId(), "BS", RbMBSTFrequencyBandsTable.class));
            }
            ret.add(this.ctx.createRequest(bs.getId(), "BS", RbOduConfigTable.class));
            ret.add(this.ctx.createRequest("SU", RbRegisteredSuSummaryEntry.class));
        }
        return ret;
    }

    protected void fillUI(List<Object> managedObjects) {
        this.suEntry = (RbRegisteredSuSummaryEntry)managedObjects.get(this.isSwitchngModeEthCS ? 8 : 6);
        if (this.frequencyBandEntry == null) {
            this.setFrequencyBandEntry(managedObjects);
            String bandName = null;
            if (this.frequencyBandEntry instanceof RbFrequencyBandsEntry) {
                bandName = ((RbFrequencyBandsEntry)this.frequencyBandEntry).getRbFrequencyBandName();
            } else if (this.frequencyBandEntry instanceof RbMBSTFrequencyBandsEntry) {
                bandName = ((RbMBSTFrequencyBandsEntry)this.frequencyBandEntry).getRbMBSTFrequencyBandName();
            }
            ((SUAirIFPanel402)this.getUI()).getPnlStandardMode().setVisible(bandName != null && bandName.startsWith("3.") && this.isSwitchngModeEthCS);
        }
        RbBsRadioParameters bsRadio = (RbBsRadioParameters)((Object)managedObjects.get(0));
        ((SUAirIFPanel402)this.getUI()).getTxtCfgATPCSupport().setText(SUAirIFPanel402.i18n.translateString(RbBsRadioParameters.toStringRbBsATPCSupport(bsRadio.getRbBsATPCSupport())));
        if (this.isSwitchngModeEthCS) {
            RbSuMACParametersGroup mac = (RbSuMACParametersGroup)((Object)managedObjects.get(1));
            ((SUAirIFPanel402)this.getUI()).getTxtCfgBaseStationID().setText(OctetString.toDottedDecimalForm((String)mac.getRbSuConfiguredBaseStationId()));
            ((SUAirIFPanel402)this.getUI()).getTxtCfgBaseStationIDMask().setText(OctetString.toDottedDecimalForm((String)mac.getRbSuConfiguredBaseStationIdMask()));
            ((SUAirIFPanel402)this.getUI()).getTxtCrtBaseStationID().setText(OctetString.toDottedDecimalForm((String)mac.getRbSuBaseStationId()));
            ((SUAirIFPanel402)this.getUI()).getTxtCrtBaseStationIDMask().setText(OctetString.toDottedDecimalForm((String)mac.getRbSuBaseStationIdMask()));
            RbSuPhyParametersGroup phy = (RbSuPhyParametersGroup)((Object)managedObjects.get(2));
            ((SUAirIFPanel402)this.getUI()).getTxtCfgTxFrequency().setText(phy.getSuPhyConfiguredTxFrequencyChannel());
            FormUtil.setSelectedValue((JComboBox)((SUAirIFPanel402)this.getUI()).getComboCfgBandwidth(), (Object)phy.getSuPhyConfiguredBandwidth());
            ((SUAirIFPanel402)this.getUI()).getTxtCrtTxFrequency().setText(phy.getSuPhyCurrentTxFrequencyChannel());
            ((SUAirIFPanel402)this.getUI()).getTxtCrtBandwidth().setText(SUAirIFPanel402.i18n.translateString(RbSuPhyParametersGroup.toStringSuPhyCurrentBandwidth(phy.getSuPhyCurrentBandwidth())));
        }
        RbSuATPCParameters suATPCParameters = (RbSuATPCParameters)((Object)managedObjects.get(this.isSwitchngModeEthCS ? 3 : 1));
        ((SUAirIFPanel402)this.getUI()).getTxtCrtATPCSupport().setText(SUAirIFPanel402.i18n.translateString(suATPCParameters.toStringRbSuATPCSupport(suATPCParameters.getRbSuATPCSupport())));
        RbSuMultirateParametersGroup multirate = (RbSuMultirateParametersGroup)((Object)managedObjects.get(this.isSwitchngModeEthCS ? 4 : 2));
        ((SUAirIFPanel402)this.getUI()).getTxtMultirateSupport().setText(SUAirIFPanel402.i18n.translateString(RbSuMultirateParametersGroup.toStringRbSuMultirateSupport(multirate.getRbSuMultirateSupport())));
        boolean canEditRates = 2 == multirate.getRbSuMultirateSupport();
        ((SUAirIFPanel402)this.getUI()).getTxtEstimatedDistance().setText(multirate.getRbSuEstDistance().toString());
        ((SUAirIFPanel402)this.getUI()).getComboUplinkRate().setEnabled(canEditRates);
        ((SUAirIFPanel402)this.getUI()).getComboDownlinkRate().setEnabled(canEditRates);
        FormUtil.setSelectedValue((JComboBox)((SUAirIFPanel402)this.getUI()).getComboUplinkRate(), (Object)multirate.getRbSuUlCurrentRate());
        FormUtil.setSelectedValue((JComboBox)((SUAirIFPanel402)this.getUI()).getComboDownlinkRate(), (Object)multirate.getRbSuDlCurrentRate());
        ((SUAirIFPanel402)this.getUI()).getTxtUplinkSNR().setText(multirate.getRbSuUlSNR());
        ((SUAirIFPanel402)this.getUI()).getTxtUplinkRSSI().setText(multirate.getRbSuUlRSSI());
        ((SUAirIFPanel402)this.getUI()).getTxtDownlinkSNR().setText(multirate.getRbSuDlSNR());
        ((SUAirIFPanel402)this.getUI()).getTxtDownlinkRSSI().setText(multirate.getRbSuDlRSSI());
        ((SUAirIFPanel402)this.getUI()).getTxtCrtTxPower().setText(multirate.getRbSuTxPower());
    }

    protected void configureMOs(List<Object> managedObjects, List<InvalidValue> invalidValues) {
        if (((SUAirIFPanel402)this.getUI()).getPnlStandardMode().isVisible() && this.isSwitchngModeEthCS) {
            this.verifyStandardModeTxFrequency(invalidValues);
            RbSuPhyParametersGroup phy = (RbSuPhyParametersGroup)((Object)managedObjects.get(2));
            phy.setSuPhyConfiguredTxFrequencyChannel(((SUAirIFPanel402)this.getUI()).getTxtCfgTxFrequency().getText());
            phy.setSuPhyConfiguredBandwidth((Integer)FormUtil.getSelectedValue((JComboBox)((SUAirIFPanel402)this.getUI()).getComboCfgBandwidth()));
        }
        RbSuMultirateParametersGroup multirate = (RbSuMultirateParametersGroup)((Object)managedObjects.get(this.isSwitchngModeEthCS ? 4 : 2));
        if (((SUAirIFPanel402)this.getUI()).getComboUplinkRate().isEnabled()) {
            multirate.setRbSuUlCurrentRate((Integer)FormUtil.getSelectedValue((JComboBox)((SUAirIFPanel402)this.getUI()).getComboUplinkRate()));
            multirate.setRbSuDlCurrentRate((Integer)FormUtil.getSelectedValue((JComboBox)((SUAirIFPanel402)this.getUI()).getComboDownlinkRate()));
        }
        Integer configuredBandwidth = (Integer)FormUtil.getSelectedValue((JComboBox)((SUAirIFPanel402)this.getUI()).getComboCfgBandwidth());
        if (((RbSU)this.ctx.getEquipment()).getManagerBS().getSoftwareVersion().compareTo((Object)new DefaultVersion("4.1")) < 0 && !Integer.valueOf(1).equals(configuredBandwidth) && !Integer.valueOf(2).equals(configuredBandwidth)) {
            invalidValues.add(new InvalidValue(SUAirIFPanel402.i18n.translateString("InvalidValueForSoftwareVersionUnder41"), JComboBox.class, SUAirIFPanel402.i18n.translateString("Bandwidth"), (Object)SUAirIFPanel402.i18n.translateString(RbSuFreqScanningEntry.toStringRbSuConfiguredBandwidth(configuredBandwidth)), (Object)((SUAirIFPanel402)this.getUI()).getComboCfgBandwidth()));
        }
        managedObjects.remove(0);
        managedObjects.remove(managedObjects.size() - 1);
        managedObjects.remove(managedObjects.size() - 1);
        managedObjects.remove(managedObjects.size() - 1);
        if (!this.suEntry.getRbSuFaultStatus().equals(5)) {
            if (multirate.getRbSuDlCurrentRate().equals(0)) {
                invalidValues.add(new InvalidValue(SUAirIFPanel402.i18n.translateString("NotDefinedInvalidValue"), JComboBox.class, SUAirIFPanel402.i18n.translateString("DownlinkRate"), (Object)SUAirIFPanel402.i18n.translateString("notDefined"), (Object)((SUAirIFPanel402)this.getUI()).getComboDownlinkRate()));
            }
            if (multirate.getRbSuUlCurrentRate().equals(0)) {
                invalidValues.add(new InvalidValue(SUAirIFPanel402.i18n.translateString("NotDefinedInvalidValue"), JComboBox.class, SUAirIFPanel402.i18n.translateString("UplinkRate"), (Object)SUAirIFPanel402.i18n.translateString("notDefined"), (Object)((SUAirIFPanel402)this.getUI()).getComboUplinkRate()));
            }
        }
    }

    private void verifyStandardModeTxFrequency(List<InvalidValue> invalidValues) {
        double adjust = 0.0;
        switch ((Integer)FormUtil.getSelectedValue((JComboBox)((SUAirIFPanel402)this.getUI()).getComboCfgBandwidth())) {
            case 1: {
                adjust = 0.875;
                break;
            }
            case 2: {
                adjust = 1.75;
                break;
            }
            case 3: {
                adjust = 2.5;
                break;
            }
            case 4: {
                adjust = 3.5;
                break;
            }
            case 5: {
                adjust = 5.0;
            }
        }
        long adjustLong = (long)(adjust * 1000.0);
        Double cfgTxFrequencyDouble = null;
        try {
            cfgTxFrequencyDouble = Double.valueOf(((SUAirIFPanel402)this.getUI()).getTxtCfgTxFrequency().getText()) * 1000.0;
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        long startFreq = 3399500L + adjustLong;
        long stopFreq = 3500000L - adjustLong;
        long bandStep = 125L;
        if (cfgTxFrequencyDouble == null || cfgTxFrequencyDouble < (double)startFreq || cfgTxFrequencyDouble > (double)stopFreq || (cfgTxFrequencyDouble - (double)startFreq) % (double)bandStep != 0.0) {
            invalidValues.add(new InvalidValue(SUAirIFPanel402.i18n.translateString("SuTxFrequencyValueBetween", new Object[]{(double)startFreq / 1000.0, (double)stopFreq / 1000.0, (double)bandStep / 1000.0}), RbSuPhyParametersGroup.class, SUAirIFPanel402.i18n.translateString("ConfigutedUplink(Tx)Frequency"), (Object)((SUAirIFPanel402)this.getUI()).getTxtCfgTxFrequency().getText(), (Object)((SUAirIFPanel402)this.getUI()).getTxtCfgTxFrequency()));
        }
    }

    private void setFrequencyBandEntry(List<Object> managedObjects) {
        if (!this.isSwitchngModeEthCS) {
            return;
        }
        RbOduConfigTable oduTable = (RbOduConfigTable)((Object)managedObjects.get(7));
        RbOduConfigEntry oduEntry = null;
        if (managedObjects.get(5) instanceof RbAuChannelConfigTable) {
            RbFrequencyBandsTable bandsTable = (RbFrequencyBandsTable)((Object)managedObjects.get(6));
            int slot = ((RbSU)this.ctx.getEquipment()).getServingAUId();
            RbAuChannelConfigTable auChannelTable = (RbAuChannelConfigTable)((Object)managedObjects.get(5));
            boolean found = false;
            Integer adminStatusEnabled = 1;
            int n = auChannelTable.getEntries().size();
            block0: for (int i = 0; i < n && !found; ++i) {
                RbAuChannelConfigEntry channelEntry = (RbAuChannelConfigEntry)((Object)auChannelTable.getEntries().get(i));
                if (channelEntry.getRbSlotNumber() != slot || !adminStatusEnabled.equals(channelEntry.getRbAuChannelAdminStatus())) continue;
                for (RbOduConfigEntry e : oduTable.getEntries()) {
                    if (!e.getRbOduConfigId().equals(channelEntry.getRbAuChannelAssociatedOduId())) continue;
                    oduEntry = e;
                    found = true;
                    continue block0;
                }
            }
            this.frequencyBandEntry = oduEntry != null && oduEntry.getRbOduConfigFrequencyBand() != null ? (RbFrequencyBandsEntry)bandsTable.findEntry(oduEntry.getRbOduConfigFrequencyBand().toString()) : null;
        } else {
            RbMBSTFrequencyBandsTable bandsTable = (RbMBSTFrequencyBandsTable)((Object)managedObjects.get(6));
            RbMBSTChannelConfigTable auChannelTable = (RbMBSTChannelConfigTable)((Object)managedObjects.get(5));
            Integer adminStatusEnabled = 1;
            block2: for (RbMBSTChannelConfigEntry entry : auChannelTable.getEntries()) {
                if (!adminStatusEnabled.equals(entry.getRbMBSTChannelAdminStatus())) continue;
                for (RbOduConfigEntry e : oduTable.getEntries()) {
                    if (!e.getRbOduConfigId().equals(entry.getRbMBSTChannelAssociatedOduId())) continue;
                    oduEntry = e;
                    continue block2;
                }
            }
            this.frequencyBandEntry = oduEntry != null && oduEntry.getRbOduConfigFrequencyBand() != null ? (RbMBSTFrequencyBandsEntry)bandsTable.findEntry(oduEntry.getRbOduConfigFrequencyBand().toString()) : null;
        }
    }

    public String getHelpTopic() {
        return "ngnms.rb.help.su_tdd_air_interface";
    }

    private boolean checkMask(String mask) {
        String[] splittedValues = mask.split("\\.");
        if (splittedValues.length != 6) {
            return false;
        }
        for (String value : splittedValues) {
            try {
                int castValue = Integer.parseInt(value);
                if (castValue <= 255 && castValue >= 0) continue;
                return false;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        return true;
    }
}

