/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JComboBoxBinding;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.binding.translators.ValueTranslator;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.mo.snmp.StaticTableRowMO;
import com.bwanms.rb.gui.binding.IdValueTranslator;
import com.bwanms.rb.gui.configuration.SUAirIFPanel;
import com.bwanms.rb.mo.RbAuChannelConfigEntry;
import com.bwanms.rb.mo.RbAuChannelConfigTable;
import com.bwanms.rb.mo.RbBsRadioParameters;
import com.bwanms.rb.mo.RbFrequencyBandsEntry;
import com.bwanms.rb.mo.RbFrequencyBandsTable;
import com.bwanms.rb.mo.RbMBSTChannelConfigEntry;
import com.bwanms.rb.mo.RbMBSTChannelConfigTable;
import com.bwanms.rb.mo.RbMBSTFrequencyBandsEntry;
import com.bwanms.rb.mo.RbMBSTFrequencyBandsTable;
import com.bwanms.rb.mo.RbOduConfigEntry;
import com.bwanms.rb.mo.RbOduConfigTable;
import com.bwanms.rb.mo.RbRegisteredSuSummaryEntry;
import com.bwanms.rb.mo.RbSuATPCParameters;
import com.bwanms.rb.mo.RbSuHwComponentsInfoSummaryEntry;
import com.bwanms.rb.mo.RbSuMACParametersGroup;
import com.bwanms.rb.mo.RbSuMultirateParametersGroup;
import com.bwanms.rb.mo.RbSuPhyParametersGroup;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbSU;
import com.bwanms.services.UnifiedMORequest;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.util.FormUtil;
import com.bwanms.util.OctetString;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SUAirIFConfigForm
extends ManagedObjectsConfigForm<SUAirIFPanel> {
    private static final Logger log = Logger.getLogger(SUAirIFConfigForm.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(SUAirIFConfigForm.class);
    private StaticTableRowMO frequencyBandEntry = null;
    private Long startFreqLimit = null;
    private Long stopFreqLimit = null;
    private RbRegisteredSuSummaryEntry suEntry;

    public SUAirIFPanel initUIComponent() {
        SUAirIFPanel panel = new SUAirIFPanel();
        if (((RbSU)this.ctx.getEquipment()).getManagerBS().getSoftwareVersion().isOlderThan((Version)new DefaultVersion("3.0"))) {
            panel.getPnl30Parameters().setVisible(false);
        }
        if (((RbSU)this.ctx.getEquipment()).getManagerBS().getSoftwareVersion().compareTo((Object)new DefaultVersion("4.0")) >= 0) {
            panel.getComboCfgBandwidth().addItem(new ComboItem((Object)3, i18n.translateString(RbSuPhyParametersGroup.toStringSuPhyConfiguredBandwidth(3))));
            panel.getComboCfgBandwidth().addItem(new ComboItem((Object)4, i18n.translateString(RbSuPhyParametersGroup.toStringSuPhyConfiguredBandwidth(4))));
            panel.getComboCfgBandwidth().addItem(new ComboItem((Object)5, i18n.translateString(RbSuPhyParametersGroup.toStringSuPhyConfiguredBandwidth(5))));
        }
        return panel;
    }

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        DefaultBinder binder = new DefaultBinder((Object)this.getUI(), managedObjects.get(1));
        binder.add((Binding)new JTextFieldBinding("txtCfgBaseStationID", "rbSuConfiguredBaseStationId", (ValueTranslator)new IdValueTranslator(6), i18n.translateString("BaseStationID")));
        binder.add((Binding)new JTextFieldBinding("txtCfgBaseStationIDMask", "rbSuConfiguredBaseStationIdMask", (ValueTranslator)new IdValueTranslator(6), i18n.translateString("BaseStationIDMask")));
        binders.add((Binder)binder);
        if (((RbSU)this.ctx.getEquipment()).getManagerBS().getSoftwareVersion().compareTo((Object)VersionFactory.getInstance().createVersion("3.0")) >= 0) {
            DefaultBinder binder_2 = new DefaultBinder((Object)this.getUI(), managedObjects.get(4));
            binder_2.add((Binding)new JComboBoxBinding(i18n, "comboMinUplinkDataRate", "rbSuUlMinDataRate", i18n.translateString("MinimumUplinkDataRate")));
            binder_2.add((Binding)new JComboBoxBinding(i18n, "comboMinDownlinkDataRate", "rbSuDlMinDataRate", i18n.translateString("MinimumDownlinkDataRate")));
            binders.add((Binder)binder_2);
        }
    }

    public List<UnifiedMORequest> getManagedObjectRequests() {
        ArrayList<UnifiedMORequest> ret = new ArrayList<UnifiedMORequest>();
        RbSU su = (RbSU)this.ctx.getEquipment();
        RbBaseStationEquipment bs = su.getManagerBS();
        if (su != null) {
            ret.add((UnifiedMORequest)this.ctx.createRequest(bs.getId(), "BS", RbBsRadioParameters.class));
            ret.add((UnifiedMORequest)this.ctx.createRequest("SU", RbSuMACParametersGroup.class));
            ret.add((UnifiedMORequest)this.ctx.createRequest("SU", RbSuPhyParametersGroup.class));
            ret.add((UnifiedMORequest)this.ctx.createRequest("SU", RbSuATPCParameters.class));
            ret.add((UnifiedMORequest)this.ctx.createRequest("SU", RbSuMultirateParametersGroup.class));
            if (bs instanceof RbBS) {
                ret.add((UnifiedMORequest)this.ctx.createRequest(bs.getId(), "BS", RbAuChannelConfigTable.class));
                ret.add((UnifiedMORequest)this.ctx.createRequest(bs.getId(), "BS", RbFrequencyBandsTable.class));
            } else {
                ret.add((UnifiedMORequest)this.ctx.createRequest(bs.getId(), "BS", RbMBSTChannelConfigTable.class));
                ret.add((UnifiedMORequest)this.ctx.createRequest(bs.getId(), "BS", RbMBSTFrequencyBandsTable.class));
            }
            ret.add((UnifiedMORequest)this.ctx.createRequest(bs.getId(), "BS", RbOduConfigTable.class));
            ret.add((UnifiedMORequest)this.ctx.createRequest("SU", RbRegisteredSuSummaryEntry.class));
            ret.add((UnifiedMORequest)this.ctx.createRequest("SU", RbSuHwComponentsInfoSummaryEntry.class));
        }
        return ret;
    }

    protected void fillUI(List<Object> managedObjects) {
        this.suEntry = (RbRegisteredSuSummaryEntry)managedObjects.get(8);
        RbSuHwComponentsInfoSummaryEntry hwInfo = (RbSuHwComponentsInfoSummaryEntry)((Object)managedObjects.get(9));
        JComboBox cmbBandwidth = ((SUAirIFPanel)this.getUI()).getComboCfgBandwidth();
        boolean _7MhzAdded = false;
        for (int i = 0; i < cmbBandwidth.getItemCount(); ++i) {
            if (!((ComboItem)cmbBandwidth.getItemAt(i)).getValue().equals(4)) continue;
            _7MhzAdded = true;
            break;
        }
        if (!_7MhzAdded) {
            int intSuHwRevision = 0;
            try {
                if (this.suEntry != null) {
                    intSuHwRevision = Integer.parseInt(hwInfo.getRbSuRfCardRevision());
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (intSuHwRevision == 12 && ((RbSU)this.ctx.getEquipment()).getSoftwareVersion().compareTo((Object)new DefaultVersion("3.5")) >= 0) {
                ((SUAirIFPanel)this.getUI()).getComboCfgBandwidth().addItem(new ComboItem((Object)4, i18n.translateString(RbSuPhyParametersGroup.toStringSuPhyConfiguredBandwidth(4))));
            }
        }
        if (this.frequencyBandEntry == null) {
            this.setFrequencyBandEntry(managedObjects);
        }
        RbBsRadioParameters bsRadio = (RbBsRadioParameters)((Object)managedObjects.get(0));
        ((SUAirIFPanel)this.getUI()).getTxtCfgATPCSupport().setText(i18n.translateString(RbBsRadioParameters.toStringRbBsATPCSupport(bsRadio.getRbBsATPCSupport())));
        RbSuMACParametersGroup mac = (RbSuMACParametersGroup)((Object)managedObjects.get(1));
        ((SUAirIFPanel)this.getUI()).getTxtCrtBaseStationID().setText(OctetString.toDottedDecimalForm((String)mac.getRbSuBaseStationId()));
        ((SUAirIFPanel)this.getUI()).getTxtCrtBaseStationIDMask().setText(OctetString.toDottedDecimalForm((String)mac.getRbSuBaseStationIdMask()));
        ((SUAirIFPanel)this.getUI()).getTxtCfgBaseStationID().setText(OctetString.toDottedDecimalForm((String)mac.getRbSuConfiguredBaseStationId()));
        ((SUAirIFPanel)this.getUI()).getTxtCfgBaseStationIDMask().setText(OctetString.toDottedDecimalForm((String)mac.getRbSuConfiguredBaseStationIdMask()));
        RbSuPhyParametersGroup phy = (RbSuPhyParametersGroup)((Object)managedObjects.get(2));
        ((SUAirIFPanel)this.getUI()).getTxtCrtTxFrequency().setText(phy.getSuPhyCurrentTxFrequencyChannel());
        ((SUAirIFPanel)this.getUI()).getTxtCrtBandwidth().setText(i18n.translateString(RbSuPhyParametersGroup.toStringSuPhyCurrentBandwidth(phy.getSuPhyCurrentBandwidth())));
        ((SUAirIFPanel)this.getUI()).getTxtCfgTxFrequency().setText(phy.getSuPhyConfiguredTxFrequencyChannel());
        FormUtil.setSelectedValue((JComboBox)((SUAirIFPanel)this.getUI()).getComboCfgBandwidth(), (Object)phy.getSuPhyConfiguredBandwidth());
        RbSuATPCParameters suATPCParameters = (RbSuATPCParameters)((Object)managedObjects.get(3));
        ((SUAirIFPanel)this.getUI()).getTxtCrtATPCSupport().setText(i18n.translateString(suATPCParameters.toStringRbSuATPCSupport(suATPCParameters.getRbSuATPCSupport())));
        RbSuMultirateParametersGroup multirate = (RbSuMultirateParametersGroup)((Object)managedObjects.get(4));
        ((SUAirIFPanel)this.getUI()).getTxtMultirateSupport().setText(i18n.translateString(RbSuMultirateParametersGroup.toStringRbSuMultirateSupport(multirate.getRbSuMultirateSupport())));
        ((SUAirIFPanel)this.getUI()).getTxtEstimatedDistance().setText(multirate.getRbSuEstDistance().toString());
        boolean canEditRates = 2 == multirate.getRbSuMultirateSupport();
        ((SUAirIFPanel)this.getUI()).getComboUplinkRate().setEnabled(canEditRates);
        ((SUAirIFPanel)this.getUI()).getComboDownlinkRate().setEnabled(canEditRates);
        FormUtil.setSelectedValue((JComboBox)((SUAirIFPanel)this.getUI()).getComboUplinkRate(), (Object)multirate.getRbSuUlCurrentRate());
        FormUtil.setSelectedValue((JComboBox)((SUAirIFPanel)this.getUI()).getComboDownlinkRate(), (Object)multirate.getRbSuDlCurrentRate());
        ((SUAirIFPanel)this.getUI()).getTxtUplinkSNR().setText(multirate.getRbSuUlSNR());
        ((SUAirIFPanel)this.getUI()).getTxtUplinkRSSI().setText(multirate.getRbSuUlRSSI());
        ((SUAirIFPanel)this.getUI()).getTxtDownlinkSNR().setText(multirate.getRbSuDlSNR());
        ((SUAirIFPanel)this.getUI()).getTxtDownlinkRSSI().setText(multirate.getRbSuDlRSSI());
        ((SUAirIFPanel)this.getUI()).getTxtCrtTxPower().setText(multirate.getRbSuTxPower());
        if (((RbSU)this.ctx.getEquipment()).getSoftwareVersion().compareTo((Object)new DefaultVersion("3.0")) < 0) {
            ((SUAirIFPanel)this.getUI()).getComboMinUplinkDataRate().setEnabled(false);
            ((SUAirIFPanel)this.getUI()).getComboMinDownlinkDataRate().setEnabled(false);
        } else {
            ((SUAirIFPanel)this.getUI()).getTxtUplinkRateBelowMinimum().setText(i18n.translateString(RbSuMultirateParametersGroup.toStringRbSuRateBelowMinimum(multirate.getRbSuUlRateBelowMinimum())));
            ((SUAirIFPanel)this.getUI()).getTxtDownlinkRateBelowMinimum().setText(i18n.translateString(RbSuMultirateParametersGroup.toStringRbSuRateBelowMinimum(multirate.getRbSuDlRateBelowMinimum())));
        }
        log.info((Object)("rbSuUlMinDataRate " + multirate.getRbSuUlMinDataRate() + " rbSuDlMinDataRate " + multirate.getRbSuDlMinDataRate()));
    }

    protected void configureMOs(List<Object> managedObjects, List<InvalidValue> invalidValues) {
        this.verifyMinMaxConfTxFrequency(managedObjects, invalidValues);
        RbSuPhyParametersGroup phy = (RbSuPhyParametersGroup)((Object)managedObjects.get(2));
        phy.setSuPhyConfiguredTxFrequencyChannel(((SUAirIFPanel)this.getUI()).getTxtCfgTxFrequency().getText());
        phy.setSuPhyConfiguredBandwidth((Integer)FormUtil.getSelectedValue((JComboBox)((SUAirIFPanel)this.getUI()).getComboCfgBandwidth()));
        RbSuMultirateParametersGroup multirate = (RbSuMultirateParametersGroup)((Object)managedObjects.get(4));
        multirate.setRbSuUlCurrentRate((Integer)FormUtil.getSelectedValue((JComboBox)((SUAirIFPanel)this.getUI()).getComboUplinkRate()));
        multirate.setRbSuDlCurrentRate((Integer)FormUtil.getSelectedValue((JComboBox)((SUAirIFPanel)this.getUI()).getComboDownlinkRate()));
        managedObjects.remove(0);
        managedObjects.remove(managedObjects.size() - 2);
        managedObjects.remove(managedObjects.size() - 2);
        managedObjects.remove(managedObjects.size() - 2);
        if (!this.suEntry.getRbSuFaultStatus().equals(5)) {
            if (multirate.getRbSuDlCurrentRate().equals(0)) {
                invalidValues.add(new InvalidValue(i18n.translateString("NotDefinedInvalidValue"), JComboBox.class, i18n.translateString("DownlinkRate"), (Object)i18n.translateString("notDefined"), (Object)((SUAirIFPanel)this.getUI()).getComboDownlinkRate()));
            }
            if (multirate.getRbSuUlCurrentRate().equals(0)) {
                invalidValues.add(new InvalidValue(i18n.translateString("NotDefinedInvalidValue"), JComboBox.class, i18n.translateString("UplinkRate"), (Object)i18n.translateString("notDefined"), (Object)((SUAirIFPanel)this.getUI()).getComboUplinkRate()));
            }
            if (((RbSU)this.ctx.getEquipment()).getManagerBS().getSoftwareVersion().compareTo((Object)VersionFactory.getInstance().createVersion("3.0")) >= 0) {
                ComboItem item = (ComboItem)((SUAirIFPanel)this.getUI()).getComboMinDownlinkDataRate().getSelectedItem();
                if (((SUAirIFPanel)this.getUI()).getComboMinDownlinkDataRate().isEnabled() && item.getValue().equals(0)) {
                    invalidValues.add(new InvalidValue(i18n.translateString("NotDefinedInvalidValue"), JComboBox.class, i18n.translateString("MinimumDownlinkDataRate"), (Object)i18n.translateString("notDefined"), (Object)((SUAirIFPanel)this.getUI()).getComboMinDownlinkDataRate()));
                }
                item = (ComboItem)((SUAirIFPanel)this.getUI()).getComboMinUplinkDataRate().getSelectedItem();
                if (((SUAirIFPanel)this.getUI()).getComboMinUplinkDataRate().isEnabled() && item.getValue().equals(0)) {
                    invalidValues.add(new InvalidValue(i18n.translateString("NotDefinedInvalidValue"), JComboBox.class, i18n.translateString("MinimumUplinkDataRate"), (Object)i18n.translateString("notDefined"), (Object)((SUAirIFPanel)this.getUI()).getComboMinUplinkDataRate()));
                }
            } else {
                multirate.setRbSuUlMinDataRate(null);
                multirate.setRbSuDlMinDataRate(null);
            }
        }
    }

    private void verifyMinMaxConfTxFrequency(List<Object> managedObjects, List<InvalidValue> invalidValues) {
        double adjust = 0.0;
        switch ((Integer)FormUtil.getSelectedValue((JComboBox)((SUAirIFPanel)this.getUI()).getComboCfgBandwidth())) {
            case 1: {
                adjust = 0.875;
                break;
            }
            case 2: {
                adjust = 1.75;
                break;
            }
            case 3: {
                adjust = 2.5;
                break;
            }
            case 4: {
                adjust = 3.5;
                break;
            }
            case 5: {
                adjust = 5.0;
            }
        }
        long adjustLong = (long)(adjust * 1000.0);
        if (this.frequencyBandEntry instanceof RbFrequencyBandsEntry) {
            RbFrequencyBandsEntry freqBand = (RbFrequencyBandsEntry)this.frequencyBandEntry;
            Double cfgTxFrequencyDouble = null;
            try {
                cfgTxFrequencyDouble = Double.valueOf(((SUAirIFPanel)this.getUI()).getTxtCfgTxFrequency().getText()) * 1000.0;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            long startFreq = this.startFreqLimit + (long)freqBand.getRbFrequencyBandDuplexSeparation().intValue() + adjustLong;
            long stopFreq = this.stopFreqLimit + (long)freqBand.getRbFrequencyBandDuplexSeparation().intValue() - adjustLong;
            if (cfgTxFrequencyDouble == null || cfgTxFrequencyDouble < (double)startFreq || cfgTxFrequencyDouble > (double)stopFreq || (cfgTxFrequencyDouble - (double)startFreq) % (double)freqBand.getRbFrequencyBandStep().longValue() != 0.0) {
                invalidValues.add(new InvalidValue(i18n.translateString("SuTxFrequencyValueBetween", new Object[]{(double)startFreq / 1000.0, (double)stopFreq / 1000.0, (double)freqBand.getRbFrequencyBandStep().longValue() / 1000.0}), RbSuPhyParametersGroup.class, i18n.translateString("ConfigutedUplink(Tx)Frequency"), (Object)((SUAirIFPanel)this.getUI()).getTxtCfgTxFrequency().getText(), (Object)((SUAirIFPanel)this.getUI()).getTxtCfgTxFrequency()));
            }
        } else if (this.frequencyBandEntry instanceof RbMBSTFrequencyBandsEntry) {
            RbMBSTFrequencyBandsEntry freqBand = (RbMBSTFrequencyBandsEntry)this.frequencyBandEntry;
            Double cfgTxFrequencyDouble = null;
            try {
                cfgTxFrequencyDouble = Double.valueOf(((SUAirIFPanel)this.getUI()).getTxtCfgTxFrequency().getText()) * 1000.0;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            long startFreq = this.startFreqLimit + (long)freqBand.getRbMBSTFrequencyBandDuplexSeparation().intValue() + adjustLong;
            long stopFreq = this.stopFreqLimit + (long)freqBand.getRbMBSTFrequencyBandDuplexSeparation().intValue() - adjustLong;
            if (cfgTxFrequencyDouble == null || cfgTxFrequencyDouble < (double)startFreq || cfgTxFrequencyDouble > (double)stopFreq || (cfgTxFrequencyDouble - (double)startFreq) % (double)freqBand.getRbMBSTFrequencyBandStep().longValue() != 0.0) {
                invalidValues.add(new InvalidValue(i18n.translateString("SuTxFrequencyValueBetween", new Object[]{(double)startFreq / 1000.0, (double)stopFreq / 1000.0, (double)freqBand.getRbMBSTFrequencyBandStep().longValue() / 1000.0}), RbSuPhyParametersGroup.class, i18n.translateString("ConfigutedUplink(Tx)Frequency"), (Object)((SUAirIFPanel)this.getUI()).getTxtCfgTxFrequency().getText(), (Object)((SUAirIFPanel)this.getUI()).getTxtCfgTxFrequency()));
            }
        }
    }

    private void setFrequencyBandEntry(List<Object> managedObjects) {
        block10: {
            RbOduConfigEntry oduEntry;
            RbOduConfigTable oduTable;
            block9: {
                oduTable = (RbOduConfigTable)((Object)managedObjects.get(7));
                oduEntry = null;
                if (!(managedObjects.get(5) instanceof RbAuChannelConfigTable)) break block9;
                RbFrequencyBandsTable bandsTable = (RbFrequencyBandsTable)((Object)managedObjects.get(6));
                RbAuChannelConfigTable auChannelTable = (RbAuChannelConfigTable)((Object)managedObjects.get(5));
                int slot = ((RbSU)this.ctx.getEquipment()).getServingAUId();
                boolean found = false;
                Integer adminStatusEnabled = 1;
                int n = auChannelTable.getEntries().size();
                block0: for (int i = 0; i < n && !found; ++i) {
                    RbAuChannelConfigEntry channelEntry = (RbAuChannelConfigEntry)((Object)auChannelTable.getEntries().get(i));
                    if (channelEntry.getRbSlotNumber() != slot || !adminStatusEnabled.equals(channelEntry.getRbAuChannelAdminStatus())) continue;
                    for (RbOduConfigEntry e : oduTable.getEntries()) {
                        if (!e.getRbOduConfigId().equals(channelEntry.getRbAuChannelAssociatedOduId())) continue;
                        oduEntry = e;
                        found = true;
                        continue block0;
                    }
                }
                RbFrequencyBandsEntry rbFrequencyBandsEntry = this.frequencyBandEntry = oduEntry != null && oduEntry.getRbOduConfigFrequencyBand() != null ? (RbFrequencyBandsEntry)bandsTable.findEntry(oduEntry.getRbOduConfigFrequencyBand().toString()) : null;
                if (this.frequencyBandEntry == null) break block10;
                RbFrequencyBandsEntry freqBandEntry = (RbFrequencyBandsEntry)this.frequencyBandEntry;
                this.startFreqLimit = freqBandEntry.getRbFrequencyBandStartFrequency();
                this.stopFreqLimit = freqBandEntry.getRbFrequencyBandStopFrequency();
                for (RbFrequencyBandsEntry entry : bandsTable.getEntries()) {
                    if (!entry.getRbFrequencyBandGroupId().equals(freqBandEntry.getRbFrequencyBandGroupId())) continue;
                    if (entry.getRbFrequencyBandStartFrequency() < this.startFreqLimit) {
                        this.startFreqLimit = entry.getRbFrequencyBandStartFrequency();
                    }
                    if (entry.getRbFrequencyBandStopFrequency() <= this.stopFreqLimit) continue;
                    this.stopFreqLimit = entry.getRbFrequencyBandStopFrequency();
                }
                break block10;
            }
            RbMBSTFrequencyBandsTable bandsTable = (RbMBSTFrequencyBandsTable)((Object)managedObjects.get(6));
            RbMBSTChannelConfigTable auChannelTable = (RbMBSTChannelConfigTable)((Object)managedObjects.get(5));
            Integer adminStatusEnabled = 1;
            block3: for (RbMBSTChannelConfigEntry entry : auChannelTable.getEntries()) {
                if (!adminStatusEnabled.equals(entry.getRbMBSTChannelAdminStatus())) continue;
                for (RbOduConfigEntry e : oduTable.getEntries()) {
                    if (!e.getRbOduConfigId().equals(entry.getRbMBSTChannelAssociatedOduId())) continue;
                    oduEntry = e;
                    continue block3;
                }
            }
            RbMBSTFrequencyBandsEntry rbMBSTFrequencyBandsEntry = this.frequencyBandEntry = oduEntry != null && oduEntry.getRbOduConfigFrequencyBand() != null ? (RbMBSTFrequencyBandsEntry)bandsTable.findEntry(oduEntry.getRbOduConfigFrequencyBand().toString()) : null;
            if (this.frequencyBandEntry != null) {
                RbMBSTFrequencyBandsEntry freqBandEntry = (RbMBSTFrequencyBandsEntry)this.frequencyBandEntry;
                this.startFreqLimit = freqBandEntry.getRbMBSTFrequencyBandStartFrequency();
                this.stopFreqLimit = freqBandEntry.getRbMBSTFrequencyBandStopFrequency();
                for (RbMBSTFrequencyBandsEntry entry : bandsTable.getEntries()) {
                    if (!entry.getRbMBSTFrequencyBandGroupId().equals(freqBandEntry.getRbMBSTFrequencyBandGroupId())) continue;
                    if (entry.getRbMBSTFrequencyBandStartFrequency() < this.startFreqLimit) {
                        this.startFreqLimit = entry.getRbMBSTFrequencyBandStartFrequency();
                    }
                    if (entry.getRbMBSTFrequencyBandStopFrequency() <= this.stopFreqLimit) continue;
                    this.stopFreqLimit = entry.getRbMBSTFrequencyBandStopFrequency();
                }
            }
        }
    }

    public boolean forceRefresh() {
        return true;
    }

    public String getHelpTopic() {
        if (VersionFactory.getInstance().createVersion(((RbSU)this.ctx.getEquipment()).getManagerBS().getRunningSoftwareVersion()).isOlderThan((Version)new DefaultVersion("4.0"))) {
            return "ngnms.rb.help.su_air_interface";
        }
        return "ngnms.rb.help.su_tdd_air_interface";
    }

    private boolean checkMask(String mask) {
        String[] splittedValues = mask.split("\\.");
        if (splittedValues.length != 6) {
            return false;
        }
        for (String value : splittedValues) {
            try {
                int castValue = Integer.parseInt(value);
                if (castValue <= 255 && castValue >= 0) continue;
                return false;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        return true;
    }
}

