/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.mediation.FileTransferEvent;
import com.bwanms.mediation.FileTransferRequest;
import com.bwanms.mediation.FileTransferService;
import com.bwanms.mediation.MediationServiceRegistry;
import com.bwanms.mediation.TftpFileTransferRequest;
import com.bwanms.mediation.TftpFileTransferService;
import com.bwanms.mediation.filetransfer.SynchronousFileTransfer;
import com.bwanms.rb.gui.configuration.RbLicenseUploadPanel;
import com.bwanms.rb.mo.RbLicenseLogEntry;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.services.UnifiedMORequest;
import com.bwanms.util.MacAddress;
import com.bwanms.util.MessageBox;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.ComponentUI;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbLicenseUploadConfigForm
extends ManagedObjectsConfigForm<RbLicenseUploadPanel> {
    private static final Logger logger = Logger.getLogger(RbLicenseUploadConfigForm.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbLicenseUploadConfigForm.class);
    private Calendar operationTime;

    public String getHelpTopic() {
        return "ngnms.rb.help.bs_license_upload";
    }

    protected List<UnifiedMORequest> getManagedObjectRequests() {
        return new ArrayList<UnifiedMORequest>();
    }

    protected RbLicenseUploadPanel initUIComponent() {
        return new RbLicenseUploadPanel(this);
    }

    public boolean canApply() {
        return false;
    }

    private boolean uploadFile(String ipAddress, File selFile) {
        boolean ret = true;
        logger.info((Object)("[" + ipAddress + "] starting upload of license file"));
        TftpFileTransferService tftpService = MediationServiceRegistry.getTftpFileTransferService();
        SynchronousFileTransfer sft = new SynchronousFileTransfer((FileTransferService)tftpService, "topic/TftpMediationTopic");
        this.setOperationTime(Calendar.getInstance());
        String fileName = this.getOperationTime().getTimeInMillis() + ".txt";
        TftpFileTransferRequest req = new TftpFileTransferRequest(ipAddress, null, fileName, 0, null);
        req.setFileData(this.getData(((RbLicenseUploadPanel)this.getUI()).getSelFile()));
        FileTransferEvent res = sft.executeTransfer((FileTransferRequest)req, 600000L);
        if (res == null || res.getEventType() == 2) {
            String msgError = i18n.translateString("TransferError");
            logger.error((Object)msgError);
            ret = false;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getData(File file) {
        byte[] ret = new byte[(int)file.length()];
        if (!file.exists()) {
            logger.error((Object)"Local license file doesn't exists");
            return null;
        }
        if (!file.isFile()) {
            logger.error((Object)"Local license file must be a file");
            return null;
        }
        if (!file.canRead()) {
            logger.error((Object)"Local license file can't be read");
            return null;
        }
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            fis = new FileInputStream(file);
            bis = new BufferedInputStream(fis);
            bis.read(ret);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
        return ret;
    }

    void uploadPerformed() {
        RbLicenseUploadPanel panel;
        RbBaseStationEquipment equipment = (RbBaseStationEquipment)this.getContext().getEquipment();
        String macAddress = MacAddress.fromOctetString((String)equipment.getMngmntIfMAC()).toDashedString();
        if (!this.isValidFile(macAddress, (panel = (RbLicenseUploadPanel)this.getUI()).getSelFile())) {
            MessageBox.Error.quickShow((Component)panel, i18n.translateString("NoSuitableLicenseFile"));
            return;
        }
        if (!this.uploadFile(equipment.getIPAddress(), panel.getSelFile())) {
            MessageBox.Error.quickShow((Component)panel, i18n.translateString("TransferError"));
            return;
        }
        this.logMessage(panel, panel.getSelFile().getName());
    }

    private void logMessage(RbLicenseUploadPanel panel, String longFileName) {
        try {
            String fileOnDevice = this.getOperationTime().getTimeInMillis() + ".txt";
            Long status = this.getLicenseLogStatus(fileOnDevice);
            if (status == null) {
                MessageBox.Error.quickShow((Component)panel, i18n.translateString("NoLicenseLogEntryFound"));
                return;
            }
            RbLicenseLogLoadStatus loadStatus = RbLicenseLogLoadStatus.getRbLicenseLoadStatus(status.intValue());
            boolean isError = true;
            switch (loadStatus) {
                case LoadSucceeded: {
                    isError = false;
                    break;
                }
            }
            if (isError) {
                String loadStatusStr = i18n.translateString("ErrorMessageFromDevice") + ":\n" + loadStatus.toString();
                MessageBox.Error.quickShow((Component)panel, loadStatusStr);
            } else {
                MessageBox.Info.quickShow((Component)panel, i18n.translateString("UploadWithSuccess"));
                panel.getTxtFile().setText("");
            }
        }
        catch (ServiceException ex) {
            MessageBox.Error.quickShow((Component)panel, i18n.translateString("GettingUpdateLogFromDeviceFailed"));
        }
    }

    private Long getLicenseLogStatus(String fileName) throws ServiceException {
        Long status = null;
        List entries = ServiceRegistry.getConfigurationService().retrieveData(this.ctx.getEquipment().getId(), "BS", RbLicenseLogEntry.class, "*");
        for (RbLicenseLogEntry entry : entries) {
            if (!fileName.equals(entry.getRbLicenseLogFileName())) continue;
            status = entry.getRbLicenseLogLoadStatus();
            break;
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isValidFile(String macAddress, File selFile) {
        boolean ret = false;
        FileReader fr = null;
        BufferedReader br = null;
        char[] data = new char[(int)selFile.length() / 2];
        try {
            fr = new FileReader(selFile);
            br = new BufferedReader(fr);
            br.read(data);
            String copyValueOf = String.copyValueOf(data);
            if (copyValueOf.toUpperCase().indexOf(macAddress.toUpperCase()) != -1) {
                ret = true;
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return ret;
    }

    void selectFile() {
        RbLicenseUploadPanel panel = (RbLicenseUploadPanel)this.getUI();
        File initialFolder = this.getInitialFolder(false);
        File selectedFile = this.createFileChooser(initialFolder);
        if (selectedFile == null) {
            panel.getBtnUpload().setEnabled(false);
            return;
        }
        panel.getTxtFile().setText(selectedFile.getAbsolutePath());
        panel.setSelFile(selectedFile);
        panel.getBtnUpload().setEnabled(true);
    }

    private File getInitialFolder(boolean initialFolder) {
        if (RbLicenseUploadPanel.getDefaultFolder() == null || !RbLicenseUploadPanel.getDefaultFolder().exists()) {
            String userHome = System.getProperty("user.home");
            String fileSeparator = System.getProperty("file.separator");
            StringBuilder fileName = new StringBuilder();
            if (fileSeparator.equals("\\")) {
                fileName.append(userHome.replaceAll("\\\\", "\\\\\\\\"));
            } else {
                fileName.append(userHome);
            }
            if (!initialFolder) {
                return new File(fileName.toString());
            }
            if (fileSeparator.equals("\\")) {
                fileName.append("\\\\");
            } else {
                fileName.append(fileSeparator);
            }
            String equipName = this.getContext().getEquipment().getName();
            fileName.append(equipName).append(".lic");
            return new File(fileName.toString());
        }
        return RbLicenseUploadPanel.getDefaultFolder();
    }

    private File createFileChooser(File initialFolder) {
        JFileChooser fileChooser = new JFileChooser(){

            public void approveSelection() {
                if (this.getSelectedFile().exists()) {
                    super.approveSelection();
                }
            }

            protected void setUI(ComponentUI newUI) {
                UIManager.put("FileChooser.readOnly", true);
                super.setUI(newUI);
            }
        };
        fileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith(".txt");
            }

            public String getDescription() {
                return "License files (.txt)";
            }
        });
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setDialogType(0);
        fileChooser.setFileHidingEnabled(true);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setCurrentDirectory(initialFolder);
        fileChooser.setDialogTitle(i18n.translateString("Choose"));
        fileChooser.setApproveButtonText(i18n.translateString("Choose"));
        fileChooser.setApproveButtonToolTipText(i18n.translateString("ChooseTheSelectedLicenseFile"));
        fileChooser.setApproveButtonMnemonic('H');
        int res = fileChooser.showOpenDialog(this.getUI());
        if (res == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            RbLicenseUploadPanel.setDefaultFolder(selectedFile.getParentFile());
            return selectedFile;
        }
        return null;
    }

    protected void fillUI(List<Object> managedObjects) {
        ((RbLicenseUploadPanel)this.getUI()).getTxtFile().setText("");
        if (((RbLicenseUploadPanel)this.getUI()).getTxtFile().getText() == null || ((RbLicenseUploadPanel)this.getUI()).getTxtFile().getText().equals("")) {
            ((RbLicenseUploadPanel)this.getUI()).getBtnUpload().setEnabled(false);
        }
    }

    public Calendar getOperationTime() {
        return this.operationTime;
    }

    public void setOperationTime(Calendar operationTime) {
        this.operationTime = operationTime;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RbLicenseLogLoadStatus {
        LoadSucceeded(0){

            protected String getInternationalizedString() {
                return i18n.translateString("loadSucceeded");
            }
        }
        ,
        BadLicenseFile(1){

            protected String getInternationalizedString() {
                return i18n.translateString("badLicenseFile");
            }
        }
        ,
        SignatureNotRecognize(2){

            protected String getInternationalizedString() {
                return i18n.translateString("signatureNotRecognize");
            }
        }
        ,
        SignatureDoNotMatch(3){

            protected String getInternationalizedString() {
                return i18n.translateString("signatureDoNotMatch");
            }
        }
        ,
        LoadToWrongMBST(4){

            protected String getInternationalizedString() {
                return i18n.translateString("loadToWrongMBST");
            }
        }
        ,
        IllegalLicenseCountOrValue(5){

            protected String getInternationalizedString() {
                return i18n.translateString("illegalLicenseCountOrValue");
            }
        }
        ,
        IllegalLicenseBW(6){

            protected String getInternationalizedString() {
                return i18n.translateString("illegalLicenseBW");
            }
        }
        ,
        NoLegalLine(7){

            protected String getInternationalizedString() {
                return i18n.translateString("noLegalLine");
            }
        }
        ,
        TooManyLicensesUploaded(8){

            protected String getInternationalizedString() {
                return i18n.translateString("tooManyLicensesUploaded");
            }
        }
        ,
        FileAlreadyExists(9){

            protected String getInternationalizedString() {
                return i18n.translateString("fileAlreadyExists");
            }
        }
        ,
        NumberOfLicensesNotPermitted(10){

            protected String getInternationalizedString() {
                return i18n.translateString("numberOfLicensesNotPermitted");
            }
        };

        protected static Internationalizer i18n;
        private int status;

        private RbLicenseLogLoadStatus(int ordinal) {
            this.status = ordinal;
        }

        public int getStatus() {
            return this.status;
        }

        protected abstract String getInternationalizedString();

        public String toString() {
            return this.getInternationalizedString();
        }

        public static RbLicenseLogLoadStatus getRbLicenseLoadStatus(int status) {
            if (status == 0) {
                return LoadSucceeded;
            }
            if (status == 1) {
                return BadLicenseFile;
            }
            if (status == 2) {
                return SignatureNotRecognize;
            }
            if (status == 3) {
                return SignatureDoNotMatch;
            }
            if (status == 4) {
                return LoadToWrongMBST;
            }
            if (status == 5) {
                return IllegalLicenseCountOrValue;
            }
            if (status == 6) {
                return IllegalLicenseBW;
            }
            if (status == 7) {
                return NoLegalLine;
            }
            if (status == 8) {
                return TooManyLicensesUploaded;
            }
            if (status == 9) {
                return FileAlreadyExists;
            }
            if (status == 10) {
                return NumberOfLicensesNotPermitted;
            }
            throw new IllegalArgumentException("Update log staus is out of the range");
        }

        static {
            i18n = Internationalizer.getInternationalizer(RbLicenseUploadConfigForm.class);
        }
    }
}

