/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.mediation.FileTransferEvent;
import com.bwanms.mediation.FileTransferRequest;
import com.bwanms.mediation.FileTransferService;
import com.bwanms.mediation.MediationServiceRegistry;
import com.bwanms.mediation.TftpFileTransferRequest;
import com.bwanms.mediation.TftpFileTransferService;
import com.bwanms.mediation.filetransfer.SynchronousFileTransfer;
import com.bwanms.rb.gui.configuration.RbFrequencyBandsUploadPanel;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.services.UnifiedMORequest;
import com.bwanms.util.MacAddress;
import com.bwanms.util.MessageBox;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.ComponentUI;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbFrequencyBandsUploadConfigForm
extends ManagedObjectsConfigForm<RbFrequencyBandsUploadPanel> {
    private static final Logger logger = Logger.getLogger(RbFrequencyBandsUploadConfigForm.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbFrequencyBandsUploadConfigForm.class);

    public String getHelpTopic() {
        return "ngnms.rb.help.bs_freq_bands_upload";
    }

    protected List<UnifiedMORequest> getManagedObjectRequests() {
        return new ArrayList<UnifiedMORequest>();
    }

    protected RbFrequencyBandsUploadPanel initUIComponent() {
        return new RbFrequencyBandsUploadPanel(this);
    }

    public boolean canApply() {
        return false;
    }

    private boolean uploadFile(String ipAddress, File selFile) {
        boolean ret = true;
        logger.info((Object)("[" + ipAddress + "] starting upload of the frequency bands file"));
        TftpFileTransferService tftpService = MediationServiceRegistry.getTftpFileTransferService();
        SynchronousFileTransfer sft = new SynchronousFileTransfer((FileTransferService)tftpService, "topic/TftpMediationTopic");
        TftpFileTransferRequest req = new TftpFileTransferRequest(ipAddress, this.getData(((RbFrequencyBandsUploadPanel)this.getUI()).getSelFile()), selFile.getName());
        FileTransferEvent res = sft.executeTransfer((FileTransferRequest)req, 600000L);
        if (res == null || res.getEventType() == 2) {
            String msgError = i18n.translateString("TransferError");
            logger.error((Object)msgError);
            ret = false;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getData(File file) {
        byte[] ret = new byte[(int)file.length()];
        if (file == null) {
            logger.error((Object)"Local frequency bands file is null");
            return null;
        }
        if (!file.exists()) {
            logger.error((Object)"Local frequency bands file doesn't exists");
            return null;
        }
        if (!file.isFile()) {
            logger.error((Object)"Local frequency bands file must be a file");
            return null;
        }
        if (!file.canRead()) {
            logger.error((Object)"Local frequency bands file can't be read");
            return null;
        }
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            fis = new FileInputStream(file);
            bis = new BufferedInputStream(fis);
            bis.read(ret);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
        return ret;
    }

    void uploadPerformed() {
        RbFrequencyBandsUploadPanel panel;
        RbBaseStationEquipment equipment = (RbBaseStationEquipment)this.getContext().getEquipment();
        String macAddress = MacAddress.fromOctetString((String)equipment.getMngmntIfMAC()).toDashedString();
        if (!this.isValidFile(macAddress, (panel = (RbFrequencyBandsUploadPanel)this.getUI()).getSelFile())) {
            MessageBox.Error.quickShow((Component)panel, i18n.translateString("NoSuitableFrequencyBandsFile"));
            return;
        }
        if (!this.uploadFile(equipment.getIPAddress(), panel.getSelFile())) {
            MessageBox.Error.quickShow((Component)panel, i18n.translateString("TransferError"));
            return;
        }
        MessageBox.Info.quickShow((Component)panel, i18n.translateString("FrequencyBandsFileUploadWithSuccess"));
        panel.getTxtFile().setText("");
    }

    boolean isValidFile(String macAddress, File selFile) {
        return true;
    }

    void selectFile() {
        RbFrequencyBandsUploadPanel panel = (RbFrequencyBandsUploadPanel)this.getUI();
        File initialFolder = this.getInitialFolder(false);
        File selectedFile = this.createFileChooser(initialFolder);
        if (selectedFile == null) {
            panel.getBtnUpload().setEnabled(false);
            return;
        }
        panel.getTxtFile().setText(selectedFile.getAbsolutePath());
        panel.setSelFile(selectedFile);
        panel.getBtnUpload().setEnabled(true);
    }

    private File getInitialFolder(boolean initialFolder) {
        if (RbFrequencyBandsUploadPanel.getDefaultFolder() == null || !RbFrequencyBandsUploadPanel.getDefaultFolder().exists()) {
            String userHome = System.getProperty("user.home");
            String fileSeparator = System.getProperty("file.separator");
            StringBuilder fileName = new StringBuilder();
            if (fileSeparator.equals("\\")) {
                fileName.append(userHome.replaceAll("\\\\", "\\\\\\\\"));
            } else {
                fileName.append(userHome);
            }
            if (!initialFolder) {
                return new File(fileName.toString());
            }
            if (fileSeparator.equals("\\")) {
                fileName.append("\\\\");
            } else {
                fileName.append(fileSeparator);
            }
            String equipName = this.getContext().getEquipment().getName();
            fileName.append(equipName).append(".txt");
            return new File(fileName.toString());
        }
        return RbFrequencyBandsUploadPanel.getDefaultFolder();
    }

    private File createFileChooser(File initialFolder) {
        JFileChooser fileChooser = new JFileChooser(){

            public void approveSelection() {
                if (this.getSelectedFile().exists()) {
                    super.approveSelection();
                }
            }

            protected void setUI(ComponentUI newUI) {
                UIManager.put("FileChooser.readOnly", true);
                super.setUI(newUI);
            }
        };
        fileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                if (f.getName().endsWith(".txt")) {
                    return true;
                }
                return f.getName().endsWith(".sig");
            }

            public String getDescription() {
                return "Frequency bands files (.txt | .sig)";
            }
        });
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setDialogType(0);
        fileChooser.setFileHidingEnabled(true);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setCurrentDirectory(initialFolder);
        fileChooser.setDialogTitle(i18n.translateString("Choose"));
        fileChooser.setApproveButtonText(i18n.translateString("Choose"));
        fileChooser.setApproveButtonToolTipText(i18n.translateString("ChooseTheSelectedFrequencyBandsFile"));
        fileChooser.setApproveButtonMnemonic('H');
        int res = fileChooser.showOpenDialog(this.getUI());
        if (res == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            RbFrequencyBandsUploadPanel.setDefaultFolder(selectedFile.getParentFile());
            return selectedFile;
        }
        return null;
    }

    protected void fillUI(List<Object> managedObjects) {
        ((RbFrequencyBandsUploadPanel)this.getUI()).getTxtFile().setText("");
    }
}

