/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.mediation.MediationServiceRegistry;
import com.bwanms.model.SNMPManagementInterface;
import com.bwanms.rb.ddi.RbBSCreateBackupFileCommand;
import com.bwanms.rb.gui.configuration.RbConfigBackupConfigForm;
import com.bwanms.rb.model.RbBackupConfigFile;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.impl.DefaultVersion;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class RbConfigBackupPanel
extends JPanel {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbConfigBackupPanel.class);
    private static final Logger log = Logger.getLogger(RbConfigBackupPanel.class);
    private RbConfigBackupConfigForm form;
    private File selFile;
    private JLabel lblOperation;
    private JComboBox cmbOperation;
    private JButton btnRun;
    private JLabel lblType;
    private JComboBox cmbType;
    private JLabel lblFile;
    private JTextField txtFile;
    private JButton btnFile;
    private JCheckBox cbRestart;

    public RbConfigBackupPanel(RbConfigBackupConfigForm form) {
        this.form = form;
        this.preInitComponents();
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.cmbType.addItem(new ComboItem((Object)RbBackupConfigFile.FileType.RbFullConfig, i18n.translateString(RbBSCreateBackupFileCommand.toStringRbNpuCreateBackupConfigFile(1))));
        RbBaseStationEquipment bsEq = (RbBaseStationEquipment)this.form.getContext().getEquipment();
        if (!bsEq.isIPCSSwitchingMode()) {
            this.cmbType.addItem(new ComboItem((Object)RbBackupConfigFile.FileType.RbServices, i18n.translateString(RbBSCreateBackupFileCommand.toStringRbNpuCreateBackupConfigFile(3))));
            this.cmbType.addItem(new ComboItem((Object)RbBackupConfigFile.FileType.RbFilters, i18n.translateString(RbBSCreateBackupFileCommand.toStringRbNpuCreateBackupConfigFile(4))));
        }
        this.cmbType.addItem(new ComboItem((Object)RbBackupConfigFile.FileType.RbServiceProfiles, i18n.translateString(RbBSCreateBackupFileCommand.toStringRbNpuCreateBackupConfigFile(2))));
        this.cmbType.addItem(new ComboItem((Object)RbBackupConfigFile.FileType.RbTraps, i18n.translateString(RbBSCreateBackupFileCommand.toStringRbNpuCreateBackupConfigFile(5))));
        if (bsEq.getSoftwareVersion().isNewerOrEqualWith((Version)new DefaultVersion("4.1.1"))) {
            this.cmbType.addItem(new ComboItem((Object)RbBackupConfigFile.FileType.RbLicensing, i18n.translateString(RbBSCreateBackupFileCommand.toStringRbNpuCreateBackupConfigFile(8))));
        }
        this.cmbOperation.addItem(new ComboItem((Object)"backup", i18n.translateString("backup")));
        this.cmbOperation.addItem(new ComboItem((Object)"restore", i18n.translateString("restore")));
    }

    private void preInitComponents() {
    }

    private void initComponents() {
        this.lblOperation = new JLabel();
        this.cmbOperation = new JComboBox();
        this.btnRun = new JButton();
        this.lblType = new JLabel();
        this.cmbType = new JComboBox();
        this.lblFile = new JLabel();
        this.txtFile = new JTextField();
        this.btnFile = new JButton();
        this.cbRestart = new JCheckBox();
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec((Size)Sizes.dluX((int)10)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.PREFERRED, 0.15), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.PREFERRED, 0.85), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.PREF_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.dluX((int)15)), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.dluX((int)15), 0.0), new ColumnSpec((Size)Sizes.DLUX3)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.lblOperation.setText("Operation");
        this.lblOperation.setDisplayedMnemonic('O');
        this.lblOperation.setLabelFor(this.cmbOperation);
        this.add((Component)this.lblOperation, cc.xy(3, 3));
        this.cmbOperation.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                RbConfigBackupPanel.this.cmbOperationItemStateChanged(e);
            }
        });
        this.add((Component)this.cmbOperation, cc.xywh(5, 3, 5, 1));
        this.btnRun.setText("Run");
        this.btnRun.setMnemonic('R');
        this.btnRun.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RbConfigBackupPanel.this.btnRunActionPerformed(e);
            }
        });
        this.add((Component)this.btnRun, cc.xywh(11, 3, 4, 1));
        this.lblType.setText("Type");
        this.lblType.setLabelFor(this.cmbType);
        this.lblType.setDisplayedMnemonic('T');
        this.add((Component)this.lblType, cc.xy(3, 5));
        this.add((Component)this.cmbType, cc.xywh(5, 5, 5, 1));
        this.lblFile.setText("File");
        this.lblFile.setLabelFor(this.txtFile);
        this.lblFile.setDisplayedMnemonic('F');
        this.add((Component)this.lblFile, cc.xy(3, 7));
        this.txtFile.setEditable(false);
        this.add((Component)this.txtFile, cc.xywh(5, 7, 5, 1));
        this.btnFile.setText("...");
        this.btnFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RbConfigBackupPanel.this.btnFileActionPerformed(e);
            }
        });
        this.add((Component)this.btnFile, cc.xywh(11, 7, 1, 1, CellConstraints.LEFT, CellConstraints.DEFAULT));
        this.cbRestart.setText("Restart");
        this.cbRestart.setSelected(true);
        this.add((Component)this.cbRestart, cc.xy(5, 9));
    }

    private void cmbOperationItemStateChanged(ItemEvent e) {
        this.form.operationChange(e, this);
    }

    private void btnRunActionPerformed(ActionEvent e) {
        this.form.run();
    }

    protected MOAccessSession createMOAccessSession(RbBaseStationEquipment equipment) throws MediationException {
        return MediationServiceRegistry.getMOSession((SNMPManagementInterface)equipment.getManagementInterface(), null);
    }

    protected void closeMOAccessSession(MOAccessSession access) {
        if (access != null) {
            try {
                access.close();
            }
            catch (Exception e) {
                log.debug((Object)"", (Throwable)e);
            }
        }
    }

    private void btnFileActionPerformed(ActionEvent e) {
        this.form.chooseFile(this);
    }

    public JLabel getLblType() {
        return this.lblType;
    }

    public JComboBox getCmbType() {
        return this.cmbType;
    }

    public JButton getBtnFile() {
        return this.btnFile;
    }

    public JButton getBtnRun() {
        return this.btnRun;
    }

    public JCheckBox getCbRestart() {
        return this.cbRestart;
    }

    public File getSelFile() {
        return this.selFile;
    }

    public void setSelFile(File selFile) {
        this.selFile = selFile;
    }

    public JTextField getTxtFile() {
        return this.txtFile;
    }

    public JComboBox getCmbOperation() {
        return this.cmbOperation;
    }

    public JLabel getLblFile() {
        return this.lblFile;
    }
}

