/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.mediation.FileTransferEvent;
import com.bwanms.mediation.FileTransferRequest;
import com.bwanms.mediation.FileTransferService;
import com.bwanms.mediation.MediationException;
import com.bwanms.mediation.MediationServiceRegistry;
import com.bwanms.mediation.TftpFileTransferRequest;
import com.bwanms.mediation.TftpFileTransferService;
import com.bwanms.mediation.filetransfer.SynchronousFileTransfer;
import com.bwanms.rb.gui.configuration.RbConfigBackupPanel;
import com.bwanms.rb.gui.configuration.SoftwareUpgradePanelLog;
import com.bwanms.rb.mo.RbNpuConfigEntry;
import com.bwanms.rb.mo.RbNpuConfigTable;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.model.RbBackupConfigFile;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbMBS;
import com.bwanms.rb.tasks.configbackup.RbConfigBackupUtil;
import com.bwanms.services.UnifiedMORequest;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.MacAddress;
import com.bwanms.util.MessageBox;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.ComponentUI;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbConfigBackupConfigForm
extends ManagedObjectsConfigForm<RbConfigBackupPanel> {
    private static final Logger log = Logger.getLogger(RbConfigBackupConfigForm.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbConfigBackupConfigForm.class);
    private SoftwareUpgradePanelLog panelLog;
    private static String LINE_SEPARATOR;
    protected static final String BACKUP = "backup";
    protected static final String RESTORE = "restore";

    public String getHelpTopic() {
        return "ngnms.rb.help.bs_backup_configuration";
    }

    protected List<UnifiedMORequest> getManagedObjectRequests() {
        ArrayList<UnifiedMORequest> requests = new ArrayList<UnifiedMORequest>();
        if (this.ctx.getEquipment() instanceof RbBS) {
            requests.add((UnifiedMORequest)this.ctx.createRequest("BS", RbNpuConfigTable.class));
        }
        return requests;
    }

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        super.createBinders(binders, managedObjects);
    }

    protected RbConfigBackupPanel initUIComponent() {
        return new RbConfigBackupPanel(this);
    }

    public String getTitle() {
        return i18n.translateString("ConfigurationBackup");
    }

    protected void fillUI(List<Object> managedObjects) {
        super.fillUI(managedObjects);
    }

    public boolean canApply() {
        return false;
    }

    private void doRestore() {
        final RbBaseStationEquipment equipment = (RbBaseStationEquipment)this.getContext().getEquipment();
        final RbConfigBackupPanel panel = (RbConfigBackupPanel)this.getUI();
        final RbBackupConfigFile.FileType fileType = (RbBackupConfigFile.FileType)((Object)((ComboItem)panel.getCmbType().getSelectedItem()).getValue());
        panel.getBtnRun().setEnabled(false);
        final JFrame mf = this.initializePanelLogFrame(RESTORE);
        final SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        new Thread(new Runnable(){

            public void run() {
                RbConfigBackupConfigForm.this.panelLog.getTxtAreaLog().append(LINE_SEPARATOR + sdf.format(new Date()) + " --- " + i18n.translateString("ConfigurationRestoreStarted") + LINE_SEPARATOR);
                RbConfigBackupConfigForm.this.panelLog.getBtnLogClose().setEnabled(false);
                log.info((Object)("[" + equipment.getIPAddress() + "] starting upload of backup file"));
                TftpFileTransferService tftpService = MediationServiceRegistry.getTftpFileTransferService();
                SynchronousFileTransfer sft = new SynchronousFileTransfer((FileTransferService)tftpService, "topic/TftpMediationTopic");
                String backupFileName = "backup.res";
                if (fileType == RbBackupConfigFile.FileType.RbLicensing) {
                    String macAddr = MacAddress.fromOctetString((String)equipment.getMngmntIfMAC()).toDashedString().toLowerCase();
                    backupFileName = backupFileName + macAddr + ".res";
                }
                TftpFileTransferRequest req = new TftpFileTransferRequest(equipment.getIPAddress(), null, backupFileName, 0, null);
                req.setFileData(RbConfigBackupConfigForm.this.getData(panel.getSelFile()));
                FileTransferEvent res = sft.executeTransfer((FileTransferRequest)req, 600000L);
                if (res == null || res.getEventType() == 2) {
                    String msgError = i18n.translateString("TransferError");
                    log.error((Object)msgError);
                    RbConfigBackupConfigForm.this.panelLog.getTxtAreaLog().append(LINE_SEPARATOR + sdf.format(new Date()) + " --- " + i18n.translateString(RbConfigBackupConfigForm.RESTORE) + ": " + msgError + "." + LINE_SEPARATOR);
                    RbConfigBackupConfigForm.this.panelLog.getBtnLogClose().setEnabled(true);
                    mf.setDefaultCloseOperation(2);
                    panel.getBtnRun().setEnabled(true);
                    return;
                }
                try {
                    if (panel.getCbRestart().isSelected()) {
                        RbNpuConfigEntry activeNpu = null;
                        if (equipment instanceof RbBS) {
                            RbNpuConfigTable rbNpuConfigTable = (RbNpuConfigTable)((Object)RbConfigBackupConfigForm.this.managedObjects.get(0));
                            List entries = rbNpuConfigTable.getEntries();
                            for (RbNpuConfigEntry entry : entries) {
                                if (!entry.isActive()) continue;
                                activeNpu = entry;
                            }
                            if (activeNpu == null) {
                                throw new MediationException(i18n.translateString("EquipmentRestartError"));
                            }
                        }
                        RbConfigBackupUtil.resetEquipment(true, equipment, activeNpu);
                        log.info((Object)("[" + equipment.getIPAddress() + "] performed RESET"));
                    }
                }
                catch (MediationException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    RbConfigBackupConfigForm.this.panelLog.getTxtAreaLog().append(LINE_SEPARATOR + sdf.format(new Date()) + " --- " + i18n.translateString(RbConfigBackupConfigForm.RESTORE) + ": " + i18n.translateString("EquipmentRestartError") + LINE_SEPARATOR);
                    RbConfigBackupConfigForm.this.panelLog.getBtnLogClose().setEnabled(true);
                    mf.setDefaultCloseOperation(2);
                    panel.getBtnRun().setEnabled(true);
                    return;
                }
                RbConfigBackupConfigForm.this.panelLog.getTxtAreaLog().append(LINE_SEPARATOR + sdf.format(new Date()) + " --- " + i18n.translateString("ConfigurationRestoreFinished") + " " + LINE_SEPARATOR);
                RbConfigBackupConfigForm.this.panelLog.getBtnLogClose().setEnabled(true);
                mf.setDefaultCloseOperation(2);
                panel.getBtnRun().setEnabled(true);
            }
        }).start();
        mf.setVisible(true);
    }

    private void doBackUp() {
        final RbConfigBackupPanel panel = (RbConfigBackupPanel)this.getUI();
        final RbBaseStationEquipment rbBSEquipment = (RbBaseStationEquipment)this.getContext().getEquipment();
        final RbBackupConfigFile.FileType fileType = (RbBackupConfigFile.FileType)((Object)((ComboItem)panel.getCmbType().getSelectedItem()).getValue());
        if (rbBSEquipment.getSwitchingMode() == RbBaseStationEquipment.SWITCHING_MODE_IP_CS && fileType == RbBackupConfigFile.FileType.RbFilters) {
            MessageBox.WarnConfirm.quickShow((Component)panel, i18n.translateString("FiltersBackupNotAvalaibleForIp_CsMode"));
            return;
        }
        File initialFile = this.getInitialFile(panel, true);
        final File selectedFile = this.createFileChooser(initialFile, 1, panel);
        if (selectedFile == null) {
            return;
        }
        final JFrame mf = this.initializePanelLogFrame(BACKUP);
        final SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        panel.getBtnRun().setEnabled(false);
        new Thread(new Runnable(){

            public void run() {
                TftpFileTransferRequest req;
                FileTransferEvent res;
                RbConfigBackupConfigForm.this.panelLog.getTxtAreaLog().append(LINE_SEPARATOR + sdf.format(new Date()) + " --- " + i18n.translateString("ConfigurationBackupStarted") + LINE_SEPARATOR);
                RbConfigBackupConfigForm.this.panelLog.getBtnLogClose().setEnabled(false);
                try {
                    RbConfigBackupUtil.createBackupFile(rbBSEquipment, fileType.mibValue());
                }
                catch (MediationException ex) {
                    ex.printStackTrace();
                    String msgError = i18n.translateString("MediationError");
                    log.error((Object)msgError, (Throwable)ex);
                    RbConfigBackupConfigForm.this.panelLog.getTxtAreaLog().append(LINE_SEPARATOR + sdf.format(new Date()) + " --- " + i18n.translateString(RbConfigBackupConfigForm.BACKUP) + ": " + msgError + "." + LINE_SEPARATOR);
                    RbConfigBackupConfigForm.this.panelLog.getBtnLogClose().setEnabled(true);
                    mf.setDefaultCloseOperation(2);
                    panel.getBtnRun().setEnabled(true);
                    return;
                }
                TftpFileTransferService tftpService = MediationServiceRegistry.getTftpFileTransferService();
                SynchronousFileTransfer sft = new SynchronousFileTransfer((FileTransferService)tftpService, "topic/TftpMediationTopic");
                String backupFileName = RbBackupConfigFile.getBackupFileName(fileType);
                if (fileType == RbBackupConfigFile.FileType.RbLicensing) {
                    String macAddr = MacAddress.fromOctetString((String)rbBSEquipment.getMngmntIfMAC()).toDashedString().toLowerCase();
                    backupFileName = backupFileName + macAddr + ".res";
                }
                if ((res = sft.executeTransfer((FileTransferRequest)(req = new TftpFileTransferRequest(rbBSEquipment.getIPAddress(), null, backupFileName, 1, (Serializable)((Object)"me"))), 600000L)) == null || res.getEventType() == 2) {
                    String msgError = i18n.translateString("TransferError");
                    log.error((Object)msgError);
                    RbConfigBackupConfigForm.this.panelLog.getTxtAreaLog().append(LINE_SEPARATOR + sdf.format(new Date()) + " --- " + i18n.translateString(RbConfigBackupConfigForm.BACKUP) + ": " + msgError + "." + LINE_SEPARATOR);
                    RbConfigBackupConfigForm.this.panelLog.getBtnLogClose().setEnabled(true);
                    mf.setDefaultCloseOperation(2);
                    panel.getBtnRun().setEnabled(true);
                    return;
                }
                byte[] data = res.getFileData();
                if (!RbConfigBackupConfigForm.this.persist(selectedFile, data)) {
                    String msgError = i18n.translateString("LocalFilePersistError");
                    log.error((Object)msgError);
                    RbConfigBackupConfigForm.this.panelLog.getTxtAreaLog().append(LINE_SEPARATOR + sdf.format(new Date()) + " --- " + i18n.translateString(RbConfigBackupConfigForm.BACKUP) + ": " + msgError + "." + LINE_SEPARATOR);
                    RbConfigBackupConfigForm.this.panelLog.getBtnLogClose().setEnabled(true);
                    mf.setDefaultCloseOperation(2);
                    panel.getBtnRun().setEnabled(true);
                    return;
                }
                RbConfigBackupConfigForm.this.panelLog.getTxtAreaLog().append(LINE_SEPARATOR + sdf.format(new Date()) + " --- " + i18n.translateString("ConfigurationBackupFinished") + " " + LINE_SEPARATOR);
                RbConfigBackupConfigForm.this.panelLog.getBtnLogClose().setEnabled(true);
                mf.setDefaultCloseOperation(2);
                panel.getBtnRun().setEnabled(true);
            }
        }).start();
        mf.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getData(File file) {
        byte[] ret = new byte[(int)file.length()];
        if (file == null) {
            log.error((Object)"Local backup file is null");
            return null;
        }
        if (!file.exists()) {
            log.error((Object)"Local backup file doesn't exists");
            return null;
        }
        if (!file.isFile()) {
            log.error((Object)"Local backup file must be a file");
            return null;
        }
        if (!file.canRead()) {
            log.error((Object)"Local backup file can't be read");
            return null;
        }
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            fis = new FileInputStream(file);
            bis = new BufferedInputStream(fis);
            bis.read(ret);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
        return ret;
    }

    private File getInitialFile(RbConfigBackupPanel panel, boolean initialFile) {
        String userHome = System.getProperty("user.home");
        String fileSeparator = System.getProperty("file.separator");
        StringBuilder fileName = new StringBuilder();
        if (fileSeparator.equals("\\")) {
            fileName.append(userHome.replaceAll("\\\\", "\\\\\\\\"));
        } else {
            fileName.append(userHome);
        }
        if (!initialFile) {
            return new File(fileName.toString());
        }
        if (fileSeparator.equals("\\")) {
            fileName.append("\\\\");
        } else {
            fileName.append(fileSeparator);
        }
        String equipName = this.getContext().getEquipment().getName();
        String strType = ((ComboItem)panel.getCmbType().getSelectedItem()).getText();
        String dateFormat = new SimpleDateFormat("yyyyMMdd HHmm").format(new Date());
        fileName.append(equipName).append(' ').append(strType).append(' ').append(dateFormat).append(".res");
        return new File(fileName.toString());
    }

    private File createFileChooser(File initialFile, int type, JPanel panel) {
        int res;
        JFileChooser fileChooser = type == 1 ? new JFileChooser(){

            protected void setUI(ComponentUI newUI) {
                UIManager.put("FileChooser.readOnly", true);
                super.setUI(newUI);
            }
        } : new JFileChooser(){

            public void approveSelection() {
                if (this.getSelectedFile().exists()) {
                    super.approveSelection();
                }
            }

            protected void setUI(ComponentUI newUI) {
                UIManager.put("FileChooser.readOnly", true);
                super.setUI(newUI);
            }
        };
        fileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith(".res");
            }

            public String getDescription() {
                return "Backup files (.res)";
            }
        });
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setDialogType(type);
        fileChooser.setFileHidingEnabled(true);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setSelectedFile(initialFile);
        if (type == 0) {
            fileChooser.setDialogTitle(i18n.translateString("Choose"));
            fileChooser.setApproveButtonText(i18n.translateString("Choose"));
            fileChooser.setApproveButtonToolTipText(i18n.translateString("ChooseTheSelectedLicenseFile"));
            fileChooser.setApproveButtonMnemonic('H');
            res = fileChooser.showOpenDialog(panel);
        } else {
            fileChooser.setDialogTitle(i18n.translateString("Save"));
            fileChooser.setApproveButtonText(i18n.translateString("Save"));
            fileChooser.setApproveButtonToolTipText(i18n.translateString("Save"));
            fileChooser.setApproveButtonMnemonic('S');
            res = fileChooser.showSaveDialog(panel);
        }
        if (res == 0) {
            return fileChooser.getSelectedFile();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean persist(File file, byte[] data) {
        if (file == null) {
            log.error((Object)"Local backup file is null");
            return false;
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException ex) {
                log.error((Object)"Create backup file error ");
                return false;
            }
        }
        if (!file.isFile()) {
            log.error((Object)"Local backup file must be a file ");
            return false;
        }
        if (!file.canWrite()) {
            log.error((Object)"Local backup file is read-only");
            return false;
        }
        boolean succes = false;
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        try {
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(data);
            ((BufferedOutputStream)bos).flush();
            succes = true;
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return succes;
    }

    protected void chooseFile(RbConfigBackupPanel panel) {
        File initialFile = this.getInitialFile(panel, false);
        File selectedFile = this.createFileChooser(initialFile, 0, panel);
        if (selectedFile == null) {
            panel.getBtnRun().setEnabled(panel.getTxtFile().getText().trim().length() != 0);
            return;
        }
        panel.getTxtFile().setText(selectedFile.getAbsolutePath());
        panel.getBtnRun().setEnabled(true);
        panel.setSelFile(selectedFile);
    }

    private JFrame initializePanelLogFrame(String frameTitle) {
        this.panelLog = new SoftwareUpgradePanelLog();
        final JFrame mf = FrameUtil.createModalFrame((Window)this.getParentWindow(this.getUI()));
        this.panelLog.getBtnLogStart().setEnabled(false);
        this.panelLog.getBtnLogStart().setVisible(false);
        this.panelLog.getBtnLogAbort().setEnabled(false);
        this.panelLog.getBtnLogAbort().setVisible(false);
        this.panelLog.getBtnLogOpen().setEnabled(false);
        this.panelLog.getBtnLogOpen().setVisible(false);
        this.panelLog.getBtnLogSave().setEnabled(false);
        this.panelLog.getBtnLogSave().setVisible(false);
        this.panelLog.getBtnLogClose().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                mf.dispose();
            }
        });
        this.panelLog.getBtnLogClose().setEnabled(true);
        this.panelLog.getBtnLogClose().setVisible(true);
        this.panelLog.getProgressBar().setVisible(false);
        this.panelLog.getCheckAutoscroll().setVisible(false);
        this.panelLog.getCheckAutoscroll().setEnabled(false);
        mf.setTitle(i18n.translateString(frameTitle));
        mf.getContentPane().add(this.panelLog);
        mf.setDefaultCloseOperation(0);
        mf.setSize(400, 400);
        int maxWidth = (int)mf.getGraphicsConfiguration().getBounds().getWidth();
        int maxHeight = (int)mf.getGraphicsConfiguration().getBounds().getHeight();
        int width = mf.getWidth();
        int height = mf.getHeight();
        mf.setLocation((maxWidth - width) / 2, (maxHeight - height) / 2);
        return mf;
    }

    private Window getParentWindow(Component comp) {
        Window w = null;
        for (comp = comp.getParent(); comp != null; comp = comp.getParent()) {
            if (!Window.class.isAssignableFrom(comp.getClass())) continue;
            w = (Window)comp;
            break;
        }
        return w;
    }

    protected void run() {
        RbConfigBackupPanel panel = (RbConfigBackupPanel)this.getUI();
        if (((ComboItem)panel.getCmbOperation().getSelectedItem()).getValue().equals(BACKUP)) {
            this.doBackUp();
        } else {
            this.doRestore();
        }
    }

    protected void operationChange(ItemEvent e, RbConfigBackupPanel panel) {
        if (((ComboItem)e.getItem()).getValue().equals(BACKUP)) {
            panel.getLblType().setVisible(true);
            panel.getCmbType().setVisible(true);
            panel.getLblFile().setVisible(false);
            panel.getTxtFile().setVisible(false);
            panel.getBtnFile().setVisible(false);
            panel.getCbRestart().setVisible(false);
            panel.getBtnRun().setEnabled(true);
        } else {
            panel.getLblFile().setVisible(true);
            panel.getTxtFile().setVisible(true);
            panel.getBtnFile().setVisible(true);
            panel.getCbRestart().setVisible(true);
            panel.getLblType().setVisible(false);
            panel.getCmbType().setVisible(false);
            if (this.ctx.getEquipment() instanceof RbMBS) {
                panel.getCbRestart().setText(i18n.translateString("RestartmBS"));
            } else if (this.ctx.getEquipment() instanceof RbBS) {
                panel.getCbRestart().setText(i18n.translateString("RestartNPU"));
            }
            if (panel.getTxtFile().getText().trim().length() == 0) {
                panel.getBtnRun().setEnabled(false);
            } else {
                panel.getBtnRun().setEnabled(true);
            }
        }
    }

    static {
        String separator = System.getProperty("line.separator");
        if (null == separator) {
            separator = "\n";
        }
        LINE_SEPARATOR = separator;
    }
}

