/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.rb.gui.configuration.pm.RadiusPerformanceMonitoringView;
import com.bwanms.ui.components.SimpleRowTable;
import com.bwanms.util.MessageBox;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;

public class RadiusMonitoringPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final Internationalizer i18n = Internationalizer.getInternationalizer(RadiusMonitoringPanel.class);
    RadiusPerformanceMonitoringView form;
    private JPanel pnlInterval;
    private JLabel lblPolInterval;
    private JLabel lblSec;
    private JSpinner spnPolInterval;
    private JButton btnApply;
    private JButton btnResetAuthCounters;
    private JButton btnResetAcctCounters;
    private JComponent sprAuthenticationMonitoring;
    private JScrollPane pnlAuthenticationMonitoring;
    private JTable tblAuthenticationMonitoring;
    private JComponent sprAccountingMonitoring;
    private JScrollPane pnlAccountingMonitoring;
    private JTable tblAccountingMonitoring;
    private JSeparator separator1;

    public RadiusMonitoringPanel(RadiusPerformanceMonitoringView form) {
        this.form = form;
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        i18n.getSwingInternationalizer().translateComponent((Component)this);
        this.translateTable((DefaultTableModel)this.tblAuthenticationMonitoring.getModel());
        this.translateTable((DefaultTableModel)this.tblAccountingMonitoring.getModel());
        this.tblAuthenticationMonitoring.getTableHeader().setReorderingAllowed(false);
        this.tblAuthenticationMonitoring.getTableHeader().setResizingAllowed(false);
        this.tblAuthenticationMonitoring.setBackground(SimpleRowTable.READONLY_COLOR);
        this.tblAccountingMonitoring.getTableHeader().setReorderingAllowed(false);
        this.tblAccountingMonitoring.getTableHeader().setResizingAllowed(false);
        this.tblAccountingMonitoring.setBackground(SimpleRowTable.READONLY_COLOR);
    }

    private void translateTable(DefaultTableModel model) {
        for (int rowIndex = 0; rowIndex < model.getRowCount(); ++rowIndex) {
            model.setValueAt(i18n.translateString(model.getValueAt(rowIndex, 0).toString()), rowIndex, 0);
        }
        model.setColumnIdentifiers(new Object[]{i18n.translateString(model.getColumnName(0)), "", ""});
    }

    private void initComponents() {
        DefaultComponentFactory compFactory = DefaultComponentFactory.getInstance();
        this.pnlInterval = new JPanel();
        this.lblPolInterval = new JLabel();
        this.lblSec = new JLabel();
        this.spnPolInterval = new JSpinner();
        this.btnApply = new JButton();
        this.btnResetAuthCounters = new JButton();
        this.btnResetAcctCounters = new JButton();
        this.sprAuthenticationMonitoring = compFactory.createSeparator("AuthenticationMonitoring");
        this.pnlAuthenticationMonitoring = new JScrollPane();
        this.tblAuthenticationMonitoring = new JTable();
        this.sprAccountingMonitoring = compFactory.createSeparator("AccountingMonitoring");
        this.pnlAccountingMonitoring = new JScrollPane();
        this.tblAccountingMonitoring = new JTable();
        this.separator1 = new JSeparator();
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.BUTTON_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.BUTTON_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{new RowSpec((Size)Sizes.dluY((int)17)), FormFactory.LINE_GAP_ROWSPEC, new RowSpec((Size)Sizes.DLUY11), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, new RowSpec(RowSpec.TOP, (Size)Sizes.DEFAULT, 0.0), FormFactory.UNRELATED_GAP_ROWSPEC, new RowSpec(RowSpec.TOP, (Size)Sizes.DEFAULT, 0.0), FormFactory.RELATED_GAP_ROWSPEC, new RowSpec(RowSpec.TOP, (Size)Sizes.DEFAULT, 1.0), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.pnlInterval.setPreferredSize(new Dimension(230, 33));
        this.pnlInterval.setLayout(new FlowLayout(0));
        this.lblPolInterval.setText("PollingInterval");
        this.pnlInterval.add(this.lblPolInterval);
        this.pnlInterval.add(this.lblSec);
        this.spnPolInterval.setModel(new SpinnerNumberModel((Number)5, Integer.valueOf(1), null, (Number)1));
        this.spnPolInterval.setPreferredSize(new Dimension(80, 20));
        this.pnlInterval.add(this.spnPolInterval);
        this.btnApply.setText("Apply");
        this.pnlInterval.add(this.btnApply);
        this.add((Component)this.pnlInterval, cc.xywh(3, 1, 3, 1));
        this.btnResetAuthCounters.setText("ResetAuthCounters");
        this.btnResetAuthCounters.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RadiusMonitoringPanel.this.btnResetAuthCountersActionPerformed(e);
            }
        });
        this.add((Component)this.btnResetAuthCounters, cc.xy(7, 1));
        this.btnResetAcctCounters.setText("ResetAcctCounters");
        this.btnResetAcctCounters.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RadiusMonitoringPanel.this.btnResetAcctCountersActionPerformed(e);
            }
        });
        this.add((Component)this.btnResetAcctCounters, cc.xy(9, 1));
        this.add((Component)this.sprAuthenticationMonitoring, cc.xywh(1, 5, 11, 1));
        this.tblAuthenticationMonitoring.setModel(new DefaultTableModel(new Object[][]{{"RoundTripTime", null, null}, {"AccessRequests", null, null}, {"AccessRetransmissions", null, null}, {"AccessAccepts", null, null}, {"AccessRejects", null, null}, {"AccessChallenges", null, null}, {"MalformedAccessResponses", null, null}, {"BadAuthenticators", null, null}, {"PendingRequests", null, null}, {"Timeouts", null, null}, {"PacketsOfUnknownType", null, null}, {"PacketsDropped", null, null}}, new String[]{"ServerAddress", " ", " "}){
            Class[] columnTypes;
            boolean[] columnEditable;
            {
                this.columnTypes = new Class[]{Object.class, Long.class, Long.class};
                this.columnEditable = new boolean[]{false, false, false};
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return this.columnTypes[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.columnEditable[columnIndex];
            }
        });
        this.tblAuthenticationMonitoring.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.tblAuthenticationMonitoring.setPreferredScrollableViewportSize(new Dimension(450, 192));
        this.tblAuthenticationMonitoring.setRowSelectionAllowed(false);
        this.tblAuthenticationMonitoring.setFocusable(false);
        this.pnlAuthenticationMonitoring.setViewportView(this.tblAuthenticationMonitoring);
        this.add((Component)this.pnlAuthenticationMonitoring, cc.xywh(3, 7, 7, 1));
        this.add((Component)this.sprAccountingMonitoring, cc.xywh(1, 9, 11, 1));
        this.tblAccountingMonitoring.setModel(new DefaultTableModel(new Object[][]{{"RoundTripTime", null, null}, {"Requests", null, null}, {"Retransmissions", null, null}, {"Responses", null, null}, {"MalformedResponses", null, null}, {"BadAuthenticators", null, null}, {"PendingRequests", null, null}, {"Timeouts", null, null}, {"PacketsOfUnknownType", null, null}, {"PacketsDropped", null, null}}, new String[]{"ServerAddress", " ", " "}){
            Class[] columnTypes;
            boolean[] columnEditable;
            {
                this.columnTypes = new Class[]{Object.class, Long.class, Long.class};
                this.columnEditable = new boolean[]{false, false, false};
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return this.columnTypes[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.columnEditable[columnIndex];
            }
        });
        this.tblAccountingMonitoring.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.tblAccountingMonitoring.setPreferredScrollableViewportSize(new Dimension(450, 160));
        this.tblAccountingMonitoring.setRowSelectionAllowed(false);
        this.tblAccountingMonitoring.setFocusable(false);
        this.pnlAccountingMonitoring.setViewportView(this.tblAccountingMonitoring);
        this.add((Component)this.pnlAccountingMonitoring, cc.xywh(3, 11, 7, 1));
        this.add((Component)this.separator1, cc.xy(3, 13));
    }

    public JTable getTblAuthenticationMonitoring() {
        return this.tblAuthenticationMonitoring;
    }

    public JTable getTblAccountingMonitoring() {
        return this.tblAccountingMonitoring;
    }

    public JSpinner getSpnPolInterval() {
        return this.spnPolInterval;
    }

    public JButton getBtnApply() {
        return this.btnApply;
    }

    private void btnResetAuthCountersActionPerformed(ActionEvent e) {
        if (MessageBox.Confirm.showResult((Component)this, i18n.translateString("AreYouSureYouWantToResetAuthCounters"))) {
            this.form.resetAuthCounters();
        }
    }

    private void btnResetAcctCountersActionPerformed(ActionEvent e) {
        if (MessageBox.Confirm.showResult((Component)this, i18n.translateString("AreYouSureYouWantToResetAcctCounters"))) {
            this.form.resetAcctCounters();
        }
    }
}

