/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.rb.gui.configuration.RadiusClientAccSrvController;
import com.bwanms.rb.gui.configuration.RadiusClientAuthSrvController;
import com.bwanms.rb.gui.configuration.RadiusClientPanel;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.SimpleRowTable;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FormUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.text.ParseException;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.DefaultFormatter;

public class RadiusClientPanelController {
    private RadiusClientAccSrvController accSrvController;
    private RadiusClientAuthSrvController authSrvController;
    private boolean canChange = true;
    public static final int[] COL = new int[]{0, 1, 2, 8, 6, 5, 7, 3, 4};
    private RadiusClientPanel form;

    public RadiusClientPanelController(RadiusClientPanel form) {
        this.accSrvController = new RadiusClientAccSrvController(form);
        this.authSrvController = new RadiusClientAuthSrvController(form);
        this.form = form;
    }

    public RadiusClientAccSrvController getAccSrvController() {
        return this.accSrvController;
    }

    public RadiusClientAuthSrvController getAuthSrvController() {
        return this.authSrvController;
    }

    public SimpleRowTableModel initTable(JTable table, Internationalizer i18n) {
        SimpleRowTableModel tableModel = null;
        boolean ifVLAN = false;
        Integer productType = this.getProductType();
        if (RbBaseStationEquipment.SWITCHING_MODE_IP_CS == productType) {
            if (!this.form.isVersion()) {
                tableModel = new SimpleRowTableModel(new SimpleRowTableModel.ColumnDefinition[]{new SimpleRowTableModel.ColumnDefinition(i18n.translateString("No"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("serverIPAddress"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("udpPort"), Integer.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("OperationStatus"), String.class)});
                tableModel.setColumnReadonly(0, true);
                tableModel.setColumnReadonly(1, true);
                tableModel.setColumnReadonly(2, true);
                tableModel.setColumnReadonly(3, true);
                tableModel.setNewColumnReadonly(0, true);
                tableModel.setNewColumnReadonly(3, true);
                tableModel.setNewRowReadOnlyOverride(true);
            } else {
                ifVLAN = true;
                table.getTableHeader().setDefaultRenderer(new WordWrapTableHeadRenderer());
                ComboItem[] dataPortAdoptItems = new ComboItem[]{new ComboItem((Object)1, i18n.translateString("DTPA_Yes")), new ComboItem((Object)2, i18n.translateString("DTPA_No"))};
                tableModel = new SimpleRowTableModel(new SimpleRowTableModel.ColumnDefinition[]{new SimpleRowTableModel.ColumnDefinition(i18n.translateString("No"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("serverIPAddress"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("udpPort"), Integer.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("AdoptDataPort"), Integer.class, dataPortAdoptItems), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("VlanId"), Integer.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("RadiusIfCIPAddress"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("RadiusServerSubnetMask"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("RadiusServerGateway"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("OperationStatus"), String.class)});
                tableModel.setColumnReadonly(0, true);
                tableModel.setColumnReadonly(1, true);
                tableModel.setColumnReadonly(2, true);
                tableModel.setColumnReadonly(3, true);
                tableModel.setColumnReadonly(4, true);
                tableModel.setColumnReadonly(5, true);
                tableModel.setColumnReadonly(6, true);
                tableModel.setColumnReadonly(7, true);
                tableModel.setColumnReadonly(8, true);
                tableModel.setNewColumnReadonly(0, true);
                tableModel.setNewColumnReadonly(4, true);
                tableModel.setNewColumnReadonly(8, true);
                tableModel.setNewColumnReadonly(6, true);
                tableModel.setNewColumnReadonly(7, true);
                tableModel.setNewColumnReadonly(5, true);
                tableModel.setNewRowReadOnlyOverride(true);
                for (TableModelListener tml : tableModel.getTableModelListeners()) {
                    tableModel.removeTableModelListener(tml);
                }
                tableModel.addTableModelListener(new TableModelListener(){

                    public void tableChanged(TableModelEvent e) {
                        Integer dataPortAdopt;
                        SimpleRowTableModel model = (SimpleRowTableModel)e.getSource();
                        if (model.getRowCount() > 0 && null != (dataPortAdopt = (Integer)model.getValueAt(0, 3))) {
                            if (dataPortAdopt == 1 && RadiusClientPanelController.this.canChange) {
                                RadiusClientPanelController.this.canChange = false;
                                model.setInitialValueAt(null, 0, 4);
                                model.setInitialValueAt(null, 0, 5);
                                model.setInitialValueAt(null, 0, 6);
                                model.setInitialValueAt(null, 0, 7);
                                model.setNewColumnReadonly(4, true);
                                model.setNewColumnReadonly(5, true);
                                model.setNewColumnReadonly(6, true);
                                model.setNewColumnReadonly(7, true);
                            }
                            if (dataPortAdopt == 2) {
                                RadiusClientPanelController.this.canChange = true;
                                model.setNewColumnReadonly(4, false);
                                model.setNewColumnReadonly(5, false);
                                model.setNewColumnReadonly(6, false);
                                model.setNewColumnReadonly(7, false);
                            }
                        }
                    }
                });
            }
        } else if (RbBaseStationEquipment.SWITCHING_MODE_ETHERNET_CS == productType) {
            tableModel = new SimpleRowTableModel(new SimpleRowTableModel.ColumnDefinition[]{new SimpleRowTableModel.ColumnDefinition(i18n.translateString("No"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("serverIPAddress"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("udpPort"), Integer.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("OperationStatus"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("ActivityStatus"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("isPrimary"), Boolean.class)});
            tableModel.setColumnReadonly(0, true);
            tableModel.setColumnReadonly(1, true);
            tableModel.setColumnReadonly(2, true);
            tableModel.setColumnReadonly(3, true);
            tableModel.setColumnReadonly(4, true);
            tableModel.setColumnReadonly(5, true);
            tableModel.setNewColumnReadonly(0, true);
            tableModel.setNewColumnReadonly(3, true);
            tableModel.setNewColumnReadonly(4, true);
            tableModel.setNewRowReadOnlyOverride(true);
        } else {
            throw new IllegalStateException("[jtonic] Unknown device type");
        }
        SimpleRowTable srTable = new SimpleRowTable(table, tableModel);
        table.getColumnModel().getColumn(0).setPreferredWidth(20);
        if (this.form.isVersion() && RbBaseStationEquipment.SWITCHING_MODE_IP_CS == productType) {
            srTable.setComboCellEditor(3);
        }
        DefaultFormatter portFormatter = new DefaultFormatter(){
            private static final long serialVersionUID = -3433286437646488341L;

            public Object stringToValue(String text) throws ParseException {
                int port;
                if (text.equals("")) {
                    return null;
                }
                try {
                    port = Integer.parseInt(text);
                    if (port < 1 || port > 65535) {
                        throw new ParseException("Port number must be between 0 and 65535", 0);
                    }
                }
                catch (NumberFormatException nfe) {
                    throw new ParseException("Wrong port number format", 0);
                }
                return port;
            }
        };
        DefaultFormatter valueFormatter = new DefaultFormatter(){
            private static final long serialVersionUID = -3433286437646488341L;

            public Object stringToValue(String text) throws ParseException {
                int port;
                if (text.equals("")) {
                    return null;
                }
                try {
                    port = Integer.parseInt(text);
                    if (port < 0 || port > 4094) {
                        throw new ParseException("Port number must be between 0 and 4094", 0);
                    }
                }
                catch (NumberFormatException nfe) {
                    throw new ParseException("Wrong port number format", 0);
                }
                return port;
            }
        };
        portFormatter.setOverwriteMode(false);
        portFormatter.setAllowsInvalid(false);
        portFormatter.setCommitsOnValidEdit(true);
        valueFormatter.setOverwriteMode(false);
        valueFormatter.setAllowsInvalid(false);
        valueFormatter.setCommitsOnValidEdit(true);
        srTable.setFormattedTextCellEditor(2, portFormatter);
        if (ifVLAN) {
            srTable.setFormattedTextCellEditor(4, valueFormatter);
        }
        return tableModel;
    }

    public void fillTable(SimpleRowTableModel tableModel, int port) {
        FormUtil.cancelTableEditing((JTable)this.form.getTblAccountingServers());
        FormUtil.cancelTableEditing((JTable)this.form.getTblAuthenticationServers());
        tableModel.clearTable();
        int noOfRows = 2;
        Integer productType = this.getProductType();
        if (productType == RbBaseStationEquipment.SWITCHING_MODE_ETHERNET_CS) {
            noOfRows = 2;
        } else if (productType == RbBaseStationEquipment.SWITCHING_MODE_IP_CS) {
            noOfRows = 1;
        } else {
            throw new IllegalStateException("[jtonic] Illegal product type");
        }
        for (int i = 1; i <= noOfRows; ++i) {
            tableModel.addNewRow(i + "", true);
            tableModel.setRowState(i - 1, 4);
            tableModel.setInitialValueAt((Object)i, i - 1, 0);
            tableModel.setInitialValueAt((Object)port, i - 1, 2);
            if (productType == RbBaseStationEquipment.SWITCHING_MODE_ETHERNET_CS) {
                tableModel.setInitialValueAt((Object)false, i - 1, 5);
            }
            if (productType != RbBaseStationEquipment.SWITCHING_MODE_IP_CS) continue;
            if (!this.form.isVersion()) {
                tableModel.setInitialValueAt(null, i - 1, 3);
                continue;
            }
            tableModel.setInitialValueAt((Object)1, i - 1, 3);
            tableModel.setNewColumnReadonly(4, true);
            tableModel.setNewColumnReadonly(5, true);
            tableModel.setNewColumnReadonly(6, true);
            tableModel.setNewColumnReadonly(7, true);
        }
    }

    private Integer getProductType() {
        return ((RbBaseStationEquipment)this.form.getManagedObjectsConfigForm().getContext().getEquipment()).getSwitchingMode();
    }

    private static class WordWrapTableHeadRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;
        private JTextArea jta = new JTextArea();
        private JLabel iconLabel = new JLabel();

        public WordWrapTableHeadRenderer() {
            this.setPreferredSize(new Dimension(100, 45));
            this.setLayout(new BorderLayout(0, 0));
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.jta.setWrapStyleWord(true);
            this.jta.setLineWrap(true);
            this.jta.setOpaque(false);
            this.add((Component)this.jta, "Center");
            this.add((Component)this.iconLabel, "East");
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.jta.setText(value == null ? "" : value.toString());
            this.setToolTipText(value == null ? "" : value.toString());
            return this;
        }
    }
}

