/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.rb.gui.configuration.RadiusClientPanelController;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.util.RbVersions;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelListener;

public class RadiusClientPanel
extends JPanel {
    public static final Internationalizer i18n = Internationalizer.getInternationalizer(RadiusClientPanel.class);
    private RadiusClientPanelController controller;
    private ManagedObjectsConfigForm cfgForm;
    private boolean version;
    private JComponent sprGeneralParameters;
    private JPanel panel1;
    private JLabel lblRetryInterval;
    private JSpinner spnRetryInterval;
    private JLabel lblNumberOfRetries;
    private JSpinner spnNumberOfRetries;
    private JLabel lblKeepAliveTimeout;
    private JSpinner spnKeepAliveTimeout;
    private JComponent sprAuthenticationServers;
    private JButton btnRevertAuthSrv;
    private JButton btnDeleteAuthSrv;
    private JScrollPane pnlAuthenticationServers;
    private JTable tblAuthenticationServers;
    private JComponent sprAccountingServers;
    private JButton btnRevertAccSrv;
    private JButton btnDeleteAccSrv;
    private JScrollPane pnlAccountingServers;
    private JTable tblAccountingServers;
    private SimpleRowTableModel tblAccountingServersModel;
    private SimpleRowTableModel tblAuthenticationServersModel;

    public RadiusClientPanel(ManagedObjectsConfigForm cfgForm) {
        this.cfgForm = cfgForm;
        RbBaseStationEquipment bs = (RbBaseStationEquipment)cfgForm.getContext().getEquipment();
        this.version = bs.getSoftwareVersion().isNewerOrEqualWith(RbVersions.V_4_5);
        this.initComponents();
        this.postInitComponents(cfgForm);
    }

    private void postInitComponents(ManagedObjectsConfigForm cfgForm) {
        i18n.getSwingInternationalizer().translateComponent((Component)this);
        this.controller = new RadiusClientPanelController(this);
        this.tblAuthenticationServersModel = this.controller.initTable(this.getTblAuthenticationServers(), i18n);
        this.tblAuthenticationServersModel.addTableModelListener((TableModelListener)((Object)this.controller.getAuthSrvController()));
        this.tblAccountingServersModel = this.controller.initTable(this.getTblAccountingServers(), i18n);
        this.tblAccountingServersModel.addTableModelListener((TableModelListener)((Object)this.controller.getAccSrvController()));
        this.tblAuthenticationServers.setSelectionMode(0);
        this.tblAccountingServers.setSelectionMode(0);
    }

    private void initComponents() {
        DefaultComponentFactory compFactory = DefaultComponentFactory.getInstance();
        this.sprGeneralParameters = compFactory.createSeparator("GeneralParameters");
        this.panel1 = new JPanel();
        this.lblRetryInterval = new JLabel();
        this.spnRetryInterval = new JSpinner();
        this.lblNumberOfRetries = new JLabel();
        this.spnNumberOfRetries = new JSpinner();
        this.lblKeepAliveTimeout = new JLabel();
        this.spnKeepAliveTimeout = new JSpinner();
        this.sprAuthenticationServers = compFactory.createSeparator("AuthenticationServers");
        this.btnRevertAuthSrv = new JButton();
        this.btnDeleteAuthSrv = new JButton();
        this.pnlAuthenticationServers = new JScrollPane();
        this.tblAuthenticationServers = new JTable(){

            public void valueChanged(ListSelectionEvent e) {
                super.valueChanged(e);
                RadiusClientPanel.this.controller.getAuthSrvController().controlTableButtons();
            }
        };
        this.sprAccountingServers = compFactory.createSeparator("AccountingServers");
        this.btnRevertAccSrv = new JButton();
        this.btnDeleteAccSrv = new JButton();
        this.pnlAccountingServers = new JScrollPane();
        this.tblAccountingServers = new JTable(){

            public void valueChanged(ListSelectionEvent e) {
                super.valueChanged(e);
                RadiusClientPanel.this.controller.getAccSrvController().controlTableButtons();
            }
        };
        CellConstraints cc = new CellConstraints();
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.dluX((int)22), 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.BUTTON_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.BUTTON_COLSPEC, new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.DLUX3, 0.0), FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec((Size)Sizes.dluY((int)50)), new RowSpec(RowSpec.TOP, (Size)Sizes.DLUY6, 0.0), FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec((Size)Sizes.dluY((int)50))}));
        this.add((Component)this.sprGeneralParameters, cc.xywh(1, 1, 9, 1));
        this.panel1.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.lblRetryInterval.setText("retryInterval");
        this.panel1.add((Component)this.lblRetryInterval, cc.xy(1, 1));
        this.spnRetryInterval.setModel(new SpinnerNumberModel((Number)5, null, null, (Number)1));
        this.spnRetryInterval.setToolTipText("1..5");
        this.spnRetryInterval.setMinimumSize(new Dimension(36, 20));
        this.spnRetryInterval.setPreferredSize(new Dimension(66, 20));
        this.panel1.add((Component)this.spnRetryInterval, cc.xy(3, 1));
        this.lblNumberOfRetries.setText("numberOfRetries");
        this.panel1.add((Component)this.lblNumberOfRetries, cc.xy(1, 3));
        this.spnNumberOfRetries.setModel(new SpinnerNumberModel((Number)3, null, null, (Number)1));
        this.spnNumberOfRetries.setToolTipText("0..5");
        this.spnNumberOfRetries.setMinimumSize(new Dimension(36, 20));
        this.spnNumberOfRetries.setPreferredSize(new Dimension(66, 20));
        this.panel1.add((Component)this.spnNumberOfRetries, cc.xy(3, 3));
        this.lblKeepAliveTimeout.setText("KeepAliveTimeout");
        this.panel1.add((Component)this.lblKeepAliveTimeout, cc.xy(1, 5));
        this.spnKeepAliveTimeout.setModel(new SpinnerNumberModel((Number)180, null, null, (Number)1));
        this.spnKeepAliveTimeout.setToolTipText("60..180");
        this.spnKeepAliveTimeout.setMinimumSize(new Dimension(36, 20));
        this.spnKeepAliveTimeout.setPreferredSize(new Dimension(66, 20));
        this.panel1.add((Component)this.spnKeepAliveTimeout, cc.xy(3, 5));
        this.add((Component)this.panel1, cc.xywh(1, 3, 9, 1));
        this.add((Component)this.sprAuthenticationServers, cc.xywh(1, 5, 9, 1));
        this.btnRevertAuthSrv.setText("Revert");
        this.btnRevertAuthSrv.setEnabled(false);
        this.btnRevertAuthSrv.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RadiusClientPanel.this.btnRevertAuthSrvActionPerformed(e);
            }
        });
        this.add((Component)this.btnRevertAuthSrv, cc.xy(5, 7));
        this.btnDeleteAuthSrv.setText("Delete");
        this.btnDeleteAuthSrv.setEnabled(false);
        this.btnDeleteAuthSrv.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RadiusClientPanel.this.btnDeleteAuthSrvActionPerformed(e);
            }
        });
        this.add((Component)this.btnDeleteAuthSrv, cc.xy(7, 7));
        this.tblAuthenticationServers.setRowHeight(20);
        this.pnlAuthenticationServers.setViewportView(this.tblAuthenticationServers);
        this.add((Component)this.pnlAuthenticationServers, cc.xywh(3, 9, 5, 1));
        this.add((Component)this.sprAccountingServers, cc.xywh(1, 11, 9, 1));
        this.btnRevertAccSrv.setText("Revert");
        this.btnRevertAccSrv.setEnabled(false);
        this.btnRevertAccSrv.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RadiusClientPanel.this.btnRevertAccSrvActionPerformed(e);
            }
        });
        this.add((Component)this.btnRevertAccSrv, cc.xy(5, 13));
        this.btnDeleteAccSrv.setText("Delete");
        this.btnDeleteAccSrv.setEnabled(false);
        this.btnDeleteAccSrv.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RadiusClientPanel.this.btnDeleteAccSrvActionPerformed(e);
            }
        });
        this.add((Component)this.btnDeleteAccSrv, cc.xy(7, 13));
        this.tblAccountingServers.setRowHeight(20);
        this.pnlAccountingServers.setViewportView(this.tblAccountingServers);
        this.add((Component)this.pnlAccountingServers, cc.xywh(3, 15, 5, 1));
    }

    public JSpinner getSpnKeepAliveTimeout() {
        return this.spnKeepAliveTimeout;
    }

    private void btnRevertAuthSrvActionPerformed(ActionEvent e) {
        this.controller.getAuthSrvController().btnRevertMouseClicked();
    }

    private void btnDeleteAuthSrvActionPerformed(ActionEvent e) {
        this.controller.getAuthSrvController().btnDeleteMouseClicked();
    }

    private void btnRevertAccSrvActionPerformed(ActionEvent e) {
        this.controller.getAccSrvController().btnRevertMouseClicked();
    }

    private void btnDeleteAccSrvActionPerformed(ActionEvent e) {
        this.controller.getAccSrvController().btnDeleteMouseClicked();
    }

    public SimpleRowTableModel getTblAccountingServersModel() {
        return this.tblAccountingServersModel;
    }

    public SimpleRowTableModel getTblAuthenticationServersModel() {
        return this.tblAuthenticationServersModel;
    }

    public JButton getBtnDeleteAccSrv() {
        return this.btnDeleteAccSrv;
    }

    public JButton getBtnDeleteAuthSrv() {
        return this.btnDeleteAuthSrv;
    }

    public JButton getBtnRevertAccSrv() {
        return this.btnRevertAccSrv;
    }

    public JButton getBtnRevertAuthSrv() {
        return this.btnRevertAuthSrv;
    }

    public JSpinner getSpnNumberOfRetries() {
        return this.spnNumberOfRetries;
    }

    public JSpinner getSpnRetryInterval() {
        return this.spnRetryInterval;
    }

    public JTable getTblAccountingServers() {
        return this.tblAccountingServers;
    }

    public JTable getTblAuthenticationServers() {
        return this.tblAuthenticationServers;
    }

    public JScrollPane getPnlAuthenticationServers() {
        return this.pnlAuthenticationServers;
    }

    public JScrollPane getPnlAccountingServers() {
        return this.pnlAccountingServers;
    }

    public RadiusClientPanelController getController() {
        return this.controller;
    }

    public ManagedObjectsConfigForm getManagedObjectsConfigForm() {
        return this.cfgForm;
    }

    public boolean isVersion() {
        return this.version;
    }
}

