/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JSpinnerBinding;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.mo.TableRowMO;
import com.bwanms.mo.snmp.DynamicTableRowMO;
import com.bwanms.rb.gui.configuration.RadiusClientPanel;
import com.bwanms.rb.gui.configuration.RadiusClientPanelController;
import com.bwanms.rb.mo.RbRadiusAccountServerEntry;
import com.bwanms.rb.mo.RbRadiusAccountServerTable;
import com.bwanms.rb.mo.RbRadiusAuthServerEntry;
import com.bwanms.rb.mo.RbRadiusAuthServerTable;
import com.bwanms.rb.mo.RbRadiusClientGeneralParameters;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.util.RbVersions;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FormUtil;
import com.bwanms.util.IpAddress;
import com.bwanms.util.IpAddressRange;
import com.bwanms.validation.IPv4Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RadiusClientConfigForm
extends ManagedObjectsConfigForm<RadiusClientPanel> {
    private static final Logger logger = Logger.getLogger(RadiusClientConfigForm.class);

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        DefaultBinder binder = new DefaultBinder((Object)this.getUI(), managedObjects.get(0));
        binder.add((Binding)new JSpinnerBinding("spnNumberOfRetries", "rbRadiusClientMaxNumOfRetries", RadiusClientPanel.i18n.translateString("numberOfRetries")));
        binder.add((Binding)new JSpinnerBinding("spnRetryInterval", "rbRadiusClientRetryInterval", RadiusClientPanel.i18n.translateString("retryInterval")));
        binder.add((Binding)new JSpinnerBinding("spnKeepAliveTimeout", "rbRadiusClientKeepAliveTimeout", RadiusClientPanel.i18n.translateString("KeepAliveTimeout")));
        binders.add((Binder)binder);
    }

    public RadiusClientPanel initUIComponent() {
        return new RadiusClientPanel(this);
    }

    public List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("BS", RbRadiusClientGeneralParameters.class));
        ret.add(this.ctx.createRequest("BS", RbRadiusAuthServerTable.class));
        ret.add(this.ctx.createRequest("BS", RbRadiusAccountServerTable.class));
        return ret;
    }

    private void checkDuplicateIPs(List<InvalidValue> invalidValues, DynamicTableRowMO entry, String ip1, String trIp1, String ip2, String trIp2) {
        if (ip1.equals(ip2)) {
            invalidValues.add(new InvalidValue(RadiusClientPanel.i18n.translateString("IpMustBeDifferent", new Object[]{RadiusClientPanel.i18n.translateString(trIp1), RadiusClientPanel.i18n.translateString(trIp2)}), entry.getClass(), RadiusClientPanel.i18n.translateString("InvalidIpAddress"), (Object)ip1, (Object)entry));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void configureMOs(List<Object> managedObjects, List<InvalidValue> invalidValues) {
        FormUtil.stopTableEditing((JTable)((RadiusClientPanel)this.getUI()).getTblAccountingServers());
        FormUtil.stopTableEditing((JTable)((RadiusClientPanel)this.getUI()).getTblAuthenticationServers());
        SimpleRowTableModel model = ((RadiusClientPanel)this.getUI()).getTblAuthenticationServersModel();
        RbRadiusAuthServerTable authTable = (RbRadiusAuthServerTable)((Object)managedObjects.get(1));
        Vector<RbRadiusAuthServerEntry> authEntries = new Vector<RbRadiusAuthServerEntry>();
        Integer productType = ((RbBaseStationEquipment)this.ctx.getEquipment()).getSwitchingMode();
        boolean sameType = true;
        RbBaseStationEquipment bs = (RbBaseStationEquipment)this.ctx.getEquipment();
        boolean version = bs.getSoftwareVersion().isNewerOrEqualWith(RbVersions.V_4_5);
        if (RbBaseStationEquipment.SWITCHING_MODE_ETHERNET_CS == productType) {
            sameType = !((Boolean)model.getValueAt(0, 5) ^ (Boolean)model.getValueAt(1, 5)) && model.getRowState(0) != 4 && model.getRowState(1) != 4;
        }
        block12: for (int i = 0; i < model.getRowCount(); ++i) {
            switch (model.getRowState(i)) {
                case 1: {
                    if (version && RbBaseStationEquipment.SWITCHING_MODE_IP_CS == productType) {
                        authTable.removeEntry((String)model.getValueAt(i, RadiusClientPanelController.COL[1]));
                        continue block12;
                    }
                    authTable.removeEntry((String)model.getValueAt(i, 1));
                    continue block12;
                }
                case 5: {
                    Integer portNo;
                    RbRadiusAuthServerEntry authEntry = new RbRadiusAuthServerEntry();
                    String ip = "";
                    if (version && RbBaseStationEquipment.SWITCHING_MODE_IP_CS == productType) {
                        ip = (String)model.getValueAt(i, RadiusClientPanelController.COL[1]);
                        authEntry.setRbRadiusAuthServerAddress(ip);
                        portNo = (Integer)model.getValueAt(i, RadiusClientPanelController.COL[2]);
                        authEntry.setRbRadiusAuthServerPortNumber(portNo);
                        String serverGateway = (String)model.getValueAt(i, RadiusClientPanelController.COL[6]);
                        serverGateway = null == serverGateway ? "" : serverGateway;
                        String string2 = (String)model.getValueAt(i, RadiusClientPanelController.COL[4]);
                        string2 = null == string2 ? "" : string2;
                        String serverIfcIpAddress = (String)model.getValueAt(i, RadiusClientPanelController.COL[5]);
                        serverIfcIpAddress = null == serverIfcIpAddress ? "" : serverIfcIpAddress;
                        Integer vlanId = (Integer)model.getValueAt(i, RadiusClientPanelController.COL[8]);
                        Integer dataPort = (Integer)model.getValueAt(i, RadiusClientPanelController.COL[7]);
                        authEntry.setRbRadiusAuthDataPortAdopt(dataPort);
                        if (2 == dataPort) {
                            authEntry.setRbRadiusAuthServerVlanId(vlanId);
                            authEntry.setRbRadiusAuthServerGateway(serverGateway);
                            authEntry.setRbRadiusAuthServerSubnetMask(string2);
                            authEntry.setRbRadiusAuthServerIfcIpAddress(serverIfcIpAddress);
                            if (null != vlanId && (vlanId > 4095 || vlanId < 0)) {
                                invalidValues.add(new InvalidValue(RadiusClientPanel.i18n.translateString("valueNotInRange", new Object[]{0, 4095}), RbRadiusAuthServerEntry.class, RadiusClientPanel.i18n.translateString("VlanId"), model.getValueAt(i, RadiusClientPanelController.COL[8]), (Object)authEntry));
                            }
                            boolean allIPsValid = true;
                            if (!IPv4Validator.isValidIp((String)serverIfcIpAddress)) {
                                invalidValues.add(new InvalidValue(RadiusClientPanel.i18n.translateString("InvalidIpAddress"), RbRadiusAuthServerEntry.class, RadiusClientPanel.i18n.translateString("RadiusIfCIPAddress"), (Object)serverIfcIpAddress, (Object)authEntry));
                                allIPsValid = false;
                            }
                            if (!serverGateway.trim().equals("0.0.0.0") && !serverGateway.trim().equals("")) {
                                if (!IPv4Validator.isValidIp((String)serverGateway)) {
                                    invalidValues.add(new InvalidValue(RadiusClientPanel.i18n.translateString("InvalidIpAddress"), RbRadiusAuthServerEntry.class, RadiusClientPanel.i18n.translateString("RadiusServerGateway"), (Object)serverGateway, (Object)authEntry));
                                    allIPsValid = false;
                                }
                            } else {
                                try {
                                    IpAddress ifcIPAddress = new IpAddress(authEntry.getRbRadiusAuthServerIfcIpAddress().trim());
                                    IpAddress serverSubnet = new IpAddress(authEntry.getRbRadiusAuthServerSubnetMask().trim());
                                    IpAddress serverIP = new IpAddress(authEntry.getRbRadiusAuthServerAddress().trim());
                                    IpAddressRange subnetRange = IpAddressRange.fromSubnet((IpAddress)ifcIPAddress, (IpAddress)serverSubnet);
                                    if (!subnetRange.contains(serverIP)) {
                                        invalidValues.add(new InvalidValue(RadiusClientPanel.i18n.translateString("InvalidIpRangeSubnet"), JTextField.class, RadiusClientPanel.i18n.translateString("RadiusIfCIPAddress"), (Object)authEntry.getRbRadiusAuthServerAddress(), (Object)authEntry.getRbRadiusAuthServerIfcIpAddress()));
                                    } else {
                                        authEntry.setRbRadiusAuthServerGateway("0.0.0.0");
                                    }
                                }
                                catch (IllegalArgumentException e) {
                                    // empty catch block
                                }
                            }
                            if (!IPv4Validator.isValidHostMask((String)string2)) {
                                invalidValues.add(new InvalidValue(RadiusClientPanel.i18n.translateString("InvalidSubnetMask"), RbRadiusAuthServerEntry.class, RadiusClientPanel.i18n.translateString("RadiusServerSubnetMask"), (Object)string2, (Object)authEntry));
                            }
                            if (allIPsValid) {
                                this.checkDuplicateIPs(invalidValues, authEntry, ip, "serverIPAddress", serverGateway, "RadiusServerGateway");
                                this.checkDuplicateIPs(invalidValues, authEntry, serverIfcIpAddress, "RadiusIfCIPAddress", serverGateway, "RadiusServerGateway");
                                this.checkDuplicateIPs(invalidValues, authEntry, serverIfcIpAddress, "RadiusIfCIPAddress", ip, "serverIPAddress");
                            }
                        } else {
                            authEntry.setRbRadiusAuthServerVlanId(null);
                            authEntry.setRbRadiusAuthServerGateway(null);
                            authEntry.setRbRadiusAuthServerSubnetMask(null);
                            authEntry.setRbRadiusAuthServerIfcIpAddress(null);
                        }
                    } else {
                        ip = (String)model.getValueAt(i, 1);
                        authEntry.setRbRadiusAuthServerAddress(ip);
                        portNo = (Integer)model.getValueAt(i, 2);
                        authEntry.setRbRadiusAuthServerPortNumber(portNo);
                    }
                    if (RbBaseStationEquipment.SWITCHING_MODE_ETHERNET_CS == productType && ((Boolean)model.getValueAt(i, 5)).booleanValue()) {
                        authEntry.setRbRadiusAuthServerType(1);
                    }
                    if (RbBaseStationEquipment.SWITCHING_MODE_ETHERNET_CS == productType && sameType) {
                        invalidValues.add(new InvalidValue(RadiusClientPanel.i18n.translateString("TwoSameTypeServersError"), RbRadiusAuthServerEntry.class, RadiusClientPanel.i18n.translateString("AuthServer"), model.getValueAt(i, 0), (Object)authEntry));
                        continue block12;
                    }
                    if (portNo == null) {
                        invalidValues.add(new InvalidValue(RadiusClientPanel.i18n.translateString("UdpPortError"), RbRadiusAuthServerEntry.class, RadiusClientPanel.i18n.translateString("udpPort"), model.getValueAt(i, 0), (Object)authEntry));
                        continue block12;
                    }
                    if (ip == null || ip.length() == 0) {
                        invalidValues.add(new InvalidValue(RadiusClientPanel.i18n.translateString("WrongIpAddress"), RbRadiusAuthServerEntry.class, RadiusClientPanel.i18n.translateString("AuthServer"), model.getValueAt(i, 0), (Object)authEntry));
                        continue block12;
                    }
                    authEntries.add(authEntry);
                }
            }
        }
        model = ((RadiusClientPanel)this.getUI()).getTblAccountingServersModel();
        RbRadiusAccountServerTable accTable = (RbRadiusAccountServerTable)((Object)managedObjects.get(2));
        Vector<RbRadiusAccountServerEntry> accEntries = new Vector<RbRadiusAccountServerEntry>();
        sameType = true;
        if (RbBaseStationEquipment.SWITCHING_MODE_ETHERNET_CS == productType) {
            sameType = !((Boolean)model.getValueAt(0, 5) ^ (Boolean)model.getValueAt(1, 5)) && model.getRowState(0) != 4 && model.getRowState(1) != 4;
        }
        block13: for (int i = 0; i < model.getRowCount(); ++i) {
            switch (model.getRowState(i)) {
                case 1: {
                    if (version && RbBaseStationEquipment.SWITCHING_MODE_IP_CS == productType) {
                        accTable.removeEntry((String)model.getValueAt(i, RadiusClientPanelController.COL[1]));
                        continue block13;
                    }
                    accTable.removeEntry((String)model.getValueAt(i, 1));
                    continue block13;
                }
                case 5: {
                    void var15_23;
                    String ip;
                    RbRadiusAccountServerEntry accEntry = new RbRadiusAccountServerEntry();
                    if (version && RbBaseStationEquipment.SWITCHING_MODE_IP_CS == productType) {
                        ip = (String)model.getValueAt(i, RadiusClientPanelController.COL[1]);
                        accEntry.setRbRadiusAcctServerAddress(ip);
                        Integer n = (Integer)model.getValueAt(i, RadiusClientPanelController.COL[2]);
                        accEntry.setRbRadiusAcctServerPortNumber(n);
                        String serverGateway = (String)model.getValueAt(i, RadiusClientPanelController.COL[6]);
                        serverGateway = null == serverGateway ? "" : serverGateway;
                        String serverSubnetMask = (String)model.getValueAt(i, RadiusClientPanelController.COL[4]);
                        serverSubnetMask = null == serverSubnetMask ? "" : serverSubnetMask;
                        String serverIfcIpAddress = (String)model.getValueAt(i, RadiusClientPanelController.COL[5]);
                        serverIfcIpAddress = null == serverIfcIpAddress ? "" : serverIfcIpAddress;
                        Integer vlanId = (Integer)model.getValueAt(i, RadiusClientPanelController.COL[8]);
                        Integer dataPort = (Integer)model.getValueAt(i, RadiusClientPanelController.COL[7]);
                        accEntry.setRbRadiusAcctDataPortAdopt(dataPort);
                        if (2 == dataPort) {
                            accEntry.setRbRadiusAcctServerVlanId(vlanId);
                            accEntry.setRbRadiusAcctServerGateway(serverGateway);
                            accEntry.setRbRadiusAcctServerSubnetMask(serverSubnetMask);
                            accEntry.setRbRadiusAcctServerIfcIpAddress(serverIfcIpAddress);
                            if (null != vlanId && (vlanId > 4095 || vlanId < 0)) {
                                invalidValues.add(new InvalidValue(RadiusClientPanel.i18n.translateString("valueNotInRange", new Object[]{0, 4095}), RbRadiusAccountServerEntry.class, RadiusClientPanel.i18n.translateString("VlanId"), model.getValueAt(i, RadiusClientPanelController.COL[8]), (Object)accEntry));
                            }
                            boolean allIPsValid = true;
                            if (!IPv4Validator.isValidIp((String)serverIfcIpAddress)) {
                                invalidValues.add(new InvalidValue(RadiusClientPanel.i18n.translateString("InvalidIpAddress"), RbRadiusAccountServerEntry.class, RadiusClientPanel.i18n.translateString("RadiusIfCIPAddress"), (Object)serverIfcIpAddress, (Object)accEntry));
                                allIPsValid = false;
                            }
                            if (!serverGateway.trim().equals("0.0.0.0") && !serverGateway.trim().equals("")) {
                                if (!IPv4Validator.isValidIp((String)serverGateway)) {
                                    invalidValues.add(new InvalidValue(RadiusClientPanel.i18n.translateString("InvalidIpAddress"), RbRadiusAccountServerEntry.class, RadiusClientPanel.i18n.translateString("RadiusServerGateway"), (Object)serverGateway, (Object)accEntry));
                                    allIPsValid = false;
                                }
                            } else {
                                try {
                                    IpAddress ifcIPAddress = new IpAddress(accEntry.getRbRadiusAcctServerIfcIpAddress().trim());
                                    IpAddress serverSubnet = new IpAddress(accEntry.getRbRadiusAcctServerSubnetMask().trim());
                                    IpAddress serverIP = new IpAddress(accEntry.getRbRadiusAcctServerAddress().trim());
                                    IpAddressRange subnetRange = IpAddressRange.fromSubnet((IpAddress)ifcIPAddress, (IpAddress)serverSubnet);
                                    if (!subnetRange.contains(serverIP)) {
                                        invalidValues.add(new InvalidValue(RadiusClientPanel.i18n.translateString("InvalidIpRangeSubnet"), JTextField.class, RadiusClientPanel.i18n.translateString("RadiusIfCIPAddress"), (Object)accEntry.getRbRadiusAcctServerAddress(), (Object)accEntry.getRbRadiusAcctServerIfcIpAddress()));
                                    } else {
                                        accEntry.setRbRadiusAcctServerGateway("0.0.0.0");
                                    }
                                }
                                catch (IllegalArgumentException e) {
                                    // empty catch block
                                }
                            }
                            if (!IPv4Validator.isValidHostMask((String)serverSubnetMask)) {
                                invalidValues.add(new InvalidValue(RadiusClientPanel.i18n.translateString("InvalidSubnetMask"), RbRadiusAccountServerEntry.class, RadiusClientPanel.i18n.translateString("RadiusServerSubnetMask"), (Object)serverSubnetMask, (Object)accEntry));
                            }
                            if (allIPsValid) {
                                this.checkDuplicateIPs(invalidValues, accEntry, ip, "serverIPAddress", serverGateway, "RadiusServerGateway");
                                this.checkDuplicateIPs(invalidValues, accEntry, serverIfcIpAddress, "RadiusIfCIPAddress", serverGateway, "RadiusServerGateway");
                                this.checkDuplicateIPs(invalidValues, accEntry, serverIfcIpAddress, "RadiusIfCIPAddress", ip, "serverIPAddress");
                            }
                        } else {
                            accEntry.setRbRadiusAcctServerVlanId(null);
                            accEntry.setRbRadiusAcctServerGateway(null);
                            accEntry.setRbRadiusAcctServerSubnetMask(null);
                            accEntry.setRbRadiusAcctServerIfcIpAddress(null);
                        }
                    } else {
                        ip = (String)model.getValueAt(i, 1);
                        accEntry.setRbRadiusAcctServerAddress(ip);
                        Integer n = (Integer)model.getValueAt(i, 2);
                        accEntry.setRbRadiusAcctServerPortNumber(n);
                    }
                    if (RbBaseStationEquipment.SWITCHING_MODE_ETHERNET_CS == productType && ((Boolean)model.getValueAt(i, 5)).booleanValue()) {
                        accEntry.setRbRadiusAcctServerType(1);
                    }
                    if (RbBaseStationEquipment.SWITCHING_MODE_ETHERNET_CS == productType && sameType) {
                        invalidValues.add(new InvalidValue(RadiusClientPanel.i18n.translateString("TwoSameTypeServersError"), RbRadiusAccountServerEntry.class, RadiusClientPanel.i18n.translateString("AcctServer"), model.getValueAt(i, 0), (Object)accEntry));
                        continue block13;
                    }
                    if (var15_23 == null) {
                        invalidValues.add(new InvalidValue(RadiusClientPanel.i18n.translateString("UdpPortError"), RbRadiusAccountServerEntry.class, RadiusClientPanel.i18n.translateString("udpPort"), model.getValueAt(i, 0), (Object)accEntry));
                        continue block13;
                    }
                    if (ip == null || ip.length() == 0) {
                        invalidValues.add(new InvalidValue(RadiusClientPanel.i18n.translateString("WrongIpAddress"), RbRadiusAccountServerEntry.class, RadiusClientPanel.i18n.translateString("AcctServer"), model.getValueAt(i, 0), (Object)accEntry));
                        continue block13;
                    }
                    accEntries.add(accEntry);
                }
            }
        }
        for (RbRadiusAuthServerEntry rbRadiusAuthServerEntry : authEntries) {
            if (!IPv4Validator.isValidIp((String)rbRadiusAuthServerEntry.getRbRadiusAuthServerAddress())) {
                invalidValues.add(new InvalidValue(RadiusClientPanel.i18n.translateString("InvalidIpAddress"), RbRadiusAuthServerEntry.class, RadiusClientPanel.i18n.translateString("AuthServer"), (Object)rbRadiusAuthServerEntry.getRowKey(), (Object)rbRadiusAuthServerEntry));
            }
            if (authTable.findEntry(rbRadiusAuthServerEntry.getRowKey()) == null) continue;
            invalidValues.add(new InvalidValue(RadiusClientPanel.i18n.translateString("DuplicateServerError"), RbRadiusAuthServerEntry.class, RadiusClientPanel.i18n.translateString("AuthServer"), (Object)rbRadiusAuthServerEntry.getRowKey(), (Object)rbRadiusAuthServerEntry));
        }
        for (RbRadiusAccountServerEntry rbRadiusAccountServerEntry : accEntries) {
            if (!IPv4Validator.isValidIp((String)rbRadiusAccountServerEntry.getRbRadiusAcctServerAddress())) {
                invalidValues.add(new InvalidValue(RadiusClientPanel.i18n.translateString("InvalidIpAddress"), RbRadiusAccountServerEntry.class, RadiusClientPanel.i18n.translateString("AcctServer"), (Object)rbRadiusAccountServerEntry.getRowKey(), (Object)rbRadiusAccountServerEntry));
            }
            if (accTable.findEntry(rbRadiusAccountServerEntry.getRowKey()) == null) continue;
            invalidValues.add(new InvalidValue(RadiusClientPanel.i18n.translateString("DuplicateServerError"), RbRadiusAccountServerEntry.class, RadiusClientPanel.i18n.translateString("AcctServer"), (Object)rbRadiusAccountServerEntry.getRowKey(), (Object)rbRadiusAccountServerEntry));
        }
        if (invalidValues.size() == 0) {
            void var15_29;
            RbRadiusAuthServerEntry rbRadiusAuthServerEntry = null;
            boolean bl = false;
            while (var15_29 < authEntries.size()) {
                rbRadiusAuthServerEntry = (RbRadiusAuthServerEntry)((Object)authEntries.get((int)var15_29));
                boolean foundDuplicate = false;
                for (void j = var15_29 + true; j < authEntries.size(); ++j) {
                    if (!rbRadiusAuthServerEntry.getRbRadiusAuthServerAddress().equals(((RbRadiusAuthServerEntry)((Object)authEntries.get((int)j))).getRbRadiusAuthServerAddress())) continue;
                    invalidValues.add(new InvalidValue(RadiusClientPanel.i18n.translateString("DuplicateServerError"), RbRadiusAuthServerEntry.class, RadiusClientPanel.i18n.translateString("AuthServer"), (Object)rbRadiusAuthServerEntry.getRowKey(), (Object)rbRadiusAuthServerEntry));
                    foundDuplicate = true;
                    break;
                }
                if (!foundDuplicate) {
                    authTable.addEntry((TableRowMO)rbRadiusAuthServerEntry);
                }
                ++var15_29;
            }
            Object var15_30 = null;
            for (int i = 0; i < accEntries.size(); ++i) {
                RbRadiusAccountServerEntry rbRadiusAccountServerEntry = (RbRadiusAccountServerEntry)((Object)accEntries.get(i));
                boolean foundDuplicate = false;
                for (int j = i + 1; j < accEntries.size(); ++j) {
                    if (!rbRadiusAccountServerEntry.getRbRadiusAcctServerAddress().equals(((RbRadiusAccountServerEntry)((Object)accEntries.get(j))).getRbRadiusAcctServerAddress())) continue;
                    invalidValues.add(new InvalidValue(RadiusClientPanel.i18n.translateString("DuplicateServerError"), RbRadiusAccountServerEntry.class, RadiusClientPanel.i18n.translateString("AcctServer"), (Object)rbRadiusAccountServerEntry.getRowKey(), (Object)rbRadiusAccountServerEntry));
                    foundDuplicate = true;
                    break;
                }
                if (foundDuplicate) continue;
                accTable.addEntry((TableRowMO)rbRadiusAccountServerEntry);
            }
        }
    }

    public void fillUI(List<Object> managedObjects) {
        SimpleRowTableModel tblAuthenticationServersModel = ((RadiusClientPanel)this.getUI()).getTblAuthenticationServersModel();
        ((RadiusClientPanel)this.getUI()).getController().fillTable(tblAuthenticationServersModel, 1812);
        RbRadiusAuthServerTable authSrvTable = (RbRadiusAuthServerTable)((Object)managedObjects.get(1));
        Integer productType = ((RbBaseStationEquipment)this.ctx.getEquipment()).getSwitchingMode();
        RbBaseStationEquipment bs = (RbBaseStationEquipment)this.ctx.getEquipment();
        boolean version = bs.getSoftwareVersion().isNewerOrEqualWith(RbVersions.V_4_5);
        for (RbRadiusAuthServerEntry entry : authSrvTable.getEntries()) {
            boolean colIdx = true;
            int rowIdx = 0;
            if (RbBaseStationEquipment.SWITCHING_MODE_ETHERNET_CS == productType) {
                rowIdx = entry.getRbRadiusAuthServerIndex() - 1;
                tblAuthenticationServersModel.setInitialValueAt((Object)entry.getRbRadiusAuthServerAddress(), rowIdx, 1);
                tblAuthenticationServersModel.setInitialValueAt((Object)entry.getRbRadiusAuthServerPortNumber(), rowIdx, 2);
                tblAuthenticationServersModel.setInitialValueAt((Object)RadiusClientPanel.i18n.translateString(RbRadiusAuthServerEntry.toStringRbRadiusAuthServerOperStatus(entry.getRbRadiusAuthServerOperStatus())), rowIdx, 3);
                tblAuthenticationServersModel.setInitialValueAt((Object)RadiusClientPanel.i18n.translateString(RbRadiusAuthServerEntry.toStringRbRadiusAuthServerStatus(entry.getRbRadiusAuthServerStatus())), rowIdx, 4);
                tblAuthenticationServersModel.setInitialValueAt((Object)entry.getRbRadiusAuthServerType().equals(1), rowIdx, 5);
            }
            if (RbBaseStationEquipment.SWITCHING_MODE_IP_CS == productType) {
                if (version) {
                    tblAuthenticationServersModel.setInitialValueAt((Object)entry.getRbRadiusAuthServerAddress(), rowIdx, RadiusClientPanelController.COL[1]);
                    tblAuthenticationServersModel.setInitialValueAt((Object)entry.getRbRadiusAuthServerPortNumber(), rowIdx, RadiusClientPanelController.COL[2]);
                    tblAuthenticationServersModel.setInitialValueAt((Object)RadiusClientPanel.i18n.translateString(RbRadiusAuthServerEntry.toStringRbRadiusAuthServerOperStatus(entry.getRbRadiusAuthServerOperStatus())), rowIdx, RadiusClientPanelController.COL[3]);
                    tblAuthenticationServersModel.setInitialValueAt((Object)entry.getRbRadiusAuthServerGateway(), rowIdx, RadiusClientPanelController.COL[6]);
                    tblAuthenticationServersModel.setInitialValueAt((Object)entry.getRbRadiusAuthServerSubnetMask(), rowIdx, RadiusClientPanelController.COL[4]);
                    tblAuthenticationServersModel.setInitialValueAt((Object)entry.getRbRadiusAuthServerIfcIpAddress(), rowIdx, RadiusClientPanelController.COL[5]);
                    tblAuthenticationServersModel.setInitialValueAt(null, rowIdx, RadiusClientPanelController.COL[7]);
                    tblAuthenticationServersModel.setInitialValueAt((Object)entry.getRbRadiusAuthServerVlanId(), rowIdx, RadiusClientPanelController.COL[8]);
                } else {
                    tblAuthenticationServersModel.setInitialValueAt((Object)entry.getRbRadiusAuthServerAddress(), rowIdx, 1);
                    tblAuthenticationServersModel.setInitialValueAt((Object)entry.getRbRadiusAuthServerPortNumber(), rowIdx, 2);
                    tblAuthenticationServersModel.setInitialValueAt((Object)RadiusClientPanel.i18n.translateString(RbRadiusAuthServerEntry.toStringRbRadiusAuthServerOperStatus(entry.getRbRadiusAuthServerOperStatus())), rowIdx, 3);
                }
            }
            tblAuthenticationServersModel.setRowState(rowIdx, 0);
        }
        SimpleRowTableModel tblAccountingServersModel = ((RadiusClientPanel)this.getUI()).getTblAccountingServersModel();
        ((RadiusClientPanel)this.getUI()).getController().fillTable(tblAccountingServersModel, 1813);
        RbRadiusAccountServerTable accSrvTable = (RbRadiusAccountServerTable)((Object)managedObjects.get(2));
        if (accSrvTable != null) {
            for (RbRadiusAccountServerEntry entry : accSrvTable.getEntries()) {
                boolean colIdx = true;
                int rowIdx = 0;
                if (RbBaseStationEquipment.SWITCHING_MODE_ETHERNET_CS == productType) {
                    rowIdx = entry.getRbRadiusAcctServerIndex() - 1;
                    tblAccountingServersModel.setInitialValueAt((Object)entry.getRbRadiusAcctServerAddress(), rowIdx, 1);
                    tblAccountingServersModel.setInitialValueAt((Object)entry.getRbRadiusAcctServerPortNumber(), rowIdx, 2);
                    tblAccountingServersModel.setInitialValueAt((Object)RadiusClientPanel.i18n.translateString(RbRadiusAccountServerEntry.toStringRbRadiusAcctServerOperStatus(entry.getRbRadiusAcctServerOperStatus())), rowIdx, 3);
                    tblAccountingServersModel.setInitialValueAt((Object)RadiusClientPanel.i18n.translateString(RbRadiusAccountServerEntry.toStringRbRadiusAcctServerStatus(entry.getRbRadiusAcctServerStatus())), rowIdx, 4);
                    tblAccountingServersModel.setInitialValueAt((Object)entry.getRbRadiusAcctServerType().equals(1), rowIdx, 5);
                }
                if (RbBaseStationEquipment.SWITCHING_MODE_IP_CS == productType) {
                    if (version) {
                        tblAccountingServersModel.setInitialValueAt((Object)entry.getRbRadiusAcctServerAddress(), rowIdx, RadiusClientPanelController.COL[1]);
                        tblAccountingServersModel.setInitialValueAt((Object)entry.getRbRadiusAcctServerPortNumber(), rowIdx, RadiusClientPanelController.COL[2]);
                        tblAccountingServersModel.setInitialValueAt((Object)RadiusClientPanel.i18n.translateString(RbRadiusAccountServerEntry.toStringRbRadiusAcctServerOperStatus(entry.getRbRadiusAcctServerOperStatus())), rowIdx, RadiusClientPanelController.COL[3]);
                        tblAccountingServersModel.setInitialValueAt((Object)entry.getRbRadiusAcctServerGateway(), rowIdx, RadiusClientPanelController.COL[6]);
                        tblAccountingServersModel.setInitialValueAt((Object)entry.getRbRadiusAcctServerSubnetMask(), rowIdx, RadiusClientPanelController.COL[4]);
                        tblAccountingServersModel.setInitialValueAt((Object)entry.getRbRadiusAcctServerIfcIpAddress(), rowIdx, RadiusClientPanelController.COL[5]);
                        tblAccountingServersModel.setInitialValueAt(null, rowIdx, RadiusClientPanelController.COL[7]);
                        tblAccountingServersModel.setInitialValueAt((Object)entry.getRbRadiusAcctServerVlanId(), rowIdx, RadiusClientPanelController.COL[8]);
                    } else {
                        tblAccountingServersModel.setInitialValueAt((Object)entry.getRbRadiusAcctServerAddress(), rowIdx, 1);
                        tblAccountingServersModel.setInitialValueAt((Object)entry.getRbRadiusAcctServerPortNumber(), rowIdx, 2);
                        tblAccountingServersModel.setInitialValueAt((Object)RadiusClientPanel.i18n.translateString(RbRadiusAccountServerEntry.toStringRbRadiusAcctServerOperStatus(entry.getRbRadiusAcctServerOperStatus())), rowIdx, 3);
                    }
                }
                tblAccountingServersModel.setRowState(rowIdx, 0);
            }
        }
    }

    public String getTitle() {
        return "RadiusClient";
    }

    public String getHelpTopic() {
        return "ngnms.rb.help.bs_tdd_radius_client";
    }
}

