/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.TableBinder;
import com.bwanms.gui.binding.TableColumnBinding;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.FormsConfigSectionView;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.mo.TableRowMO;
import com.bwanms.mo.snmp.SNMPTableMO;
import com.bwanms.rb.gui.configuration.RadioClustersPanel;
import com.bwanms.rb.mo.RbOduConfigEntry;
import com.bwanms.rb.mo.RbOduConfigTable;
import com.bwanms.rb.mo.RbRadioClusterEntry;
import com.bwanms.rb.mo.RbRadioClusterTable;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FormUtil;
import com.bwanms.util.MessageBox;
import com.bwanms.util.TableUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RadioClustersConfigForm
extends ManagedObjectsConfigForm<RadioClustersPanel> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RadioClustersConfigForm.class);
    private List<Integer> usedClusters = new ArrayList<Integer>();

    public RadioClustersPanel initUIComponent() {
        return new RadioClustersPanel();
    }

    public List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("BS", RbRadioClusterTable.class));
        ret.add(this.ctx.createRequest("BS", RbOduConfigTable.class));
        return ret;
    }

    public void fillUI(List<Object> managedObjects) {
        SimpleRowTableModel model = ((RadioClustersPanel)this.getUI()).getTable2Model();
        FormUtil.cancelTableEditing((JTable)((RadioClustersPanel)this.getUI()).getTable2());
        model.clearTable();
        RbRadioClusterTable clusterTable = (RbRadioClusterTable)((Object)managedObjects.get(0));
        for (int i = 0; i < this.getRowsNumber(); ++i) {
            model.addNewRow(Integer.toString(i + 1), true);
            model.setRowState(i, 4);
            model.setInitialValueAt((Object)(i + 1), i, 0);
        }
        int counter = 0;
        for (RbRadioClusterEntry entry : clusterTable.getEntries()) {
            counter = entry.getRbRadioClusterId() - 1;
            if (counter >= this.getRowsNumber()) continue;
            model.setInitialValueAt((Object)entry.getRbRadioClusterName(), counter, 1);
            model.setInitialValueAt((Object)entry.getRbRadioClusterLocation(), counter, 2);
            model.setInitialValueAt((Object)entry.getRbRadioClusterSectorHeading(), counter, 3);
            model.setInitialValueAt((Object)entry.getRbRadioClusterSectorBeamWidth(), counter, 4);
            model.setRowState(counter, 0);
        }
        this.usedClusters.clear();
        RbOduConfigTable table = (RbOduConfigTable)((Object)managedObjects.get(1));
        if (table != null) {
            for (RbOduConfigEntry entry : table.getEntries()) {
                this.usedClusters.add(entry.getRbOduAssociatedRadioClusterId());
            }
        }
        TableUtil.autoResizeColumn((JTable)((RadioClustersPanel)this.getUI()).getTable2(), (int)0, (boolean)true);
        model.sort();
        FormsConfigSectionView formsConfigSectionView = (FormsConfigSectionView)this.getConfigSectionView();
        String clusterId = String.valueOf(formsConfigSectionView.getAttribute("clusterId"));
        if (clusterId != null) {
            try {
                int chanelIdInt = Integer.parseInt(clusterId) - 1;
                ((RadioClustersPanel)this.getUI()).getTable2().setRowSelectionInterval(chanelIdInt, chanelIdInt);
            }
            catch (Exception e) {}
        } else {
            ((RadioClustersPanel)this.getUI()).getTable2().clearSelection();
        }
    }

    public List<Object> configureManagedObjects(List<InvalidValue> invalidValues) {
        List managedObjects = super.configureManagedObjects(invalidValues);
        managedObjects.remove(1);
        return managedObjects;
    }

    public void configureMOs(List<Object> managedObjects) {
        SimpleRowTableModel model = ((RadioClustersPanel)this.getUI()).getTable2Model();
        FormUtil.stopTableEditing((JTable)((RadioClustersPanel)this.getUI()).getTable2());
        RbRadioClusterTable clusterTable = (RbRadioClusterTable)((Object)managedObjects.get(0));
        ArrayList<String> notDeletedClusters = new ArrayList<String>();
        block5: for (int i = 0; i < model.getRowCount(); ++i) {
            RbRadioClusterEntry entry = (RbRadioClusterEntry)clusterTable.findEntry(model.getRowKey(i));
            switch (model.getRowState(i)) {
                case 3: {
                    entry.setRbRadioClusterName((String)model.getValueAt(i, 1));
                    entry.setRbRadioClusterLocation((String)model.getValueAt(i, 2));
                    entry.setRbRadioClusterSectorHeading((Integer)model.getValueAt(i, 3));
                    entry.setRbRadioClusterSectorBeamWidth((Integer)model.getValueAt(i, 4));
                    continue block5;
                }
                case 1: {
                    if (!this.usedClusters.contains(entry.getRbRadioClusterId())) {
                        clusterTable.removeEntry(entry.getRowKey());
                        continue block5;
                    }
                    notDeletedClusters.add(entry.getRbRadioClusterName());
                    continue block5;
                }
                case 5: {
                    boolean addEntry = true;
                    if (entry != null) {
                        addEntry = false;
                    } else {
                        entry = new RbRadioClusterEntry();
                        entry.setRbRadioClusterId(Integer.valueOf(model.getRowKey(i)));
                        addEntry = true;
                    }
                    entry.setRbRadioClusterName((String)model.getValueAt(i, 1));
                    entry.setRbRadioClusterLocation((String)model.getValueAt(i, 2));
                    entry.setRbRadioClusterSectorHeading((Integer)model.getValueAt(i, 3));
                    entry.setRbRadioClusterSectorBeamWidth((Integer)model.getValueAt(i, 4));
                    if (!addEntry) continue block5;
                    clusterTable.addEntry((TableRowMO)entry);
                }
            }
        }
        if (!notDeletedClusters.isEmpty()) {
            MessageBox.Alert.quickShow((Component)this.getUI(), i18n.translateString("radioClustersNotDeleted", new Object[]{((Object)notDeletedClusters).toString()}));
            notDeletedClusters.clear();
        }
    }

    public String getTitle() {
        return "RadioClusters";
    }

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        RadioClustersPanel cfr_ignored_0 = (RadioClustersPanel)this.getUI();
        TableBinder binder = new TableBinder(RadioClustersPanel.getI18n(), ((RadioClustersPanel)this.getUI()).getTable2Model(), (SNMPTableMO)managedObjects.get(0));
        binder.add((Binding)new TableColumnBinding("Name", "rbRadioClusterName"));
        binder.add((Binding)new TableColumnBinding("Location", "rbRadioClusterLocation"));
        binder.add((Binding)new TableColumnBinding("SectorHeading", "rbRadioClusterSectorHeading"));
        binder.add((Binding)new TableColumnBinding("BeamWidth", "rbRadioClusterSectorBeamWidth"));
        binders.add((Binder)binder);
    }

    public abstract int getRowsNumber();
}

