/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JComboBoxBinding;
import com.bwanms.gui.binding.UnifiedTableBinder;
import com.bwanms.gui.binding.UnifiedTableColumnBinding;
import com.bwanms.gui.binding.translators.IntegerValueTranslator;
import com.bwanms.gui.binding.translators.ValueTranslator;
import com.bwanms.gui.configuration.UnifiedMOsConfigForm;
import com.bwanms.mo.ManagedObject;
import com.bwanms.mo.UnifiedMOSupport;
import com.bwanms.model.Equipment;
import com.bwanms.rb.gui.configuration.QinQPanel;
import com.bwanms.rb.mo.RbQinQConfig;
import com.bwanms.rb.mo.RbQinQEntry;
import com.bwanms.rb.model.RbMBS;
import com.bwanms.services.UnifiedMORequest;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FormUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QinQConfigForm
extends UnifiedMOsConfigForm<QinQPanel> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(QinQConfigForm.class);
    private static final Logger log = Logger.getLogger(QinQConfigForm.class);

    public QinQPanel initUIComponent() {
        return new QinQPanel();
    }

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        UnifiedTableBinder binder = new UnifiedTableBinder(QinQPanel.getI18n(), ((QinQPanel)this.getUI()).getTable2(), (UnifiedMOSupport)managedObjects.get(0));
        binder.add((Binding)new UnifiedTableColumnBinding("S/N", "rbQinQVlanRangeIdx"));
        binder.add((Binding)new UnifiedTableColumnBinding("MetroTag", "rbQinQMetroTag", (ValueTranslator)IntegerValueTranslator.instance()));
        binder.add((Binding)new UnifiedTableColumnBinding("StartVLAN", "rbQinQStartVlanRange", (ValueTranslator)IntegerValueTranslator.instance()));
        binder.add((Binding)new UnifiedTableColumnBinding("EndVLAN", "rbQinQEndVlanRange", (ValueTranslator)IntegerValueTranslator.instance()));
        binders.add((Binder)binder);
        RbQinQConfig rbQinQConfig = (RbQinQConfig)((UnifiedMOSupport)managedObjects.get(1)).findInstance("0");
        DefaultBinder binder2 = new DefaultBinder((Object)this.getUI(), (Object)rbQinQConfig);
        JComboBoxBinding binding = new JComboBoxBinding(i18n, "cmbEtherType", "rbQinQEtherType", i18n.translateString("EtherType"));
        binder2.add((Binding)binding);
        binders.add((Binder)binder2);
    }

    public List<UnifiedMORequest> getManagedObjectRequests() {
        ArrayList<UnifiedMORequest> ret = new ArrayList<UnifiedMORequest>();
        ret.add((UnifiedMORequest)this.ctx.createRequest("BS", RbQinQEntry.class));
        ret.add((UnifiedMORequest)this.ctx.createRequest("BS", RbQinQConfig.class));
        return ret;
    }

    protected void fillUI(List<Object> managedObjects) {
        FormUtil.cancelTableEditing((JTable)((QinQPanel)this.getUI()).getTable2());
        Equipment equipment = ((RbQinQConfig)((UnifiedMOSupport)managedObjects.get(1)).findInstance("0")).getNRConfiguration().getConfigurationEquipment();
        if (equipment instanceof RbMBS) {
            ((QinQPanel)this.getUI()).getController().setMaxNoRows(2);
        }
        ((QinQPanel)this.getUI()).getBtnAdd().setEnabled(((QinQPanel)this.getUI()).getTable2Model().getRowCount() < ((QinQPanel)this.getUI()).getController().getMaxNoRows());
        ((QinQPanel)this.getUI()).getTable2Model().sort();
    }

    public void configureMOs(List<Object> managedObjects, List<InvalidValue> invalidValues) {
        log.debug((Object)("configureMOs " + managedObjects + " invalidValues " + invalidValues));
        UnifiedMOSupport qinQTable = (UnifiedMOSupport)managedObjects.get(0);
        RbQinQConfig qinQConfig = (RbQinQConfig)((UnifiedMOSupport)managedObjects.get(1)).findInstance("0");
        SimpleRowTableModel model = ((QinQPanel)this.getUI()).getTable2Model();
        FormUtil.stopTableEditing((JTable)((QinQPanel)this.getUI()).getTable2());
        Integer[] indexs = new Integer[model.getRowCount()];
        Integer[][] vlans = new Integer[model.getRowCount()][2];
        boolean validateRow = true;
        block5: for (int i = 0; i < model.getRowCount(); ++i) {
            SimpleRowTableModel.TableRow tableRow = model.getTableRow(i);
            validateRow = this.validateRow(invalidValues, indexs, vlans, i, tableRow);
            Integer idx = (Integer)tableRow.getValue(0);
            String instance = idx.toString();
            log.debug((Object)("instance " + instance));
            if (!validateRow) continue;
            switch (model.getRowState(i)) {
                case 3: {
                    RbQinQEntry entry = (RbQinQEntry)qinQTable.findInstance(instance);
                    entry.setInstance(instance);
                    entry.setRbQinQVlanRangeIdx(idx);
                    entry.setRbQinQMetroTag(new Integer((String)tableRow.getValue(1)));
                    entry.setRbQinQStartVlanRange(new Integer((String)tableRow.getValue(2)));
                    entry.setRbQinQEndVlanRange(new Integer((String)tableRow.getValue(3)));
                    continue block5;
                }
                case 1: {
                    qinQTable.removeInstance(instance);
                    continue block5;
                }
                case 2: {
                    RbQinQEntry entry = new RbQinQEntry();
                    entry.setInstance(instance);
                    entry.setRbQinQVlanRangeIdx(idx);
                    entry.setRbQinQMetroTag(new Integer((String)tableRow.getValue(1)));
                    entry.setRbQinQStartVlanRange(new Integer((String)tableRow.getValue(2)));
                    entry.setRbQinQEndVlanRange(new Integer((String)tableRow.getValue(3)));
                    if (!invalidValues.isEmpty()) continue block5;
                    qinQTable.addInstance((ManagedObject)entry);
                }
            }
        }
        qinQConfig.setRbQinQEtherType((Integer)((ComboItem)((QinQPanel)this.getUI()).getCmbEtherType().getSelectedItem()).getValue());
    }

    public String getTitle() {
        return "QinQ";
    }

    public String getHelpTopic() {
        return "ngnms.rb.help.bs_QinQ";
    }

    public boolean forceRefresh() {
        return false;
    }

    private boolean validateRow(List<InvalidValue> invalidValues, Integer[] indexs, Integer[][] vlans, int i, SimpleRowTableModel.TableRow tableRow) {
        String metroTag;
        boolean result = true;
        Integer idx = (Integer)tableRow.getValue(0);
        if (this.validateMandatory(idx, "rangeIdx.mandatory", Integer.class, "S/N", invalidValues)) {
            if (idx < 1 || idx > ((QinQPanel)this.getUI()).getController().getMaxNoRows()) {
                invalidValues.add(new InvalidValue(i18n.translateString("rangeIdx.outofrange", new Object[]{1, ((QinQPanel)this.getUI()).getController().getMaxNoRows()}), Integer.class, i18n.translateString("S/N"), (Object)idx, null));
                result = false;
            }
            for (int j = 0; j < indexs.length; ++j) {
                if (indexs[j] == null || !indexs[j].equals(idx)) continue;
                invalidValues.add(new InvalidValue(i18n.translateString("rangeIdx.duplicatevalue"), Integer.class, i18n.translateString("S/N"), (Object)idx, null));
                result = false;
            }
            indexs[i] = idx;
        }
        if (!(this.validateMandatory(metroTag = (String)tableRow.getValue(1), "metroTag.mandatory", Integer.class, "MetroTag", invalidValues) && this.validateInteger(metroTag, "metroTag.notinteger", "MetroTag", invalidValues) && this.validateRange(Integer.parseInt(metroTag), 0, 4094, "metroTag.outofrange", idx, "MetroTag", invalidValues))) {
            result = false;
        }
        String strStartVLAN = (String)tableRow.getValue(2);
        String strEndVLAN = (String)tableRow.getValue(3);
        boolean startValid = false;
        if (this.validateMandatory(strStartVLAN, "startVLAN.mandatory", Integer.class, "StartVLAN", invalidValues) && this.validateInteger(strStartVLAN, "startVLAN..notinteger", "StartVLAN", invalidValues) && this.validateRange(Integer.parseInt(strStartVLAN), 0, 4094, "startVLAN.outofrange", idx, "StartVLAN", invalidValues)) {
            startValid = true;
        } else {
            result = false;
        }
        boolean endValid = false;
        if (this.validateMandatory(strEndVLAN, "endVLAN.mandatory", Integer.class, "EndVLAN", invalidValues) && this.validateInteger(strEndVLAN, "endVLAN.nointeger", "EndVLAN", invalidValues) && this.validateRange(Integer.parseInt(strEndVLAN), 0, 4094, "endVLAN.outofrange", idx, "EndVLAN", invalidValues)) {
            endValid = true;
        } else {
            result = false;
        }
        if (result) {
            Integer startVLAN = new Integer(strStartVLAN);
            Integer endVLAN = new Integer(strEndVLAN);
            if (startValid && endValid && startVLAN > endVLAN) {
                invalidValues.add(new InvalidValue(i18n.translateString("vlanrange.invalid", new Object[]{idx == null ? "" : idx, startVLAN, endVLAN}), RbQinQEntry.class, i18n.translateString("vlanrange"), (Object)"", (Object)""));
                result = false;
            }
            for (int j = 0; j < vlans.length; ++j) {
                if (vlans[j][0] == null || vlans[j][1] == null || endVLAN < vlans[j][0] || startVLAN > vlans[j][1]) continue;
                invalidValues.add(new InvalidValue(i18n.translateString("vlanrange.overlap"), RbQinQEntry.class, i18n.translateString("vlanrange"), (Object)"", (Object)""));
                result = false;
            }
            vlans[i][0] = startVLAN;
            vlans[i][1] = endVLAN;
        }
        return result;
    }

    private boolean validateMandatory(Object value, String messageKey, Class clazz, String columnHeader, List<InvalidValue> invalidValues) {
        if (value == null) {
            invalidValues.add(new InvalidValue(i18n.translateString(messageKey), clazz, i18n.translateString(columnHeader), (Object)"", null));
            return false;
        }
        return true;
    }

    private boolean validateInteger(String value, String messagekey, String columnHeader, List<InvalidValue> invalidValues) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean validateRange(int value, Integer min, Integer max, String message, Integer idx, String columnHeader, List<InvalidValue> invalidValues) {
        if (value < min || value > max) {
            invalidValues.add(new InvalidValue(i18n.translateString(message, new Object[]{idx == null ? "" : idx, min, max}), Integer.class, i18n.translateString(columnHeader), (Object)value, null));
            return false;
        }
        return true;
    }
}

