/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.rb.gui.configuration.PFParametersPanelController;
import com.bwanms.rb.gui.configuration.RadiusClientPanel;
import com.bwanms.rb.mo.RbBSPFServersEntry;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.SimpleRowTable;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.Comparator;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.DefaultFormatter;

public class PFParametersPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final Internationalizer i18n = Internationalizer.getInternationalizer(RadiusClientPanel.class);
    private boolean canChange = true;
    private PFParametersPanelController controller;
    private SimpleRowTableModel tblPFServerTableModel;
    private boolean version;
    private boolean isNewPFNoLimit;
    private Color colorDisabled = new Color(235, 235, 235);
    private JComponent sprGeneralParameters;
    private JLabel lblRetryInterval;
    private JSpinner spnRetryInterval;
    private JLabel lblNumberOfRetries;
    private JSpinner spnNumberOfRetries;
    private JLabel lblKeepAliveTimeout;
    private JSpinner spnKeepAliveTimeout;
    private JLabel lblPFListenerPort;
    private JSpinner spnPFListenerPort;
    private JLabel lblPFSIPUdpPortNumber;
    private JSpinner spnPFSIPUdpPortNumber;
    private JPanel pnlPFServers;
    private JComponent sprPFServers;
    private JButton btnRevert;
    private JButton btnDelete;
    private JButton btnAdd;
    private JScrollPane pnlPFServer;
    private JTable tblPFServer;

    public PFParametersPanel(boolean version, boolean newLimit) {
        this.initComponents();
        this.version = version;
        this.isNewPFNoLimit = newLimit;
        this.lblKeepAliveTimeout.setVisible(false);
        this.spnKeepAliveTimeout.setVisible(false);
        this.postInitComponents();
    }

    public boolean getVersion() {
        return this.version;
    }

    private void postInitComponents() {
        SimpleRowTable srTable;
        i18n.getSwingInternationalizer().translateComponent((Component)this);
        ComboItem[] adoptDataPortItems = new ComboItem[]{new ComboItem((Object)1, i18n.translateString("DTPA_Yes")), new ComboItem((Object)2, i18n.translateString("DTPA_No"))};
        ComboItem[] operStatusItems = new ComboItem[]{new ComboItem((Object)1, i18n.translateString(RbBSPFServersEntry.toStringRbPFServerOperStatus(1))), new ComboItem((Object)2, i18n.translateString(RbBSPFServersEntry.toStringRbPFServerOperStatus(2)))};
        if (this.version) {
            this.lblKeepAliveTimeout.setVisible(true);
            this.spnKeepAliveTimeout.setVisible(true);
            this.tblPFServer.getTableHeader().setDefaultRenderer(new WordWrapTableHeadRenderer());
            this.tblPFServerTableModel = new SimpleRowTableModel(new SimpleRowTableModel.ColumnDefinition[]{new SimpleRowTableModel.ColumnDefinition(i18n.translateString("serverIPAddress"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("udpPort"), Integer.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("SharedSecret"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("RetypeSharedSecret"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("AdoptDataPort"), Integer.class, adoptDataPortItems), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("VLANId"), Integer.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("ifCIPAddress"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("ifCSubnetMask"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("serverGateway"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("OperatorStatus"), Integer.class, operStatusItems)}, this.tblPFServer.getTableHeader());
            srTable = new SimpleRowTable(this.tblPFServer, this.tblPFServerTableModel);
            srTable.setComboCellEditor(4);
            srTable.setComboCellEditor(9);
            this.tblPFServerTableModel.setColumnReadonly(0, true);
            this.tblPFServerTableModel.setColumnReadonly(9, true);
            this.tblPFServerTableModel.setNewColumnReadonly(9, true);
        } else {
            this.tblPFServerTableModel = new SimpleRowTableModel(new SimpleRowTableModel.ColumnDefinition[]{new SimpleRowTableModel.ColumnDefinition(i18n.translateString("serverIPAddress"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("udpPort"), Integer.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("VLANId"), Integer.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("SharedSecret"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("RetypeSharedSecret"), String.class)}, this.tblPFServer.getTableHeader());
            srTable = new SimpleRowTable(this.tblPFServer, this.tblPFServerTableModel);
            for (int i = 0; i < 3; ++i) {
                this.tblPFServerTableModel.setColumnReadonly(i, true);
            }
        }
        this.tblPFServerTableModel.setNewRowReadOnlyOverride(true);
        this.tblPFServerTableModel.setColumnComparator(Integer.valueOf(0), SimpleRowTableModel.IP_ADDRESS_COMPARATOR);
        Comparator<String> sBuggyComparator = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return 0;
            }
        };
        if (this.version) {
            this.tblPFServerTableModel.setColumnComparator(Integer.valueOf(2), (Comparator)sBuggyComparator);
            this.tblPFServerTableModel.setColumnComparator(Integer.valueOf(3), (Comparator)sBuggyComparator);
        } else {
            this.tblPFServerTableModel.setColumnComparator(Integer.valueOf(3), (Comparator)sBuggyComparator);
            this.tblPFServerTableModel.setColumnComparator(Integer.valueOf(4), (Comparator)sBuggyComparator);
        }
        DefaultFormatter portFormatter = new DefaultFormatter(){
            private static final long serialVersionUID = -3433286437646488341L;

            public Object stringToValue(String text) throws ParseException {
                int port;
                if (text.equals("")) {
                    return null;
                }
                try {
                    port = Integer.parseInt(text);
                    if (port < 1 || port > 65535) {
                        throw new ParseException("Port number must be between 0 and 65535", 0);
                    }
                }
                catch (NumberFormatException nfe) {
                    throw new ParseException("Wrong port number format", 0);
                }
                return port;
            }
        };
        DefaultFormatter vlanIdFormatter = new DefaultFormatter(){
            private static final long serialVersionUID = -3433286437646488341L;

            public Object stringToValue(String text) throws ParseException {
                int vlanId;
                if (text.equals("")) {
                    return null;
                }
                try {
                    vlanId = Integer.parseInt(text);
                    if (vlanId < 0 || vlanId > 4094) {
                        throw new ParseException("VLAN ID must be between 0 and 4095", 0);
                    }
                }
                catch (NumberFormatException nfe) {
                    throw new ParseException("Wrong VLAN ID format", 0);
                }
                if (text.equals("4095")) {
                    return null;
                }
                return vlanId;
            }
        };
        portFormatter.setOverwriteMode(false);
        portFormatter.setAllowsInvalid(false);
        portFormatter.setCommitsOnValidEdit(true);
        srTable.setFormattedTextCellEditor(1, portFormatter);
        vlanIdFormatter.setOverwriteMode(false);
        vlanIdFormatter.setAllowsInvalid(false);
        vlanIdFormatter.setCommitsOnValidEdit(true);
        if (this.version) {
            srTable.setFormattedTextCellEditor(5, vlanIdFormatter);
        } else {
            srTable.setFormattedTextCellEditor(2, vlanIdFormatter);
        }
        this.controller = new PFParametersPanelController(this);
        if (this.isNewPFNoLimit) {
            this.controller.setMaxNoOfPFServer(10);
        } else {
            this.controller.setMaxNoOfPFServer(20);
        }
        this.tblPFServerTableModel.addTableModelListener((TableModelListener)((Object)this.controller));
        class PasswordCellRenderer
        implements TableCellRenderer {
            private JPasswordField jpf = new JPasswordField();

            PasswordCellRenderer() {
            }

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value == null) {
                    this.jpf.setText("********");
                } else {
                    this.jpf.setText(value.toString());
                }
                this.jpf.setBorder(table.getBorder());
                this.jpf.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                return this.jpf;
            }
        }
        PasswordCellRenderer passwordCellRenderer = new PasswordCellRenderer();
        DefaultCellEditor passwordCellEditor = new DefaultCellEditor(new JPasswordField());
        if (this.version) {
            this.tblPFServer.getColumnModel().getColumn(2).setCellEditor(passwordCellEditor);
            this.tblPFServer.getColumnModel().getColumn(2).setCellRenderer(passwordCellRenderer);
            this.tblPFServer.getColumnModel().getColumn(3).setCellEditor(passwordCellEditor);
            this.tblPFServer.getColumnModel().getColumn(3).setCellRenderer(passwordCellRenderer);
        } else {
            this.tblPFServer.getColumnModel().getColumn(3).setCellEditor(passwordCellEditor);
            this.tblPFServer.getColumnModel().getColumn(3).setCellRenderer(passwordCellRenderer);
            this.tblPFServer.getColumnModel().getColumn(4).setCellEditor(passwordCellEditor);
            this.tblPFServer.getColumnModel().getColumn(4).setCellRenderer(passwordCellRenderer);
        }
        ((JTextField)((DefaultCellEditor)this.tblPFServer.getDefaultEditor(Integer.class)).getComponent()).setHorizontalAlignment(2);
    }

    public JSpinner getSpnPFListenerPort() {
        return this.spnPFListenerPort;
    }

    public JSpinner getSpnPFSIPUdpPortNumber() {
        return this.spnPFSIPUdpPortNumber;
    }

    private void initComponents() {
        DefaultComponentFactory compFactory = DefaultComponentFactory.getInstance();
        this.sprGeneralParameters = compFactory.createSeparator("GeneralParameters");
        this.lblRetryInterval = new JLabel();
        this.spnRetryInterval = new JSpinner();
        this.lblNumberOfRetries = new JLabel();
        this.spnNumberOfRetries = new JSpinner();
        this.lblKeepAliveTimeout = new JLabel();
        this.spnKeepAliveTimeout = new JSpinner();
        this.lblPFListenerPort = new JLabel();
        this.spnPFListenerPort = new JSpinner();
        this.lblPFSIPUdpPortNumber = new JLabel();
        this.spnPFSIPUdpPortNumber = new JSpinner();
        this.pnlPFServers = new JPanel();
        this.sprPFServers = compFactory.createSeparator("PFServersTable");
        this.btnRevert = new JButton();
        this.btnDelete = new JButton();
        this.btnAdd = new JButton();
        this.pnlPFServer = new JScrollPane();
        this.tblPFServer = new JTable(){

            public void valueChanged(ListSelectionEvent e) {
                super.valueChanged(e);
                PFParametersPanel.this.controller.controlTableButtons();
            }
        };
        CellConstraints cc = new CellConstraints();
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.DEFAULT, 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.dluX((int)70)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}));
        this.add((Component)this.sprGeneralParameters, cc.xywh(1, 1, 7, 1));
        this.lblRetryInterval.setText("retryInterval");
        this.add((Component)this.lblRetryInterval, cc.xy(3, 3));
        this.spnRetryInterval.setModel(new SpinnerNumberModel((Number)5, null, null, (Number)1));
        this.spnRetryInterval.setToolTipText("1..60");
        this.spnRetryInterval.setMinimumSize(new Dimension(36, 20));
        this.spnRetryInterval.setPreferredSize(new Dimension(66, 20));
        this.add((Component)this.spnRetryInterval, cc.xy(5, 3));
        this.lblNumberOfRetries.setText("numberOfRetries");
        this.add((Component)this.lblNumberOfRetries, cc.xy(3, 5));
        this.spnNumberOfRetries.setModel(new SpinnerNumberModel((Number)3, null, null, (Number)1));
        this.spnNumberOfRetries.setToolTipText("0..5");
        this.spnNumberOfRetries.setMinimumSize(new Dimension(36, 20));
        this.spnNumberOfRetries.setPreferredSize(new Dimension(66, 20));
        this.add((Component)this.spnNumberOfRetries, cc.xy(5, 5));
        this.lblKeepAliveTimeout.setText("KeepAliveTimeout");
        this.add((Component)this.lblKeepAliveTimeout, cc.xy(3, 7));
        this.spnKeepAliveTimeout.setModel(new SpinnerNumberModel((Number)180, null, null, (Number)1));
        this.spnKeepAliveTimeout.setToolTipText("60..300");
        this.spnKeepAliveTimeout.setMinimumSize(new Dimension(36, 20));
        this.spnKeepAliveTimeout.setPreferredSize(new Dimension(66, 20));
        this.add((Component)this.spnKeepAliveTimeout, cc.xy(5, 7));
        this.lblPFListenerPort.setText("PFListenerPort");
        this.add((Component)this.lblPFListenerPort, cc.xy(3, 9));
        this.add((Component)this.spnPFListenerPort, cc.xy(5, 9));
        this.lblPFSIPUdpPortNumber.setText("PFSIPUdpPortNumber");
        this.add((Component)this.lblPFSIPUdpPortNumber, cc.xy(3, 11));
        this.add((Component)this.spnPFSIPUdpPortNumber, cc.xy(5, 11));
        this.pnlPFServers.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.pnlPFServers.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.dluX((int)22), 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.BUTTON_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.BUTTON_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.BUTTON_COLSPEC, new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.DLUX3, 0.0), FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0), new RowSpec(RowSpec.TOP, (Size)Sizes.DLUY6, 0.0)}));
        this.pnlPFServers.add((Component)this.sprPFServers, cc.xywh(1, 1, 11, 1));
        this.btnRevert.setText("Revert");
        this.btnRevert.setEnabled(false);
        this.btnRevert.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PFParametersPanel.this.btnRevertActionPerformed(e);
            }
        });
        this.pnlPFServers.add((Component)this.btnRevert, cc.xy(5, 3));
        this.btnDelete.setText("Delete");
        this.btnDelete.setEnabled(false);
        this.btnDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PFParametersPanel.this.btnDeleteActionPerformed(e);
            }
        });
        this.pnlPFServers.add((Component)this.btnDelete, cc.xy(7, 3));
        this.btnAdd.setText("Add");
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PFParametersPanel.this.btnAddActionPerformed(e);
            }
        });
        this.pnlPFServers.add((Component)this.btnAdd, cc.xy(9, 3));
        this.pnlPFServer.setPreferredSize(new Dimension(452, 350));
        this.tblPFServer.setRowHeight(20);
        this.tblPFServer.setIntercellSpacing(new Dimension(2, 1));
        this.pnlPFServer.setViewportView(this.tblPFServer);
        this.pnlPFServers.add((Component)this.pnlPFServer, cc.xywh(3, 5, 7, 2));
        this.add((Component)this.pnlPFServers, cc.xywh(1, 13, 7, 1));
    }

    public JSpinner getSpnRetryInterval() {
        return this.spnRetryInterval;
    }

    public JSpinner getSpnNumberOfRetries() {
        return this.spnNumberOfRetries;
    }

    private void btnRevertActionPerformed(ActionEvent e) {
        this.controller.btnRevertMouseClicked();
    }

    private void btnDeleteActionPerformed(ActionEvent e) {
        this.controller.btnDeleteMouseClicked();
    }

    private void btnAddActionPerformed(ActionEvent e) {
        this.controller.btnAddMouseClicked();
    }

    public JButton getBtnRevert() {
        return this.btnRevert;
    }

    public JButton getBtnDelete() {
        return this.btnDelete;
    }

    public JButton getBtnAdd() {
        return this.btnAdd;
    }

    public JTable getTblPFServer() {
        return this.tblPFServer;
    }

    public SimpleRowTableModel getTblPFServerTableModel() {
        return this.tblPFServerTableModel;
    }

    public JSpinner getSpnKeepAliveTimeout() {
        return this.spnKeepAliveTimeout;
    }

    private static class WordWrapTableHeadRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;
        private JTextArea jta = new JTextArea();
        private JLabel iconLabel = new JLabel();

        public WordWrapTableHeadRenderer() {
            this.setPreferredSize(new Dimension(100, 50));
            this.setLayout(new BorderLayout(0, 0));
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.jta.setWrapStyleWord(true);
            this.jta.setLineWrap(true);
            this.jta.setOpaque(false);
            this.add((Component)this.jta, "Center");
            this.add((Component)this.iconLabel, "East");
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.jta.setText(value == null ? "" : value.toString());
            this.setToolTipText(value == null ? "" : value.toString());
            return this;
        }
    }
}

