/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JSpinnerBinding;
import com.bwanms.gui.binding.TableBinder;
import com.bwanms.gui.binding.TableColumnBinding;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.FormsConfigSectionView;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.mo.TableRowMO;
import com.bwanms.mo.snmp.DynamicTableRowMO;
import com.bwanms.mo.snmp.SNMPTableMO;
import com.bwanms.rb.gui.configuration.PFParametersPanel;
import com.bwanms.rb.mo.RbBSPFServersEntry;
import com.bwanms.rb.mo.RbBSPFServersTable;
import com.bwanms.rb.mo.RbPFGeneralParameters;
import com.bwanms.rb.mo.RbRegisteredSuEntry;
import com.bwanms.rb.mo.services.RbVoiceDomainsEntry;
import com.bwanms.rb.mo.services.RbVoiceDomainsTable;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.util.RbFeatures;
import com.bwanms.rb.util.RbVersions;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FormUtil;
import com.bwanms.util.IpAddress;
import com.bwanms.util.IpAddressRange;
import com.bwanms.util.PlatformConfiguration;
import com.bwanms.util.TableUtil;
import com.bwanms.util.version.Version;
import com.bwanms.validation.IPv4Validator;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PFParametersConfigForm
extends ManagedObjectsConfigForm<PFParametersPanel> {
    private boolean valid = false;
    private PFParametersPanel panel;

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        DefaultBinder binder = new DefaultBinder((Object)this.getUI(), managedObjects.get(0));
        binder.add((Binding)new JSpinnerBinding("spnNumberOfRetries", "rbBSPFMaxNumOfRetries", PFParametersPanel.i18n.translateString("numberOfRetries")));
        binder.add((Binding)new JSpinnerBinding("spnRetryInterval", "rbBSPFRetryInterval", PFParametersPanel.i18n.translateString("retryInterval")));
        binder.add((Binding)new JSpinnerBinding("spnPFListenerPort", "rbBSPFListenerPortNumber", PFParametersPanel.i18n.translateString("PFListenerPort")));
        binder.add((Binding)new JSpinnerBinding("spnPFSIPUdpPortNumber", "rbBSPFSIPUdpPortNumber", PFParametersPanel.i18n.translateString("PFSIPUdpPortNumber")));
        if (this.valid) {
            binder.add((Binding)new JSpinnerBinding("spnKeepAliveTimeout", "rbBSPFKeepAliveTimeout", PFParametersPanel.i18n.translateString("KeepAliveTimeout")));
        }
        binders.add((Binder)binder);
        binder = new TableBinder(PFParametersPanel.i18n, ((PFParametersPanel)this.getUI()).getTblPFServerTableModel(), (SNMPTableMO)managedObjects.get(1));
        binder.add((Binding)new TableColumnBinding("serverIPAddress", "rbBSPFServerAddress"));
        binder.add((Binding)new TableColumnBinding("udpPort", "rbBSPFServerPortNumber"));
        binder.add((Binding)new TableColumnBinding("VLANId", "rbBSPFServerPFVlan"));
        if (this.valid) {
            binder.add((Binding)new TableColumnBinding("OperatorStatus", "rbBSPFServerOperStatus"));
            binder.add((Binding)new TableColumnBinding("ifCIPAddress", "rbPFServerIfcIpAddress"));
            binder.add((Binding)new TableColumnBinding("ifCSubnetMask", "rbPFServerIfcSubnetMask"));
            binder.add((Binding)new TableColumnBinding("serverGateway", "rbPFServerGateway"));
        }
        binders.add((Binder)binder);
    }

    public PFParametersPanel initUIComponent() {
        RbBaseStationEquipment equipment = (RbBaseStationEquipment)this.ctx.getEquipment();
        Version runningSoftwareVersion = equipment.getSoftwareVersion();
        this.valid = runningSoftwareVersion.isNewerOrEqualWith(RbVersions.V_4_5) && equipment instanceof RbBS;
        boolean newLimit = RbFeatures.isNewLimitInVD(equipment);
        this.panel = new PFParametersPanel(this.valid, newLimit);
        return this.panel;
    }

    public List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("BS", RbPFGeneralParameters.class));
        ret.add(this.ctx.createRequest("BS", RbBSPFServersTable.class));
        ret.add(this.ctx.createRequest("BS", RbVoiceDomainsTable.class));
        return ret;
    }

    public void fillUI(List<Object> managedObjects) {
        boolean version;
        RbBaseStationEquipment equipment = (RbBaseStationEquipment)this.ctx.getEquipment();
        SimpleRowTableModel tblPFServerTableModel = ((PFParametersPanel)this.getUI()).getTblPFServerTableModel();
        int pfLimit = RbFeatures.isNewLimitInVD(equipment) ? 10 : 20;
        ((PFParametersPanel)this.getUI()).getBtnAdd().setEnabled(tblPFServerTableModel.getRowCount() < pfLimit);
        FormUtil.cancelTableEditing((JTable)((PFParametersPanel)this.getUI()).getTblPFServer());
        tblPFServerTableModel.sort();
        FormsConfigSectionView formsConfigSectionView = (FormsConfigSectionView)this.getConfigSectionView();
        String rowKey = String.valueOf(formsConfigSectionView.getAttribute("serverIP"));
        RbBSPFServersTable pfServerTable = (RbBSPFServersTable)((Object)managedObjects.get(1));
        if (rowKey != null) {
            for (int i = 0; i < tblPFServerTableModel.getRowCount(); ++i) {
                if (!rowKey.equals(tblPFServerTableModel.getRowKey(i))) continue;
                TableUtil.selectAndScrollToRow((JTable)((PFParametersPanel)this.getUI()).getTblPFServer(), (int)i);
                break;
            }
        }
        if (version = ((PFParametersPanel)this.getUI()).getVersion()) {
            for (int i = 0; i < tblPFServerTableModel.getRowCount(); ++i) {
                tblPFServerTableModel.setInitialValueAt(null, i, 2);
                tblPFServerTableModel.setInitialValueAt(null, i, 3);
                tblPFServerTableModel.setInitialValueAt(null, i, 4);
            }
        }
    }

    private void validateServersTable(List<InvalidValue> invalidValues, int index, RbBSPFServersEntry vplDomainEntry, String ip, Integer serverPort, Integer vlanId, String serverSharedString, String serverSharedString2, Integer dataPortAdopt, String pfServerIfIpAddress, String pfServerIfNetmask, String pfServerGW) {
        vplDomainEntry.setRbBSPFServerPortNumber(serverPort);
        vplDomainEntry.setRbPFServerDataPortAdopt(dataPortAdopt);
        if (null == dataPortAdopt) {
            invalidValues.add(new InvalidValue(PFParametersPanel.i18n.translateString("InvalidAdoptDataPort", new Object[]{index}), RbBSPFServersEntry.class, PFParametersPanel.i18n.translateString("AdoptDataPort"), (Object)"", null));
            dataPortAdopt = 0;
        }
        if (1 != dataPortAdopt) {
            if (null != vlanId) {
                if (vlanId > 4095) {
                    invalidValues.add(new InvalidValue(PFParametersPanel.i18n.translateString("InvalidVlanId"), RbBSPFServersEntry.class, PFParametersPanel.i18n.translateString("VLANId"), (Object)vlanId, null));
                }
            } else {
                vlanId = 4095;
            }
            vplDomainEntry.setRbBSPFServerPFVlan(vlanId);
            boolean allIPsValid = true;
            vplDomainEntry.setRbPFServerGateway(pfServerGW);
            if (!pfServerGW.trim().equals("0.0.0.0") && !pfServerGW.trim().equals("")) {
                if (!IPv4Validator.isIp((String)pfServerGW)) {
                    invalidValues.add(new InvalidValue(PFParametersPanel.i18n.translateString("InvalidIpAddress"), RbBSPFServersEntry.class, PFParametersPanel.i18n.translateString("serverGateway"), (Object)pfServerGW, null));
                    allIPsValid = false;
                }
            } else {
                vplDomainEntry.setRbPFServerGateway("0.0.0.0");
            }
            vplDomainEntry.setRbPFServerIfcIpAddress(pfServerIfIpAddress);
            if (!IPv4Validator.isIp((String)pfServerIfIpAddress)) {
                invalidValues.add(new InvalidValue(PFParametersPanel.i18n.translateString("InvalidIpAddress"), RbBSPFServersEntry.class, PFParametersPanel.i18n.translateString("ifCIPAddress"), (Object)pfServerIfIpAddress, null));
                allIPsValid = false;
            }
            vplDomainEntry.setRbPFServerIfcSubnetMask(pfServerIfNetmask);
            if (!IPv4Validator.isValidHostMask((String)pfServerIfNetmask)) {
                invalidValues.add(new InvalidValue(PFParametersPanel.i18n.translateString("InvalidSubnetMask"), RbBSPFServersEntry.class, PFParametersPanel.i18n.translateString("ifCSubnetMask"), (Object)pfServerIfNetmask, null));
            }
            if (allIPsValid) {
                this.checkDuplicateIPs(invalidValues, vplDomainEntry, ip, "serverIPAddress", pfServerGW, "serverGateway");
                this.checkDuplicateIPs(invalidValues, vplDomainEntry, pfServerIfIpAddress, "ifCIPAddress", pfServerGW, "serverGateway");
                this.checkDuplicateIPs(invalidValues, vplDomainEntry, pfServerIfIpAddress, "ifCIPAddress", ip, "serverIPAddress");
            }
            if (vplDomainEntry.getRbPFServerGateway() == "0.0.0.0") {
                try {
                    IpAddress domainIP = new IpAddress(vplDomainEntry.getRbPFServerIfcIpAddress().trim());
                    IpAddress domainSubnet = new IpAddress(vplDomainEntry.getRbPFServerIfcSubnetMask().trim());
                    IpAddress serverIP = new IpAddress(vplDomainEntry.getRbBSPFServerAddress());
                    IpAddressRange subnetRange = IpAddressRange.fromSubnet((IpAddress)domainIP, (IpAddress)domainSubnet);
                    if (!subnetRange.contains(serverIP)) {
                        invalidValues.add(new InvalidValue(PFParametersPanel.i18n.translateString("InvalidIpRangeSubnet"), RbBSPFServersEntry.class, PFParametersPanel.i18n.translateString("ifCIPAddress"), (Object)pfServerIfIpAddress, null));
                    }
                }
                catch (IllegalArgumentException e) {}
            }
        } else {
            vplDomainEntry.setRbPFServerGateway(null);
            vplDomainEntry.setRbPFServerIfcIpAddress(null);
            vplDomainEntry.setRbPFServerIfcSubnetMask(null);
            vplDomainEntry.setRbBSPFServerPFVlan(null);
        }
        vplDomainEntry.setRbBSPFServerSharedString(serverSharedString);
        if (null != serverSharedString) {
            if (serverSharedString.length() == 0) {
                invalidValues.add(new InvalidValue(PFParametersPanel.i18n.translateString("SharedSecretNotEmpty"), RbRegisteredSuEntry.class, PFParametersPanel.i18n.translateString("SharedSecret"), (Object)"...", null));
            } else if (serverSharedString.length() > 16) {
                invalidValues.add(new InvalidValue(PFParametersPanel.i18n.translateString("SharedSecretRange", new Object[]{1, 16}), RbRegisteredSuEntry.class, PFParametersPanel.i18n.translateString("SharedSecret"), (Object)"...", null));
            } else if (!serverSharedString.equals(serverSharedString2)) {
                invalidValues.add(new InvalidValue(PFParametersPanel.i18n.translateString("SharedAndRetypeMustBeSame"), RbRegisteredSuEntry.class, PFParametersPanel.i18n.translateString("SharedSecret"), (Object)"...", null));
            }
        }
    }

    private void validateServersTable_IsNotValid(List<InvalidValue> invalidValues, RbBSPFServersEntry vplDomainEntry, String ip, Integer serverPort, Integer vlanId, String serverSharedString, String serverSharedString2) {
        vplDomainEntry.setRbBSPFServerPortNumber(serverPort);
        vplDomainEntry.setRbBSPFServerPFVlan(vlanId);
        vplDomainEntry.setRbBSPFServerSharedString(serverSharedString);
        if (null != serverSharedString) {
            if (serverSharedString.length() == 0) {
                invalidValues.add(new InvalidValue(PFParametersPanel.i18n.translateString("SharedSecretNotEmpty"), RbRegisteredSuEntry.class, PFParametersPanel.i18n.translateString("SharedSecret"), (Object)"...", null));
            } else if (serverSharedString.length() > 16) {
                invalidValues.add(new InvalidValue(PFParametersPanel.i18n.translateString("SharedSecretRange", new Object[]{1, 16}), RbRegisteredSuEntry.class, PFParametersPanel.i18n.translateString("SharedSecret"), (Object)"...", null));
            } else if (!serverSharedString.equals(serverSharedString2)) {
                invalidValues.add(new InvalidValue(PFParametersPanel.i18n.translateString("SharedAndRetypeMustBeSame"), RbRegisteredSuEntry.class, PFParametersPanel.i18n.translateString("SharedSecret"), (Object)"...", null));
            }
        }
    }

    private void configureMOs_IsValid(List<Object> managedObjects, List<InvalidValue> invalidValues, SimpleRowTableModel model) {
        RbBSPFServersTable pfServerTable = (RbBSPFServersTable)((Object)managedObjects.get(1));
        block5: for (int i = 0; i < model.getRowCount(); ++i) {
            String ip = (String)model.getValueAt(i, 0);
            ip = null == ip ? "" : ip;
            Integer serverPort = (Integer)model.getValueAt(i, 1);
            Integer vlanId = null;
            if (null != model.getValueAt(i, 5) && !model.getValueAt(i, 5).equals("")) {
                vlanId = Integer.valueOf(String.valueOf(model.getValueAt(i, 5)));
            }
            String serverSharedString = (String)model.getValueAt(i, 2);
            String serverSharedString2 = (String)model.getValueAt(i, 3);
            Integer dataPortAdopt = (Integer)model.getValueAt(i, 4);
            String pfServerIfIpAddress = (String)model.getValueAt(i, 6);
            pfServerIfIpAddress = null == pfServerIfIpAddress ? "" : pfServerIfIpAddress;
            String pfServerIfNetmask = (String)model.getValueAt(i, 7);
            pfServerIfNetmask = null == pfServerIfNetmask ? "" : pfServerIfNetmask;
            String pfServerGW = (String)model.getValueAt(i, 8);
            pfServerGW = null == pfServerGW ? "" : pfServerGW;
            switch (model.getRowState(i)) {
                case 1: {
                    RbBSPFServersEntry vplDomainEntry = (RbBSPFServersEntry)pfServerTable.findEntry(model.getRowKey(i));
                    if (!this.canDeleteEntry(vplDomainEntry, (RbVoiceDomainsTable)((Object)managedObjects.get(2)), invalidValues)) continue block5;
                    pfServerTable.removeEntry(model.getRowKey(i));
                    continue block5;
                }
                case 2: {
                    RbBSPFServersEntry vplDomainEntry = new RbBSPFServersEntry();
                    vplDomainEntry.setRbBSPFServerAddress(ip);
                    this.validateServersTable(invalidValues, i + 1, vplDomainEntry, ip, serverPort, vlanId, serverSharedString, serverSharedString2, dataPortAdopt, pfServerIfIpAddress, pfServerIfNetmask, pfServerGW);
                    if (this.existsIP(pfServerTable, ip)) {
                        invalidValues.add(new InvalidValue(PFParametersPanel.i18n.translateString("entryAlreadyInTable"), RbRegisteredSuEntry.class, PFParametersPanel.i18n.translateString("serverIPAddress"), (Object)ip, null));
                        continue block5;
                    }
                    if (ip.startsWith("0.")) {
                        invalidValues.add(new InvalidValue(PFParametersPanel.i18n.translateString("IPsThatStartsWith0AreNotAllowed"), JTable.class, PFParametersPanel.i18n.translateString("serverIPAddress"), (Object)ip, null));
                        continue block5;
                    }
                    pfServerTable.addEntry((TableRowMO)vplDomainEntry);
                    continue block5;
                }
                case 3: {
                    RbBSPFServersEntry vplDomainEntry = (RbBSPFServersEntry)pfServerTable.findEntry(model.getRowKey(i));
                    if (vplDomainEntry == null) continue block5;
                    this.validateServersTable(invalidValues, i + 1, vplDomainEntry, ip, serverPort, vlanId, serverSharedString, serverSharedString2, dataPortAdopt, pfServerIfIpAddress, pfServerIfNetmask, pfServerGW);
                }
            }
        }
    }

    private void configureMOs_IsNotValid(List<Object> managedObjects, List<InvalidValue> invalidValues, SimpleRowTableModel model) {
        RbBSPFServersTable pfServerTable = (RbBSPFServersTable)((Object)managedObjects.get(1));
        block5: for (int i = 0; i < model.getRowCount(); ++i) {
            String ip = (String)model.getValueAt(i, 0);
            ip = null == ip ? "" : ip;
            Integer serverPort = (Integer)model.getValueAt(i, 1);
            Integer vlanId = (Integer)model.getValueAt(i, 2);
            String serverSharedString = (String)model.getValueAt(i, 3);
            String serverSharedString2 = (String)model.getValueAt(i, 4);
            switch (model.getRowState(i)) {
                case 1: {
                    RbBSPFServersEntry vplDomainEntry = (RbBSPFServersEntry)pfServerTable.findEntry(model.getRowKey(i));
                    if (this.canDeleteEntry(vplDomainEntry, (RbVoiceDomainsTable)((Object)managedObjects.get(2)), invalidValues)) {
                        pfServerTable.removeEntry(model.getRowKey(i));
                        continue block5;
                    }
                    if (String.valueOf(model.getValueAt(i, 3)).length() <= 32) continue block5;
                    invalidValues.add(new InvalidValue(PFParametersPanel.i18n.translateString("NameLengthBetwen1And32"), RbRegisteredSuEntry.class, PFParametersPanel.i18n.translateString("SharedSecret"), (Object)"...", null));
                    continue block5;
                }
                case 2: {
                    RbBSPFServersEntry vplDomainEntry = new RbBSPFServersEntry();
                    vplDomainEntry.setRbBSPFServerAddress(ip);
                    this.validateServersTable_IsNotValid(invalidValues, vplDomainEntry, ip, serverPort, vlanId, serverSharedString, serverSharedString2);
                    if (this.existsIP(pfServerTable, ip)) {
                        invalidValues.add(new InvalidValue(PFParametersPanel.i18n.translateString("entryAlreadyInTable"), RbRegisteredSuEntry.class, PFParametersPanel.i18n.translateString("serverIPAddress"), (Object)ip, null));
                        continue block5;
                    }
                    if (ip.startsWith("0.")) {
                        invalidValues.add(new InvalidValue(PFParametersPanel.i18n.translateString("IPsThatStartsWith0AreNotAllowed"), JTable.class, PFParametersPanel.i18n.translateString("serverIPAddress"), (Object)ip, null));
                        continue block5;
                    }
                    pfServerTable.addEntry((TableRowMO)vplDomainEntry);
                    continue block5;
                }
                case 3: {
                    RbBSPFServersEntry vplDomainEntry = (RbBSPFServersEntry)pfServerTable.findEntry(model.getRowKey(i));
                    if (vplDomainEntry == null) continue block5;
                    this.validateServersTable_IsNotValid(invalidValues, vplDomainEntry, ip, serverPort, vlanId, serverSharedString, serverSharedString2);
                }
            }
        }
    }

    private void checkDuplicateIPs(List<InvalidValue> invalidValues, DynamicTableRowMO entry, String ip1, String trIp1, String ip2, String trIp2) {
        if (ip1.equals(ip2)) {
            invalidValues.add(new InvalidValue(PFParametersPanel.i18n.translateString("IpMustBeDifferent", new Object[]{PFParametersPanel.i18n.translateString(trIp1), PFParametersPanel.i18n.translateString(trIp2)}), entry.getClass(), PFParametersPanel.i18n.translateString("InvalidIpAddress"), (Object)ip1, (Object)entry));
        }
    }

    public void configureMOs(List<Object> managedObjects, List<InvalidValue> invalidValues) {
        FormUtil.stopTableEditing((JTable)((PFParametersPanel)this.getUI()).getTblPFServer());
        SimpleRowTableModel model = ((PFParametersPanel)this.getUI()).getTblPFServerTableModel();
        if (this.valid) {
            this.configureMOs_IsValid(managedObjects, invalidValues, model);
        } else {
            this.configureMOs_IsNotValid(managedObjects, invalidValues, model);
        }
    }

    private boolean existsIP(RbBSPFServersTable pfServersTable, String name) {
        if (name == null || pfServersTable == null) {
            return false;
        }
        String trimName = name.trim();
        for (RbBSPFServersEntry entry : pfServersTable.getEntries()) {
            if (!trimName.equals(entry.getRbBSPFServerAddress())) continue;
            return true;
        }
        return false;
    }

    private boolean canDeleteEntry(RbBSPFServersEntry e, RbVoiceDomainsTable table, List<InvalidValue> invalidValues) {
        if (table != null && e.getRbBSPFServerAddress() != null) {
            for (RbVoiceDomainsEntry entry : table.getEntries()) {
                if (!e.getRbBSPFServerAddress().equals(entry.getRbVoiceDomainPrimaryPFIpAddress()) && !e.getRbBSPFServerAddress().equals(entry.getRbVoiceDomainSecondaryPFIpAddress())) continue;
                invalidValues.add(new InvalidValue(PFParametersPanel.i18n.translateString("VDusedVD", new Object[]{e.getRbBSPFServerAddress(), entry.getRbVoiceDomainName()}), null, "", (Object)"", null));
                return false;
            }
        }
        return true;
    }

    public String getTitle() {
        return "PFParameters";
    }

    public String getHelpTopic() {
        if (PlatformConfiguration.isLocalPlatform()) {
            return "ngnms.rb.help.craft_bs_tdd_pf_parameters";
        }
        return "ngnms.rb.help.bs_tdd_pf_parameters";
    }
}

