/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.rb.gui.configuration.OutdoorUnitDetailsPanel;
import com.bwanms.rb.gui.configuration.OutdoorUnitsPanel;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.ui.components.SimpleRowTableModelPanelController;
import com.bwanms.util.FrameUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class OutdoorUnitsPanelController
extends SimpleRowTableModelPanelController {
    private OutdoorUnitsPanel form;
    private static Logger logger = Logger.getLogger(OutdoorUnitsPanelController.class);
    private Map<Integer, String[]> hwDetails;

    public OutdoorUnitsPanelController(OutdoorUnitsPanel form) {
        this.form = form;
        this.hwDetails = new HashMap<Integer, String[]>();
    }

    public void btnDetailsMouseClicked(MouseEvent e) {
        JLabel lblStatusMask;
        int row = this.getTable().getSelectedRow();
        if (row < 0) {
            return;
        }
        SimpleRowTableModel model = this.form.getTable2Model();
        Integer oduID = (Integer)model.getValueAt(row, 0) - 1;
        System.out.println("Should display details for ID " + this.getTable().getValueAt(row, 0));
        OutdoorUnitDetailsPanel detailsPanel = new OutdoorUnitDetailsPanel();
        Container topLevelParent = this.form.getTopLevelAncestor();
        JDialog dlg = null;
        dlg = topLevelParent instanceof Frame ? new JDialog((Frame)topLevelParent) : (topLevelParent instanceof Dialog ? new JDialog((Dialog)topLevelParent) : new JDialog());
        final JDialog dialog = dlg;
        KeyAdapter theListener = new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    dialog.dispose();
                }
            }
        };
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                dialog.dispose();
                super.windowClosing(e);
            }
        });
        dialog.setTitle(OutdoorUnitDetailsPanel.i18n.translateString("HWDetails"));
        dialog.setModal(true);
        dialog.add(detailsPanel);
        detailsPanel.setParent(dialog);
        FrameUtil.addKeyListenerRecursively((Component)dialog, (KeyAdapter)theListener);
        detailsPanel.getTxtCardSerialNumber().setText(this.hwDetails.get(oduID)[0]);
        detailsPanel.getTxtHWRevision().setText(this.hwDetails.get(oduID)[1]);
        detailsPanel.getTxtHWConfiguration().setText(this.hwDetails.get(oduID)[2]);
        detailsPanel.getTxtHC08Version().setText(this.hwDetails.get(oduID)[3]);
        detailsPanel.getTxtCPLDVersion().setText(this.hwDetails.get(oduID)[4]);
        detailsPanel.getTxtTemperature().setText(this.hwDetails.get(oduID)[5]);
        detailsPanel.getTxtMaxTxPower().setText(this.hwDetails.get(oduID)[6]);
        if (this.hwDetails.get(oduID)[7].equals("mbs")) {
            detailsPanel.getlblConnectedAUSlotNr().setVisible(false);
            detailsPanel.getTxtConnectedAUSlotNr().setVisible(false);
        }
        try {
            detailsPanel.getTxtConnectedAUSlotNr().setText(this.hwDetails.get(oduID)[8]);
        }
        catch (Exception exc) {
            detailsPanel.getTxtConnectedAUSlotNr().setText("NA");
        }
        try {
            detailsPanel.getTxtChannel().setText(this.hwDetails.get(oduID)[9]);
        }
        catch (Exception exc) {
            detailsPanel.getTxtChannel().setText("NA");
        }
        JTextField txtStatusMask = detailsPanel.getTxtStatusMask();
        JTextField txtRxCableLoss = detailsPanel.getTxtRxCableLoss();
        try {
            txtStatusMask.setText(this.hwDetails.get(oduID)[10]);
            txtRxCableLoss.setText(this.hwDetails.get(oduID)[11]);
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            logger.debug((Object)"Older version than 4.1.1.1,this parameters are not available");
            txtStatusMask.setVisible(false);
            txtRxCableLoss.setVisible(false);
            lblStatusMask = detailsPanel.getLblStatusMask();
            lblStatusMask.setVisible(false);
            JLabel lblRxCableLoss = detailsPanel.getLblRxCableLoss();
            lblRxCableLoss.setVisible(false);
        }
        catch (NullPointerException nullPointerEx) {
            logger.debug((Object)"Older version than 4.1.1.1,this parameters are not available");
            txtStatusMask.setVisible(false);
            txtRxCableLoss.setVisible(false);
            lblStatusMask = detailsPanel.getLblStatusMask();
            lblStatusMask.setVisible(false);
            JLabel lblRxCableLoss = detailsPanel.getLblRxCableLoss();
            lblRxCableLoss.setVisible(false);
        }
        int maxWidth = (int)dialog.getGraphicsConfiguration().getBounds().getWidth();
        int maxHeight = (int)dialog.getGraphicsConfiguration().getBounds().getHeight();
        dialog.pack();
        dialog.setLocation((maxWidth - 320) / 2, (maxHeight - 400) / 2);
        dialog.setVisible(true);
    }

    public void controlTableButtons() {
        super.controlTableButtons();
        int row = this.getTable().getSelectedRow();
        if (row < 0 || row >= this.getTableModel().getRowCount()) {
            this.form.getBtnDetails().setEnabled(false);
            this.getRevertButton().setEnabled(false);
            this.getDeleteButton().setEnabled(false);
            return;
        }
        if (this.getTableModel().getRowState(row) == 0 || this.getTableModel().getRowState(row) == 1 || this.getTableModel().getRowState(row) == 3) {
            this.form.getBtnDetails().setEnabled(true);
        } else {
            this.form.getBtnDetails().setEnabled(false);
        }
    }

    public void addDetails(Integer key, String[] data) {
        this.hwDetails.put(key, data);
    }

    public void resetDetails() {
        this.hwDetails.clear();
    }

    protected SimpleRowTableModel getTableModel() {
        return this.form.getTable2Model();
    }

    protected JTable getTable() {
        return this.form.getTable2();
    }

    protected JButton getDeleteButton() {
        return this.form.getBtnDelete();
    }

    protected JButton getRevertButton() {
        return this.form.getBtnRevert();
    }
}

