/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.TableBinder;
import com.bwanms.gui.binding.TableColumnBinding;
import com.bwanms.gui.configuration.FormsConfigSectionView;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.mo.TableRowMO;
import com.bwanms.mo.snmp.SNMPTableMO;
import com.bwanms.rb.gui.configuration.OutdoorUnitsPanel;
import com.bwanms.rb.mo.RbAuChannelConfigEntry;
import com.bwanms.rb.mo.RbAuChannelConfigTable;
import com.bwanms.rb.mo.RbAuConfigEntry;
import com.bwanms.rb.mo.RbAuConfigTable;
import com.bwanms.rb.mo.RbFrequencyBandsEntry;
import com.bwanms.rb.mo.RbFrequencyBandsTable;
import com.bwanms.rb.mo.RbOduConfigEntry;
import com.bwanms.rb.mo.RbOduConfigTable;
import com.bwanms.rb.mo.RbRadioClusterEntry;
import com.bwanms.rb.mo.RbRadioClusterTable;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.util.RbVersions;
import com.bwanms.services.UnifiedMORequest;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FormUtil;
import com.bwanms.util.MessageBox;
import com.bwanms.util.TableUtil;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.JTable;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutdoorUnitsConfigForm
extends ManagedObjectsConfigForm<OutdoorUnitsPanel> {
    private static final Logger logger = Logger.getLogger(OutdoorUnitsConfigForm.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(OutdoorUnitsConfigForm.class);
    private boolean softwareVersionAbove30;
    private boolean softwareVersionUnder41;
    private boolean softwareVersionUnder4117;

    public OutdoorUnitsPanel initUIComponent() {
        this.softwareVersionAbove30 = ((RbBS)this.ctx.getEquipment()).getSoftwareVersion().compareTo((Object)new DefaultVersion("3.0")) > 0;
        this.softwareVersionUnder41 = ((RbBS)this.ctx.getEquipment()).getSoftwareVersion().compareTo((Object)new DefaultVersion("4.1")) < 0;
        this.softwareVersionUnder4117 = ((RbBS)this.ctx.getEquipment()).getSoftwareVersion().compareTo((Object)new DefaultVersion("4.1.1.7")) < 0;
        return new OutdoorUnitsPanel(this.softwareVersionUnder4117);
    }

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        TableBinder binder = new TableBinder(i18n, ((OutdoorUnitsPanel)this.getUI()).getTable2Model(), (SNMPTableMO)managedObjects.get(0));
        binder.add((Binding)new TableColumnBinding("TxPower", "rbOduTxPower"));
        binders.add((Binder)binder);
    }

    public List<UnifiedMORequest> getManagedObjectRequests() {
        ArrayList<UnifiedMORequest> ret = new ArrayList<UnifiedMORequest>();
        ret.add((UnifiedMORequest)this.ctx.createRequest("BS", RbOduConfigTable.class));
        ret.add((UnifiedMORequest)this.ctx.createRequest("BS", RbRadioClusterTable.class));
        ret.add((UnifiedMORequest)this.ctx.createRequest("BS", RbFrequencyBandsTable.class));
        ret.add((UnifiedMORequest)this.ctx.createRequest("BS", RbAuChannelConfigTable.class));
        if (this.softwareVersionAbove30) {
            ret.add((UnifiedMORequest)this.ctx.createRequest("BS", RbAuConfigTable.class));
        }
        return ret;
    }

    public void fillUI(List<Object> managedObjects) {
        FormUtil.cancelTableEditing((JTable)((OutdoorUnitsPanel)this.getUI()).getTable2());
        ((OutdoorUnitsPanel)this.getUI()).getTable2Model().clearTable();
        for (int i = 0; i < 24; ++i) {
            ((OutdoorUnitsPanel)this.getUI()).getTable2Model().addNewRow(Integer.toString(i + 1), true);
            ((OutdoorUnitsPanel)this.getUI()).getTable2Model().setRowState(i, 4);
            ((OutdoorUnitsPanel)this.getUI()).getTable2Model().setInitialValueAt((Object)(i + 1), i, 0);
        }
        ((OutdoorUnitsPanel)this.getUI()).getController().resetDetails();
        ArrayList<ComboItem> clusters = new ArrayList<ComboItem>();
        RbRadioClusterTable clusterTable = (RbRadioClusterTable)((Object)managedObjects.get(1));
        clusters.add(new ComboItem((Object)0, i18n.translateString("noCluster")));
        List sortedClusters = clusterTable.getEntries();
        Collections.sort(sortedClusters, new Comparator<RbRadioClusterEntry>(){

            @Override
            public int compare(RbRadioClusterEntry o1, RbRadioClusterEntry o2) {
                return o1.getRbRadioClusterName().compareTo(o2.getRbRadioClusterName());
            }
        });
        for (RbRadioClusterEntry entry : sortedClusters) {
            clusters.add(new ComboItem((Object)entry.getRbRadioClusterId(), entry.getRbRadioClusterName()));
        }
        ((OutdoorUnitsPanel)this.getUI()).getTable2Model().setValueSet(-1, 1, clusters);
        ArrayList<ComboItem> bands = new ArrayList<ComboItem>();
        RbFrequencyBandsTable bandsTable = (RbFrequencyBandsTable)((Object)managedObjects.get(2));
        List sortedBands = bandsTable.getEntries();
        Collections.sort(sortedBands, new Comparator<RbFrequencyBandsEntry>(){

            @Override
            public int compare(RbFrequencyBandsEntry o1, RbFrequencyBandsEntry o2) {
                return o1.getRbFrequencyBandId().compareTo(o2.getRbFrequencyBandId());
            }
        });
        for (RbFrequencyBandsEntry entry : sortedBands) {
            bands.add(new ComboItem((Object)entry.getRbFrequencyBandId().intValue(), entry.getRbFrequencyBandName()));
        }
        ((OutdoorUnitsPanel)this.getUI()).getTable2Model().setValueSet(-1, this.softwareVersionUnder4117 ? 3 : 4, bands);
        RbAuChannelConfigTable auTable = (RbAuChannelConfigTable)((Object)managedObjects.get(3));
        RbOduConfigTable table = (RbOduConfigTable)((Object)managedObjects.get(0));
        if (table != null) {
            for (RbOduConfigEntry entry : table.getEntries()) {
                String[] oduDetails;
                int col = 1;
                int counter = entry.getRbOduConfigId() - 1;
                ((OutdoorUnitsPanel)this.getUI()).getTable2Model().setInitialValueAt((Object)entry.getRbOduAssociatedRadioClusterId(), counter, col++);
                if (!this.softwareVersionUnder4117) {
                    ((OutdoorUnitsPanel)this.getUI()).getTable2Model().setInitialValueAt((Object)entry.getRbOduActualTxPower(), counter, col++);
                }
                ((OutdoorUnitsPanel)this.getUI()).getTable2Model().setInitialValueAt((Object)entry.getRbOduTxPower(), counter, col++);
                if (entry.getRbOduConfigFrequencyBand() != 0) {
                    ((OutdoorUnitsPanel)this.getUI()).getTable2Model().setInitialValueAt((Object)entry.getRbOduConfigFrequencyBand(), counter, col);
                }
                int n = ++col;
                ((OutdoorUnitsPanel)this.getUI()).getTable2Model().setInitialValueAt((Object)entry.getRbOduAdminStatus(), counter, n);
                int n2 = ++col;
                ++col;
                ((OutdoorUnitsPanel)this.getUI()).getTable2Model().setInitialValueAt((Object)entry.getRbOduOperationalStatus(), counter, n2);
                ((OutdoorUnitsPanel)this.getUI()).getTable2Model().setRowState(counter, 0);
                RbAuChannelConfigEntry auEntry = null;
                for (RbAuChannelConfigEntry auEntry1 : auTable.getEntries()) {
                    if (!auEntry1.getRbAuChannelAssociatedOduId().equals(entry.getRbOduConfigId())) continue;
                    if (auEntry1.getRbAuChannelAdminStatus() != 1) continue;
                    auEntry = auEntry1;
                    break;
                }
                RbBS bs = (RbBS)this.ctx.getEquipment();
                Version softwareVersion = bs.getSoftwareVersion();
                if (auEntry != null) {
                    oduDetails = softwareVersion.compareTo((Object)RbVersions.V_4_5) >= 0 ? new String[]{entry.getRbOduCardSerialNumber(), entry.getRbOduHwRevision(), entry.getRbOduHwConfigDescription(), entry.getRbOduHwHC08Version(), entry.getRbOduCpldVersion(), entry.getRbOduOperationalStatus() == 2 ? "NA" : entry.getRbOduTemperature().toString(), entry.getRbOduMaxTxPower() == null || entry.getRbOduOperationalStatus() == 2 ? "NA" : entry.getRbOduMaxTxPower().toString(), "bs", auEntry.getRbSlotNumber().toString(), auEntry.getRbAuChannelId().toString(), entry.getRbOduStatusMask(), entry.toStringRbOduGeneralDescription(entry.getRbOduGeneralDescription())} : new String[]{entry.getRbOduCardSerialNumber(), entry.getRbOduHwRevision(), entry.getRbOduHwConfigDescription(), entry.getRbOduHwHC08Version(), entry.getRbOduCpldVersion(), entry.getRbOduOperationalStatus() == 2 ? "NA" : entry.getRbOduTemperature().toString(), entry.getRbOduMaxTxPower() == null || entry.getRbOduOperationalStatus() == 2 ? "NA" : entry.getRbOduMaxTxPower().toString(), "bs", auEntry.getRbSlotNumber().toString(), auEntry.getRbAuChannelId().toString()};
                    ((OutdoorUnitsPanel)this.getUI()).getController().addDetails(counter, oduDetails);
                    continue;
                }
                oduDetails = softwareVersion.compareTo((Object)RbVersions.V_4_5) >= 0 ? new String[]{entry.getRbOduCardSerialNumber(), entry.getRbOduHwRevision(), entry.getRbOduHwConfigDescription(), entry.getRbOduHwHC08Version(), entry.getRbOduCpldVersion(), entry.getRbOduOperationalStatus() == 2 ? "NA" : entry.getRbOduTemperature().toString(), entry.getRbOduMaxTxPower() == null || entry.getRbOduOperationalStatus() == 2 ? "NA" : entry.getRbOduMaxTxPower().toString(), "bs", null, null, entry.getRbOduStatusMask(), entry.toStringRbOduGeneralDescription(entry.getRbOduGeneralDescription())} : new String[]{entry.getRbOduCardSerialNumber(), entry.getRbOduHwRevision(), entry.getRbOduHwConfigDescription(), entry.getRbOduHwHC08Version(), entry.getRbOduCpldVersion(), entry.getRbOduOperationalStatus() == 2 ? "NA" : entry.getRbOduTemperature().toString(), entry.getRbOduMaxTxPower() == null || entry.getRbOduOperationalStatus() == 2 ? "NA" : entry.getRbOduMaxTxPower().toString(), "bs"};
                ((OutdoorUnitsPanel)this.getUI()).getController().addDetails(counter, oduDetails);
            }
        }
        TableUtil.autoResizeColumn((JTable)((OutdoorUnitsPanel)this.getUI()).getTable2(), (int)0, (boolean)true);
        ((OutdoorUnitsPanel)this.getUI()).getTable2Model().sort();
        FormsConfigSectionView formsConfigSectionView = (FormsConfigSectionView)this.getConfigSectionView();
        String oduId = String.valueOf(formsConfigSectionView.getAttribute("oduId"));
        if (oduId != null) {
            try {
                int chanelIdInt = Integer.parseInt(oduId) - 1;
                ((OutdoorUnitsPanel)this.getUI()).getTable2().setRowSelectionInterval(chanelIdInt, chanelIdInt);
            }
            catch (Exception e) {}
        } else {
            ((OutdoorUnitsPanel)this.getUI()).getTable2().clearSelection();
        }
    }

    public void configureMOs(List<Object> managedObjects, List<InvalidValue> invalidValues) {
        RbAuConfigTable auTbl = null;
        SimpleRowTableModel model = ((OutdoorUnitsPanel)this.getUI()).getTable2Model();
        FormUtil.stopTableEditing((JTable)((OutdoorUnitsPanel)this.getUI()).getTable2());
        RbOduConfigTable oduTable = (RbOduConfigTable)((Object)managedObjects.get(0));
        RbAuChannelConfigTable chnlTbl = (RbAuChannelConfigTable)((Object)managedObjects.get(3));
        HashSet<Integer> changedFreqBandODUs = new HashSet<Integer>();
        HashSet<Integer> changedODUs = new HashSet<Integer>();
        ArrayList<Integer> notDeletedODUs = new ArrayList<Integer>();
        if (managedObjects.size() > 4) {
            auTbl = (RbAuConfigTable)((Object)managedObjects.get(4));
        }
        int increaseColumnIndexFrom2By = this.softwareVersionUnder4117 ? 0 : 1;
        block5: for (int i = 0; i < model.getRowCount(); ++i) {
            RbOduConfigEntry entry = (RbOduConfigEntry)oduTable.findEntry(model.getRowKey(i));
            Integer clusterId = (Integer)model.getValueAt(i, 1);
            Integer statusId = (Integer)model.getValueAt(i, 4 + increaseColumnIndexFrom2By);
            Integer cfgBand = (Integer)model.getValueAt(i, 3 + increaseColumnIndexFrom2By);
            if (model.getRowState(i) == 3 || model.getRowState(i) == 5) {
                if (clusterId == null) {
                    invalidValues.add(new InvalidValue(i18n.translateString("MandatoryValue"), RbOduConfigEntry.class, i18n.translateString("rbOduAssociatedRadioClusterId"), null, (Object)this));
                } else if (Integer.valueOf(1).equals(statusId) && clusterId.equals(0)) {
                    if (entry == null || !clusterId.equals(entry.getRbOduAssociatedRadioClusterId())) {
                        invalidValues.add(new InvalidValue(i18n.translateString("NoClusterEnabled"), RbOduConfigEntry.class, i18n.translateString("AssociatedRadioCluster"), (Object)i18n.translateString("noCluster"), (Object)this));
                    }
                    if (entry == null || !entry.getRbOduAdminStatus().equals(statusId)) {
                        invalidValues.add(new InvalidValue(i18n.translateString("CanNotEnebleNoCluster"), RbOduConfigEntry.class, i18n.translateString("AdminStatus"), (Object)i18n.translateString(RbOduConfigEntry.toStringRbOduAdminStatus(statusId)), (Object)this));
                    }
                }
                if (cfgBand == null || cfgBand.equals(0)) {
                    invalidValues.add(new InvalidValue(i18n.translateString("ConfiguredBandMustBeDefinedAtRow", new Object[]{i + 1}), RbOduConfigEntry.class, i18n.translateString("ConfiguredBand"), (Object)i18n.translateString("notDefined"), (Object)this));
                }
            }
            switch (model.getRowState(i)) {
                case 3: {
                    entry.setRbOduAssociatedRadioClusterId((Integer)model.getValueAt(i, 1));
                    OutdoorUnitsConfigForm.setTxPower(entry, (String)model.getValueAt(i, 2 + increaseColumnIndexFrom2By), invalidValues, this.softwareVersionUnder41, (Object)this);
                    if (!entry.getRbOduConfigFrequencyBand().equals(cfgBand)) {
                        entry.setRbOduConfigFrequencyBand(cfgBand);
                        changedFreqBandODUs.add(entry.getRbOduConfigId());
                    }
                    entry.setRbOduAdminStatus((Integer)model.getValueAt(i, 4 + increaseColumnIndexFrom2By));
                    changedODUs.add(entry.getRbOduConfigId());
                    continue block5;
                }
                case 1: {
                    boolean isAssocWithChannel = false;
                    for (RbAuChannelConfigEntry chnl : chnlTbl.getEntries()) {
                        if (!entry.getRbOduConfigId().equals(chnl.getRbAuChannelAssociatedOduId())) continue;
                        isAssocWithChannel = true;
                        break;
                    }
                    if (!isAssocWithChannel) {
                        oduTable.removeEntry(entry.getRowKey());
                        continue block5;
                    }
                    notDeletedODUs.add(entry.getRbOduConfigId());
                    continue block5;
                }
                case 5: {
                    boolean addEntry = true;
                    if (entry != null) {
                        addEntry = false;
                    } else {
                        entry = new RbOduConfigEntry();
                        entry.setRbOduConfigId(Integer.valueOf(model.getRowKey(i)));
                        addEntry = true;
                    }
                    entry.setRbOduAssociatedRadioClusterId((Integer)model.getValueAt(i, 1));
                    OutdoorUnitsConfigForm.setTxPower(entry, (String)model.getValueAt(i, 2 + increaseColumnIndexFrom2By), invalidValues, this.softwareVersionUnder41, (Object)this);
                    entry.setRbOduConfigFrequencyBand(cfgBand);
                    entry.setRbOduAdminStatus((Integer)model.getValueAt(i, 4 + increaseColumnIndexFrom2By));
                    if (!addEntry) continue block5;
                    oduTable.addEntry((TableRowMO)entry);
                }
            }
        }
        for (RbAuChannelConfigEntry chnl : chnlTbl.getEntries()) {
            if (changedFreqBandODUs.contains(chnl.getRbAuChannelAssociatedOduId()) && chnl.getRbAuChannelAdminStatus().equals(1)) {
                invalidValues.add(new InvalidValue(i18n.translateString("ConfigFrequencyBandCanotBeChanged", new Object[]{chnl.getRbAuChannelAssociatedOduId().toString()}), RbOduConfigEntry.class, i18n.translateString("rbOduConfigFrequencyBand"), (Object)"", (Object)this));
            }
            if (!changedODUs.contains(chnl.getRbAuChannelAssociatedOduId()) || !chnl.getRbAuChannelAdminStatus().equals(1)) continue;
            this.checkDiversity(auTbl, chnl, invalidValues);
        }
        if (!notDeletedODUs.isEmpty()) {
            MessageBox.Alert.quickShow((Component)this.getUI(), i18n.translateString("outdoorUnitsNotDeleted", new Object[]{((Object)notDeletedODUs).toString()}));
            notDeletedODUs.clear();
        }
    }

    private void checkDiversity(RbAuConfigTable auTbl, RbAuChannelConfigEntry chnl, List<InvalidValue> invalidValues) {
        if (auTbl == null) {
            return;
        }
        if (chnl.getRbAuChannelId().equals(1)) {
            return;
        }
        RbAuConfigEntry auEntry = (RbAuConfigEntry)auTbl.findEntry(chnl.getRbSlotNumber().toString());
        if (!auEntry.getRbAuDiversityMode().equals(1)) {
            invalidValues.add(new InvalidValue(i18n.translateString("ODUInDiversityModeError"), RbOduConfigEntry.class, i18n.translateString("ODUID"), (Object)chnl.getRbAuChannelAssociatedOduId(), (Object)this));
        }
    }

    public static void setTxPower(RbOduConfigEntry entry, String value, List<InvalidValue> invalidValues, boolean softwareVersionUnder41, Object object) {
        double oduTxPower;
        int lowerTxLimit = softwareVersionUnder41 ? 1300 : 0;
        int stepTx = softwareVersionUnder41 ? 25 : 100;
        Integer upperTxLimit = 5000;
        if (entry.getRbOduMaxTxPower() != null && entry.getRbOduMaxTxPower() > 0) {
            upperTxLimit = entry.getRbOduMaxTxPower() * 100;
        }
        String message = i18n.translateString("InvalidTxPower", new Object[]{lowerTxLimit / 100, upperTxLimit / 100, String.format("%.2f", Float.valueOf((float)stepTx / 100.0f))});
        InvalidValue invalidTxPower = new InvalidValue(message, RbOduConfigEntry.class, i18n.translateString("TxPower"), (Object)value, object);
        try {
            oduTxPower = Double.parseDouble(value) * 100.0;
        }
        catch (NumberFormatException nfe) {
            invalidValues.add(invalidTxPower);
            return;
        }
        catch (NullPointerException npe) {
            invalidValues.add(invalidTxPower);
            return;
        }
        if (oduTxPower < (double)lowerTxLimit || oduTxPower > (double)upperTxLimit.intValue() || oduTxPower % (double)stepTx != 0.0) {
            invalidValues.add(invalidTxPower);
        } else {
            entry.setRbOduTxPower(value);
        }
    }

    public String getTitle() {
        return "OutdoorUnits";
    }

    public String getHelpTopic() {
        if (VersionFactory.getInstance().createVersion(this.ctx.getEquipment().getRunningSoftwareVersion()).isOlderThan((Version)new DefaultVersion("4.0"))) {
            return "ngnms.rb.help.outdoor_units";
        }
        return "ngnms.rb.help.tdd_outdoor_units";
    }
}

