/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.binding.ReadOnlyBinder;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.rb.command.RbNpuCommand;
import com.bwanms.rb.gui.configuration.NpuUnitControlPanel;
import com.bwanms.rb.mo.RbBsRadioParameters;
import com.bwanms.rb.mo.RbNpuConfigEntry;
import com.bwanms.rb.mo.RbNpuConfigTable;
import com.bwanms.rb.mo.RbSwUpgrade;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.security.Security;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FormUtil;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JTable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NpuUnitControlConfigForm
extends ManagedObjectsConfigForm<NpuUnitControlPanel> {
    private static final Log log = LogFactory.getLog(NpuUnitControlConfigForm.class);

    public String getTitle() {
        return "UnitControl";
    }

    public List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("BS", RbSwUpgrade.class));
        ret.add(this.ctx.createRequest("BS", RbNpuConfigTable.class));
        ret.add(this.ctx.createRequest("BS", RbBsRadioParameters.class));
        return ret;
    }

    protected NpuUnitControlPanel initUIComponent() {
        NpuUnitControlPanel panel = new NpuUnitControlPanel(this);
        Version softwareVersion = ((RbBaseStationEquipment)this.ctx.getEquipment()).getSoftwareVersion();
        if (softwareVersion.isOlderThan((Version)new DefaultVersion("3.5")) || softwareVersion.isNewerOrEqualWith((Version)new DefaultVersion("4.0"))) {
            panel.getLblLocalClockDateAndTime().setVisible(false);
            panel.getSpnLocalClockDateAndTime().setVisible(false);
            panel.getBtnLocalClockDateAndTime().setVisible(false);
        }
        return panel;
    }

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        RbNpuConfigTable cfgTbl = (RbNpuConfigTable)((Object)managedObjects.get(1));
        ReadOnlyBinder binder = new ReadOnlyBinder((Object)this.getUI(), (Object)cfgTbl.findEntry("5"));
        binder.add((Binding)new JTextFieldBinding("txtRuningSwVersion", "runingSwVersion"));
        binder.add((Binding)new JTextFieldBinding("txtMainSwVersion", "rbNpuOperSwVersion"));
        binder.add((Binding)new JTextFieldBinding("txtShadowSwVersion", "rbNpuShadowSwVersion"));
        binders.add((Binder)binder);
    }

    public void reset() {
        this.fireCommand(RbNpuCommand.createResetCommand((RbBS)this.ctx.getEquipment(), (RbNpuConfigEntry)((Object)this.ctx.getAttribute("NPU"))));
    }

    public void resetAndBootFromShadow() {
        this.fireCommand(RbNpuCommand.createResetAndRunFromShadowCommand((RbBS)this.ctx.getEquipment(), (RbNpuConfigEntry)((Object)this.ctx.getAttribute("NPU"))));
    }

    public void makeRuningVersionOperational() {
        this.fireCommand(RbNpuCommand.createMakeRunningVersionOperationalCommand((RbBS)this.ctx.getEquipment(), (RbNpuConfigEntry)((Object)this.ctx.getAttribute("NPU"))));
    }

    public void loadFactoryDflt() {
        this.fireCommand(RbNpuCommand.createFactoryDefaultsCommand((RbBS)this.ctx.getEquipment(), (RbNpuConfigEntry)((Object)this.ctx.getAttribute("NPU"))));
    }

    public void deleteSwFiles(String swFile) {
        this.fireCommand(RbNpuCommand.createDeleteSwFilesCommand((RbBS)this.ctx.getEquipment(), (RbNpuConfigEntry)((Object)this.ctx.getAttribute("NPU")), swFile));
    }

    public void fillUI(List<Object> managedObjects) {
        if (((RbNpuConfigEntry)((Object)this.ctx.getAttribute("NPU"))).isConnected()) {
            this.enableForm(true);
        } else {
            this.enableForm(false);
        }
        Version softwareVersion = ((RbBaseStationEquipment)this.ctx.getEquipment()).getSoftwareVersion();
        if (!softwareVersion.isOlderThan((Version)new DefaultVersion("3.5")) && !softwareVersion.isNewerOrEqualWith((Version)new DefaultVersion("4.0"))) {
            Date deviceDate;
            RbBsRadioParameters bsRadioParameters = (RbBsRadioParameters)((Object)managedObjects.get(2));
            SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            try {
                deviceDate = formatter.parse(bsRadioParameters.getRbLocalClockDateAndTime());
            }
            catch (ParseException parseEx) {
                deviceDate = new Date();
            }
            ((NpuUnitControlPanel)this.getUI()).getSpnLocalClockDateAndTime().setValue(deviceDate);
            ((NpuUnitControlPanel)this.getUI()).getSpnLocalClockDateAndTime().revalidate();
        }
        RbSwUpgrade swUpgrade = (RbSwUpgrade)((Object)managedObjects.get(0));
        SimpleRowTableModel model = (SimpleRowTableModel)((NpuUnitControlPanel)this.getUI()).getTblAuFiles().getModel();
        FormUtil.cancelTableEditing((JTable)((NpuUnitControlPanel)this.getUI()).getTblAuFiles());
        model.clearTable();
        int row = 0;
        if (swUpgrade.getRbSwAuFiles().trim().length() > 0) {
            String[] auFiles;
            for (String file : auFiles = swUpgrade.getRbSwAuFiles().split(";")) {
                model.addNewRow(file, true);
                model.setInitialValueAt((Object)file, row++, 0);
            }
        }
        model.sort();
        model = (SimpleRowTableModel)((NpuUnitControlPanel)this.getUI()).getTblSuFiles().getModel();
        FormUtil.cancelTableEditing((JTable)((NpuUnitControlPanel)this.getUI()).getTblAuFiles());
        model.clearTable();
        row = 0;
        if (swUpgrade.getRbSwSuFiles().trim().length() > 0) {
            String[] suFiles;
            for (String file : suFiles = swUpgrade.getRbSwSuFiles().split(";")) {
                model.addNewRow(file, true);
                model.setInitialValueAt((Object)file, row++, 0);
            }
        }
        model.sort();
    }

    protected void configureMOs(List<Object> managedObjects, List<InvalidValue> invalidValues) {
        RbBsRadioParameters bsRadioParameters = (RbBsRadioParameters)((Object)managedObjects.get(2));
        Date date = (Date)((NpuUnitControlPanel)this.getUI()).getSpnLocalClockDateAndTime().getValue();
        bsRadioParameters.setRbLocalClockDateAndTime(new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format(date));
    }

    private void enableForm(boolean enabled) {
        ((NpuUnitControlPanel)this.getUI()).getLblMainSwVersion().setEnabled(enabled);
        ((NpuUnitControlPanel)this.getUI()).getLblRuningSwVersion().setEnabled(enabled);
        ((NpuUnitControlPanel)this.getUI()).getLblShadowSwVersion().setEnabled(enabled);
        ((NpuUnitControlPanel)this.getUI()).getBtnReset().setEnabled(enabled);
        ((NpuUnitControlPanel)this.getUI()).getBtnResetAndBootFromShadow().setEnabled(enabled);
        ((NpuUnitControlPanel)this.getUI()).getBtnLoadFactoryDefaults().setEnabled(enabled);
        ((NpuUnitControlPanel)this.getUI()).getBtnMakeRuningVersionOperational().setEnabled(enabled);
        if (!Security.getSecurity().checkPermissions("Av:ConfigureEquipment", "write")) {
            ((NpuUnitControlPanel)this.getUI()).getBtnDeleteAuFiles().setEnabled(false);
            ((NpuUnitControlPanel)this.getUI()).getBtnDeleteSuFiles().setEnabled(false);
            ((NpuUnitControlPanel)this.getUI()).getBtnLoadFactoryDefaults().setEnabled(false);
            ((NpuUnitControlPanel)this.getUI()).getBtnMakeRuningVersionOperational().setEnabled(false);
            ((NpuUnitControlPanel)this.getUI()).getBtnReset().setEnabled(false);
            ((NpuUnitControlPanel)this.getUI()).getBtnResetAndBootFromShadow().setEnabled(false);
            ((NpuUnitControlPanel)this.getUI()).getTblAuFiles().setEnabled(false);
            ((NpuUnitControlPanel)this.getUI()).getTblSuFiles().setEnabled(false);
        }
    }

    public boolean forceRefresh() {
        return true;
    }

    public String getHelpTopic() {
        if (VersionFactory.getInstance().createVersion(this.ctx.getEquipment().getRunningSoftwareVersion()).isOlderThan((Version)new DefaultVersion("4.0"))) {
            return "ngnms.rb.help.npu_unit_control";
        }
        return "ngnms.rb.help.tdd_npu_unit_control";
    }
}

