/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.binding.ReadOnlyBinder;
import com.bwanms.gui.binding.translators.TranslateException;
import com.bwanms.gui.binding.translators.ValueTranslator;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.rb.gui.configuration.NpuSummaryPanel;
import com.bwanms.rb.mo.RbNpuConfigEntry;
import com.bwanms.rb.mo.RbNpuConfigTable;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NpuSummaryConfigForm
extends ManagedObjectsConfigForm<NpuSummaryPanel> {
    private static Internationalizer i18n = Internationalizer.getInternationalizer(NpuSummaryConfigForm.class);

    protected List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("BS", RbNpuConfigTable.class));
        return ret;
    }

    protected NpuSummaryPanel initUIComponent() {
        return new NpuSummaryPanel();
    }

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        RbNpuConfigEntry npu = (RbNpuConfigEntry)((Object)this.ctx.getAttribute("NPU"));
        if (npu == null) {
            return;
        }
        RbNpuConfigTable cfgTbl = (RbNpuConfigTable)((Object)managedObjects.get(0));
        ReadOnlyBinder binder = new ReadOnlyBinder((Object)this.getUI(), (Object)cfgTbl.findEntry(String.valueOf(npu.getRbSlotNumber())));
        binder.add((Binding)new JTextFieldBinding("txtCumulativePowerOnTime", "rbNpuCumulativePowerOnTime", (ValueTranslator)new ValueTranslator<Long, String>(){

            public String convertToUIValue(Long beanValue) throws TranslateException {
                if (beanValue == 0L) {
                    return i18n.translateString("unknown");
                }
                return beanValue.toString();
            }

            public Long convertToBeanValue(String uiBeanValue) throws TranslateException {
                return null;
            }
        }));
        binders.add((Binder)binder);
    }

    protected void fillUI(List<Object> managedObjects) {
        RbNpuConfigTable table = (RbNpuConfigTable)((Object)managedObjects.get(0));
        for (RbNpuConfigEntry entry : table.getEntries()) {
            if (entry.getRbNpuRedundancyStatus() != 1) continue;
            ((NpuSummaryPanel)this.getUI()).getTxtFaultStatus().setText(i18n.translateString(RbNpuConfigEntry.toStringRbNpuFaultStatus(entry.getRbNpuFaultStatus())));
            ((NpuSummaryPanel)this.getUI()).getTxtManagementInterface().setText(i18n.translateString(RbNpuConfigEntry.toStringRbNpuManagementInterface(entry.getRbNpuManagementInterface())));
            ((NpuSummaryPanel)this.getUI()).getTxtRunningSw().setText(i18n.translateString(RbNpuConfigEntry.toStringRbNpuRunningSoftware(entry.getRbNpuRunningSoftware())));
            ((NpuSummaryPanel)this.getUI()).getTxtOperationalSwVersion().setText(entry.getRbNpuOperSwVersion());
            ((NpuSummaryPanel)this.getUI()).getTxtShadowSwVersion().setText(entry.getRbNpuShadowSwVersion());
            ((NpuSummaryPanel)this.getUI()).getTxtSerialNumber().setText(entry.getRbNpuSerialNo());
            ((NpuSummaryPanel)this.getUI()).getTxtHWRevision().setText(entry.getRbNpuHwRevision());
            ((NpuSummaryPanel)this.getUI()).getTxtHWConfig().setText(entry.getRbNpuHwConfigDescription());
            break;
        }
    }

    public boolean canApply() {
        return false;
    }

    public String getHelpTopic() {
        if (VersionFactory.getInstance().createVersion(this.ctx.getEquipment().getRunningSoftwareVersion()).isOlderThan((Version)new DefaultVersion("4.0"))) {
            return "ngnms.rb.help.npu_view";
        }
        return "ngnms.rb.help.tdd_npu_view";
    }
}

