/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.rb.gui.configuration.NPUFreqBandsPanel;
import com.bwanms.rb.mo.RbFrequencyBandsEntry;
import com.bwanms.rb.mo.RbFrequencyBandsTable;
import com.bwanms.rb.mo.RbNpuFrequencyBandsParameters;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FormUtil;
import com.bwanms.util.TableUtil;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NPUFreqBandsConfigForm
extends ManagedObjectsConfigForm<NPUFreqBandsPanel> {
    public NPUFreqBandsPanel initUIComponent() {
        return new NPUFreqBandsPanel();
    }

    public List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("BS", RbNpuFrequencyBandsParameters.class));
        ret.add(this.ctx.createRequest("BS", RbFrequencyBandsTable.class));
        return ret;
    }

    protected void fillUI(List<Object> managedObjects) {
        SimpleRowTableModel tableModel = ((NPUFreqBandsPanel)this.getUI()).getTableModel();
        FormUtil.cancelTableEditing((JTable)((NPUFreqBandsPanel)this.getUI()).getTable2());
        tableModel.clearTable();
        RbNpuFrequencyBandsParameters params = (RbNpuFrequencyBandsParameters)((Object)managedObjects.get(0));
        ((NPUFreqBandsPanel)this.getUI()).getTxtFileVersion().setText(params.getRbFrequencyBandsFileVersion().toString());
        RbFrequencyBandsTable table = (RbFrequencyBandsTable)((Object)managedObjects.get(1));
        List sortedBands = table.getEntries();
        Collections.sort(sortedBands);
        int row = 0;
        for (RbFrequencyBandsEntry entry : sortedBands) {
            int col = 0;
            tableModel.addNewRow(null, true);
            tableModel.setRowState(row, 0);
            tableModel.setInitialValueAt((Object)entry.getRbFrequencyBandId(), row, col++);
            tableModel.setInitialValueAt((Object)entry.getRbFrequencyBandName(), row, col++);
            tableModel.setInitialValueAt((Object)entry.getRbFrequencyBandGroupId(), row, col++);
            tableModel.setInitialValueAt((Object)this.divideBy1000(entry.getRbFrequencyBandStartFrequency()), row, col++);
            tableModel.setInitialValueAt((Object)this.divideBy1000(entry.getRbFrequencyBandStopFrequency()), row, col++);
            tableModel.setInitialValueAt((Object)entry.getRbFrequencyBandStep(), row, col++);
            tableModel.setInitialValueAt((Object)this.divideBy1000(entry.getRbFrequencyBandDuplexSeparation().longValue()), row, col++);
            ++row;
        }
        TableUtil.autoResizeColumn((JTable)((NPUFreqBandsPanel)this.getUI()).getTable2(), (int)0, (boolean)true);
        TableUtil.autoResizeColumn((JTable)((NPUFreqBandsPanel)this.getUI()).getTable2(), (int)1, (boolean)true);
        TableUtil.autoResizeColumn((JTable)((NPUFreqBandsPanel)this.getUI()).getTable2(), (int)2, (boolean)true);
        tableModel.sort();
    }

    private String divideBy1000(Long frequency) {
        double freq = frequency.doubleValue();
        return Double.toString(freq / 1000.0);
    }

    public boolean canApply() {
        return false;
    }

    public String getHelpTopic() {
        if (VersionFactory.getInstance().createVersion(this.ctx.getEquipment().getRunningSoftwareVersion()).isOlderThan((Version)new DefaultVersion("4.0"))) {
            return "ngnms.rb.help.freq_bands";
        }
        return "ngnms.rb.help.tdd_freq_bands";
    }
}

