/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.TableBinder;
import com.bwanms.gui.binding.TableColumnBinding;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.FormsConfigSectionView;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.mo.TableRowMO;
import com.bwanms.mo.snmp.SNMPTableMO;
import com.bwanms.rb.gui.configuration.OutdoorUnitsConfigForm;
import com.bwanms.rb.gui.configuration.OutdoorUnitsPanel;
import com.bwanms.rb.mo.RbMBSTAdditionalConfigParameters;
import com.bwanms.rb.mo.RbMBSTChannelConfigEntry;
import com.bwanms.rb.mo.RbMBSTChannelConfigTable;
import com.bwanms.rb.mo.RbMBSTFrequencyBandsEntry;
import com.bwanms.rb.mo.RbMBSTFrequencyBandsTable;
import com.bwanms.rb.mo.RbOduConfigEntry;
import com.bwanms.rb.mo.RbOduConfigTable;
import com.bwanms.rb.mo.RbRadioClusterEntry;
import com.bwanms.rb.mo.RbRadioClusterTable;
import com.bwanms.rb.model.RbMBS;
import com.bwanms.rb.util.RbVersions;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FormUtil;
import com.bwanms.util.MessageBox;
import com.bwanms.util.TableUtil;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.impl.DefaultVersion;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.JTable;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MbstOutdoorUnitsConfigForm
extends ManagedObjectsConfigForm<OutdoorUnitsPanel> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(MbstOutdoorUnitsConfigForm.class);
    private boolean softwareVersionAbove30;
    private boolean softwareVersionUnder41;
    private boolean softwareVersionUnder4117;

    public OutdoorUnitsPanel initUIComponent() {
        this.softwareVersionAbove30 = ((RbMBS)this.ctx.getEquipment()).getSoftwareVersion().compareTo((Object)new DefaultVersion("3.0")) > 0;
        this.softwareVersionUnder41 = ((RbMBS)this.ctx.getEquipment()).getSoftwareVersion().compareTo((Object)new DefaultVersion("4.1")) < 0;
        this.softwareVersionUnder4117 = ((RbMBS)this.ctx.getEquipment()).getSoftwareVersion().compareTo((Object)new DefaultVersion("4.1.1.7")) < 0;
        return new OutdoorUnitsPanel(this.softwareVersionUnder4117);
    }

    public List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("BS", RbOduConfigTable.class));
        ret.add(this.ctx.createRequest("BS", RbRadioClusterTable.class));
        ret.add(this.ctx.createRequest("BS", RbMBSTFrequencyBandsTable.class));
        ret.add(this.ctx.createRequest("BS", RbMBSTChannelConfigTable.class));
        if (this.softwareVersionAbove30) {
            ret.add(this.ctx.createRequest("BS", RbMBSTAdditionalConfigParameters.class));
        }
        return ret;
    }

    public void fillUI(List<Object> managedObjects) {
        FormUtil.cancelTableEditing((JTable)((OutdoorUnitsPanel)this.getUI()).getTable2());
        ((OutdoorUnitsPanel)this.getUI()).getTable2Model().clearTable();
        for (int i = 0; i < 4; ++i) {
            ((OutdoorUnitsPanel)this.getUI()).getTable2Model().addNewRow(Integer.toString(i + 1), true);
            ((OutdoorUnitsPanel)this.getUI()).getTable2Model().setRowState(i, 4);
            ((OutdoorUnitsPanel)this.getUI()).getTable2Model().setInitialValueAt((Object)(i + 1), i, 0);
        }
        ((OutdoorUnitsPanel)this.getUI()).getController().resetDetails();
        ArrayList<ComboItem> clusters = new ArrayList<ComboItem>();
        RbRadioClusterTable clusterTable = (RbRadioClusterTable)((Object)managedObjects.get(1));
        clusters.add(new ComboItem((Object)0, i18n.translateString("noCluster")));
        List sortedClusters = clusterTable.getEntries();
        Collections.sort(sortedClusters, new Comparator<RbRadioClusterEntry>(){

            @Override
            public int compare(RbRadioClusterEntry o1, RbRadioClusterEntry o2) {
                return o1.getRbRadioClusterName().compareTo(o2.getRbRadioClusterName());
            }
        });
        for (RbRadioClusterEntry entry : sortedClusters) {
            clusters.add(new ComboItem((Object)entry.getRbRadioClusterId(), entry.getRbRadioClusterName()));
        }
        ((OutdoorUnitsPanel)this.getUI()).getTable2Model().setValueSet(-1, 1, clusters);
        ArrayList<ComboItem> bands = new ArrayList<ComboItem>();
        RbMBSTFrequencyBandsTable bandsTable = (RbMBSTFrequencyBandsTable)((Object)managedObjects.get(2));
        List sortedBands = bandsTable.getEntries();
        Collections.sort(sortedBands, new Comparator<RbMBSTFrequencyBandsEntry>(){

            @Override
            public int compare(RbMBSTFrequencyBandsEntry o1, RbMBSTFrequencyBandsEntry o2) {
                return o1.getRbMBSTFrequencyBandId().compareTo(o2.getRbMBSTFrequencyBandId());
            }
        });
        for (RbMBSTFrequencyBandsEntry entry : sortedBands) {
            bands.add(new ComboItem((Object)entry.getRbMBSTFrequencyBandId().intValue(), entry.getRbMBSTFrequencyBandName()));
        }
        ((OutdoorUnitsPanel)this.getUI()).getTable2Model().setValueSet(-1, this.softwareVersionUnder4117 ? 3 : 4, bands);
        RbMBSTChannelConfigTable auTable = (RbMBSTChannelConfigTable)((Object)managedObjects.get(3));
        RbOduConfigTable table = (RbOduConfigTable)((Object)managedObjects.get(0));
        if (table != null) {
            for (RbOduConfigEntry entry : table.getEntries()) {
                int col = 1;
                int counter = entry.getRbOduConfigId() - 1;
                if (counter >= 4) continue;
                ((OutdoorUnitsPanel)this.getUI()).getTable2Model().setInitialValueAt((Object)entry.getRbOduAssociatedRadioClusterId(), counter, col++);
                if (!this.softwareVersionUnder4117) {
                    ((OutdoorUnitsPanel)this.getUI()).getTable2Model().setInitialValueAt((Object)entry.getRbOduActualTxPower(), counter, col++);
                }
                ((OutdoorUnitsPanel)this.getUI()).getTable2Model().setInitialValueAt((Object)entry.getRbOduTxPower(), counter, col++);
                if (entry.getRbOduConfigFrequencyBand() != 0) {
                    ((OutdoorUnitsPanel)this.getUI()).getTable2Model().setInitialValueAt((Object)entry.getRbOduConfigFrequencyBand(), counter, col);
                }
                int n = ++col;
                ((OutdoorUnitsPanel)this.getUI()).getTable2Model().setInitialValueAt((Object)entry.getRbOduAdminStatus(), counter, n);
                int n2 = ++col;
                ++col;
                ((OutdoorUnitsPanel)this.getUI()).getTable2Model().setInitialValueAt((Object)entry.getRbOduOperationalStatus(), counter, n2);
                ((OutdoorUnitsPanel)this.getUI()).getTable2Model().setRowState(counter, 0);
                RbMBSTChannelConfigEntry auEntry = null;
                for (RbMBSTChannelConfigEntry auEntry1 : auTable.getEntries()) {
                    if (!auEntry1.getRbMBSTChannelAssociatedOduId().equals(entry.getRbOduConfigId())) continue;
                    if (auEntry1.getRbMBSTChannelAdminStatus() != 1) continue;
                    auEntry = auEntry1;
                    break;
                }
                RbMBS bs = (RbMBS)this.ctx.getEquipment();
                Version softwareVersion = bs.getSoftwareVersion();
                if (auEntry != null) {
                    String[] oduDetails = RbVersions.V_4_5.isOlderOrEqualWith(softwareVersion) ? new String[]{entry.getRbOduCardSerialNumber(), entry.getRbOduHwRevision(), entry.getRbOduHwConfigDescription(), entry.getRbOduHwHC08Version(), entry.getRbOduCpldVersion(), entry.getRbOduOperationalStatus() == 2 ? "NA" : entry.getRbOduTemperature().toString(), entry.getRbOduMaxTxPower() == null || entry.getRbOduOperationalStatus() == 2 ? "NA" : entry.getRbOduMaxTxPower().toString(), "mbs", "", auEntry.getRbMBSTChannelId().toString(), entry.getRbOduStatusMask(), entry.toStringRbOduGeneralDescription(entry.getRbOduGeneralDescription())} : new String[]{entry.getRbOduCardSerialNumber(), entry.getRbOduHwRevision(), entry.getRbOduHwConfigDescription(), entry.getRbOduHwHC08Version(), entry.getRbOduCpldVersion(), entry.getRbOduOperationalStatus() == 2 ? "NA" : entry.getRbOduTemperature().toString(), entry.getRbOduMaxTxPower() == null || entry.getRbOduOperationalStatus() == 2 ? "NA" : entry.getRbOduMaxTxPower().toString(), "mbs", "", auEntry.getRbMBSTChannelId().toString()};
                    ((OutdoorUnitsPanel)this.getUI()).getController().addDetails(counter, oduDetails);
                    continue;
                }
                ((OutdoorUnitsPanel)this.getUI()).getController().addDetails(counter, new String[]{entry.getRbOduCardSerialNumber(), entry.getRbOduHwRevision(), entry.getRbOduHwConfigDescription(), entry.getRbOduHwHC08Version(), entry.getRbOduCpldVersion(), entry.getRbOduOperationalStatus() == 2 ? "NA" : entry.getRbOduTemperature().toString(), entry.getRbOduMaxTxPower() == null || entry.getRbOduOperationalStatus() == 2 ? "NA" : entry.getRbOduMaxTxPower().toString(), "mbs", ""});
            }
        }
        TableUtil.autoResizeColumn((JTable)((OutdoorUnitsPanel)this.getUI()).getTable2(), (int)0, (boolean)true);
        ((OutdoorUnitsPanel)this.getUI()).getTable2Model().sort();
        FormsConfigSectionView formsConfigSectionView = (FormsConfigSectionView)this.getConfigSectionView();
        String oduId = String.valueOf(formsConfigSectionView.getAttribute("oduId"));
        if (oduId != null) {
            try {
                int chanelIdInt = Integer.parseInt(oduId) - 1;
                ((OutdoorUnitsPanel)this.getUI()).getTable2().setRowSelectionInterval(chanelIdInt, chanelIdInt);
            }
            catch (Exception e) {}
        } else {
            ((OutdoorUnitsPanel)this.getUI()).getTable2().clearSelection();
        }
    }

    public void configureMOs(List<Object> managedObjects, List<InvalidValue> invalidValues) {
        SimpleRowTableModel model = ((OutdoorUnitsPanel)this.getUI()).getTable2Model();
        FormUtil.stopTableEditing((JTable)((OutdoorUnitsPanel)this.getUI()).getTable2());
        RbOduConfigTable oduTable = (RbOduConfigTable)((Object)managedObjects.get(0));
        RbMBSTChannelConfigTable channelTable = (RbMBSTChannelConfigTable)((Object)managedObjects.get(3));
        HashSet<Integer> changedFreqBandODUs = new HashSet<Integer>();
        HashSet<Integer> changedODUs = new HashSet<Integer>();
        ArrayList<Integer> notDeletedODUs = new ArrayList<Integer>();
        RbMBSTAdditionalConfigParameters configParams = null;
        if (this.softwareVersionAbove30) {
            configParams = (RbMBSTAdditionalConfigParameters)((Object)managedObjects.get(4));
        }
        block5: for (int i = 0; i < model.getRowCount(); ++i) {
            Integer clusterId = (Integer)model.getValueAt(i, 1);
            Integer statusId = (Integer)model.getValueAt(i, this.softwareVersionUnder4117 ? 4 : 5);
            RbOduConfigEntry entry = (RbOduConfigEntry)oduTable.findEntry(model.getRowKey(i));
            if (model.getRowState(i) == 3 || model.getRowState(i) == 5) {
                if (clusterId == null) {
                    invalidValues.add(new InvalidValue(i18n.translateString("MandatoryValue"), RbOduConfigEntry.class, i18n.translateString("rbOduAssociatedRadioClusterId"), null, (Object)this));
                } else if (Integer.valueOf(1).equals(statusId) && clusterId.equals(0)) {
                    if (entry == null || !clusterId.equals(entry.getRbOduAssociatedRadioClusterId())) {
                        invalidValues.add(new InvalidValue(i18n.translateString("NoClusterEnabled"), RbOduConfigEntry.class, i18n.translateString("AssociatedRadioCluster"), (Object)i18n.translateString("noCluster"), (Object)this));
                    }
                    if (entry == null || !entry.getRbOduAdminStatus().equals(statusId)) {
                        invalidValues.add(new InvalidValue(i18n.translateString("CanNotEnebleNoCluster"), RbOduConfigEntry.class, i18n.translateString("AdminStatus"), (Object)i18n.translateString(RbOduConfigEntry.toStringRbOduAdminStatus(statusId)), (Object)this));
                    }
                }
            }
            switch (model.getRowState(i)) {
                case 3: {
                    entry.setRbOduAssociatedRadioClusterId(clusterId);
                    OutdoorUnitsConfigForm.setTxPower(entry, (String)model.getValueAt(i, this.softwareVersionUnder4117 ? 2 : 3), invalidValues, this.softwareVersionUnder41, (Object)this);
                    if (!entry.getRbOduConfigFrequencyBand().equals(model.getValueAt(i, this.softwareVersionUnder4117 ? 3 : 4))) {
                        entry.setRbOduConfigFrequencyBand((Integer)model.getValueAt(i, this.softwareVersionUnder4117 ? 3 : 4));
                        changedFreqBandODUs.add(entry.getRbOduConfigId());
                    }
                    changedODUs.add(entry.getRbOduConfigId());
                    entry.setRbOduAdminStatus(statusId);
                    continue block5;
                }
                case 1: {
                    boolean isAssocWithChannel = false;
                    for (RbMBSTChannelConfigEntry chnl : channelTable.getEntries()) {
                        if (!entry.getRbOduConfigId().equals(chnl.getRbMBSTChannelAssociatedOduId())) continue;
                        isAssocWithChannel = true;
                        break;
                    }
                    if (!isAssocWithChannel) {
                        oduTable.removeEntry(entry.getRowKey());
                        continue block5;
                    }
                    notDeletedODUs.add(entry.getRbOduConfigId());
                    continue block5;
                }
                case 5: {
                    boolean addEntry = true;
                    if (entry != null) {
                        addEntry = false;
                    } else {
                        entry = new RbOduConfigEntry();
                        entry.setRbOduConfigId(i + 1);
                        addEntry = true;
                    }
                    entry.setRbOduAssociatedRadioClusterId(clusterId);
                    OutdoorUnitsConfigForm.setTxPower(entry, (String)model.getValueAt(i, this.softwareVersionUnder4117 ? 2 : 3), invalidValues, this.softwareVersionUnder41, (Object)this);
                    if ((Integer)model.getValueAt(i, this.softwareVersionUnder4117 ? 3 : 4) != null) {
                        entry.setRbOduConfigFrequencyBand((Integer)model.getValueAt(i, this.softwareVersionUnder4117 ? 3 : 4));
                    } else {
                        invalidValues.add(new InvalidValue(i18n.translateString("ConfiguredBandNotSelected"), RbOduConfigEntry.class, i18n.translateString("ConfiguredBand"), null, (Object)entry));
                    }
                    entry.setRbOduAdminStatus(statusId);
                    if (!addEntry) continue block5;
                    oduTable.addEntry((TableRowMO)entry);
                }
            }
        }
        for (RbMBSTChannelConfigEntry chnl : channelTable.getEntries()) {
            if (changedFreqBandODUs.contains(chnl.getRbMBSTChannelAssociatedOduId()) && chnl.getRbMBSTChannelAdminStatus().equals(1)) {
                invalidValues.add(new InvalidValue(i18n.translateString("ConfigFrequencyBandCanotBeChanged", new Object[]{chnl.getRbMBSTChannelAssociatedOduId().toString()}), RbOduConfigEntry.class, i18n.translateString("ODUID"), (Object)chnl.getRbMBSTChannelAssociatedOduId().toString(), (Object)this));
            }
            if (!changedODUs.contains(chnl.getRbMBSTChannelAssociatedOduId())) continue;
            if (chnl.getRbMBSTChannelId().equals(1) || configParams == null) break;
            if (!chnl.getRbMBSTChannelAdminStatus().equals(1) || configParams.getRbMBSTDiversityMode().equals(1)) continue;
            invalidValues.add(new InvalidValue(i18n.translateString(this.softwareVersionUnder4117 ? "ODUAssociatedToChannelEnabled" : "ODUInDiversityModeError"), RbOduConfigEntry.class, i18n.translateString("ODUID"), (Object)chnl.getRbMBSTChannelAssociatedOduId().toString(), (Object)this));
        }
        if (!notDeletedODUs.isEmpty()) {
            MessageBox.Alert.quickShow((Component)this.getUI(), i18n.translateString("outdoorUnitsNotDeleted", new Object[]{((Object)notDeletedODUs).toString()}));
            notDeletedODUs.clear();
        }
    }

    public String getTitle() {
        return "OutdoorUnits";
    }

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        TableBinder binder = new TableBinder(i18n, ((OutdoorUnitsPanel)this.getUI()).getTable2Model(), (SNMPTableMO)managedObjects.get(0));
        binder.add((Binding)new TableColumnBinding("TxPower", "rbOduTxPower"));
        binders.add((Binder)binder);
    }

    public String getHelpTopic() {
        return "ngnms.rb.help.outdoor_units";
    }
}

