/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JComboBoxBinding;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.binding.ReadOnlyBinder;
import com.bwanms.gui.binding.translators.TranslateException;
import com.bwanms.gui.binding.translators.ValueTranslator;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.rb.gui.configuration.MbstManagementPortPanel;
import com.bwanms.rb.mo.RbIfInfoEntry;
import com.bwanms.rb.mo.RbMbstEthIfConfigEntry;
import com.bwanms.rb.mo.RbMbstIfInfoEntry;
import com.bwanms.rb.mo.RbMbstIpIfConfigEntry;
import com.bwanms.util.MacAddress;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MbstManagementPortConfigForm
extends ManagedObjectsConfigForm<MbstManagementPortPanel> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(MbstManagementPortConfigForm.class);

    public MbstManagementPortPanel initUIComponent() {
        return new MbstManagementPortPanel();
    }

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        RbMbstEthIfConfigEntry eth = (RbMbstEthIfConfigEntry)((Object)managedObjects.get(1));
        ReadOnlyBinder binder = new ReadOnlyBinder((Object)this.getUI(), (Object)eth);
        binder.add((Binding)new JTextFieldBinding("txtCrtAutoNegotiation", "ethConfigCurrentdAutoNegotiation", (ValueTranslator)new ValueTranslator<Integer, String>(){

            public String convertToUIValue(Integer beanValue) throws TranslateException {
                return i18n.translateString(RbMbstEthIfConfigEntry.toStringEthConfigCurrentdAutoNegotiation(beanValue));
            }

            public Integer convertToBeanValue(String uiBeanValue) throws TranslateException {
                return null;
            }
        }, i18n.translateString("AutoNegotiationMode")));
        binder.add((Binding)new JTextFieldBinding("txtCrtSpeedAndDuplex", "ethConfigCurrentLinkSpeedAndDuplex", (ValueTranslator)new ValueTranslator<Integer, String>(){

            public String convertToUIValue(Integer beanValue) throws TranslateException {
                return i18n.translateString(RbMbstEthIfConfigEntry.toStringEthConfigCurrentLinkSpeedAndDuplex(beanValue));
            }

            public Integer convertToBeanValue(String uiBeanValue) throws TranslateException {
                return null;
            }
        }, i18n.translateString("LinkSpeed")));
        binders.add((Binder)binder);
        binder = new DefaultBinder((Object)this.getUI(), (Object)eth);
        binder.add((Binding)new JComboBoxBinding(i18n, "cmbCfgAutoNegotiation", "ethConfigAutoNegotiation", i18n.translateString("AutoNegociationMode")));
        JComboBoxBinding speedDuplexBinding = new JComboBoxBinding(i18n, "cmbCfgSpeedAndDuplex", "ethConfigLinkSpeedAndDuplex", i18n.translateString("LinkSpeed"));
        speedDuplexBinding.setIgnoreDisabled(true);
        binder.add((Binding)speedDuplexBinding);
        binders.add((Binder)binder);
        RbMbstIfInfoEntry ifEntry = (RbMbstIfInfoEntry)((Object)managedObjects.get(2));
        binder = new ReadOnlyBinder((Object)this.getUI(), (Object)ifEntry);
        binder.add((Binding)new JTextFieldBinding("txtOperationalStatus", "ifOperStatus", (ValueTranslator)new ValueTranslator<Integer, String>(){

            public String convertToUIValue(Integer beanValue) throws TranslateException {
                return i18n.translateString(RbIfInfoEntry.toStringIfOperStatus(beanValue));
            }

            public Integer convertToBeanValue(String uiBeanValue) throws TranslateException {
                return null;
            }
        }, i18n.translateString("OperationalStatus")));
        binders.add((Binder)binder);
        RbMbstIpIfConfigEntry ipIfConfigEntry = (RbMbstIpIfConfigEntry)((Object)managedObjects.get(0));
        binder = new DefaultBinder((Object)this.getUI(), (Object)ipIfConfigEntry);
        binder.add((Binding)new JTextFieldBinding("txtDefaultGatewayMgmt", "ipIfConfigDefaultGateway", i18n.translateString("DefaultGateway")));
        binder.add((Binding)new JTextFieldBinding("txtIPAddressMgmt", "ipIfConfigIpAddress", i18n.translateString("IPAddress")));
        binder.add((Binding)new JTextFieldBinding("txtNetworkMaskMgmt", "ipIfConfigNetworkMask", i18n.translateString("SubnetMask")));
        binder.add((Binding)new JTextFieldBinding("txtNetworkDestination", "ipIfStaticRouteSubnet", i18n.translateString("NetworkDestination")));
        binder.add((Binding)new JTextFieldBinding("txtNetMask", "ipIfStaticRouteSubnetMask", i18n.translateString("NetMask")));
        binders.add((Binder)binder);
    }

    public List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("BS", RbMbstIpIfConfigEntry.class, "2"));
        ret.add(this.ctx.createRequest("BS", RbMbstEthIfConfigEntry.class, "2"));
        ret.add(this.ctx.createRequest("BS", RbMbstIfInfoEntry.class, "2"));
        return ret;
    }

    public void fillUI(List<Object> managedObjects) {
        RbMbstIpIfConfigEntry ipIfConfigEntry = (RbMbstIpIfConfigEntry)((Object)managedObjects.get(0));
        ((MbstManagementPortPanel)this.getUI()).getTxtIPAddressMgmt().setText(ipIfConfigEntry.getIpIfConfigIpAddress());
        ((MbstManagementPortPanel)this.getUI()).getTxtNetworkMaskMgmt().setText(ipIfConfigEntry.getIpIfConfigNetworkMask());
        ((MbstManagementPortPanel)this.getUI()).getTxtDefaultGatewayMgmt().setText(ipIfConfigEntry.getIpIfConfigDefaultGateway());
        ((MbstManagementPortPanel)this.getUI()).getTxtNetworkDestination().setText(ipIfConfigEntry.getIpIfStaticRouteSubnet());
        ((MbstManagementPortPanel)this.getUI()).getTxtNetMask().setText(ipIfConfigEntry.getIpIfStaticRouteSubnetMask());
        ipIfConfigEntry.getChangeStrategy().acknowledge();
        RbMbstEthIfConfigEntry ethIfConfig = (RbMbstEthIfConfigEntry)((Object)managedObjects.get(1));
        ethIfConfig.getChangeStrategy().acknowledge();
        RbMbstIfInfoEntry ifInfoEntry = (RbMbstIfInfoEntry)((Object)managedObjects.get(2));
        String ifPhysAddress = ifInfoEntry.getIfPhysAddress();
        if (ifPhysAddress != null) {
            ((MbstManagementPortPanel)this.getUI()).getTxtMacAddress().setText(MacAddress.fromOctetString((String)ifPhysAddress).toDashedString());
        }
    }

    public void configureMOs(List<Object> managedObjects) {
        RbMbstIpIfConfigEntry ipIfConfigEntry = (RbMbstIpIfConfigEntry)((Object)managedObjects.get(0));
        ipIfConfigEntry.setIpIfConfigIpAddress(((MbstManagementPortPanel)this.getUI()).getTxtIPAddressMgmt().getText());
        ipIfConfigEntry.setIpIfConfigNetworkMask(((MbstManagementPortPanel)this.getUI()).getTxtNetworkMaskMgmt().getText());
        ipIfConfigEntry.setIpIfConfigDefaultGateway(((MbstManagementPortPanel)this.getUI()).getTxtDefaultGatewayMgmt().getText());
        ipIfConfigEntry.setIpIfStaticRouteSubnet(((MbstManagementPortPanel)this.getUI()).getTxtNetworkDestination().getText());
        ipIfConfigEntry.setIpIfStaticRouteSubnetMask(((MbstManagementPortPanel)this.getUI()).getTxtNetMask().getText());
    }

    public String getTitle() {
        return "ManagementPort";
    }

    public String warnApply() {
        return i18n.translateString("ApplyingMayCauseInability");
    }

    public String getHelpTopic() {
        return "ngnms.rb.help.mbs_management_port";
    }
}

