/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.binding.ReadOnlyBinder;
import com.bwanms.gui.binding.translators.ParserValueTranslator;
import com.bwanms.gui.binding.translators.TranslateException;
import com.bwanms.gui.binding.translators.ValueTranslator;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.rb.gui.configuration.MbstGeneralDetailsPanel;
import com.bwanms.rb.mo.RbSysGeneral;
import com.bwanms.rb.mo.RbSysMicroBSTConfig;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.util.RbVersions;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MbstGeneralDetailsConfigForm
extends ManagedObjectsConfigForm<MbstGeneralDetailsPanel> {
    private static Internationalizer i18n = Internationalizer.getInternationalizer(MbstGeneralDetailsConfigForm.class);

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        ReadOnlyBinder binder = new ReadOnlyBinder((Object)this.getUI(), managedObjects.get(1));
        binder.add((Binding)new JTextFieldBinding("txtFaultStatus", "rbSysFaultStatus", (ValueTranslator)new ValueTranslator<Integer, String>(){

            public String convertToUIValue(Integer beanValue) throws TranslateException {
                return i18n.translateString(RbSysGeneral.toStringRbSysFaultStatus(beanValue));
            }

            public Integer convertToBeanValue(String uiBeanValue) throws TranslateException {
                return null;
            }
        }));
        binders.add((Binder)binder);
        binder = new ReadOnlyBinder((Object)this.getUI(), managedObjects.get(0));
        binder.add((Binding)new JTextFieldBinding("txtTemperature", "rbMBSTIduTemperature", (ValueTranslator)new ValueTranslator<Integer, String>(){

            public String convertToUIValue(Integer beanValue) throws TranslateException {
                return beanValue.toString();
            }

            public Integer convertToBeanValue(String uiBeanValue) throws TranslateException {
                return null;
            }
        }));
        binder.add((Binding)new JTextFieldBinding("txtCumulativePowerOnTime", "rbMBSTCumulativePowerOnTime", (ValueTranslator)new ValueTranslator<Long, String>(){

            public String convertToUIValue(Long beanValue) throws TranslateException {
                if (beanValue == 0L) {
                    return i18n.translateString("unknown");
                }
                return beanValue.toString();
            }

            public Long convertToBeanValue(String uiBeanValue) throws TranslateException {
                return null;
            }
        }));
        binder.add((Binding)new JTextFieldBinding("txtBootVersion", "rbMBSTIduBootVersion"));
        binder.add((Binding)new JTextFieldBinding("txtIFCardHWRevision", "rbMBSTIduIfCardRevision"));
        binder.add((Binding)new JTextFieldBinding("txtIFCardHWConfig", "rbMBSTIduIfCardConfiguration"));
        binder.add((Binding)new JTextFieldBinding("txtCPLDVersion", "rbMBSTRedundantCPLDVersion", (ValueTranslator)new ParserValueTranslator(Integer.class)));
        binders.add((Binder)binder);
    }

    protected List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("BS", RbSysMicroBSTConfig.class));
        ret.add(this.ctx.createRequest("BS", RbSysGeneral.class));
        return ret;
    }

    protected void fillUI(List<Object> managedObjects) {
        RbSysMicroBSTConfig config = (RbSysMicroBSTConfig)((Object)managedObjects.get(0));
        ((MbstGeneralDetailsPanel)this.getUI()).getTxtManagementInterface().setText(i18n.translateString(RbSysMicroBSTConfig.toStringRbMBSTManagementInterface(config.getRbMBSTManagementInterface())));
        ((MbstGeneralDetailsPanel)this.getUI()).getTxtSerialNumber().setText(config.getRbMBSTSerialNo());
        ((MbstGeneralDetailsPanel)this.getUI()).getTxtMainCardHWRevision().setText(config.getRbMBSTIduHwRevision());
        ((MbstGeneralDetailsPanel)this.getUI()).getTxtMainCardHWConfig().setText(config.getRbMBSTIduHwConfigDescription());
        ((MbstGeneralDetailsPanel)this.getUI()).getTxtRunningSw().setText(i18n.translateString(RbSysMicroBSTConfig.toStringRbMBSTRunningSoftware(config.getRbMBSTRunningSoftware())));
        ((MbstGeneralDetailsPanel)this.getUI()).getTxtOperationalSwVersion().setText(config.getRbMBSTOperSwVersion());
        ((MbstGeneralDetailsPanel)this.getUI()).getTxtShadowSwVersion().setText(config.getRbMBSTShadowSwVersion());
    }

    protected MbstGeneralDetailsPanel initUIComponent() {
        MbstGeneralDetailsPanel panel = new MbstGeneralDetailsPanel();
        if (((RbBaseStationEquipment)this.ctx.getEquipment()).getSoftwareVersion().isOlderThan(RbVersions.V_4_0)) {
            panel.getLblCPLDVersion().setVisible(false);
            panel.getTxtCPLDVersion().setVisible(false);
        }
        return panel;
    }

    public boolean canApply() {
        return false;
    }

    public String getHelpTopic() {
        return "ngnms.rb.help.mbs_general_details";
    }
}

