/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.rb.gui.configuration.NPUFreqBandsPanel;
import com.bwanms.rb.mo.RbMBSTFrequencyBandsEntry;
import com.bwanms.rb.mo.RbMBSTFrequencyBandsTable;
import com.bwanms.rb.mo.RbMbstFrequencyBandsParameters;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FormUtil;
import com.bwanms.util.TableUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MbstFreqBandsConfigForm
extends ManagedObjectsConfigForm<NPUFreqBandsPanel> {
    public NPUFreqBandsPanel initUIComponent() {
        return new NPUFreqBandsPanel();
    }

    public List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("BS", RbMbstFrequencyBandsParameters.class));
        ret.add(this.ctx.createRequest("BS", RbMBSTFrequencyBandsTable.class));
        return ret;
    }

    protected void fillUI(List<Object> managedObjects) {
        SimpleRowTableModel tableModel = ((NPUFreqBandsPanel)this.getUI()).getTableModel();
        FormUtil.cancelTableEditing((JTable)((NPUFreqBandsPanel)this.getUI()).getTable2());
        tableModel.clearTable();
        RbMbstFrequencyBandsParameters params = (RbMbstFrequencyBandsParameters)((Object)managedObjects.get(0));
        ((NPUFreqBandsPanel)this.getUI()).getTxtFileVersion().setText(params.getRbMBSTFrequencyBandsFileVersion().toString());
        RbMBSTFrequencyBandsTable table = (RbMBSTFrequencyBandsTable)((Object)managedObjects.get(1));
        List sortedBands = table.getEntries();
        Collections.sort(sortedBands, new Comparator<RbMBSTFrequencyBandsEntry>(){

            @Override
            public int compare(RbMBSTFrequencyBandsEntry o1, RbMBSTFrequencyBandsEntry o2) {
                return o1.getRbMBSTFrequencyBandId().compareTo(o2.getRbMBSTFrequencyBandId());
            }
        });
        int row = 0;
        for (RbMBSTFrequencyBandsEntry entry : sortedBands) {
            int col = 0;
            tableModel.addNewRow(null, true);
            tableModel.setRowState(row, 0);
            tableModel.setInitialValueAt((Object)entry.getRbMBSTFrequencyBandId(), row, col++);
            tableModel.setInitialValueAt((Object)entry.getRbMBSTFrequencyBandName(), row, col++);
            tableModel.setInitialValueAt((Object)entry.getRbMBSTFrequencyBandGroupId(), row, col++);
            tableModel.setInitialValueAt((Object)this.divideBy1000(entry.getRbMBSTFrequencyBandStartFrequency().doubleValue()), row, col++);
            tableModel.setInitialValueAt((Object)this.divideBy1000(entry.getRbMBSTFrequencyBandStopFrequency().doubleValue()), row, col++);
            tableModel.setInitialValueAt((Object)entry.getRbMBSTFrequencyBandStep(), row, col++);
            tableModel.setInitialValueAt((Object)this.divideBy1000(entry.getRbMBSTFrequencyBandDuplexSeparation().doubleValue()), row, col++);
            ++row;
        }
        TableUtil.autoResizeColumn((JTable)((NPUFreqBandsPanel)this.getUI()).getTable2(), (int)0, (boolean)true);
        tableModel.sort();
    }

    private String divideBy1000(double freq) {
        return Double.toString(freq / 1000.0);
    }

    public boolean canApply() {
        return false;
    }

    public String getHelpTopic() {
        return "ngnms.rb.help.freq_bands";
    }
}

