/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JComboBoxBinding;
import com.bwanms.gui.binding.JSpinnerBinding;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.binding.ReadOnlyBinder;
import com.bwanms.gui.binding.translators.TranslateException;
import com.bwanms.gui.binding.translators.ValueTranslator;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.rb.gui.configuration.MbstDataPortPanel;
import com.bwanms.rb.mo.RbIfInfoEntry;
import com.bwanms.rb.mo.RbIpIfConfigEntry;
import com.bwanms.rb.mo.RbMbstEthIfConfigEntry;
import com.bwanms.rb.mo.RbMbstIfInfoEntry;
import com.bwanms.rb.mo.RbMbstIpIfConfigEntry;
import com.bwanms.util.MacAddress;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MbstDataPortConfigForm
extends ManagedObjectsConfigForm<MbstDataPortPanel> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(MbstDataPortConfigForm.class);

    public MbstDataPortPanel initUIComponent() {
        return new MbstDataPortPanel();
    }

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        RbMbstEthIfConfigEntry eth = (RbMbstEthIfConfigEntry)((Object)managedObjects.get(1));
        ReadOnlyBinder binder = new ReadOnlyBinder((Object)this.getUI(), (Object)eth);
        binder.add((Binding)new JTextFieldBinding("txtCrtAutoNegotiation", "ethConfigCurrentdAutoNegotiation", (ValueTranslator)new ValueTranslator<Integer, String>(){

            public String convertToUIValue(Integer beanValue) throws TranslateException {
                return i18n.translateString(RbMbstEthIfConfigEntry.toStringEthConfigCurrentdAutoNegotiation(beanValue));
            }

            public Integer convertToBeanValue(String uiBeanValue) throws TranslateException {
                return null;
            }
        }, i18n.translateString("AutoNegotiation")));
        binder.add((Binding)new JTextFieldBinding("txtCrtSpeedAndDuplex", "ethConfigCurrentLinkSpeedAndDuplex", (ValueTranslator)new ValueTranslator<Integer, String>(){

            public String convertToUIValue(Integer beanValue) throws TranslateException {
                return i18n.translateString(RbMbstEthIfConfigEntry.toStringEthConfigCurrentLinkSpeedAndDuplex(beanValue));
            }

            public Integer convertToBeanValue(String uiBeanValue) throws TranslateException {
                return null;
            }
        }, i18n.translateString("SpeedAndDuplex")));
        binders.add((Binder)binder);
        binder = new DefaultBinder((Object)this.getUI(), (Object)eth);
        binder.add((Binding)new JComboBoxBinding(i18n, "cmbCfgAutoNegotiation", "ethConfigAutoNegotiation", i18n.translateString("AutoNegotiation")));
        binders.add((Binder)binder);
        JComboBoxBinding speedDuplexBinding = new JComboBoxBinding(i18n, "cmbCfgSpeedAndDuplex", "ethConfigLinkSpeedAndDuplex", i18n.translateString("SpeedAndDuplex"));
        speedDuplexBinding.setIgnoreDisabled(true);
        binder.add((Binding)speedDuplexBinding);
        binders.add((Binder)binder);
        RbMbstIfInfoEntry ifEntry = (RbMbstIfInfoEntry)((Object)managedObjects.get(2));
        binder = new ReadOnlyBinder((Object)this.getUI(), (Object)ifEntry);
        binder.add((Binding)new JTextFieldBinding("txtOperationalStatus", "ifOperStatus", (ValueTranslator)new ValueTranslator<Integer, String>(){

            public String convertToUIValue(Integer beanValue) throws TranslateException {
                return i18n.translateString(RbIfInfoEntry.toStringIfOperStatus(beanValue));
            }

            public Integer convertToBeanValue(String uiBeanValue) throws TranslateException {
                return null;
            }
        }, i18n.translateString("OperationalStatus")));
        binders.add((Binder)binder);
        RbMbstIpIfConfigEntry ipIfConfigEntry = (RbMbstIpIfConfigEntry)((Object)managedObjects.get(0));
        binder = new DefaultBinder((Object)this.getUI(), (Object)ipIfConfigEntry);
        binder.add((Binding)new JSpinnerBinding("spnrMgmtVLANId", "ipIfConfigVlanId", i18n.translateString("MgmtVLANId")));
        binder.add((Binding)new JTextFieldBinding("txtIPAddressData", "ipIfConfigIpAddress", i18n.translateString("IPAddress")));
        binder.add((Binding)new JTextFieldBinding("txtNetworkMaskData", "ipIfConfigNetworkMask", i18n.translateString("SubnetMask")));
        binder.add((Binding)new JTextFieldBinding("txtDefaultGatewayData", "ipIfConfigDefaultGateway", i18n.translateString("DefaultGateway")));
        binders.add((Binder)binder);
    }

    public List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("BS", RbMbstIpIfConfigEntry.class, "1"));
        ret.add(this.ctx.createRequest("BS", RbMbstEthIfConfigEntry.class, "1"));
        ret.add(this.ctx.createRequest("BS", RbMbstIfInfoEntry.class, "1"));
        return ret;
    }

    public void fillUI(List<Object> managedObjects) {
        RbMbstIpIfConfigEntry ipIfConfigEntry = (RbMbstIpIfConfigEntry)((Object)managedObjects.get(0));
        ((MbstDataPortPanel)this.getUI()).getTxtIPAddressData().setText(ipIfConfigEntry.getIpIfConfigIpAddress());
        ((MbstDataPortPanel)this.getUI()).getTxtNetworkMaskData().setText(ipIfConfigEntry.getIpIfConfigNetworkMask());
        ((MbstDataPortPanel)this.getUI()).getTxtDefaultGatewayData().setText(ipIfConfigEntry.getIpIfConfigDefaultGateway());
        int vlanId = ipIfConfigEntry.getIpIfConfigVlanId();
        ((MbstDataPortPanel)this.getUI()).getSpnrMgmtVLANId().setValue(vlanId);
        RbIpIfConfigEntry ifEntry = (RbIpIfConfigEntry)((Object)managedObjects.get(0));
        ifEntry.getChangeStrategy().acknowledge();
        RbMbstEthIfConfigEntry ethIfConfig = (RbMbstEthIfConfigEntry)((Object)managedObjects.get(1));
        ethIfConfig.getChangeStrategy().acknowledge();
        RbMbstIfInfoEntry ifInfoEntry = (RbMbstIfInfoEntry)((Object)managedObjects.get(2));
        String ifPhysAddress = ifInfoEntry.getIfPhysAddress();
        if (ifPhysAddress != null) {
            ((MbstDataPortPanel)this.getUI()).getTxtMacAddress().setText(MacAddress.fromOctetString((String)ifPhysAddress).toDashedString());
        }
    }

    public void configureMOs(List<Object> managedObjects) {
        RbMbstIpIfConfigEntry ipIfConfigEntry = (RbMbstIpIfConfigEntry)((Object)managedObjects.get(0));
        ipIfConfigEntry.setIpIfConfigIpAddress(((MbstDataPortPanel)this.getUI()).getTxtIPAddressData().getText());
        ipIfConfigEntry.setIpIfConfigNetworkMask(((MbstDataPortPanel)this.getUI()).getTxtNetworkMaskData().getText());
        ipIfConfigEntry.setIpIfConfigDefaultGateway(((MbstDataPortPanel)this.getUI()).getTxtDefaultGatewayData().getText());
        ipIfConfigEntry.setIpIfConfigVlanId((Integer)((MbstDataPortPanel)this.getUI()).getSpnrMgmtVLANId().getValue());
    }

    public String getTitle() {
        return "DataPort";
    }

    public String warnApply() {
        return i18n.translateString("ApplyingMayCauseInability");
    }

    public String getHelpTopic() {
        return "ngnms.rb.help.mbs_data_port";
    }
}

