/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.binding.ReadOnlyBinder;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.rb.gui.configuration.MbsUnitControlPanel;
import com.bwanms.rb.mo.RbBsRadioParameters;
import com.bwanms.rb.mo.RbSwUpgrade;
import com.bwanms.rb.mo.RbSysMicroBSTConfig;
import com.bwanms.rb.model.RbMBS;
import com.bwanms.security.Security;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FormUtil;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.impl.DefaultVersion;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JTable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MbsUnitControlConfigForm
extends ManagedObjectsConfigForm<MbsUnitControlPanel> {
    private static final Log log = LogFactory.getLog(MbsUnitControlConfigForm.class);

    public String getTitle() {
        return "UnitControl";
    }

    public List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("BS", RbSwUpgrade.class));
        ret.add(this.ctx.createRequest("BS", RbSysMicroBSTConfig.class));
        ret.add(this.ctx.createRequest("BS", RbBsRadioParameters.class));
        return ret;
    }

    protected MbsUnitControlPanel initUIComponent() {
        MbsUnitControlPanel panel = new MbsUnitControlPanel(this);
        Version softwareVersion = ((RbMBS)this.ctx.getEquipment()).getSoftwareVersion();
        if (softwareVersion.isOlderThan((Version)new DefaultVersion("3.5")) || softwareVersion.isNewerOrEqualWith((Version)new DefaultVersion("4.0"))) {
            panel.getLblLocalClockDateAndTime().setVisible(false);
            panel.getSpnLocalClockDateAndTime().setVisible(false);
            panel.getBtnLocalClockDateAndTime().setVisible(false);
        }
        return panel;
    }

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        ReadOnlyBinder binder = new ReadOnlyBinder((Object)this.getUI(), managedObjects.get(1));
        binder.add((Binding)new JTextFieldBinding("txtRuningSwVersion", "runingSwVersion"));
        binder.add((Binding)new JTextFieldBinding("txtMainSwVersion", "rbMBSTOperSwVersion"));
        binder.add((Binding)new JTextFieldBinding("txtShadowSwVersion", "rbMBSTShadowSwVersion"));
        binders.add((Binder)binder);
    }

    public void reset() {
        RbMBS mbs = (RbMBS)this.ctx.getEquipment();
        if (mbs != null) {
            this.fireCommand(mbs.createResetCommand());
        }
    }

    public void resetAndBootFromShadow() {
        RbMBS mbs = (RbMBS)this.ctx.getEquipment();
        if (mbs != null) {
            this.fireCommand(mbs.createResetAndRunFromShadowCommand());
        }
    }

    public void makeRuningVersionOperational() {
        RbMBS mbs = (RbMBS)this.ctx.getEquipment();
        if (mbs != null) {
            this.fireCommand(mbs.createMakeRunningVersionOperationalCommand());
        }
    }

    public void loadFactoryDflt() {
        RbMBS mbs = (RbMBS)this.ctx.getEquipment();
        if (mbs != null) {
            this.fireCommand(mbs.createFactoryDefaultsCommand());
        }
    }

    public void deleteSwFiles(String swFile) {
        RbMBS mbs = (RbMBS)this.ctx.getEquipment();
        if (mbs != null) {
            this.fireCommand(mbs.createDeleteSwFilesCommand(swFile));
        }
    }

    public void fillUI(List<Object> managedObjects) {
        RbMBS mbs = (RbMBS)this.ctx.getEquipment();
        if (mbs == null) {
            this.enableForm(false);
        } else {
            this.enableForm(true);
        }
        Version softwareVersion = mbs.getSoftwareVersion();
        if (!softwareVersion.isOlderThan((Version)new DefaultVersion("3.5")) && !softwareVersion.isNewerOrEqualWith((Version)new DefaultVersion("4.0"))) {
            Date deviceDate;
            RbBsRadioParameters bsRadioParameters = (RbBsRadioParameters)((Object)managedObjects.get(2));
            SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            try {
                deviceDate = formatter.parse(bsRadioParameters.getRbLocalClockDateAndTime());
            }
            catch (ParseException parseEx) {
                deviceDate = new Date();
            }
            ((MbsUnitControlPanel)this.getUI()).getSpnLocalClockDateAndTime().setValue(deviceDate);
            ((MbsUnitControlPanel)this.getUI()).getSpnLocalClockDateAndTime().revalidate();
        }
        RbSwUpgrade swUpgrade = (RbSwUpgrade)((Object)managedObjects.get(0));
        SimpleRowTableModel model = (SimpleRowTableModel)((MbsUnitControlPanel)this.getUI()).getTblSuFiles().getModel();
        FormUtil.cancelTableEditing((JTable)((MbsUnitControlPanel)this.getUI()).getTblSuFiles());
        model.clearTable();
        if (swUpgrade.getRbSwSuFiles().trim().length() > 0) {
            String[] suFiles = swUpgrade.getRbSwSuFiles().split(";");
            int row = 0;
            for (String file : suFiles) {
                model.addNewRow(file, true);
                model.setInitialValueAt((Object)file, row++, 0);
            }
        }
    }

    private void enableForm(boolean enabled) {
        ((MbsUnitControlPanel)this.getUI()).getLblMainSwVersion().setEnabled(enabled);
        ((MbsUnitControlPanel)this.getUI()).getLblRuningSwVersion().setEnabled(enabled);
        ((MbsUnitControlPanel)this.getUI()).getLblShadowSwVersion().setEnabled(enabled);
        ((MbsUnitControlPanel)this.getUI()).getBtnReset().setEnabled(enabled);
        ((MbsUnitControlPanel)this.getUI()).getBtnResetAndBootFromShadow().setEnabled(enabled);
        ((MbsUnitControlPanel)this.getUI()).getBtnLoadFactoryDefaults().setEnabled(enabled);
        ((MbsUnitControlPanel)this.getUI()).getBtnMakeRuningVersionOperational().setEnabled(enabled);
        if (!Security.getSecurity().checkPermissions("Av:ConfigureEquipment", "write")) {
            ((MbsUnitControlPanel)this.getUI()).getBtnDeleteSuFiles().setEnabled(false);
            ((MbsUnitControlPanel)this.getUI()).getBtnLoadFactoryDefaults().setEnabled(false);
            ((MbsUnitControlPanel)this.getUI()).getBtnMakeRuningVersionOperational().setEnabled(false);
            ((MbsUnitControlPanel)this.getUI()).getBtnReset().setEnabled(false);
            ((MbsUnitControlPanel)this.getUI()).getBtnResetAndBootFromShadow().setEnabled(false);
            ((MbsUnitControlPanel)this.getUI()).getTblSuFiles().setEnabled(false);
        }
    }

    protected void configureMOs(List<Object> managedObjects) {
        RbBsRadioParameters bsRadioParameters = (RbBsRadioParameters)((Object)managedObjects.get(2));
        Date date = (Date)((MbsUnitControlPanel)this.getUI()).getSpnLocalClockDateAndTime().getValue();
        bsRadioParameters.setRbLocalClockDateAndTime(new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format(date));
    }

    public boolean forceRefresh() {
        return true;
    }

    public String getHelpTopic() {
        return "ngnms.rb.help.npu_unit_control";
    }
}

