/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.rb.gui.configuration.ManagementPortPanel;
import com.bwanms.rb.mo.RbBsEthIfConfigEntry;
import com.bwanms.rb.mo.RbBsIfInfoEntry;
import com.bwanms.rb.mo.RbBsIpIfConfigEntry;
import com.bwanms.rb.mo.RbEthIfConfigEntry;
import com.bwanms.rb.mo.RbIfInfoEntry;
import com.bwanms.util.MacAddress;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementPortConfigForm
extends ManagedObjectsConfigForm<ManagementPortPanel> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(ManagementPortConfigForm.class);

    public ManagementPortPanel initUIComponent() {
        return new ManagementPortPanel();
    }

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        RbBsIpIfConfigEntry ipIfConfigEntry = (RbBsIpIfConfigEntry)((Object)managedObjects.get(0));
        DefaultBinder binder = new DefaultBinder((Object)this.getUI(), (Object)ipIfConfigEntry);
        binder.add((Binding)new JTextFieldBinding("txtIPAddressMgmt", "ipIfConfigIpAddress", i18n.translateString("IPAddress")));
        binder.add((Binding)new JTextFieldBinding("txtDefaultGatewayMgmt", "ipIfConfigDefaultGateway", i18n.translateString("DefaultGateway")));
        binder.add((Binding)new JTextFieldBinding("txtNetworkMaskMgmt", "ipIfConfigNetworkMask", i18n.translateString("SubnetMask")));
        binder.add((Binding)new JTextFieldBinding("txtNetworkDestination", "ipIfStaticRouteSubnet", i18n.translateString("NetworkDestination")));
        binder.add((Binding)new JTextFieldBinding("txtNetMask", "ipIfStaticRouteSubnetMask", i18n.translateString("NetMask")));
        binders.add((Binder)binder);
    }

    public List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("BS", RbBsIpIfConfigEntry.class, "2"));
        ret.add(this.ctx.createRequest("BS", RbBsEthIfConfigEntry.class, "2"));
        ret.add(this.ctx.createRequest("BS", RbBsIfInfoEntry.class, "2"));
        return ret;
    }

    public void fillUI(List<Object> managedObjects) {
        RbBsEthIfConfigEntry ethIfConfigEntry = (RbBsEthIfConfigEntry)((Object)managedObjects.get(1));
        RbBsIfInfoEntry ifInfoEntry = (RbBsIfInfoEntry)((Object)managedObjects.get(2));
        ((ManagementPortPanel)this.getUI()).getTxtOperationalStatus().setText(i18n.translateString(RbIfInfoEntry.toStringIfOperStatus(ifInfoEntry.getIfOperStatus())));
        String ifPhysAddress = ifInfoEntry.getIfPhysAddress();
        if (ifPhysAddress != null) {
            ((ManagementPortPanel)this.getUI()).getTxtMacAddress().setText(MacAddress.fromOctetString((String)ifPhysAddress).toDashedString());
        }
        ((ManagementPortPanel)this.getUI()).getTxtCrtLinkSpeed().setText(i18n.translateString(RbEthIfConfigEntry.toStringEthConfigCurrentLinkSpeedAndDuplex(ethIfConfigEntry.getEthConfigCurrentLinkSpeedAndDuplex())));
        ((ManagementPortPanel)this.getUI()).getTxtCrtLinkSpeed().setSelectionStart(0);
        ((ManagementPortPanel)this.getUI()).getTxtCrtLinkSpeed().setSelectionEnd(0);
        ((ManagementPortPanel)this.getUI()).getTxtCrtAutoNegociationMode().setText(i18n.translateString(RbEthIfConfigEntry.toStringEthConfigCurrentdAutoNegotiation(ethIfConfigEntry.getEthConfigAutoNegotiation())));
        RbBsIpIfConfigEntry ipIfConfig = (RbBsIpIfConfigEntry)((Object)managedObjects.get(0));
        ipIfConfig.getChangeStrategy().acknowledge();
    }

    protected void configureMOs(List<Object> managedObjects, List<InvalidValue> invalidValues) {
        if (managedObjects.size() > 2) {
            managedObjects.remove(2);
            managedObjects.remove(1);
        }
        super.configureMOs(managedObjects, invalidValues);
    }

    public String getTitle() {
        return "ManagementPort";
    }

    public String warnApply() {
        if (((ManagementPortPanel)this.getUI()).getTxtNetworkMaskMgmt().getText().equals("0.0.0.0")) {
            return i18n.translateString("InvalidNetworkMaskContinue");
        }
        if (((ManagementPortPanel)this.getUI()).getTxtNetworkDestination().getText().equals("0.0.0.0")) {
            return i18n.translateString("InvalidNetworkDestinationMaskContinue");
        }
        if (((ManagementPortPanel)this.getUI()).getTxtNetMask().getText().equals("0.0.0.0")) {
            return i18n.translateString("InvalidNetworkNetMaskContinue");
        }
        return i18n.translateString("ApplyingMayCauseInability");
    }

    public String getHelpTopic() {
        if (VersionFactory.getInstance().createVersion(this.ctx.getEquipment().getRunningSoftwareVersion()).isOlderThan((Version)new DefaultVersion("4.0"))) {
            return "ngnms.rb.help.npu_management_port";
        }
        return "ngnms.rb.help.tdd_npu_management_port";
    }
}

