/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.client.gui.fault.events.OpenAlarmsView;
import com.bwanms.gui.View;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.FormsConfigSectionView;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.gui.manager.generic.EntityManagerConfig;
import com.bwanms.gui.manager.generic.EntityManagerView;
import com.bwanms.mo.snmp.DynamicTableRowMO;
import com.bwanms.model.Equipment;
import com.bwanms.model.Settings;
import com.bwanms.rb.gui.configuration.MBSChasisPanel;
import com.bwanms.rb.gui.inventory.chasis.MBSChannel;
import com.bwanms.rb.gui.inventory.chasis.MBSChasis;
import com.bwanms.rb.gui.inventory.chasis.MBSChasisMouseEvent;
import com.bwanms.rb.gui.inventory.chasis.MBSChasisMouseListener;
import com.bwanms.rb.gui.inventory.chasis.ODUMouseEvent;
import com.bwanms.rb.gui.inventory.chasis.ODUMouseListener;
import com.bwanms.rb.gui.inventory.chasis.RCComponent;
import com.bwanms.rb.gui.managers.RbServiceGMLManagerConfig;
import com.bwanms.rb.gui.selectors.service.RbSelfContainedSelectorDialog;
import com.bwanms.rb.mo.RbMBSTChannelConfigEntry;
import com.bwanms.rb.mo.RbMBSTChannelConfigTable;
import com.bwanms.rb.mo.RbMbstIfInfoEntry;
import com.bwanms.rb.mo.RbMbstIfInfoTable;
import com.bwanms.rb.mo.RbOduConfigTable;
import com.bwanms.rb.mo.RbRadioClusterTable;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbMBS;
import com.bwanms.rb.util.RbGUIUtil;
import com.bwanms.security.Security;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.IpAddress;
import com.bwanms.util.PlatformConfiguration;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBSChasisConfigForm
extends ManagedObjectsConfigForm<MBSChasisPanel> {
    private static final Log logger = LogFactory.getLog(MBSChasisConfigForm.class);
    private boolean receiving = false;

    public MBSChasisPanel initUIComponent() {
        JPopupMenu ctxMenu;
        RbMBS bs = (RbMBS)this.ctx.getEquipment();
        int iduType = bs.getRbMBSTIduType() != null ? bs.getRbMBSTIduType() : 0;
        boolean hasFourChannel = iduType == 2 || iduType == 4;
        JPopupMenu jPopupMenu = ctxMenu = !PlatformConfiguration.isLocalPlatform() ? new JPopupMenu() : null;
        if (!PlatformConfiguration.isLocalPlatform()) {
            JMenuItem jMenuItem = new JMenuItem("Show Services for BS");
            JMenuItem jMenuItem2 = new JMenuItem("Open Alarms");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MBSChasisConfigForm.this.showServices();
                }
            });
            jMenuItem2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        FrameUtil.runView((View)new OpenAlarmsView(MBSChasisConfigForm.this.ctx.getEquipment()), (int)640, (int)480);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            ctxMenu.add(jMenuItem);
            ctxMenu.add(jMenuItem2);
        }
        final MBSChasisPanel chasisPanel = PlatformConfiguration.isLocalPlatform() ? new MBSChasisPanel(bs.isTDDDuplexMode() || hasFourChannel) : new MBSChasisPanel(bs.isTDDDuplexMode() || hasFourChannel){

            protected void mbsChassisMouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    ctxMenu.show(e.getComponent(), e.getX(), e.getY());
                } else {
                    super.mbsChassisMouseClicked(e);
                }
            }
        };
        new Thread(new Runnable(){

            public void run() {
                boolean shouldStop = false;
                while (!shouldStop) {
                    try {
                        Thread.sleep(15000L);
                    }
                    catch (InterruptedException ie) {
                        logger.error((Object)ie, (Throwable)ie);
                    }
                    boolean bl = shouldStop = null == chasisPanel.getParent() || ((FormsConfigSectionView)MBSChasisConfigForm.this.getConfigSectionView()).isShouldStop();
                    if (MBSChasisConfigForm.this.receiving || shouldStop) continue;
                    MBSChasisConfigForm.this.receiving = true;
                    try {
                        MBSChasisConfigForm.this.getConfigSectionView().refresh(false);
                    }
                    catch (Throwable t) {
                        logger.error((Object)t, t);
                    }
                }
            }
        }).start();
        return chasisPanel;
    }

    public List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("BS", RbMbstIfInfoTable.class));
        ret.add(this.ctx.createRequest("BS", RbMBSTChannelConfigTable.class));
        ret.add(this.ctx.createRequest("BS", RbOduConfigTable.class));
        ret.add(this.ctx.createRequest("BS", RbRadioClusterTable.class));
        return ret;
    }

    public void fillUI(List<Object> managedObjects) {
        RbMBS bs = (RbMBS)this.ctx.getEquipment();
        int iduType = bs.getRbMBSTIduType() != null ? bs.getRbMBSTIduType() : 0;
        boolean hasFourChannel = iduType == 2 || iduType == 4 || iduType == 0;
        RbMbstIfInfoTable ifInfoTable = (RbMbstIfInfoTable)((Object)managedObjects.get(0));
        RbMBSTChannelConfigTable channelTable = (RbMBSTChannelConfigTable)((Object)managedObjects.get(1));
        RbOduConfigTable oduTable = (RbOduConfigTable)((Object)managedObjects.get(2));
        RbRadioClusterTable rcTable = (RbRadioClusterTable)((Object)managedObjects.get(3));
        if (oduTable != null) {
            for (DynamicTableRowMO entry : oduTable.getEntries()) {
                if (entry.getRbOduConfigId() > 4) continue;
                ((MBSChasisPanel)this.getUI()).getOutdoorUnits().getODU(entry.getRbOduConfigId() - 1).setRadioClusterID(entry.getRbOduAssociatedRadioClusterId());
                ((MBSChasisPanel)this.getUI()).getOutdoorUnits().getODU(entry.getRbOduConfigId() - 1).setStatus(entry.getRbOduOperationalStatus());
                ((MBSChasisPanel)this.getUI()).getOutdoorUnits().getODU(entry.getRbOduConfigId() - 1).setTxPower(entry.getRbOduTxPower());
            }
        }
        if (rcTable != null) {
            for (DynamicTableRowMO entry : rcTable.getEntries()) {
                if (entry.getRbRadioClusterId() > 4) continue;
                ((MBSChasisPanel)this.getUI()).getRadioClusters().getRadioCluster(entry.getRbRadioClusterId() - 1).setName(entry.getRbRadioClusterName());
            }
        }
        if (ifInfoTable != null) {
            ((MBSChasisPanel)this.getUI()).getMbsChassis().getChannel(0).setStatus(((RbMbstIfInfoEntry)ifInfoTable.findEntry("1")).getIfOperStatus());
            ((MBSChasisPanel)this.getUI()).getMbsChassis().getChannel(1).setStatus(((RbMbstIfInfoEntry)ifInfoTable.findEntry("2")).getIfOperStatus());
        }
        if (channelTable != null) {
            RbMBSTChannelConfigEntry entry = null;
            MBSChannel channel = null;
            int limit = hasFourChannel ? 4 : 2;
            for (int i = 1; i <= limit; ++i) {
                entry = (RbMBSTChannelConfigEntry)channelTable.findEntry(String.valueOf(i));
                try {
                    channel = (MBSChannel)((MBSChasisPanel)this.getUI()).getMbsChassis().getChannel(i + 1);
                }
                catch (IndexOutOfBoundsException e) {
                    break;
                }
                if (entry == null || channel == null) continue;
                channel.setOutdoorUnitID(entry.getRbMBSTChannelAssociatedOduId());
                channel.setRadioClusterID(entry.getRbMBSTChannelAssociatedRadioClusterId());
                if (Integer.valueOf(1).equals(entry.getRbMBSTChannelAdminStatus())) {
                    Integer operStatus = entry.getRbMBSTChannelOperStatus();
                    if (Integer.valueOf(1).equals(operStatus)) {
                        channel.setStatus(1);
                    } else {
                        channel.setStatus(2);
                    }
                } else {
                    channel.setStatus(3);
                }
                channel.setChannelTxFreq(entry.getRbMBSTChannelTxFrequency());
                if (channel.getOutdoorUnitID() <= 0) continue;
                ((MBSChasisPanel)this.getUI()).getOutdoorUnits().getODU(channel.getOutdoorUnitID() - 1).setChannelTxFreq(entry.getRbMBSTChannelTxFrequency());
            }
        }
        ((MBSChasisPanel)this.getUI()).getMbsChassis().addChasisMouseListener(new MBSChasisMouseListener(){

            public void mouseClicked(MBSChasisMouseEvent e) {
                if (e.getClickCount() == 2) {
                    String url = null;
                    int channel = e.getChannel();
                    if (channel == MBSChasis.MBS_DATA_PORT) {
                        url = "bwanms://config/" + MBSChasisConfigForm.this.ctx.getEquipment().getEUID() + "/DataPort/";
                    } else if (channel == MBSChasis.MBS_MGMT_PORT) {
                        url = "bwanms://config/" + MBSChasisConfigForm.this.ctx.getEquipment().getEUID() + "/ManagementPort/";
                    } else if (channel == MBSChasis.MBS_ODU1_CHANNEL || channel == MBSChasis.MBS_ODU2_CHANNEL || channel == MBSChasis.MBS_ODU3_CHANNEL || channel == MBSChasis.MBS_ODU4_CHANNEL) {
                        url = "bwanms://config/" + MBSChasisConfigForm.this.ctx.getEquipment().getEUID() + "/AccessParameters/";
                        int channelNr = e.getChannel() - 2;
                        if (channelNr >= 0) {
                            url = url + "Channels/?channelId=" + channelNr;
                        }
                    }
                    if (url != null) {
                        MBSChasisConfigForm.this.fireAction(url);
                    }
                }
            }
        });
        ((MBSChasisPanel)this.getUI()).getOutdoorUnits().addODUMouseListener(new ODUMouseListener(){

            public void mouseClicked(ODUMouseEvent e) {
                if (e.getClickCount() == 2) {
                    String url = "bwanms://config/" + MBSChasisConfigForm.this.ctx.getEquipment().getEUID() + "/OutdoorUnits/";
                    url = url + "/?oduId=" + e.get_selectedODU();
                    MBSChasisConfigForm.this.fireAction(url);
                }
            }
        });
        ((MBSChasisPanel)this.getUI()).getRadioClusters().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    String url = "bwanms://config/" + MBSChasisConfigForm.this.ctx.getEquipment().getEUID() + "/RadioClusters/";
                    if (e.getComponent() instanceof RCComponent) {
                        url = url + "?clusterId=" + ((RCComponent)e.getComponent()).getRadioClusterID();
                    }
                    MBSChasisConfigForm.this.fireAction(url);
                }
            }
        });
        ((MBSChasisPanel)this.getUI()).repaint();
        this.receiving = false;
    }

    private void showServices() {
        Equipment equipment = this.ctx.getEquipment();
        if (equipment != null) {
            RbSelfContainedSelectorDialog dialog;
            IpAddress BSIp = new IpAddress(((RbBaseStationEquipment)equipment).getIPAddress());
            Settings settings = ServiceRegistry.getSettingsService().fetchSettings(Security.getSecurity().getCurrentUserId(), true);
            settings.setProperty("ActiveFilters:mBSChassisShowServices", "2_1_0_NRConfiguration.configuration.equipment.ipAddr");
            settings.setProperty("SelectedFilterValues:mBSChassisShowServices:2_1_0_NRConfiguration.configuration.equipment.ipAddr", BSIp.toString().length() + ":" + BSIp);
            ServiceRegistry.getSettingsService().updateSettings(settings);
            RbServiceGMLManagerConfig serviceManagerConfig = new RbServiceGMLManagerConfig();
            serviceManagerConfig.setSelectorName("mBSChassisShowServices");
            Window parentWindow = SwingUtilities.getWindowAncestor(this.getUI());
            if (parentWindow instanceof JFrame) {
                dialog = new RbSelfContainedSelectorDialog((JFrame)parentWindow);
            } else if (parentWindow instanceof JDialog) {
                dialog = new RbSelfContainedSelectorDialog((JDialog)parentWindow);
            } else {
                throw new IllegalArgumentException("Unsupported parent window of type: " + parentWindow.getClass().getName());
            }
            EntityManagerView managerView = new EntityManagerView((EntityManagerConfig)serviceManagerConfig);
            dialog.setView((View)managerView);
            dialog.setModal(false);
            dialog.setTitle("Services for " + ((RbBaseStationEquipment)this.ctx.getEquipment()).getName());
            dialog.setPreferredSize(new Dimension(managerView.getUI().getPreferredSize().width + 10, managerView.getUI().getPreferredSize().height + 70));
            dialog.pack();
            RbGUIUtil.centerDialog((JDialog)((Object)dialog));
            dialog.setVisible(true);
        }
    }

    public boolean canApply() {
        return false;
    }

    public String getTitle() {
        return "MBSChasis";
    }

    public String getHelpTopic() {
        return "ngnms.rb.help.mbs_manager";
    }
}

