/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.TableBinder;
import com.bwanms.gui.binding.TableColumnBinding;
import com.bwanms.gui.configuration.FormsConfigSectionView;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.mo.snmp.SNMPTableMO;
import com.bwanms.rb.gui.configuration.MBSChannelPanelSW25;
import com.bwanms.rb.mo.RbAuPhyParameters;
import com.bwanms.rb.mo.RbMBSTChannelConfigEntry;
import com.bwanms.rb.mo.RbMBSTChannelConfigTable;
import com.bwanms.rb.mo.RbMBSTFrequencyBandsEntry;
import com.bwanms.rb.mo.RbMBSTFrequencyBandsTable;
import com.bwanms.rb.mo.RbMbstPhyParametersGroup;
import com.bwanms.rb.mo.RbOduConfigEntry;
import com.bwanms.rb.mo.RbOduConfigTable;
import com.bwanms.services.UnifiedMORequest;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.ROTableModel;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FormUtil;
import com.bwanms.util.TableUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBSChannelConfigFormSW25
extends ManagedObjectsConfigForm<MBSChannelPanelSW25> {
    private static final Log log = LogFactory.getLog(MBSChannelConfigFormSW25.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(MBSChannelConfigFormSW25.class);

    public MBSChannelPanelSW25 initUIComponent() {
        return new MBSChannelPanelSW25();
    }

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        TableBinder tblBinder = new TableBinder(i18n, (SimpleRowTableModel)((MBSChannelPanelSW25)this.getUI()).getTableModel(), (SNMPTableMO)managedObjects.get(0));
        tblBinder.add((Binding)new TableColumnBinding("AssocODU", "rbMBSTChannelAssociatedOduId"));
        tblBinder.add((Binding)new TableColumnBinding("AdminStatus", "rbMBSTChannelAdminStatus"));
        binders.add((Binder)tblBinder);
        String nrName = (String)this.ctx.getAttribute("NR");
        String key = nrName.substring(nrName.indexOf(46) + 1);
    }

    public List<UnifiedMORequest> getManagedObjectRequests() {
        ArrayList<UnifiedMORequest> ret = new ArrayList<UnifiedMORequest>();
        ret.add((UnifiedMORequest)this.ctx.createRequest("BS", RbMBSTChannelConfigTable.class));
        ret.add((UnifiedMORequest)this.ctx.createRequest("BS", RbOduConfigTable.class));
        ret.add((UnifiedMORequest)this.ctx.createRequest("BS", RbMBSTFrequencyBandsTable.class));
        ret.add((UnifiedMORequest)this.ctx.createRequest((String)this.ctx.getAttribute("NR"), RbMbstPhyParametersGroup.class));
        return ret;
    }

    public void fillUI(List<Object> managedObjects) {
        JTable table = ((MBSChannelPanelSW25)this.getUI()).getTable();
        FormUtil.cancelTableEditing((JTable)table);
        ROTableModel tableModel = ((MBSChannelPanelSW25)this.getUI()).getTableModel();
        tableModel.clearTable();
        for (int i = 0; i < 4; ++i) {
            tableModel.addNewRow(null, true);
        }
        RbMBSTChannelConfigTable channelTable = (RbMBSTChannelConfigTable)((Object)managedObjects.get(0));
        RbOduConfigTable oduTable = (RbOduConfigTable)((Object)managedObjects.get(1));
        RbMBSTFrequencyBandsTable bandsTable = (RbMBSTFrequencyBandsTable)((Object)managedObjects.get(2));
        ArrayList<ComboItem> bands = new ArrayList<ComboItem>();
        bands.add(new ComboItem((Object)0, i18n.translateString("notDefined")));
        for (RbMBSTFrequencyBandsEntry entry : bandsTable.getEntries()) {
            bands.add(new ComboItem((Object)entry.getRbMBSTFrequencyBandId().intValue(), entry.getRbMBSTFrequencyBandName()));
        }
        tableModel.setValueSet(-1, 4, bands);
        tableModel.setValueSet(-1, 5, bands);
        log.info((Object)("+++++++++++++++++++++ ODU Table entries: " + oduTable.getSize()));
        int rowCounter = 0;
        for (RbMBSTChannelConfigEntry entry : channelTable.getEntries()) {
            RbOduConfigEntry oduEntry = null;
            for (RbOduConfigEntry e : oduTable.getEntries()) {
                if (!e.getRbOduConfigId().equals(entry.getRbMBSTChannelAssociatedOduId())) continue;
                oduEntry = e;
            }
            rowCounter = entry.getRbMBSTChannelId() - 1;
            if (rowCounter < 4) {
                tableModel.setRowKey(rowCounter, entry.getRowKey());
                tableModel.setInitialValueAt((Object)entry.getRbMBSTChannelId(), rowCounter, 0);
                if (entry.getRbMBSTChannelAssociatedOduId() > 0) {
                    tableModel.setInitialValueAt((Object)entry.getRbMBSTChannelAssociatedOduId(), rowCounter, 1);
                }
                if (oduEntry != null) {
                    tableModel.setInitialValueAt((Object)oduEntry.getRbOduAssociatedRadioClusterId(), rowCounter, 2);
                    tableModel.setInitialValueAt((Object)oduEntry.getRbOduTxPower(), rowCounter, 3);
                    tableModel.setInitialValueAt((Object)oduEntry.getRbOduConfigFrequencyBand(), rowCounter, 4);
                }
                tableModel.setInitialValueAt((Object)entry.getRbMBSTChannelOduActualFrequencyBand(), rowCounter, 5);
                tableModel.setInitialValueAt((Object)entry.getRbMBSTChannelConfiguredTxFrequency(), rowCounter, 6);
                tableModel.setInitialValueAt((Object)entry.getRbMBSTChannelTxFrequency(), rowCounter, 7);
                tableModel.setInitialValueAt((Object)entry.getRbMBSTChannelRxFrequency(), rowCounter, 8);
                tableModel.setInitialValueAt((Object)entry.getRbMBSTChannelAdminStatus(), rowCounter, 9);
                tableModel.setInitialValueAt((Object)i18n.translateString(RbMBSTChannelConfigEntry.toStringRbMBSTChannelOperStatus(entry.getRbMBSTChannelOperStatus())), rowCounter, 10);
                if (oduEntry != null) {
                    ((MBSChannelPanelSW25)this.getUI()).getController().addDetails(entry.getRbMBSTChannelAssociatedOduId(), new String[]{oduEntry.getRbOduCardSerialNumber(), oduEntry.getRbOduHwRevision(), oduEntry.getRbOduHwConfigDescription(), oduEntry.getRbOduHwHC08Version(), oduEntry.getRbOduCpldVersion(), oduEntry.getRbOduTemperature().toString(), oduEntry.getRbOduMaxTxPower() == null ? "NA" : oduEntry.getRbOduMaxTxPower().toString()});
                }
            }
            ++rowCounter;
        }
        FormsConfigSectionView formsConfigSectionView = (FormsConfigSectionView)this.getConfigSectionView();
        String channelId = String.valueOf(formsConfigSectionView.getAttribute("channelId"));
        if (channelId != null) {
            try {
                int chanelIdInt = Integer.parseInt(channelId);
                ((MBSChannelPanelSW25)this.getUI()).getTable().setRowSelectionInterval(chanelIdInt, chanelIdInt);
            }
            catch (Exception e) {}
        } else {
            ((MBSChannelPanelSW25)this.getUI()).getTable().clearSelection();
        }
        TableUtil.autoResizeColumn((JTable)table, (int)0, (boolean)true);
        tableModel.sort();
    }

    public void configureMOs(List<Object> managedObjects, List<InvalidValue> invalidValues) {
        RbMBSTChannelConfigTable channelTable = (RbMBSTChannelConfigTable)((Object)managedObjects.get(0));
        RbOduConfigTable oduTable = (RbOduConfigTable)((Object)managedObjects.get(1));
        RbMBSTFrequencyBandsTable bandsTable = (RbMBSTFrequencyBandsTable)((Object)managedObjects.get(2));
        RbAuPhyParameters phyParams = (RbAuPhyParameters)((Object)managedObjects.get(3));
        double adjust = RbAuPhyParameters.getFrequencyBoundsAdjust(phyParams.getRbAuPhyConfiguredBandwidth());
        ROTableModel model = ((MBSChannelPanelSW25)this.getUI()).getTableModel();
        FormUtil.stopTableEditing((JTable)((MBSChannelPanelSW25)this.getUI()).getTable());
        for (int i = 0; i < model.getRowCount(); ++i) {
            RbMBSTFrequencyBandsEntry freqBand;
            if (model.getRowState(i) != 3) continue;
            String confTxFrequency = model.getValueAt(i, 6) != null ? String.valueOf(model.getValueAt(i, 6)) : null;
            Integer oduId = (Integer)model.getValueAt(i, 1);
            String rowKey = model.getRowKey(i);
            RbMBSTChannelConfigEntry entry = (RbMBSTChannelConfigEntry)channelTable.findEntry(rowKey);
            entry.setRbMBSTChannelAssociatedOduId(oduId);
            entry.setRbMBSTChannelConfiguredTxFrequency(confTxFrequency);
            entry.setRbMBSTChannelAdminStatus((Integer)model.getValueAt(i, 9));
            if (oduId == null) {
                invalidValues.add(new InvalidValue(i18n.translateString("MandatoryValue"), RbMBSTChannelConfigEntry.class, i18n.translateString("AssocODU"), (Object)"", (Object)this));
            }
            RbOduConfigEntry oduEntry = (RbOduConfigEntry)oduTable.findEntry(oduId != null ? oduId.toString() : "");
            Integer configBandId = oduEntry != null ? oduEntry.getRbOduConfigFrequencyBand() : null;
            RbMBSTFrequencyBandsEntry rbMBSTFrequencyBandsEntry = freqBand = configBandId != null ? (RbMBSTFrequencyBandsEntry)bandsTable.findEntry(((Object)configBandId).toString()) : null;
            if (freqBand != null && confTxFrequency != null) {
                double configTxFreq = Double.parseDouble(confTxFrequency);
                double startFreq = freqBand.getRbMBSTFrequencyBandStartFrequency().doubleValue() / 1000.0 + adjust;
                double stopFreq = freqBand.getRbMBSTFrequencyBandStopFrequency().doubleValue() / 1000.0 - adjust;
                Long step = freqBand.getRbMBSTFrequencyBandStep();
                if (configTxFreq < startFreq || configTxFreq > stopFreq || (configTxFreq - startFreq) * 1000.0 % step.doubleValue() != 0.0) {
                    Object[] range = new Object[]{String.valueOf(startFreq), String.valueOf(stopFreq), String.valueOf(step.doubleValue() / 1000.0)};
                    invalidValues.add(new InvalidValue(i18n.translateString("GenericValueBetweenWithStep", range), RbMBSTChannelConfigEntry.class, i18n.translateString("ConfiguredTxFrequency"), (Object)confTxFrequency, (Object)this));
                }
            }
            this.checkAssocOduId(entry, managedObjects, invalidValues);
        }
    }

    public String getTitle() {
        return "ChannelConfigForm";
    }

    private void checkAssocOduId(RbMBSTChannelConfigEntry entry, List<Object> managedObjects, List<InvalidValue> invalidValues) {
        RbOduConfigEntry entryOdu;
        Integer adminStatusEnabled;
        RbOduConfigEntry odu;
        RbMBSTChannelConfigTable channelTable = (RbMBSTChannelConfigTable)((Object)managedObjects.get(0));
        RbOduConfigTable oduTable = (RbOduConfigTable)((Object)managedObjects.get(1));
        Integer entryOduId = entry.getRbMBSTChannelAssociatedOduId();
        if (entryOduId == null) {
            return;
        }
        int[] validValues = new int[oduTable.getSize()];
        int count = 0;
        Iterator i$ = oduTable.getEntries().iterator();
        while (i$.hasNext() && !entryOduId.equals((odu = (RbOduConfigEntry)((Object)i$.next())).getRbOduConfigId())) {
            validValues[count++] = odu.getRbOduConfigId();
        }
        if (count == validValues.length) {
            Arrays.sort(validValues);
            invalidValues.add(new InvalidValue(i18n.translateString("AssocODUValidValuesAre", new Object[]{Arrays.toString(validValues)}), RbOduConfigTable.class, i18n.translateString("RowId", new Object[]{entry.getRbMBSTChannelId()}), (Object)entry.getRbMBSTChannelAssociatedOduId(), (Object)entry));
        }
        if ((adminStatusEnabled = Integer.valueOf(1)).equals(entry.getRbMBSTChannelAdminStatus()) && (entryOdu = (RbOduConfigEntry)oduTable.findEntry(entryOduId.toString())) != null) {
            Integer entryOduFreqBand = entryOdu.getRbOduConfigFrequencyBand();
            RbMBSTFrequencyBandsTable bandsTable = (RbMBSTFrequencyBandsTable)((Object)managedObjects.get(2));
            RbMBSTFrequencyBandsEntry currentFrequencyBandsEntry = (RbMBSTFrequencyBandsEntry)bandsTable.findEntry(entryOduFreqBand.toString());
            if (currentFrequencyBandsEntry != null) {
                ArrayList<Integer> validBandsList = new ArrayList<Integer>();
                for (RbMBSTFrequencyBandsEntry rbFrequencyBandsEntry : bandsTable.getEntries()) {
                    if (!rbFrequencyBandsEntry.getRbMBSTFrequencyBandGroupId().equals(currentFrequencyBandsEntry.getRbMBSTFrequencyBandGroupId())) continue;
                    validBandsList.add(rbFrequencyBandsEntry.getRbMBSTFrequencyBandId().intValue());
                }
                for (RbMBSTChannelConfigEntry channel : channelTable.getEntries()) {
                    RbOduConfigEntry odu2;
                    if (entry.getRbMBSTChannelId().equals(channel.getRbMBSTChannelId()) || !adminStatusEnabled.equals(channel.getRbMBSTChannelAdminStatus()) || null == channel.getRbMBSTChannelAssociatedOduId() || (odu2 = (RbOduConfigEntry)oduTable.findEntry(channel.getRbMBSTChannelAssociatedOduId().toString())) == null || validBandsList.contains(odu2.getRbOduConfigFrequencyBand())) continue;
                    invalidValues.add(new InvalidValue(i18n.translateString("ODUDifferentFreqBand"), RbMBSTChannelConfigEntry.class, i18n.translateString("AssocODU"), (Object)entryOduId, (Object)this));
                    break;
                }
            }
        }
        if (adminStatusEnabled.equals(entry.getRbMBSTChannelAdminStatus())) {
            for (RbMBSTChannelConfigEntry channel : channelTable.getEntries()) {
                if (entry.getRbMBSTChannelId().equals(channel.getRbMBSTChannelId()) || !adminStatusEnabled.equals(channel.getRbMBSTChannelAdminStatus()) || !entryOduId.equals(channel.getRbMBSTChannelAssociatedOduId())) continue;
                Object[] values = new Object[]{"", channel.getRbMBSTChannelId()};
                invalidValues.add(new InvalidValue(i18n.translateString("ODUAlreadyAssoc", values), RbMBSTChannelConfigEntry.class, i18n.translateString("AssocODU"), (Object)entryOduId, (Object)this));
                break;
            }
        }
    }

    public String getHelpTopic() {
        return "ngnms.rb.help.au_channels";
    }
}

