/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JComboBoxBinding;
import com.bwanms.gui.binding.TableBinder;
import com.bwanms.gui.binding.TableColumnBinding;
import com.bwanms.gui.configuration.FormsConfigSectionView;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.mo.snmp.SNMPTableMO;
import com.bwanms.rb.gui.configuration.AUChannelConfigFormSW41;
import com.bwanms.rb.gui.configuration.MBSChannelPanel;
import com.bwanms.rb.mo.RbAuChannelConfigEntry;
import com.bwanms.rb.mo.RbAuPhyParameters;
import com.bwanms.rb.mo.RbMBSTAdditionalConfigParameters;
import com.bwanms.rb.mo.RbMBSTChannelConfigEntry;
import com.bwanms.rb.mo.RbMBSTChannelConfigTable;
import com.bwanms.rb.mo.RbMBSTFrequencyBandsEntry;
import com.bwanms.rb.mo.RbMBSTFrequencyBandsTable;
import com.bwanms.rb.mo.RbMbstPhyParametersGroup;
import com.bwanms.rb.mo.RbOduConfigEntry;
import com.bwanms.rb.mo.RbOduConfigTable;
import com.bwanms.rb.model.RbMBS;
import com.bwanms.rb.util.RbVersions;
import com.bwanms.services.UnifiedMORequest;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.ROTableModel;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FormUtil;
import com.bwanms.util.TableUtil;
import com.bwanms.util.version.Version;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JTable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBSChannelConfigForm41
extends ManagedObjectsConfigForm<MBSChannelPanel> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(AUChannelConfigFormSW41.class);
    private static final Log log = LogFactory.getLog(AUChannelConfigFormSW41.class);
    private boolean applyPressed = false;
    private Object diversityMode;

    public MBSChannelPanel initUIComponent() {
        return new MBSChannelPanel();
    }

    public List<UnifiedMORequest> getManagedObjectRequests() {
        ArrayList<UnifiedMORequest> ret = new ArrayList<UnifiedMORequest>();
        ret.add((UnifiedMORequest)this.ctx.createRequest("BS", RbMBSTChannelConfigTable.class));
        ret.add((UnifiedMORequest)this.ctx.createRequest("BS", RbOduConfigTable.class));
        ret.add((UnifiedMORequest)this.ctx.createRequest("BS", RbMBSTFrequencyBandsTable.class));
        ret.add((UnifiedMORequest)this.ctx.createRequest((String)this.ctx.getAttribute("NR"), RbMbstPhyParametersGroup.class));
        ret.add((UnifiedMORequest)this.ctx.createRequest("BS", RbMBSTAdditionalConfigParameters.class));
        return ret;
    }

    public void fillUI(List<Object> managedObjects) {
        JTable table = ((MBSChannelPanel)this.getUI()).getTable();
        FormUtil.cancelTableEditing((JTable)table);
        ROTableModel tableModel = ((MBSChannelPanel)this.getUI()).getTableModel();
        tableModel.clearTable();
        for (int i = 0; i < 4; ++i) {
            tableModel.addNewRow(null, true);
        }
        RbMBSTChannelConfigTable mbsChannelTable = (RbMBSTChannelConfigTable)((Object)managedObjects.get(0));
        RbOduConfigTable oduTable = (RbOduConfigTable)((Object)managedObjects.get(1));
        RbMBSTFrequencyBandsTable bandsTable = (RbMBSTFrequencyBandsTable)((Object)managedObjects.get(2));
        RbMBSTAdditionalConfigParameters mbstParams = (RbMBSTAdditionalConfigParameters)((Object)managedObjects.get(4));
        ArrayList<ComboItem> bands = new ArrayList<ComboItem>();
        bands.add(new ComboItem((Object)0, i18n.translateString("notDefined")));
        for (RbMBSTFrequencyBandsEntry entry : bandsTable.getEntries()) {
            bands.add(new ComboItem((Object)entry.getRbMBSTFrequencyBandId().intValue(), entry.getRbMBSTFrequencyBandName()));
        }
        tableModel.setValueSet(-1, 4, bands);
        tableModel.setValueSet(-1, 5, bands);
        String nrName = (String)this.ctx.getAttribute("NR");
        String slotNo = nrName.substring(nrName.indexOf(46) + 1);
        Integer diversity = mbstParams.getRbMBSTDiversityMode();
        JComboBox cmbDiversityMode = ((MBSChannelPanel)this.getUI()).getCmbDiversityMode();
        this.diversityMode = cmbDiversityMode.getSelectedItem();
        boolean diversityOn = !diversity.equals(1);
        boolean is2ndOrder = diversity.equals(2);
        int rowCounter = 0;
        boolean firstChannelAdminStatusEnabled = false;
        for (RbMBSTChannelConfigEntry entry : mbsChannelTable.getEntries()) {
            boolean curentChannelAdminStatusEnabled;
            boolean bl = entry.getRbMBSTChannelAdminStatus() != null ? entry.getRbMBSTChannelAdminStatus() == 1 : (curentChannelAdminStatusEnabled = false);
            if (rowCounter == 0) {
                firstChannelAdminStatusEnabled = curentChannelAdminStatusEnabled;
            }
            RbOduConfigEntry oduEntry = null;
            for (RbOduConfigEntry e : oduTable.getEntries()) {
                if (!e.getRbOduConfigId().equals(entry.getRbMBSTChannelAssociatedOduId())) continue;
                oduEntry = e;
                break;
            }
            rowCounter = entry.getRbMBSTChannelId() - 1;
            tableModel.setRowKey(rowCounter, entry.getRowKey());
            tableModel.setInitialValueAt((Object)entry.getRbMBSTChannelId(), rowCounter, 0);
            if (entry.getRbMBSTChannelAssociatedOduId() > 0) {
                tableModel.setInitialValueAt((Object)entry.getRbMBSTChannelAssociatedOduId(), rowCounter, 1);
            }
            if (oduEntry != null) {
                tableModel.setInitialValueAt((Object)oduEntry.getRbOduAssociatedRadioClusterId(), rowCounter, 2);
                tableModel.setInitialValueAt((Object)oduEntry.getRbOduTxPower(), rowCounter, 3);
                tableModel.setInitialValueAt((Object)oduEntry.getRbOduConfigFrequencyBand(), rowCounter, 4);
            } else {
                tableModel.setInitialValueAt((Object)0, rowCounter, 4);
            }
            tableModel.setInitialValueAt((Object)entry.getRbMBSTChannelOduActualFrequencyBand(), rowCounter, 5);
            tableModel.setInitialValueAt((Object)entry.getRbMBSTChannelConfiguredTxFrequency(), rowCounter, 6);
            tableModel.setInitialValueAt((Object)entry.getRbMBSTChannelTxFrequency(), rowCounter, 7);
            tableModel.setInitialValueAt((Object)entry.getRbMBSTChannelRxFrequency(), rowCounter, 8);
            tableModel.setInitialValueAt((Object)entry.getRbMBSTChannelAdminStatus(), rowCounter, 9);
            if (!firstChannelAdminStatusEnabled) {
                if (diversityOn && rowCounter > 0) {
                    tableModel.setROCell(rowCounter, 6);
                    tableModel.setROCell(rowCounter, 9);
                }
                if (is2ndOrder && rowCounter > 1) {
                    tableModel.setROCell(rowCounter, 1);
                }
            } else if (diversityOn) {
                tableModel.setROCell(rowCounter, 1);
                tableModel.setROCell(rowCounter, 6);
                if (rowCounter > 0) {
                    tableModel.setROCell(rowCounter, 9);
                }
            }
            if (curentChannelAdminStatusEnabled) {
                tableModel.setROCell(rowCounter, 1);
                tableModel.setROCell(rowCounter, 6);
            }
            tableModel.setInitialValueAt((Object)i18n.translateString(RbMBSTChannelConfigEntry.toStringRbMBSTChannelOperStatus(entry.getRbMBSTChannelOperStatus())), rowCounter, 10);
            if (oduEntry != null) {
                RbMBS bs = (RbMBS)this.ctx.getEquipment();
                Version softwareVersion = bs.getSoftwareVersion();
                if (RbVersions.V_4_5.isOlderOrEqualWith(softwareVersion)) {
                    ((MBSChannelPanel)this.getUI()).getController().addDetails(entry.getRbMBSTChannelAssociatedOduId(), new String[]{oduEntry.getRbOduCardSerialNumber(), oduEntry.getRbOduHwRevision(), oduEntry.getRbOduHwConfigDescription(), oduEntry.getRbOduHwHC08Version(), oduEntry.getRbOduCpldVersion(), oduEntry.getRbOduTemperature().toString(), oduEntry.getRbOduMaxTxPower() == null ? "NA" : oduEntry.getRbOduMaxTxPower().toString(), oduEntry.getRbOduStatusMask(), oduEntry.toStringRbOduGeneralDescription(oduEntry.getRbOduGeneralDescription())});
                } else {
                    ((MBSChannelPanel)this.getUI()).getController().addDetails(entry.getRbMBSTChannelAssociatedOduId(), new String[]{oduEntry.getRbOduCardSerialNumber(), oduEntry.getRbOduHwRevision(), oduEntry.getRbOduHwConfigDescription(), oduEntry.getRbOduHwHC08Version(), oduEntry.getRbOduCpldVersion(), oduEntry.getRbOduTemperature().toString(), oduEntry.getRbOduMaxTxPower() == null ? "NA" : oduEntry.getRbOduMaxTxPower().toString()});
                }
            }
            ++rowCounter;
        }
        TableUtil.autoResizeColumn((JTable)table, (int)0, (boolean)true);
        tableModel.sort();
        FormsConfigSectionView formsConfigSectionView = (FormsConfigSectionView)this.getConfigSectionView();
        String channelId = String.valueOf(formsConfigSectionView.getAttribute("channelId"));
        if (channelId != null) {
            try {
                int chanelIdInt = Integer.parseInt(channelId);
                ((MBSChannelPanel)this.getUI()).getTable().setRowSelectionInterval(chanelIdInt, chanelIdInt);
            }
            catch (Exception e) {}
        } else {
            ((MBSChannelPanel)this.getUI()).getTable().clearSelection();
        }
        if (this.applyPressed) {
            this.applyPressed = false;
            this.getConfigSectionView().refresh(true);
        }
    }

    public void configureMOs(List<Object> managedObjects, List<InvalidValue> invalidValues) {
        String confTxFrequency;
        ArrayList<RbMBSTChannelConfigEntry> mbstChannels;
        RbMBSTChannelConfigTable mbstChannelTable = (RbMBSTChannelConfigTable)((Object)managedObjects.get(0));
        RbOduConfigTable oduTable = (RbOduConfigTable)((Object)managedObjects.get(1));
        RbMBSTFrequencyBandsTable bandsTable = (RbMBSTFrequencyBandsTable)((Object)managedObjects.get(2));
        RbMbstPhyParametersGroup phyParams = (RbMbstPhyParametersGroup)((Object)managedObjects.get(3));
        RbMBSTAdditionalConfigParameters mbstParams = (RbMBSTAdditionalConfigParameters)((Object)managedObjects.get(4));
        RbMBSTChannelConfigEntry entry = null;
        boolean is2ndOrder = mbstParams.getRbMBSTDiversityMode().equals(2);
        boolean is4thOrder = mbstParams.getRbMBSTDiversityMode() > 2;
        boolean chnlHasDiversity = is2ndOrder || is4thOrder;
        boolean oduChanged = false;
        Integer crtDiv = (Integer)((ComboItem)((MBSChannelPanel)this.getUI()).getCmbDiversityMode().getSelectedItem()).getValue();
        boolean entryIsDirty = false;
        double adjust = RbAuPhyParameters.getFrequencyBoundsAdjust(phyParams.getRbAuPhyConfiguredBandwidth());
        ROTableModel model = ((MBSChannelPanel)this.getUI()).getTableModel();
        FormUtil.stopTableEditing((JTable)((MBSChannelPanel)this.getUI()).getTable());
        HashSet<String> rowKeys = new HashSet<String>();
        HashMap<String, RbMBSTChannelConfigEntry> mbstChnlsByODU = new HashMap<String, RbMBSTChannelConfigEntry>();
        if (chnlHasDiversity) {
            rowKeys.add(model.getRowKey(model.getSortedIndexFromOriginalIndex(1)));
            if (is4thOrder || crtDiv > 2) {
                for (int j = 2; j < model.getRowCount(); ++j) {
                    rowKeys.add(model.getRowKey(model.getSortedIndexFromOriginalIndex(j)));
                }
            }
            mbstChannels = new ArrayList<RbMBSTChannelConfigEntry>();
            int sortedIndexOfRow0 = model.getSortedIndexFromOriginalIndex(0);
            for (RbMBSTChannelConfigEntry channel : mbstChannelTable.getEntries()) {
                if (rowKeys.contains(channel.getRowKey())) {
                    RbMBSTChannelConfigEntry cloneChnl = (RbMBSTChannelConfigEntry)channel.clone();
                    cloneChnl.setRbMBSTChannelAdminStatus((Integer)model.getValueAt(sortedIndexOfRow0, 9));
                    confTxFrequency = model.getValueAt(sortedIndexOfRow0, 6) != null ? String.valueOf(model.getValueAt(sortedIndexOfRow0, 6)) : null;
                    cloneChnl.setRbMBSTChannelConfiguredTxFrequency(confTxFrequency);
                    cloneChnl.setRbMBSTChannelOduActualFrequencyBand((Integer)model.getValueAt(sortedIndexOfRow0, 4));
                    mbstChannels.add(cloneChnl);
                    mbstChnlsByODU.put(channel.getRowKey(), cloneChnl);
                    continue;
                }
                mbstChannels.add(channel);
            }
        } else {
            mbstChannels = mbstChannelTable.getEntries();
        }
        for (int i = 0; i < model.getRowCount(); ++i) {
            int unSortedI = model.modelIndex(i);
            boolean thisODUChanged = false;
            Integer oduId = (Integer)model.getValueAt(i, 1);
            if (model.getRowState(i) == 3) {
                RbMBSTFrequencyBandsEntry freqBand;
                if (null == oduId) {
                    oduId = 0;
                }
                confTxFrequency = model.getValueAt(i, 6) != null ? String.valueOf(model.getValueAt(i, 6)) : null;
                Double confTxFrequencyDouble = null;
                if (confTxFrequency == null) {
                    invalidValues.add(new InvalidValue(i18n.translateString("ConfiguredTxFrequency"), RbMBSTChannelConfigEntry.class, "NullConfiguredTxFrequencyError", (Object)"null", (Object)this));
                } else {
                    try {
                        confTxFrequencyDouble = Double.valueOf(confTxFrequency);
                    }
                    catch (NumberFormatException nfe) {
                        invalidValues.add(new InvalidValue(i18n.translateString("ConfiguredTxFrequency"), RbMBSTChannelConfigEntry.class, i18n.translateString("NotNumberConfiguredTxFrequencyError"), (Object)confTxFrequency, (Object)this));
                    }
                }
                String rowKey = model.getRowKey(i);
                entry = (RbMBSTChannelConfigEntry)mbstChannelTable.findEntry(rowKey);
                if (!entry.getRbMBSTChannelAssociatedOduId().equals(oduId) && entry.getRbMBSTChannelId() != 1) {
                    thisODUChanged = true;
                    oduChanged = true;
                }
                if (!entry.getRbMBSTChannelAssociatedOduId().equals(oduId)) {
                    entryIsDirty = true;
                }
                entry.setRbMBSTChannelAssociatedOduId(oduId);
                if (entry.getRbMBSTChannelConfiguredTxFrequency() != null && !entry.getRbMBSTChannelConfiguredTxFrequency().equals(confTxFrequency)) {
                    entryIsDirty = true;
                }
                entry.setRbMBSTChannelConfiguredTxFrequency(String.format(Locale.ENGLISH, "%.3f", confTxFrequencyDouble));
                Integer adminStatus = (Integer)model.getValueAt(i, 9);
                if (!entry.getRbMBSTChannelAdminStatus().equals(adminStatus)) {
                    entryIsDirty = true;
                }
                entry.setRbMBSTChannelAdminStatus(adminStatus);
                if (oduId == 0 && Integer.valueOf(1).equals(entry.getRbMBSTChannelAdminStatus())) {
                    invalidValues.add(new InvalidValue(i18n.translateString("ODUAssocCantBeDeleted"), RbMBSTChannelConfigEntry.class, i18n.translateString("AssocODU"), (Object)oduId, (Object)this));
                }
                RbOduConfigEntry oduEntry = null;
                for (RbOduConfigEntry e : oduTable.getEntries()) {
                    if (!oduId.equals(e.getRbOduConfigId())) continue;
                    oduEntry = e;
                    break;
                }
                RbMBSTFrequencyBandsEntry rbMBSTFrequencyBandsEntry = freqBand = oduEntry != null ? (RbMBSTFrequencyBandsEntry)bandsTable.findEntry(String.valueOf(oduEntry.getRbOduConfigFrequencyBand())) : null;
                if (freqBand != null && confTxFrequencyDouble != null) {
                    double startFreq = freqBand.getRbMBSTFrequencyBandStartFrequency().doubleValue() / 1000.0 + adjust;
                    double stopFreq = freqBand.getRbMBSTFrequencyBandStopFrequency().doubleValue() / 1000.0 - adjust;
                    if (model.isCellEditable(i, 6) && (confTxFrequencyDouble < startFreq || confTxFrequencyDouble > stopFreq) || (confTxFrequencyDouble - startFreq) * 1000.0 % (double)freqBand.getRbMBSTFrequencyBandStep().longValue() != 0.0) {
                        Object[] range = new Object[]{String.valueOf(startFreq), String.valueOf(stopFreq), String.valueOf(freqBand.getRbMBSTFrequencyBandStep().doubleValue() / 1000.0)};
                        invalidValues.add(new InvalidValue(i18n.translateString("GenericValueBetweenWithStep", range), RbMBSTChannelConfigEntry.class, i18n.translateString("ConfiguredTxFrequency"), (Object)confTxFrequency, (Object)this));
                    }
                }
                this.checkAssocOduId(entry, mbstChannels, managedObjects, invalidValues, chnlHasDiversity);
                if (!model.isCellEditable(i, 6) && entryIsDirty) {
                    entry.setRbMBSTChannelConfiguredTxFrequency(null);
                }
                if (!model.isCellEditable(i, 9) && entryIsDirty) {
                    entry.setRbMBSTChannelAdminStatus(null);
                }
                if (!(!thisODUChanged || chnlHasDiversity && unSortedI != 0 || oduEntry == null || oduEntry.getRbOduConfigFrequencyBand() != null && oduEntry.getRbOduConfigFrequencyBand() != 0)) {
                    invalidValues.add(new InvalidValue(i18n.translateString("AssocOduMustHaveConfiguredBandDefined"), RbAuChannelConfigEntry.class, i18n.translateString("AssocODU"), (Object)entry.getRbMBSTChannelAssociatedOduId(), (Object)this));
                }
            } else if (chnlHasDiversity) {
                if (oduId == null && model.getValueAt(model.getSortedIndexFromOriginalIndex(0), 9).equals(1)) {
                    if (unSortedI == 1 && is2ndOrder || unSortedI > 0 && is4thOrder) {
                        invalidValues.add(new InvalidValue(i18n.translateString("ODUAssocCantBeDeleted"), RbMBSTChannelConfigEntry.class, i18n.translateString("AssocODU"), (Object)"0", (Object)this));
                    }
                } else {
                    this.checkAssocOduId((RbMBSTChannelConfigEntry)((Object)mbstChnlsByODU.get(model.getRowKey(i))), mbstChannels, managedObjects, invalidValues, chnlHasDiversity);
                }
            }
            mbstChnlsByODU.remove(model.getRowKey(i));
        }
        this.checkOduAssoc(invalidValues, is2ndOrder, mbstChannelTable);
        RbMBSTChannelConfigEntry firstChnl = (RbMBSTChannelConfigEntry)mbstChannelTable.findEntry("1");
        if (oduChanged && chnlHasDiversity && firstChnl.getRbMBSTChannelAdminStatus().equals(1)) {
            invalidValues.add(new InvalidValue(i18n.translateString("FirstApplyODUChanges"), RbMBSTChannelConfigEntry.class, i18n.translateString("AdminStatus"), (Object)i18n.translateString("Enable"), (Object)this));
        }
    }

    private void checkOduAssoc(List<InvalidValue> invalidValues, boolean is2ndOrder, RbMBSTChannelConfigTable mbstChannelTable) {
        if (!is2ndOrder) {
            return;
        }
        ComboItem diversity = (ComboItem)((MBSChannelPanel)this.getUI()).getCmbDiversityMode().getSelectedItem();
        if ((Integer)diversity.getValue() <= 2) {
            return;
        }
        RbMBSTChannelConfigEntry firstChnl = (RbMBSTChannelConfigEntry)mbstChannelTable.findEntry("1");
        if (firstChnl == null) {
            return;
        }
        if (!firstChnl.getRbMBSTChannelAdminStatus().equals(1)) {
            return;
        }
        this.checkChannel(invalidValues, (RbMBSTChannelConfigEntry)mbstChannelTable.findEntry("3"));
        this.checkChannel(invalidValues, (RbMBSTChannelConfigEntry)mbstChannelTable.findEntry("4"));
    }

    private void checkChannel(List<InvalidValue> invalidValues, RbMBSTChannelConfigEntry entry) {
        if (entry == null) {
            return;
        }
        if (entry.getRbMBSTChannelAssociatedOduId().equals(0)) {
            invalidValues.add(new InvalidValue(i18n.translateString("ChannelMustHaveAssocODU"), RbMBSTChannelConfigEntry.class, i18n.translateString("Channel"), (Object)entry.getRbMBSTChannelId(), (Object)this));
        }
    }

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        TableBinder tblBinder = new TableBinder(i18n, (SimpleRowTableModel)((MBSChannelPanel)this.getUI()).getTableModel(), (SNMPTableMO)managedObjects.get(0));
        tblBinder.add((Binding)new TableColumnBinding("AssocODU", "rbMBSTChannelAssociatedOduId"));
        tblBinder.add((Binding)new TableColumnBinding("AdminStatus", "rbMBSTChannelAdminStatus"));
        binders.add((Binder)tblBinder);
        RbMBSTAdditionalConfigParameters cfgTbl = (RbMBSTAdditionalConfigParameters)((Object)managedObjects.get(4));
        DefaultBinder binder = new DefaultBinder((Object)this.getUI(), (Object)cfgTbl);
        JComboBoxBinding comboBoxBinding = new JComboBoxBinding(i18n, "cmbDiversityMode", "rbMBSTDiversityMode", i18n.translateString("DiversityMode"));
        comboBoxBinding.setIgnoreDisabled(true);
        binder.add((Binding)comboBoxBinding);
        binders.add((Binder)binder);
    }

    public String getTitle() {
        return "AUChannelConfigForm";
    }

    private void checkAssocOduId(RbMBSTChannelConfigEntry entry, List<RbMBSTChannelConfigEntry> auChannels, List<Object> managedObjects, List<InvalidValue> invalidValues, boolean chnlHasDiversity) {
        RbOduConfigEntry entryOdu;
        Integer adminStatusEnabled;
        RbOduConfigEntry odu;
        if (entry == null) {
            return;
        }
        RbOduConfigTable oduTable = (RbOduConfigTable)((Object)managedObjects.get(1));
        Integer entryOduId = entry.getRbMBSTChannelAssociatedOduId();
        if (entryOduId == null || entryOduId == 0) {
            return;
        }
        int[] validValues = new int[oduTable.getSize()];
        int count = 0;
        Iterator i$ = oduTable.getEntries().iterator();
        while (i$.hasNext() && !entryOduId.equals((odu = (RbOduConfigEntry)((Object)i$.next())).getRbOduConfigId())) {
            validValues[count++] = odu.getRbOduConfigId();
        }
        if (count == validValues.length) {
            Arrays.sort(validValues);
            invalidValues.add(new InvalidValue(i18n.translateString("AssocODUValidValuesAre", new Object[]{Arrays.toString(validValues)}), RbOduConfigTable.class, i18n.translateString("RowId", new Object[]{entry.getRbMBSTChannelId()}), (Object)entry.getRbMBSTChannelAssociatedOduId(), (Object)entry));
        }
        if ((adminStatusEnabled = Integer.valueOf(1)).equals(entry.getRbMBSTChannelAdminStatus()) && (entryOdu = (RbOduConfigEntry)oduTable.findEntry(entryOduId.toString())) != null) {
            Integer entryOduFreqBand = entryOdu.getRbOduConfigFrequencyBand();
            RbMBSTFrequencyBandsTable bandsTable = (RbMBSTFrequencyBandsTable)((Object)managedObjects.get(2));
            RbMBSTFrequencyBandsEntry currentFrequencyBandsEntry = (RbMBSTFrequencyBandsEntry)bandsTable.findEntry(entryOduFreqBand.toString());
            if (currentFrequencyBandsEntry != null) {
                ArrayList<Integer> validBandsList = new ArrayList<Integer>();
                for (RbMBSTFrequencyBandsEntry rbFrequencyBandsEntry : bandsTable.getEntries()) {
                    if (!rbFrequencyBandsEntry.getRbMBSTFrequencyBandGroupId().equals(currentFrequencyBandsEntry.getRbMBSTFrequencyBandGroupId())) continue;
                    validBandsList.add(rbFrequencyBandsEntry.getRbMBSTFrequencyBandId().intValue());
                }
                for (RbMBSTChannelConfigEntry channel : auChannels) {
                    Integer oduId;
                    if (!adminStatusEnabled.equals(channel.getRbMBSTChannelAdminStatus()) || entry.getRbMBSTChannelId().equals(channel.getRbMBSTChannelId()) || (oduId = channel.getRbMBSTChannelAssociatedOduId()) == null || oduId == 0) continue;
                    RbOduConfigEntry odu2 = (RbOduConfigEntry)oduTable.findEntry(oduId.toString());
                    if (chnlHasDiversity || odu2 == null || validBandsList.isEmpty() || validBandsList.contains(odu2.getRbOduConfigFrequencyBand())) continue;
                    invalidValues.add(new InvalidValue(i18n.translateString("ODUDifferentFreqBand"), RbAuChannelConfigEntry.class, i18n.translateString("AssocODU"), (Object)entryOduId, (Object)this));
                    break;
                }
            }
        }
        if (adminStatusEnabled.equals(entry.getRbMBSTChannelAdminStatus())) {
            for (RbMBSTChannelConfigEntry channel : auChannels) {
                if (entry.getRbMBSTChannelId().equals(channel.getRbMBSTChannelId()) || !entryOduId.equals(channel.getRbMBSTChannelAssociatedOduId()) || !adminStatusEnabled.equals(channel.getRbMBSTChannelAdminStatus())) continue;
                Object[] values = new Object[]{" ", channel.getRbMBSTChannelId()};
                invalidValues.add(new InvalidValue(i18n.translateString("ODUAlreadyAssoc", values), RbMBSTChannelConfigEntry.class, i18n.translateString("AssocODU"), (Object)entryOduId, (Object)this));
                break;
            }
        }
    }

    public String warnApply() {
        this.applyPressed = true;
        Object o = ((MBSChannelPanel)this.getUI()).getCmbDiversityMode().getSelectedItem();
        if (this.diversityMode != null && !this.diversityMode.equals(o)) {
            return i18n.translateString("AutomaticallyResetMBS");
        }
        return null;
    }

    public String getHelpTopic() {
        return "ngnms.rb.help.au_tdd_channels";
    }
}

