/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JComboBoxBinding;
import com.bwanms.gui.binding.TableBinder;
import com.bwanms.gui.binding.TableColumnBinding;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.FormsConfigSectionView;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.mo.snmp.SNMPTableMO;
import com.bwanms.rb.gui.configuration.MBSChannelPanel;
import com.bwanms.rb.mo.RbAuPhyParameters;
import com.bwanms.rb.mo.RbMBSTAdditionalConfigParameters;
import com.bwanms.rb.mo.RbMBSTChannelConfigEntry;
import com.bwanms.rb.mo.RbMBSTChannelConfigTable;
import com.bwanms.rb.mo.RbMBSTFrequencyBandsEntry;
import com.bwanms.rb.mo.RbMBSTFrequencyBandsTable;
import com.bwanms.rb.mo.RbMbstPhyParametersGroup;
import com.bwanms.rb.mo.RbOduConfigEntry;
import com.bwanms.rb.mo.RbOduConfigTable;
import com.bwanms.rb.model.RbMBS;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.ROTableModel;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FormUtil;
import com.bwanms.util.TableUtil;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JTable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBSChannelConfigForm
extends ManagedObjectsConfigForm<MBSChannelPanel> {
    private static final Log log = LogFactory.getLog(MBSChannelConfigForm.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(MBSChannelConfigForm.class);
    private static final Version V_3_0 = VersionFactory.getInstance().createVersion("3.0");
    private boolean applyPressed = false;
    private Object diversityMode;

    public MBSChannelPanel initUIComponent() {
        MBSChannelPanel panel = new MBSChannelPanel();
        RbMBS bs = (RbMBS)this.ctx.getEquipment();
        if (!bs.isTDDDuplexMode()) {
            panel.getCmbDiversityMode().removeItemAt(2);
            panel.getCmbDiversityMode().removeItemAt(2);
        }
        panel.getCmbDiversityMode().addItem(new ComboItem((Object)5, i18n.translateString(RbMBSTAdditionalConfigParameters.toStringRbMBSTDiversityMode(5))));
        return panel;
    }

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        TableBinder tblBinder = new TableBinder(i18n, (SimpleRowTableModel)((MBSChannelPanel)this.getUI()).getTableModel(), (SNMPTableMO)managedObjects.get(0));
        tblBinder.add((Binding)new TableColumnBinding("AssocODU", "rbMBSTChannelAssociatedOduId"));
        tblBinder.add((Binding)new TableColumnBinding("AdminStatus", "rbMBSTChannelAdminStatus"));
        binders.add((Binder)tblBinder);
        String nrName = (String)this.ctx.getAttribute("NR");
        String key = nrName.substring(nrName.indexOf(46) + 1);
        RbMBSTAdditionalConfigParameters additionalConfigParams = (RbMBSTAdditionalConfigParameters)((Object)managedObjects.get(4));
        DefaultBinder binder = new DefaultBinder((Object)this.getUI(), (Object)additionalConfigParams);
        JComboBoxBinding comboBoxBinding = new JComboBoxBinding(i18n, "cmbDiversityMode", "rbMBSTDiversityMode", i18n.translateString("DiversityMode"));
        comboBoxBinding.setIgnoreDisabled(true);
        binder.add((Binding)comboBoxBinding);
        binders.add((Binder)binder);
    }

    public List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("BS", RbMBSTChannelConfigTable.class));
        ret.add(this.ctx.createRequest("BS", RbOduConfigTable.class));
        ret.add(this.ctx.createRequest("BS", RbMBSTFrequencyBandsTable.class));
        ret.add(this.ctx.createRequest((String)this.ctx.getAttribute("NR"), RbMbstPhyParametersGroup.class));
        ret.add(this.ctx.createRequest("BS", RbMBSTAdditionalConfigParameters.class));
        return ret;
    }

    public void fillUI(List<Object> managedObjects) {
        JTable table = ((MBSChannelPanel)this.getUI()).getTable();
        FormUtil.cancelTableEditing((JTable)table);
        ROTableModel tableModel = ((MBSChannelPanel)this.getUI()).getTableModel();
        tableModel.clearTable();
        for (int i = 0; i < 4; ++i) {
            tableModel.addNewRow(null, true);
        }
        RbMBSTChannelConfigTable channelTable = (RbMBSTChannelConfigTable)((Object)managedObjects.get(0));
        RbOduConfigTable oduTable = (RbOduConfigTable)((Object)managedObjects.get(1));
        RbMBSTFrequencyBandsTable bandsTable = (RbMBSTFrequencyBandsTable)((Object)managedObjects.get(2));
        ArrayList<ComboItem> bands = new ArrayList<ComboItem>();
        bands.add(new ComboItem((Object)0, i18n.translateString("notDefined")));
        for (RbMBSTFrequencyBandsEntry entry : bandsTable.getEntries()) {
            bands.add(new ComboItem((Object)entry.getRbMBSTFrequencyBandId().intValue(), entry.getRbMBSTFrequencyBandName()));
        }
        tableModel.setValueSet(-1, 4, bands);
        tableModel.setValueSet(-1, 5, bands);
        log.info((Object)("+++++++++++++++++++++ ODU Table entries: " + oduTable.getSize()));
        RbMBSTAdditionalConfigParameters additionalConfigParams = (RbMBSTAdditionalConfigParameters)((Object)managedObjects.get(4));
        Version runningVersion = VersionFactory.getInstance().createVersion(this.ctx.getEquipment().getRunningSoftwareVersion());
        Integer diversity = additionalConfigParams.getRbMBSTDiversityMode();
        JComboBox cmbDiversityMode = ((MBSChannelPanel)this.getUI()).getCmbDiversityMode();
        cmbDiversityMode.setEnabled(V_3_0.compareTo((Object)runningVersion) < 0);
        this.diversityMode = cmbDiversityMode.getSelectedItem();
        boolean diversityOn = !diversity.equals(1);
        boolean is2ndOrder = diversity.equals(2) || diversity.equals(5);
        int rowCounter = 0;
        boolean firstChannelAdminStatusEnabled = false;
        for (RbMBSTChannelConfigEntry entry : channelTable.getEntries()) {
            boolean curentChannelAdminStatusEnabled;
            boolean bl = entry.getRbMBSTChannelAdminStatus() != null ? entry.getRbMBSTChannelAdminStatus() == 1 : (curentChannelAdminStatusEnabled = false);
            if (rowCounter == 0) {
                firstChannelAdminStatusEnabled = curentChannelAdminStatusEnabled;
            }
            RbOduConfigEntry oduEntry = null;
            for (RbOduConfigEntry e : oduTable.getEntries()) {
                if (!e.getRbOduConfigId().equals(entry.getRbMBSTChannelAssociatedOduId())) continue;
                oduEntry = e;
            }
            rowCounter = entry.getRbMBSTChannelId() - 1;
            if (rowCounter < 4) {
                tableModel.setRowKey(rowCounter, entry.getRowKey());
                tableModel.setInitialValueAt((Object)entry.getRbMBSTChannelId(), rowCounter, 0);
                if (entry.getRbMBSTChannelAssociatedOduId() > 0) {
                    tableModel.setInitialValueAt((Object)entry.getRbMBSTChannelAssociatedOduId(), rowCounter, 1);
                }
                if (oduEntry != null) {
                    tableModel.setInitialValueAt((Object)oduEntry.getRbOduAssociatedRadioClusterId(), rowCounter, 2);
                    tableModel.setInitialValueAt((Object)oduEntry.getRbOduTxPower(), rowCounter, 3);
                    tableModel.setInitialValueAt((Object)oduEntry.getRbOduConfigFrequencyBand(), rowCounter, 4);
                }
                tableModel.setInitialValueAt((Object)entry.getRbMBSTChannelOduActualFrequencyBand(), rowCounter, 5);
                tableModel.setInitialValueAt((Object)entry.getRbMBSTChannelConfiguredTxFrequency(), rowCounter, 6);
                tableModel.setInitialValueAt((Object)entry.getRbMBSTChannelTxFrequency(), rowCounter, 7);
                tableModel.setInitialValueAt((Object)entry.getRbMBSTChannelRxFrequency(), rowCounter, 8);
                tableModel.setInitialValueAt((Object)entry.getRbMBSTChannelAdminStatus(), rowCounter, 9);
                tableModel.setInitialValueAt((Object)i18n.translateString(RbMBSTChannelConfigEntry.toStringRbMBSTChannelOperStatus(entry.getRbMBSTChannelOperStatus())), rowCounter, 10);
                if (!firstChannelAdminStatusEnabled) {
                    if (diversityOn && rowCounter > 0) {
                        tableModel.setROCell(rowCounter, 6);
                        tableModel.setROCell(rowCounter, 9);
                    }
                    if (is2ndOrder && rowCounter > 1) {
                        tableModel.setROCell(rowCounter, 1);
                    }
                } else if (diversityOn) {
                    tableModel.setROCell(rowCounter, 1);
                    tableModel.setROCell(rowCounter, 6);
                    if (rowCounter > 0) {
                        tableModel.setROCell(rowCounter, 9);
                    }
                }
                if (curentChannelAdminStatusEnabled) {
                    tableModel.setROCell(rowCounter, 1);
                    tableModel.setROCell(rowCounter, 6);
                }
                if (oduEntry != null) {
                    ((MBSChannelPanel)this.getUI()).getController().addDetails(entry.getRbMBSTChannelAssociatedOduId(), new String[]{oduEntry.getRbOduCardSerialNumber(), oduEntry.getRbOduHwRevision(), oduEntry.getRbOduHwConfigDescription(), oduEntry.getRbOduHwHC08Version(), oduEntry.getRbOduCpldVersion(), oduEntry.getRbOduTemperature().toString(), oduEntry.getRbOduMaxTxPower() == null ? "NA" : oduEntry.getRbOduMaxTxPower().toString()});
                }
            }
            ++rowCounter;
        }
        TableUtil.autoResizeColumn((JTable)table, (int)0, (boolean)true);
        tableModel.sort();
        FormsConfigSectionView formsConfigSectionView = (FormsConfigSectionView)this.getConfigSectionView();
        String channelId = String.valueOf(formsConfigSectionView.getAttribute("channelId"));
        if (channelId != null) {
            try {
                int chanelIdInt = Integer.parseInt(channelId);
                ((MBSChannelPanel)this.getUI()).getTable().setRowSelectionInterval(chanelIdInt, chanelIdInt);
            }
            catch (Exception e) {}
        } else {
            ((MBSChannelPanel)this.getUI()).getTable().clearSelection();
        }
        if (this.applyPressed) {
            this.applyPressed = false;
            this.getConfigSectionView().refresh(true);
        }
    }

    public void configureMOs(List<Object> managedObjects, List<InvalidValue> invalidValues) {
        RbMBSTChannelConfigTable channelTable = (RbMBSTChannelConfigTable)((Object)managedObjects.get(0));
        RbOduConfigTable oduTable = (RbOduConfigTable)((Object)managedObjects.get(1));
        RbMBSTFrequencyBandsTable bandsTable = (RbMBSTFrequencyBandsTable)((Object)managedObjects.get(2));
        RbAuPhyParameters phyParams = (RbAuPhyParameters)((Object)managedObjects.get(3));
        RbMBSTAdditionalConfigParameters additionalConfigParams = (RbMBSTAdditionalConfigParameters)((Object)managedObjects.get(4));
        Integer diversity = additionalConfigParams.getRbMBSTDiversityMode();
        boolean hasDiversity = diversity != null && (diversity.equals(2) || diversity.equals(5));
        boolean oduChanged = false;
        boolean entryIsDirty = false;
        double adjust = RbAuPhyParameters.getFrequencyBoundsAdjust(phyParams.getRbAuPhyConfiguredBandwidth());
        ROTableModel model = ((MBSChannelPanel)this.getUI()).getTableModel();
        FormUtil.stopTableEditing((JTable)((MBSChannelPanel)this.getUI()).getTable());
        boolean activeRowDiversityStatusEnabled = false;
        Integer secondRowDiversityODUId = null;
        Integer activeRowDiversityODUId = null;
        for (int i = 0; i < model.getRowCount(); ++i) {
            if (model.getRowState(i) == 3) {
                RbMBSTFrequencyBandsEntry freqBand;
                RbOduConfigEntry oduEntry;
                String confTxFrequency = model.getValueAt(i, 6) != null ? String.valueOf(model.getValueAt(i, 6)) : null;
                Double confTxFrequencyDouble = null;
                if (confTxFrequency == null) {
                    invalidValues.add(new InvalidValue(i18n.translateString("ConfiguredTxFrequency"), RbMBSTChannelConfigEntry.class, "NullConfiguredTxFrequencyError", (Object)"null", (Object)this));
                } else {
                    try {
                        confTxFrequencyDouble = Double.valueOf(confTxFrequency);
                    }
                    catch (NumberFormatException nfe) {
                        invalidValues.add(new InvalidValue(i18n.translateString("ConfiguredTxFrequency"), RbMBSTChannelConfigEntry.class, i18n.translateString("NotNumberConfiguredTxFrequencyError"), (Object)confTxFrequency, (Object)this));
                    }
                }
                Integer oduId = (Integer)model.getValueAt(i, 1);
                if (oduId == null) {
                    oduId = new Integer(0);
                }
                String rowKey = model.getRowKey(i);
                Integer adminStatus = (Integer)model.getValueAt(i, 9);
                RbMBSTChannelConfigEntry entry = (RbMBSTChannelConfigEntry)channelTable.findEntry(rowKey);
                if (!entry.getRbMBSTChannelAssociatedOduId().equals(oduId) && entry.getRbMBSTChannelId() != 1) {
                    oduChanged = true;
                }
                if (!entry.getRbMBSTChannelAssociatedOduId().equals(oduId)) {
                    entryIsDirty = true;
                }
                entry.setRbMBSTChannelAssociatedOduId(oduId);
                if (entry.getRbMBSTChannelConfiguredTxFrequency() != null && !entry.getRbMBSTChannelConfiguredTxFrequency().equals(confTxFrequency)) {
                    entryIsDirty = true;
                }
                entry.setRbMBSTChannelConfiguredTxFrequency(String.format(Locale.ENGLISH, "%.3f", confTxFrequencyDouble));
                if (!entry.getRbMBSTChannelAdminStatus().equals(adminStatus)) {
                    entryIsDirty = true;
                }
                entry.setRbMBSTChannelAdminStatus(adminStatus);
                if (oduId == 0 && Integer.valueOf(1).equals(entry.getRbMBSTChannelAdminStatus())) {
                    invalidValues.add(new InvalidValue(i18n.translateString("ODUAssocCantBeDeleted"), RbMBSTChannelConfigEntry.class, i18n.translateString("AssocODU"), (Object)oduId, (Object)this));
                }
                Integer configBandId = (oduEntry = (RbOduConfigEntry)oduTable.findEntry(oduId.toString())) != null ? oduEntry.getRbOduConfigFrequencyBand() : null;
                RbMBSTFrequencyBandsEntry rbMBSTFrequencyBandsEntry = freqBand = configBandId != null ? (RbMBSTFrequencyBandsEntry)bandsTable.findEntry(((Object)configBandId).toString()) : null;
                if (freqBand != null && confTxFrequencyDouble != null) {
                    double startFreq = freqBand.getRbMBSTFrequencyBandStartFrequency().doubleValue() / 1000.0 + adjust;
                    double stopFreq = freqBand.getRbMBSTFrequencyBandStopFrequency().doubleValue() / 1000.0 - adjust;
                    Long step = freqBand.getRbMBSTFrequencyBandStep();
                    if (model.isCellEditable(i, 6) && (confTxFrequencyDouble < startFreq || confTxFrequencyDouble > stopFreq || (confTxFrequencyDouble - startFreq) * 1000.0 % step.doubleValue() != 0.0)) {
                        Object[] range = new Object[]{String.valueOf(startFreq), String.valueOf(stopFreq), String.valueOf(step.doubleValue() / 1000.0)};
                        invalidValues.add(new InvalidValue(i18n.translateString("GenericValueBetweenWithStep", range), RbMBSTChannelConfigEntry.class, i18n.translateString("ConfiguredTxFrequency"), (Object)confTxFrequency, (Object)this));
                    }
                }
                this.checkAssocOduId(entry, managedObjects, invalidValues, hasDiversity);
                if (!model.isCellEditable(i, 6) && entryIsDirty) {
                    entry.setRbMBSTChannelConfiguredTxFrequency(null);
                } else if (confTxFrequency == null) {
                    invalidValues.add(new InvalidValue(i18n.translateString("ConfiguredTxFrequencyMandatory"), RbMBSTChannelConfigEntry.class, i18n.translateString("ConfiguredTxFrequency"), (Object)confTxFrequency, (Object)this));
                }
                if (!model.isCellEditable(i, 9) && entryIsDirty) {
                    entry.setRbMBSTChannelAdminStatus(null);
                } else if (adminStatus == null) {
                    invalidValues.add(new InvalidValue(i18n.translateString("AdminStatusMandatory"), RbMBSTChannelConfigEntry.class, i18n.translateString("AdminStatus"), (Object)confTxFrequency, (Object)this));
                } else if (hasDiversity && adminStatus.equals(1)) {
                    activeRowDiversityStatusEnabled = true;
                    activeRowDiversityODUId = (Integer)model.getValueAt(i, 1);
                }
            }
            if (!hasDiversity || (Integer)model.getValueAt(i, 0) != 2) continue;
            secondRowDiversityODUId = (Integer)model.getValueAt(i, 1);
        }
        if (hasDiversity && activeRowDiversityStatusEnabled) {
            if (secondRowDiversityODUId == null) {
                invalidValues.add(new InvalidValue(i18n.translateString("ODUAssocCantBeDeleted"), RbMBSTChannelConfigEntry.class, i18n.translateString("AssocODU"), (Object)2, (Object)this));
            } else if (secondRowDiversityODUId.equals(activeRowDiversityODUId)) {
                Object[] values = new Object[]{"", secondRowDiversityODUId};
                invalidValues.add(new InvalidValue(i18n.translateString("ODUAlreadyAssoc", values), RbMBSTChannelConfigEntry.class, i18n.translateString("AssocODU"), activeRowDiversityODUId, (Object)this));
            }
        }
        RbMBSTChannelConfigEntry firstChnl = (RbMBSTChannelConfigEntry)channelTable.findEntry("1");
        if (oduChanged && hasDiversity && firstChnl.getRbMBSTChannelAdminStatus().equals(1)) {
            invalidValues.add(new InvalidValue(i18n.translateString("FirstApplyODUChanges"), RbMBSTChannelConfigEntry.class, i18n.translateString("AdminStatus"), (Object)i18n.translateString("Enable"), (Object)this));
        }
        additionalConfigParams.setRbMBSTMaxNumberOfCalls(null);
    }

    public String getTitle() {
        return "ChannelConfigForm";
    }

    private void checkAssocOduId(RbMBSTChannelConfigEntry entry, List<Object> managedObjects, List<InvalidValue> invalidValues, boolean hasDiversity) {
        RbOduConfigEntry entryOdu;
        Integer adminStatusEnabled;
        RbOduConfigEntry odu;
        RbMBSTChannelConfigTable channelTable = (RbMBSTChannelConfigTable)((Object)managedObjects.get(0));
        RbOduConfigTable oduTable = (RbOduConfigTable)((Object)managedObjects.get(1));
        Integer entryOduId = entry.getRbMBSTChannelAssociatedOduId();
        if (entryOduId == null || entryOduId == 0) {
            return;
        }
        int[] validValues = new int[oduTable.getSize()];
        int count = 0;
        Iterator i$ = oduTable.getEntries().iterator();
        while (i$.hasNext() && !entryOduId.equals((odu = (RbOduConfigEntry)((Object)i$.next())).getRbOduConfigId())) {
            validValues[count++] = odu.getRbOduConfigId();
        }
        if (count == validValues.length) {
            Arrays.sort(validValues);
            invalidValues.add(new InvalidValue(i18n.translateString("AssocODUValidValuesAre", new Object[]{Arrays.toString(validValues)}), RbOduConfigTable.class, i18n.translateString("RowId", new Object[]{entry.getRbMBSTChannelId()}), (Object)entry.getRbMBSTChannelAssociatedOduId(), (Object)entry));
        }
        if ((adminStatusEnabled = Integer.valueOf(1)).equals(entry.getRbMBSTChannelAdminStatus()) && (entryOdu = (RbOduConfigEntry)oduTable.findEntry(entryOduId.toString())) != null) {
            Integer entryOduFreqBand = entryOdu.getRbOduConfigFrequencyBand();
            RbMBSTFrequencyBandsTable bandsTable = (RbMBSTFrequencyBandsTable)((Object)managedObjects.get(2));
            RbMBSTFrequencyBandsEntry currentFrequencyBandsEntry = (RbMBSTFrequencyBandsEntry)bandsTable.findEntry(entryOduFreqBand.toString());
            if (currentFrequencyBandsEntry != null) {
                ArrayList<Integer> validBandsList = new ArrayList<Integer>();
                for (RbMBSTFrequencyBandsEntry rbFrequencyBandsEntry : bandsTable.getEntries()) {
                    if (!rbFrequencyBandsEntry.getRbMBSTFrequencyBandGroupId().equals(currentFrequencyBandsEntry.getRbMBSTFrequencyBandGroupId())) continue;
                    validBandsList.add(rbFrequencyBandsEntry.getRbMBSTFrequencyBandId().intValue());
                }
                for (RbMBSTChannelConfigEntry channel : channelTable.getEntries()) {
                    if (entry.getRbMBSTChannelId().equals(channel.getRbMBSTChannelId()) || !adminStatusEnabled.equals(channel.getRbMBSTChannelAdminStatus()) || null == channel.getRbMBSTChannelAssociatedOduId()) continue;
                    RbOduConfigEntry odu2 = (RbOduConfigEntry)oduTable.findEntry(channel.getRbMBSTChannelAssociatedOduId().toString());
                    if (hasDiversity || odu2 == null || validBandsList.contains(odu2.getRbOduConfigFrequencyBand())) continue;
                    invalidValues.add(new InvalidValue(i18n.translateString("ODUDifferentFreqBand"), RbMBSTChannelConfigEntry.class, i18n.translateString("AssocODU"), (Object)entryOduId, (Object)this));
                    break;
                }
            }
        }
        if (adminStatusEnabled.equals(entry.getRbMBSTChannelAdminStatus())) {
            for (RbMBSTChannelConfigEntry channel : channelTable.getEntries()) {
                if (entry.getRbMBSTChannelId().equals(channel.getRbMBSTChannelId()) || !adminStatusEnabled.equals(channel.getRbMBSTChannelAdminStatus()) || !entryOduId.equals(channel.getRbMBSTChannelAssociatedOduId())) continue;
                Object[] values = new Object[]{"", channel.getRbMBSTChannelId()};
                invalidValues.add(new InvalidValue(i18n.translateString("ODUAlreadyAssoc", values), RbMBSTChannelConfigEntry.class, i18n.translateString("AssocODU"), (Object)entryOduId, (Object)this));
                break;
            }
        }
    }

    public String getHelpTopic() {
        return "ngnms.rb.help.au_channels";
    }

    public String warnApply() {
        this.applyPressed = true;
        Object o = ((MBSChannelPanel)this.getUI()).getCmbDiversityMode().getSelectedItem();
        if (this.diversityMode != null && !this.diversityMode.equals(o)) {
            return i18n.translateString("AutomaticallyResetMBS");
        }
        return null;
    }
}

