/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.translators.MACAddressTranslator;
import com.bwanms.gui.binding.translators.TranslateException;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.mo.DuplicateEntryException;
import com.bwanms.mo.TableRowMO;
import com.bwanms.rb.gui.configuration.MACDenyListPanel;
import com.bwanms.rb.mo.RbMACAddressDenyListEntry;
import com.bwanms.rb.mo.RbMACAddressDenyListTable;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FormUtil;
import com.bwanms.util.MacAddress;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MACDenyListConfigForm
extends ManagedObjectsConfigForm<MACDenyListPanel> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(MACDenyListConfigForm.class);

    public MACDenyListPanel initUIComponent() {
        return new MACDenyListPanel();
    }

    public List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("BS", RbMACAddressDenyListTable.class));
        return ret;
    }

    public void fillUI(List<Object> managedObjects) {
        SimpleRowTableModel model = ((MACDenyListPanel)this.getUI()).getTableModel();
        FormUtil.cancelTableEditing((JTable)((MACDenyListPanel)this.getUI()).getTable2());
        model.clearTable();
        RbMACAddressDenyListTable table = (RbMACAddressDenyListTable)((Object)managedObjects.get(0));
        int count = 0;
        for (RbMACAddressDenyListEntry entry : table.getEntries()) {
            model.addNewRow(entry.getRowKey(), true);
            model.setInitialValueAt((Object)MacAddress.fromOctetString((String)entry.getRbMACAddressDenyMacAddress()).toString(), count++, 0);
        }
        ((MACDenyListPanel)this.getUI()).getBtnAdd().setEnabled(true);
        model.sort();
    }

    protected void configureMOs(List<Object> managedObjects, List<InvalidValue> invalidValues) {
        SimpleRowTableModel model = ((MACDenyListPanel)this.getUI()).getTableModel();
        FormUtil.stopTableEditing((JTable)((MACDenyListPanel)this.getUI()).getTable2());
        RbMACAddressDenyListTable table = (RbMACAddressDenyListTable)((Object)managedObjects.get(0));
        block8: for (int i = 0; i < model.getRowCount(); ++i) {
            String macAddress = "";
            String macValue = (String)model.getValueAt(i, 0);
            try {
                new MACAddressTranslator().convertToBeanValue((Object)macValue);
            }
            catch (TranslateException e) {
                invalidValues.add(new InvalidValue(i18n.translateString("macDenyInvalidMACAddress", new Object[]{String.valueOf(i + 1)}), RbMACAddressDenyListEntry.class, "MAC", (Object)macValue, (Object)this));
                continue;
            }
            if (macValue.equalsIgnoreCase("FF-FF-FF-FF-FF-FF")) {
                invalidValues.add(new InvalidValue(i18n.translateString("macDenyInvalidMACAddress", new Object[]{String.valueOf(i + 1)}), RbMACAddressDenyListEntry.class, "MAC", (Object)macValue, (Object)this));
                continue;
            }
            macAddress = MacAddress.fromString((String)macValue).toOctetString();
            switch (model.getRowState(i)) {
                case 1: {
                    table.removeEntry(MacAddress.fromString((String)macValue).toInstanceString());
                    continue block8;
                }
                case 2: {
                    RbMACAddressDenyListEntry entry = new RbMACAddressDenyListEntry();
                    entry.setRbMACAddressDenyMacAddress(macAddress);
                    try {
                        table.addEntry((TableRowMO)entry);
                        continue block8;
                    }
                    catch (DuplicateEntryException deea) {
                        invalidValues.add(new InvalidValue(i18n.translateString("entryAlreadyInTable"), RbMACAddressDenyListEntry.class, i18n.translateString("MACAddress"), (Object)macValue, null));
                    }
                }
            }
        }
    }

    public String getTitle() {
        return "MACAddressDenyList";
    }

    public String getHelpTopic() {
        if (VersionFactory.getInstance().createVersion(this.ctx.getEquipment().getRunningSoftwareVersion()).isOlderThan((Version)new DefaultVersion("4.0"))) {
            return "ngnms.rb.help.mac_deny_list";
        }
        return "ngnms.rb.help.tdd_mac_deny_list";
    }
}

