/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.rb.gui.configuration.FiltersPanel;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.ui.components.SimpleRowTableModelPanelController;
import com.bwanms.util.TableUtil;
import java.util.Comparator;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JTable;

public class L3L4FiltersTablePanelController
extends SimpleRowTableModelPanelController {
    public static int MAX_FILTERS_NUMBER = 255;
    public static TreeMap<String, String> portTypes = new TreeMap(new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return Integer.parseInt(o1) - Integer.parseInt(o2);
        }
    });
    public static TreeMap<String, String> protocolTypes = new TreeMap();
    FiltersPanel form;

    public L3L4FiltersTablePanelController(FiltersPanel form) {
        this.form = form;
    }

    protected SimpleRowTableModel getTableModel() {
        return this.form.getTblL34RulesModel();
    }

    protected JTable getTable() {
        return this.form.getTblL34Rules();
    }

    protected JButton getDeleteButton() {
        return this.form.getBtnL34Delete();
    }

    protected JButton getRevertButton() {
        return this.form.getBtnL34Revert();
    }

    public void btnRevertMouseClicked() {
        super.btnRevertMouseClicked();
        if (this.getTable().getRowCount() < MAX_FILTERS_NUMBER) {
            this.form.getBtnL34Add().setEnabled(true);
        }
    }

    public void btnAddMouseClicked() {
        super.btnAddMouseClicked();
        TableUtil.selectAndScrollToRow((JTable)this.getTable(), (int)(this.getTableModel().getRowCount() - 1));
        int rowcount = this.getTable().getRowCount();
        if (this.getTable().getRowCount() >= MAX_FILTERS_NUMBER) {
            this.form.getBtnL34Add().setEnabled(false);
        }
    }

    public void updateMbstDirection() {
        String ipValue;
        if (this.getTable().getSelectedRow() < 0) {
            return;
        }
        if (this.getTableModel().getValueAt(this.getTable().getSelectedRow(), 2) == null) {
            return;
        }
        if (this.getTableModel().getValueAt(this.getTable().getSelectedRow(), 2).equals(0)) {
            this.getTableModel().setValueAt((Object)FiltersPanel.i18n.translateString("any"), this.getTable().getSelectedRow(), 1);
            this.form.getTblL34RulesModel().setROCell(this.getTable().getSelectedRow(), 1);
        } else if (this.getTableModel().getValueAt(this.getTable().getSelectedRow(), 1) != null && ((ipValue = this.getTableModel().getValueAt(this.getTable().getSelectedRow(), 1).toString()).equalsIgnoreCase(FiltersPanel.i18n.translateString("any")) || ipValue.equals("254.255.255.255"))) {
            this.form.getTblL34RulesModel().resetTableAccess(Integer.valueOf(this.getTable().getSelectedRow()), Integer.valueOf(1));
            this.getTableModel().setValueAt((Object)"", this.getTable().getSelectedRow(), 1);
        }
    }

    public void updateDirection() {
        if (this.getTable().getSelectedRow() < 0) {
            return;
        }
        if (this.getTableModel().getValueAt(this.getTable().getSelectedRow(), 3) == null) {
            return;
        }
        if (this.getTableModel().getValueAt(this.getTable().getSelectedRow(), 3).equals(0)) {
            this.getTableModel().setValueAt((Object)FiltersPanel.i18n.translateString("any"), this.getTable().getSelectedRow(), 1);
            this.form.getTblL34RulesModel().setROCell(this.getTable().getSelectedRow(), 1);
            this.getTableModel().setValueAt((Object)FiltersPanel.i18n.translateString("notApplicable"), this.getTable().getSelectedRow(), 2);
            this.form.getTblL34RulesModel().setROCell(this.getTable().getSelectedRow(), 2);
        } else {
            String ipValue;
            if (this.getTableModel().getValueAt(this.getTable().getSelectedRow(), 1) != null && ((ipValue = this.getTableModel().getValueAt(this.getTable().getSelectedRow(), 1).toString()).equalsIgnoreCase(FiltersPanel.i18n.translateString("any")) || ipValue.equals("254.255.255.255"))) {
                this.form.getTblL34RulesModel().resetTableAccess(Integer.valueOf(this.getTable().getSelectedRow()), Integer.valueOf(1));
                this.getTableModel().setValueAt((Object)"", this.getTable().getSelectedRow(), 1);
            }
            if (this.getTableModel().getValueAt(this.getTable().getSelectedRow(), 2) != null && this.getTableModel().getValueAt(this.getTable().getSelectedRow(), 2).toString().indexOf(FiltersPanel.i18n.translateString("notApplicable")) >= 0) {
                this.form.getTblL34RulesModel().resetTableAccess(Integer.valueOf(this.getTable().getSelectedRow()), Integer.valueOf(2));
                this.getTableModel().setValueAt((Object)"", this.getTable().getSelectedRow(), 2);
            }
        }
    }

    public void updatePort(int colIdx) {
        if (this.getTable().getSelectedRow() < 0) {
            return;
        }
        if (this.getTableModel().getValueAt(this.getTable().getSelectedRow(), colIdx) == null) {
            return;
        }
        if (this.getTableModel().getValueAt(this.getTable().getSelectedRow(), colIdx).equals(0)) {
            this.getTableModel().setValueAt((Object)"65535", this.getTable().getSelectedRow(), colIdx - 1);
            this.form.getTblL34RulesModel().setROCell(this.getTable().getSelectedRow(), colIdx - 1);
        } else {
            if (this.getTableModel().getValueAt(this.getTable().getSelectedRow(), colIdx - 1) == null) {
                return;
            }
            if (this.getTableModel().getValueAt(this.getTable().getSelectedRow(), colIdx - 1).equals("65535")) {
                this.form.getTblL34RulesModel().resetTableAccess(Integer.valueOf(this.getTable().getSelectedRow()), Integer.valueOf(colIdx - 1));
                this.getTableModel().setValueAt((Object)"", this.getTable().getSelectedRow(), colIdx - 1);
            }
        }
    }

    public void updateIpProtocol(int colIdx) {
        if (this.getTable().getSelectedRow() < 0) {
            return;
        }
        if (this.getTableModel().getValueAt(this.getTable().getSelectedRow(), colIdx) == null) {
            return;
        }
        String currentValue = (String)this.getTableModel().getValueAt(this.getTable().getSelectedRow(), colIdx);
        if (!currentValue.equals("6") && !currentValue.equals("17")) {
            this.getTableModel().setValueAt((Object)"65535", this.getTable().getSelectedRow(), colIdx + 1);
            this.form.getTblL34RulesModel().setROCell(this.getTable().getSelectedRow(), colIdx + 1);
            this.getTableModel().setValueAt((Object)new ComboItem((Object)0, FiltersPanel.i18n.translateString("both")), this.getTable().getSelectedRow(), colIdx + 2);
            this.form.getTblL34RulesModel().setROCell(this.getTable().getSelectedRow(), colIdx + 2);
        } else {
            this.form.getTblL34RulesModel().resetTableAccess(Integer.valueOf(this.getTable().getSelectedRow()), Integer.valueOf(colIdx + 1));
            this.form.getTblL34RulesModel().resetTableAccess(Integer.valueOf(this.getTable().getSelectedRow()), Integer.valueOf(colIdx + 2));
        }
    }

    public void updateIp(int colIdx, String value) {
        if (this.getTable().getSelectedRow() < 0 || null == value) {
            return;
        }
        if (value.equalsIgnoreCase("any") || value.equals("254.255.255.255")) {
            this.getTableModel().setValueAt((Object)FiltersPanel.i18n.translateString("notApplicable"), this.getTable().getSelectedRow(), colIdx + 1);
            this.form.getTblL34RulesModel().setROCell(this.getTable().getSelectedRow(), colIdx + 1);
            this.getTableModel().setValueAt((Object)new ComboItem((Object)0, FiltersPanel.i18n.translateString("both")), this.getTable().getSelectedRow(), colIdx + 2);
        } else {
            if (this.getTableModel().getValueAt(this.getTable().getSelectedRow(), colIdx + 1) != null && this.getTableModel().getValueAt(this.getTable().getSelectedRow(), colIdx + 1).toString().indexOf(FiltersPanel.i18n.translateString("notApplicable")) >= 0) {
                this.form.getTblL34RulesModel().resetTableAccess(Integer.valueOf(this.getTable().getSelectedRow()), Integer.valueOf(colIdx + 1));
                this.getTableModel().setValueAt((Object)"", this.getTable().getSelectedRow(), colIdx + 1);
            }
            if (this.getTableModel().getValueAt(this.getTable().getSelectedRow(), colIdx + 2) != null && this.getTableModel().getValueAt(this.getTable().getSelectedRow(), colIdx + 2).toString().indexOf(FiltersPanel.i18n.translateString("both")) >= 0) {
                this.getTableModel().setValueAt((Object)"", this.getTable().getSelectedRow(), colIdx + 2);
            }
        }
    }

    public void updateMbstIp(int colIdx, String value) {
        if (this.getTable().getSelectedRow() < 0 || null == value) {
            return;
        }
        if (value.equalsIgnoreCase("any") || value.equals("254.255.255.255")) {
            this.getTableModel().setValueAt((Object)new ComboItem((Object)0, FiltersPanel.i18n.translateString("both")), this.getTable().getSelectedRow(), colIdx + 1);
        } else if (this.getTableModel().getValueAt(this.getTable().getSelectedRow(), colIdx + 1) != null && this.getTableModel().getValueAt(this.getTable().getSelectedRow(), colIdx + 1).toString().indexOf(FiltersPanel.i18n.translateString("both")) >= 0) {
            this.getTableModel().setValueAt((Object)"", this.getTable().getSelectedRow(), colIdx + 1);
        }
    }

    public void updateMbstIpProtocol(int colIdx) {
        if (this.getTable().getSelectedRow() < 0) {
            return;
        }
        if (this.getTableModel().getValueAt(this.getTable().getSelectedRow(), colIdx) == null) {
            return;
        }
        String currentValue = (String)this.getTableModel().getValueAt(this.getTable().getSelectedRow(), colIdx);
        if (!currentValue.equals("6") && !currentValue.equals("17")) {
            this.getTableModel().setValueAt((Object)"65535", this.getTable().getSelectedRow(), colIdx + 1);
            this.form.getTblL34RulesModel().setROCell(this.getTable().getSelectedRow(), colIdx + 1);
        } else {
            this.form.getTblL34RulesModel().resetTableAccess(Integer.valueOf(this.getTable().getSelectedRow()), Integer.valueOf(colIdx + 1));
        }
    }

    static {
        portTypes.put("65535", FiltersPanel.i18n.translateString("any"));
        portTypes.put("7", FiltersPanel.i18n.translateString("Echo"));
        portTypes.put("18", FiltersPanel.i18n.translateString("MSP"));
        portTypes.put("20", FiltersPanel.i18n.translateString("FTPData"));
        portTypes.put("21", FiltersPanel.i18n.translateString("FTPControl"));
        portTypes.put("23", FiltersPanel.i18n.translateString("Telnet"));
        portTypes.put("25", FiltersPanel.i18n.translateString("SMTP"));
        portTypes.put("37", FiltersPanel.i18n.translateString("Time"));
        portTypes.put("42", FiltersPanel.i18n.translateString("Nameserver"));
        portTypes.put("53", FiltersPanel.i18n.translateString("DNS"));
        portTypes.put("69", FiltersPanel.i18n.translateString("TFTP"));
        portTypes.put("70", FiltersPanel.i18n.translateString("GopherServices"));
        portTypes.put("79", FiltersPanel.i18n.translateString("Finger"));
        portTypes.put("80", FiltersPanel.i18n.translateString("HTTP"));
        portTypes.put("103", FiltersPanel.i18n.translateString("X400"));
        portTypes.put("109", FiltersPanel.i18n.translateString("POP2"));
        portTypes.put("110", FiltersPanel.i18n.translateString("POP3"));
        portTypes.put("115", FiltersPanel.i18n.translateString("SFTP"));
        portTypes.put("118", FiltersPanel.i18n.translateString("SQLServices"));
        portTypes.put("119", FiltersPanel.i18n.translateString("NNTP"));
        portTypes.put("137", FiltersPanel.i18n.translateString("NETBIOSNameService"));
        portTypes.put("138", FiltersPanel.i18n.translateString("NETBIOSDatagrameService"));
        portTypes.put("139", FiltersPanel.i18n.translateString("NETBIOSSessionService"));
        portTypes.put("143", FiltersPanel.i18n.translateString("IMAP"));
        portTypes.put("156", FiltersPanel.i18n.translateString("SQLServer"));
        portTypes.put("396", FiltersPanel.i18n.translateString("Novell"));
        portTypes.put("443", FiltersPanel.i18n.translateString("HTTPS"));
        portTypes.put("444", FiltersPanel.i18n.translateString("SNPP"));
        portTypes.put("458", FiltersPanel.i18n.translateString("AppleQuickTime"));
        portTypes.put("68", FiltersPanel.i18n.translateString("DHCPClient"));
        portTypes.put("67", FiltersPanel.i18n.translateString("DHCPServer"));
        protocolTypes.put("255", FiltersPanel.i18n.translateString("any"));
        protocolTypes.put("6", FiltersPanel.i18n.translateString("tcp"));
        protocolTypes.put("17", FiltersPanel.i18n.translateString("udp"));
    }
}

