/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JComboBoxBinding;
import com.bwanms.gui.binding.JSpinnerBinding;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.binding.ReadOnlyBinder;
import com.bwanms.gui.binding.translators.ParserValueTranslator;
import com.bwanms.gui.binding.translators.TranslateException;
import com.bwanms.gui.binding.translators.ValueTranslator;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.rb.gui.configuration.GPSPanel42;
import com.bwanms.rb.mo.RbBSClockConfigParameters;
import com.bwanms.rb.mo.RbChainConfig;
import com.bwanms.rb.mo.RbGPSInfo;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbMBS;
import com.bwanms.rb.util.RbVersions;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.PlatformConfiguration;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextField;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GPSConfigForm42
extends ManagedObjectsConfigForm<GPSPanel42> {
    private static final int AU_TX_BIT = 0;
    private static final int HOLD_OVER_T_O_BIT = 1;
    private static final int HOLD_OVER_BIT = 2;
    private static final int GPS_COM_BIT = 3;
    private static final int SAT_MORE2_BIT = 4;
    private static final int SAT_MORE4_BIT = 5;
    private static final int EXT_16MHZ_BIT = 6;
    private static final int EXT_1PPS_BIT = 7;
    private static final int AU_TX_COL = 0;
    private static final int HOLD_OVER_T_O_COL = 1;
    private static final int HOLD_OVER_COL = 2;
    private static final int EXT_16MHZ_COL = 3;
    private static final int EXT_1PPS_COL = 4;
    private static final int GPS_COM_COL_ALL = 3;
    private static final int SAT_MORE2_COL_ALL = 4;
    private static final int SAT_MORE4_COL_ALL = 5;
    private static final int EXT_16MHZ_COL_ALL = 6;
    private static final int EXT_1PPS_COL_ALL = 7;
    Integer clockMode = null;
    boolean localPlatform = PlatformConfiguration.isLocalPlatform();
    private String OK_STATUS = GPSPanel42.i18n.translateString("okStatus");
    private String FAILED_STATUS = GPSPanel42.i18n.translateString("failedStatus");
    private String STARTED_STATUS = GPSPanel42.i18n.translateString("startedStatus");
    private String NONE_STATUS = GPSPanel42.i18n.translateString("noneStatus");
    private String PASSED_STATUS = GPSPanel42.i18n.translateString("passedStatus");
    private String STOPPED_STATUS = GPSPanel42.i18n.translateString("stoppedStatus");

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        boolean isParameterRO;
        DefaultBinder binder = new DefaultBinder((Object)this.getUI(), managedObjects.get(0));
        RbBaseStationEquipment bs = (RbBaseStationEquipment)this.ctx.getEquipment();
        binder.add((Binding)new JSpinnerBinding("spnCfgChainNumber", "rbConfiguredChainNumber", GPSPanel42.i18n.translateString("ChainNumber")));
        JComboBoxBinding jbinding = new JComboBoxBinding(GPSPanel42.i18n, "cmbCfgType", "rbGPSConfiguredType", GPSPanel42.i18n.translateString("GPSType"));
        boolean bl = isParameterRO = !this.localPlatform && bs instanceof RbMBS;
        if (isParameterRO) {
            jbinding.setReadOnly(true);
            jbinding.setIgnoreDisabled(true);
        }
        binder.add((Binding)jbinding);
        jbinding = new JComboBoxBinding(GPSPanel42.i18n, "cmbStopTxAfterHoldOverTimeout", "rbStopTxAfterHoldOverTimeout", GPSPanel42.i18n.translateString("StopTxAfterHoldOverTimeout"));
        if (isParameterRO) {
            jbinding.setReadOnly(true);
            jbinding.setIgnoreDisabled(true);
        }
        binder.add((Binding)jbinding);
        binder.add((Binding)new JTextFieldBinding("txtTimeZoneOffsetFromUTC", "rbTimeZoneOffsetFromUTC", (ValueTranslator)new ValueTranslator<String, String>(){

            public String convertToBeanValue(String uiBeanValue) throws TranslateException {
                String timeZoneOffset = ((GPSPanel42)GPSConfigForm42.this.getUI()).getTxtTimeZoneOffsetFromUTC().getText();
                if (!timeZoneOffset.startsWith("+") && !timeZoneOffset.startsWith("-")) {
                    return "+" + uiBeanValue;
                }
                return timeZoneOffset;
            }

            public String convertToUIValue(String beanValue) throws TranslateException {
                return beanValue;
            }
        }, GPSPanel42.i18n.translateString("TimeZoneOffsetFromUTC")));
        JSpinnerBinding sbinding = new JSpinnerBinding("spnHoldOverPassedTimeout", "rbHoldOverPassedTimeout", GPSPanel42.i18n.translateString("HoldOverPassedTimeout"));
        if (isParameterRO) {
            sbinding.setReadOnly(true);
        }
        binder.add((Binding)sbinding);
        jbinding = new JComboBoxBinding(GPSPanel42.i18n, "cmbDaylightSavingStatus", "rbDaylightSavingStatus", GPSPanel42.i18n.translateString("DaylightSavingStatus"));
        if (isParameterRO) {
            jbinding.setReadOnly(true);
            jbinding.setIgnoreDisabled(true);
        }
        binder.add((Binding)jbinding);
        binder.add((Binding)new JTextFieldBinding("txtDaylightSavingDateStart", "rbDaylightSavingDateStart", (ValueTranslator)new ValueTranslator<String, String>(){

            public String convertToBeanValue(String uiBeanValue) throws TranslateException {
                if (((GPSPanel42)GPSConfigForm42.this.getUI()).getTxtDaylightSavingDateStart().isEnabled() && !isParameterRO) {
                    return uiBeanValue;
                }
                return null;
            }

            public String convertToUIValue(String beanValue) throws TranslateException {
                return beanValue;
            }
        }, GPSPanel42.i18n.translateString("DaylightSavingStartDate")));
        binder.add((Binding)new JTextFieldBinding("txtDaylightSavingDateStop", "rbDaylightSavingDateStop", (ValueTranslator)new ValueTranslator<String, String>(){

            public String convertToBeanValue(String uiBeanValue) throws TranslateException {
                if (((GPSPanel42)GPSConfigForm42.this.getUI()).getTxtDaylightSavingDateStop().isEnabled() && !isParameterRO) {
                    return uiBeanValue;
                }
                return null;
            }

            public String convertToUIValue(String beanValue) throws TranslateException {
                return beanValue;
            }
        }, GPSPanel42.i18n.translateString("DaylightSavingStopDate")));
        binder.add((Binding)new JTextFieldBinding("txtDaylightSavingAdvFactor", "rbDaylightSavingAdvFactor", (ValueTranslator)new ValueTranslator<String, String>(){

            public String convertToBeanValue(String uiBeanValue) throws TranslateException {
                if (((GPSPanel42)GPSConfigForm42.this.getUI()).getTxtDaylightSavingAdvFactor().isEnabled() && !isParameterRO) {
                    return uiBeanValue;
                }
                return null;
            }

            public String convertToUIValue(String beanValue) throws TranslateException {
                return beanValue;
            }
        }, GPSPanel42.i18n.translateString("DaylightSavingAdvanceFactor")));
        binders.add((Binder)binder);
        binder = new ReadOnlyBinder((Object)this.getUI(), managedObjects.get(0));
        binder.add((Binding)new JTextFieldBinding("txtCrtChainNumber", "rbCurrentChainNumber", (ValueTranslator)new ParserValueTranslator(Long.class), GPSPanel42.i18n.translateString("ChainNumber")));
        binder.add((Binding)new JTextFieldBinding("txtCrtType", "rbGPSCurrentType", (ValueTranslator)new ParserValueTranslator<Integer>(Integer.class){

            public String convertToUIValue(Integer beanValue) {
                return GPSPanel42.i18n.translateString(RbChainConfig.toStringRbGPSCurrentType(beanValue));
            }
        }, GPSPanel42.i18n.translateString("GPSType")));
        binders.add((Binder)binder);
        binder = new DefaultBinder((Object)this.getUI(), managedObjects.get(1));
        binder.add((Binding)new JComboBoxBinding(GPSPanel42.i18n, "cmbCfgExternalPPSClock", "rbBSConfiguredExternalPPSClock", GPSPanel42.i18n.translateString("ExternalPPSClock")));
        binder.add((Binding)new JComboBoxBinding(GPSPanel42.i18n, "cmbCfgExternal16MhzClock", "rbBSConfiguredExternal16MhzClock", GPSPanel42.i18n.translateString("External16MhzClock")));
        binders.add((Binder)binder);
        if (bs.getSoftwareVersion().isOlderThan(RbVersions.V_4_5) || bs instanceof RbMBS) {
            binder.add((Binding)new JComboBoxBinding(GPSPanel42.i18n, "cmbCfgClkMode", "rbBSConfiguredClockMode", GPSPanel42.i18n.translateString("ClockMode")));
            binders.add((Binder)binder);
        }
        binder = new ReadOnlyBinder((Object)this.getUI(), managedObjects.get(1));
        binder.add((Binding)new JTextFieldBinding("txtCrtExternalPPSClock", "rbBSCurrentExternalPPSClock", (ValueTranslator)new ParserValueTranslator<Integer>(Integer.class){

            public String convertToUIValue(Integer beanValue) {
                return GPSPanel42.i18n.translateString(RbBSClockConfigParameters.toStringRbBSCurrentExternalPPSClock(beanValue));
            }
        }, GPSPanel42.i18n.translateString("ExternalPPSClock")));
        binder.add((Binding)new JTextFieldBinding("txtCrtExternal16MhzClock", "rbBSCurrentExternal16MhzClock", (ValueTranslator)new ParserValueTranslator<Integer>(Integer.class){

            public String convertToUIValue(Integer beanValue) {
                return GPSPanel42.i18n.translateString(RbBSClockConfigParameters.toStringRbBSCurrentExternal16MhzClock(beanValue));
            }
        }, GPSPanel42.i18n.translateString("External16MhzClock")));
        if (bs.getSoftwareVersion().isOlderThan(RbVersions.V_4_5) || bs instanceof RbMBS) {
            binder.add((Binding)new JTextFieldBinding("txtCrtClkMode", "rbBSCurrentClockMode", (ValueTranslator)new ParserValueTranslator<Integer>(Integer.class){

                public String convertToUIValue(Integer beanValue) {
                    return GPSPanel42.i18n.translateString(RbBSClockConfigParameters.toStringRbBSCurrentClockMode(beanValue));
                }
            }, GPSPanel42.i18n.translateString("ClockMode")));
        }
        binders.add((Binder)binder);
        binder = new ReadOnlyBinder((Object)this.getUI(), managedObjects.get(2));
        binder.add((Binding)new JTextFieldBinding("txtNumberOfRxSatellites", "rbGPSNumberOfRxSatellites", (ValueTranslator)new ParserValueTranslator(Long.class), GPSPanel42.i18n.translateString("NumberOfRxSatellites")));
        binder.add((Binding)new JTextFieldBinding("txtLatitude", "rbGPSLatitude", GPSPanel42.i18n.translateString("Latitude")));
        binder.add((Binding)new JTextFieldBinding("txtLocalDateAndTime", "rbGPSLocalDateAndTime", GPSPanel42.i18n.translateString("LocalDateAndTime")));
        binder.add((Binding)new JTextFieldBinding("txtSignalProcessorSWVersion", "rbGPSSignalProcessorSWVersion", GPSPanel42.i18n.translateString("SignalProcessorSWVersion")));
        binder.add((Binding)new JTextFieldBinding("txtLongitude", "rbGPSLongitude", GPSPanel42.i18n.translateString("Longitude")));
        binder.add((Binding)new JTextFieldBinding("txtAltitude", "rbGPSAltitude", GPSPanel42.i18n.translateString("Altitude")));
        binder.add((Binding)new JTextFieldBinding("txtNavigationProcessorSWVersion", "rbGPSNavigationProcessorSWVersion", GPSPanel42.i18n.translateString("NavigationProcessorSWVersion")));
        binders.add((Binder)binder);
    }

    protected List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        RbBaseStationEquipment bs = (RbBaseStationEquipment)this.ctx.getEquipment();
        ret.add(this.ctx.createRequest("BS", RbChainConfig.class));
        ret.add(this.ctx.createRequest("BS", RbBSClockConfigParameters.class));
        ret.add(this.ctx.createRequest("BS", RbGPSInfo.class, "*"));
        return ret;
    }

    protected void fillUI(List<Object> managedObjects) {
        RbBaseStationEquipment bs = (RbBaseStationEquipment)this.ctx.getEquipment();
        RbChainConfig chainConfig = (RbChainConfig)((Object)managedObjects.get(0));
        GPSPanel42 ui = (GPSPanel42)this.getUI();
        if (bs.getSoftwareVersion().isNewerOrEqualWith(RbVersions.V_4_5)) {
            ui.getScrollPane1().setVisible(true);
            ui.getSeparator1().setVisible(true);
            this.fillUI_GPSStatus(managedObjects);
            if (bs instanceof RbBS) {
                this.hideClockMode(ui, false);
            }
        } else {
            this.hideClockMode(ui, true);
        }
        boolean gpsSupported = chainConfig.getRbGPSSupported() == 1;
        this.setGPSSupportDependentComponentsState(gpsSupported);
    }

    private void hideClockMode(GPSPanel42 ui, boolean aFlag) {
        ui.getCmbCfgClkMode().setVisible(aFlag);
        ui.getTxtCrtClkMode().setVisible(aFlag);
        ui.getLblCrtClkMode().setVisible(aFlag);
        ui.getLblCfgClkMode().setVisible(aFlag);
    }

    private void fillUI_GPSStatus(List<Object> managedObjects) {
        Long moEntry;
        RbChainConfig chainConfig = (RbChainConfig)((Object)managedObjects.get(0));
        RbGPSInfo gpsInfo = (RbGPSInfo)((Object)managedObjects.get(2));
        Integer gpsCurrentType = chainConfig.getRbGPSCurrentType();
        String string = gpsInfo.getRbGPSStatusMask();
        string = string.replace(":", "");
        try {
            moEntry = Long.parseLong(string, 16);
        }
        catch (NumberFormatException ex) {
            moEntry = Long.parseLong("ffff", 16);
        }
        String hexToByteConverter = this.HexToByteConverter(moEntry);
        char[] bits = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'};
        int length = hexToByteConverter.length();
        for (int i = 0; i < length; ++i) {
            bits[16 - i - 1] = hexToByteConverter.charAt(length - 1 - i);
        }
        GPSPanel42 ui = (GPSPanel42)this.getUI();
        if (gpsCurrentType != 1) {
            ui.postInitGPSStatusSymmetricom();
            SimpleRowTableModel model = (SimpleRowTableModel)((GPSPanel42)this.getUI()).getGpsStatusPanel().getModel();
            this.setGPSStatusSimmetricon(model, bits);
        } else {
            ui.postInitGPSStatus();
            SimpleRowTableModel model = (SimpleRowTableModel)((GPSPanel42)this.getUI()).getGpsStatusPanel().getModel();
            this.setGPSStatus(model, bits);
        }
    }

    private void setGPSStatusSimmetricon(SimpleRowTableModel model, char[] bits) {
        if (bits[8] == '0') {
            model.setInitialValueAt((Object)this.OK_STATUS, 0, 0);
        } else {
            model.setInitialValueAt((Object)this.STOPPED_STATUS, 0, 0);
        }
        if (bits[9] == '0') {
            model.setInitialValueAt((Object)this.NONE_STATUS, 0, 1);
        } else {
            model.setInitialValueAt((Object)this.PASSED_STATUS, 0, 1);
        }
        if (bits[10] == '0') {
            model.setInitialValueAt((Object)this.NONE_STATUS, 0, 2);
        } else {
            model.setInitialValueAt((Object)this.STARTED_STATUS, 0, 2);
        }
        if (bits[14] == '0') {
            model.setInitialValueAt((Object)this.OK_STATUS, 0, 3);
        } else {
            model.setInitialValueAt((Object)this.FAILED_STATUS, 0, 3);
        }
        if (bits[15] == '0') {
            model.setInitialValueAt((Object)this.OK_STATUS, 0, 4);
        } else {
            model.setInitialValueAt((Object)this.FAILED_STATUS, 0, 4);
        }
    }

    private void setGPSStatus(SimpleRowTableModel model, char[] bits) {
        if (bits[8] == '0') {
            model.setInitialValueAt((Object)this.OK_STATUS, 0, 0);
        } else {
            model.setInitialValueAt((Object)this.STOPPED_STATUS, 0, 0);
        }
        if (bits[9] == '0') {
            model.setInitialValueAt((Object)this.NONE_STATUS, 0, 1);
        } else {
            model.setInitialValueAt((Object)this.PASSED_STATUS, 0, 1);
        }
        if (bits[10] == '0') {
            model.setInitialValueAt((Object)this.NONE_STATUS, 0, 2);
        } else {
            model.setInitialValueAt((Object)this.STARTED_STATUS, 0, 2);
        }
        if (bits[11] == '0') {
            model.setInitialValueAt((Object)this.OK_STATUS, 0, 3);
        } else {
            model.setInitialValueAt((Object)this.FAILED_STATUS, 0, 3);
        }
        if (bits[12] == '0') {
            model.setInitialValueAt((Object)this.OK_STATUS, 0, 4);
        } else {
            model.setInitialValueAt((Object)this.FAILED_STATUS, 0, 4);
        }
        if (bits[13] == '0') {
            model.setInitialValueAt((Object)this.OK_STATUS, 0, 5);
        } else {
            model.setInitialValueAt((Object)this.FAILED_STATUS, 0, 5);
        }
        if (bits[14] == '0') {
            model.setInitialValueAt((Object)this.OK_STATUS, 0, 6);
        } else {
            model.setInitialValueAt((Object)this.FAILED_STATUS, 0, 6);
        }
        if (bits[15] == '0') {
            model.setInitialValueAt((Object)this.OK_STATUS, 0, 7);
        } else {
            model.setInitialValueAt((Object)this.FAILED_STATUS, 0, 7);
        }
    }

    private boolean b8b15zero(char[] bits) {
        boolean noError = true;
        for (int i = 0; i < 8; ++i) {
            if (bits[i] == '0') continue;
            noError = false;
        }
        return noError;
    }

    protected void configureMOs(List<Object> managedObjects, List<InvalidValue> invalidValues) {
        RbChainConfig chainConfig;
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
        sdf.setLenient(false);
        if (((GPSPanel42)this.getUI()).getTxtDaylightSavingDateStart().isEnabled()) {
            String rbDaylightSavingDateStart = ((GPSPanel42)this.getUI()).getTxtDaylightSavingDateStart().getText().trim();
            if (rbDaylightSavingDateStart.matches("\\d{2}\\p{Punct}\\d{2}")) {
                try {
                    sdf.parse(rbDaylightSavingDateStart + ".2000");
                }
                catch (ParseException ex) {
                    invalidValues.add(new InvalidValue(GPSPanel42.i18n.translateString("InvalidDaylightSavingDateStart"), JTextField.class, GPSPanel42.i18n.translateString("DaylightSavingStartDate"), (Object)rbDaylightSavingDateStart, (Object)((GPSPanel42)this.getUI()).getTxtDaylightSavingDateStart()));
                }
            } else {
                invalidValues.add(new InvalidValue(GPSPanel42.i18n.translateString("InvalidDaylightSavingDateStart"), JTextField.class, GPSPanel42.i18n.translateString("DaylightSavingStartDate"), (Object)rbDaylightSavingDateStart, (Object)((GPSPanel42)this.getUI()).getTxtDaylightSavingDateStart()));
            }
        } else {
            chainConfig = (RbChainConfig)((Object)managedObjects.get(0));
            chainConfig.setRbDaylightSavingDateStart(null);
        }
        if (((GPSPanel42)this.getUI()).getTxtDaylightSavingDateStop().isEnabled()) {
            String rbDaylightSavingDateStop = ((GPSPanel42)this.getUI()).getTxtDaylightSavingDateStop().getText().trim();
            if (rbDaylightSavingDateStop.matches("\\d{2}\\p{Punct}\\d{2}")) {
                try {
                    sdf.parse(rbDaylightSavingDateStop + ".2000");
                }
                catch (ParseException ex) {
                    invalidValues.add(new InvalidValue(GPSPanel42.i18n.translateString("InvalidDaylightSavingDateStop"), JTextField.class, GPSPanel42.i18n.translateString("DaylightSavingStopDate"), (Object)rbDaylightSavingDateStop, (Object)((GPSPanel42)this.getUI()).getTxtDaylightSavingDateStop()));
                }
            } else {
                invalidValues.add(new InvalidValue(GPSPanel42.i18n.translateString("InvalidDaylightSavingDateStop"), JTextField.class, GPSPanel42.i18n.translateString("DaylightSavingStopDate"), (Object)rbDaylightSavingDateStop, (Object)((GPSPanel42)this.getUI()).getTxtDaylightSavingDateStop()));
            }
        } else {
            chainConfig = (RbChainConfig)((Object)managedObjects.get(0));
            chainConfig.setRbDaylightSavingDateStop(null);
        }
    }

    protected GPSPanel42 initUIComponent() {
        GPSPanel42 panel = new GPSPanel42(this);
        this.setPlatformDependentComponentsState(panel);
        return panel;
    }

    public String getHelpTopic() {
        if (PlatformConfiguration.isLocalPlatform()) {
            return "ngnms.rb.help.bs_tdd_gps_craft";
        }
        return "ngnms.rb.help.bs_tdd_gps";
    }

    public void reflectDaylightSavingOnUI(boolean dayLightSavingEnable) {
        RbBaseStationEquipment bs = (RbBaseStationEquipment)this.ctx.getEquipment();
        if (this.localPlatform || bs instanceof RbBS) {
            ((GPSPanel42)this.getUI()).getTxtDaylightSavingDateStart().setEnabled(dayLightSavingEnable);
            ((GPSPanel42)this.getUI()).getTxtDaylightSavingDateStop().setEnabled(dayLightSavingEnable);
            ((GPSPanel42)this.getUI()).getTxtDaylightSavingAdvFactor().setEnabled(dayLightSavingEnable);
        }
    }

    public void reflectClockModeOnUI(boolean clockModeMaster) {
        ((GPSPanel42)this.getUI()).getCmbCfgExternalPPSClock().setEnabled(clockModeMaster);
        ((GPSPanel42)this.getUI()).getCmbCfgExternal16MhzClock().setEnabled(clockModeMaster);
    }

    private void setPlatformDependentComponentsState(GPSPanel42 panel) {
        RbBaseStationEquipment bs = (RbBaseStationEquipment)this.ctx.getEquipment();
        if (bs instanceof RbMBS) {
            panel.getCmbCfgType().setEnabled(this.localPlatform);
            panel.getCmbStopTxAfterHoldOverTimeout().setEnabled(this.localPlatform);
            panel.getSpnHoldOverPassedTimeout().setEnabled(this.localPlatform);
            panel.getTxtTimeZoneOffsetFromUTC().setEnabled(this.localPlatform);
            panel.getCmbDaylightSavingStatus().setEnabled(this.localPlatform);
            panel.getTxtDaylightSavingDateStart().setEnabled(this.localPlatform);
            panel.getTxtDaylightSavingDateStop().setEnabled(this.localPlatform);
            panel.getTxtDaylightSavingAdvFactor().setEnabled(this.localPlatform);
        } else {
            panel.getCmbCfgType().setEnabled(true);
            panel.getCmbStopTxAfterHoldOverTimeout().setEnabled(true);
            panel.getSpnHoldOverPassedTimeout().setEnabled(true);
            panel.getTxtTimeZoneOffsetFromUTC().setEnabled(true);
            panel.getCmbDaylightSavingStatus().setEnabled(true);
            panel.getTxtDaylightSavingDateStart().setEnabled(true);
            panel.getTxtDaylightSavingDateStop().setEnabled(true);
            panel.getTxtDaylightSavingAdvFactor().setEnabled(true);
        }
    }

    private void setGPSSupportDependentComponentsState(boolean gpsSupported) {
        ((GPSPanel42)this.getUI()).getSprGPSInfo().setVisible(gpsSupported);
        ((GPSPanel42)this.getUI()).getLblAltitude().setVisible(gpsSupported);
        ((GPSPanel42)this.getUI()).getLblLatitude().setVisible(gpsSupported);
        ((GPSPanel42)this.getUI()).getLblLocalDateAndTime().setVisible(gpsSupported);
        ((GPSPanel42)this.getUI()).getLblLongitude().setVisible(gpsSupported);
        ((GPSPanel42)this.getUI()).getLblNavigationProcessorSWVersion().setVisible(gpsSupported);
        ((GPSPanel42)this.getUI()).getLblNumberOfRxSatellites().setVisible(gpsSupported);
        ((GPSPanel42)this.getUI()).getLblSignalProcessorSWVersion().setVisible(gpsSupported);
        ((GPSPanel42)this.getUI()).getTxtAltitude().setVisible(gpsSupported);
        ((GPSPanel42)this.getUI()).getTxtLatitude().setVisible(gpsSupported);
        ((GPSPanel42)this.getUI()).getTxtLocalDateAndTime().setVisible(gpsSupported);
        ((GPSPanel42)this.getUI()).getTxtLongitude().setVisible(gpsSupported);
        ((GPSPanel42)this.getUI()).getTxtNavigationProcessorSWVersion().setVisible(gpsSupported);
        ((GPSPanel42)this.getUI()).getTxtNumberOfRxSatellites().setVisible(gpsSupported);
        ((GPSPanel42)this.getUI()).getTxtSignalProcessorSWVersion().setVisible(gpsSupported);
    }

    public boolean forceRefresh() {
        return true;
    }

    public String HexToByteConverter(Long byteP) {
        String rez = Long.toBinaryString(byteP);
        return rez;
    }
}

