/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JComboBoxBinding;
import com.bwanms.gui.binding.JSpinnerBinding;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.binding.ReadOnlyBinder;
import com.bwanms.gui.binding.translators.ParserValueTranslator;
import com.bwanms.gui.binding.translators.TranslateException;
import com.bwanms.gui.binding.translators.ValueTranslator;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.rb.gui.configuration.GPSPanel;
import com.bwanms.rb.mo.RbBSClockConfigParameters;
import com.bwanms.rb.mo.RbChainConfig;
import com.bwanms.rb.mo.RbGPSInfo;
import com.bwanms.util.PlatformConfiguration;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GPSConfigForm
extends ManagedObjectsConfigForm<GPSPanel> {
    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        DefaultBinder binder = new DefaultBinder((Object)this.getUI(), managedObjects.get(0));
        binder.add((Binding)new JSpinnerBinding("spnCfgChainNumber", "rbConfiguredChainNumber", GPSPanel.i18n.translateString("ChainNumber")));
        binder.add((Binding)new JComboBoxBinding(GPSPanel.i18n, "cmbCfgType", "rbGPSConfiguredType", GPSPanel.i18n.translateString("GPSType")));
        binder.add((Binding)new JComboBoxBinding(GPSPanel.i18n, "cmbStopTxAfterHoldOverTimeout", "rbStopTxAfterHoldOverTimeout", GPSPanel.i18n.translateString("StopTxAfterHoldOverTimeout")));
        binder.add((Binding)new JTextFieldBinding("txtTimeZoneOffsetFromUTC", "rbTimeZoneOffsetFromUTC", (ValueTranslator)new ValueTranslator<String, String>(){

            public String convertToBeanValue(String uiBeanValue) throws TranslateException {
                String timeZoneOffset = ((GPSPanel)GPSConfigForm.this.getUI()).getTxtTimeZoneOffsetFromUTC().getText();
                if (!timeZoneOffset.startsWith("+") && !timeZoneOffset.startsWith("-")) {
                    return "+" + uiBeanValue;
                }
                return timeZoneOffset;
            }

            public String convertToUIValue(String beanValue) throws TranslateException {
                return beanValue;
            }
        }, GPSPanel.i18n.translateString("TimeZoneOffsetFromUTC")));
        binder.add((Binding)new JSpinnerBinding("spnHoldOverPassedTimeout", "rbHoldOverPassedTimeout", GPSPanel.i18n.translateString("HoldOverPassedTimeout")));
        binders.add((Binder)binder);
        binder = new ReadOnlyBinder((Object)this.getUI(), managedObjects.get(0));
        binder.add((Binding)new JTextFieldBinding("txtCrtChainNumber", "rbCurrentChainNumber", (ValueTranslator)new ParserValueTranslator(Long.class), GPSPanel.i18n.translateString("ChainNumber")));
        binder.add((Binding)new JTextFieldBinding("txtCrtType", "rbGPSCurrentType", (ValueTranslator)new ParserValueTranslator<Integer>(Integer.class){

            public String convertToUIValue(Integer beanValue) {
                return GPSPanel.i18n.translateString(RbChainConfig.toStringRbGPSCurrentType(beanValue));
            }
        }, GPSPanel.i18n.translateString("GPSType")));
        binders.add((Binder)binder);
        binder = new DefaultBinder((Object)this.getUI(), managedObjects.get(1));
        binder.add((Binding)new JComboBoxBinding(GPSPanel.i18n, "cmbCfgExternalPPSClock", "rbBSConfiguredExternalPPSClock", GPSPanel.i18n.translateString("ExternalPPSClock")));
        binder.add((Binding)new JComboBoxBinding(GPSPanel.i18n, "cmbCfgExternal16MhzClock", "rbBSConfiguredExternal16MhzClock", GPSPanel.i18n.translateString("External16MhzClock")));
        binders.add((Binder)binder);
        binder = new ReadOnlyBinder((Object)this.getUI(), managedObjects.get(1));
        binder.add((Binding)new JTextFieldBinding("txtCrtExternalPPSClock", "rbBSCurrentExternalPPSClock", (ValueTranslator)new ParserValueTranslator<Integer>(Integer.class){

            public String convertToUIValue(Integer beanValue) {
                return GPSPanel.i18n.translateString(RbBSClockConfigParameters.toStringRbBSCurrentExternalPPSClock(beanValue));
            }
        }, GPSPanel.i18n.translateString("ExternalPPSClock")));
        binder.add((Binding)new JTextFieldBinding("txtCrtExternal16MhzClock", "rbBSCurrentExternal16MhzClock", (ValueTranslator)new ParserValueTranslator<Integer>(Integer.class){

            public String convertToUIValue(Integer beanValue) {
                return GPSPanel.i18n.translateString(RbBSClockConfigParameters.toStringRbBSCurrentExternal16MhzClock(beanValue));
            }
        }, GPSPanel.i18n.translateString("External16MhzClock")));
        binders.add((Binder)binder);
        binder = new ReadOnlyBinder((Object)this.getUI(), managedObjects.get(2));
        binder.add((Binding)new JTextFieldBinding("txtNumberOfRxSatellites", "rbGPSNumberOfRxSatellites", (ValueTranslator)new ParserValueTranslator(Long.class), GPSPanel.i18n.translateString("NumberOfRxSatellites")));
        binder.add((Binding)new JTextFieldBinding("txtLatitude", "rbGPSLatitude", GPSPanel.i18n.translateString("Latitude")));
        binder.add((Binding)new JTextFieldBinding("txtLocalDateAndTime", "rbGPSLocalDateAndTime", GPSPanel.i18n.translateString("LocalDateAndTime")));
        binder.add((Binding)new JTextFieldBinding("txtSignalProcessorSWVersion", "rbGPSSignalProcessorSWVersion", GPSPanel.i18n.translateString("SignalProcessorSWVersion")));
        binder.add((Binding)new JTextFieldBinding("txtLongitude", "rbGPSLongitude", GPSPanel.i18n.translateString("Longitude")));
        binder.add((Binding)new JTextFieldBinding("txtAltitude", "rbGPSAltitude", GPSPanel.i18n.translateString("Altitude")));
        binder.add((Binding)new JTextFieldBinding("txtNavigationProcessorSWVersion", "rbGPSNavigationProcessorSWVersion", GPSPanel.i18n.translateString("NavigationProcessorSWVersion")));
        binders.add((Binder)binder);
    }

    protected List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("BS", RbChainConfig.class));
        ret.add(this.ctx.createRequest("BS", RbBSClockConfigParameters.class));
        ret.add(this.ctx.createRequest("BS", RbGPSInfo.class));
        return ret;
    }

    protected void fillUI(List<Object> managedObjects) {
        RbChainConfig chainConfig = (RbChainConfig)((Object)managedObjects.get(0));
        boolean gpsSupported = chainConfig.getRbGPSSupported() == 1;
        ((GPSPanel)this.getUI()).getSprGPSInfo().setVisible(gpsSupported);
        ((GPSPanel)this.getUI()).getLblAltitude().setVisible(gpsSupported);
        ((GPSPanel)this.getUI()).getLblLatitude().setVisible(gpsSupported);
        ((GPSPanel)this.getUI()).getLblLocalDateAndTime().setVisible(gpsSupported);
        ((GPSPanel)this.getUI()).getLblLongitude().setVisible(gpsSupported);
        ((GPSPanel)this.getUI()).getLblNavigationProcessorSWVersion().setVisible(gpsSupported);
        ((GPSPanel)this.getUI()).getLblNumberOfRxSatellites().setVisible(gpsSupported);
        ((GPSPanel)this.getUI()).getLblSignalProcessorSWVersion().setVisible(gpsSupported);
        ((GPSPanel)this.getUI()).getTxtAltitude().setVisible(gpsSupported);
        ((GPSPanel)this.getUI()).getTxtLatitude().setVisible(gpsSupported);
        ((GPSPanel)this.getUI()).getTxtLocalDateAndTime().setVisible(gpsSupported);
        ((GPSPanel)this.getUI()).getTxtLongitude().setVisible(gpsSupported);
        ((GPSPanel)this.getUI()).getTxtNavigationProcessorSWVersion().setVisible(gpsSupported);
        ((GPSPanel)this.getUI()).getTxtNumberOfRxSatellites().setVisible(gpsSupported);
        ((GPSPanel)this.getUI()).getTxtSignalProcessorSWVersion().setVisible(gpsSupported);
    }

    protected GPSPanel initUIComponent() {
        return new GPSPanel();
    }

    public String getHelpTopic() {
        if (PlatformConfiguration.isLocalPlatform()) {
            return "ngnms.rb.help.bs_tdd_gps_craft";
        }
        return "ngnms.rb.help.bs_tdd_gps";
    }
}

