/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.configuration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.RegexFormatter;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JComboBoxBinding;
import com.bwanms.gui.binding.TableBinder;
import com.bwanms.gui.configuration.ConfigFormManagedObjectRequest;
import com.bwanms.gui.configuration.ManagedObjectsConfigForm;
import com.bwanms.gui.util.SortedTableModel;
import com.bwanms.mo.TableRowMO;
import com.bwanms.mo.snmp.DynamicTableRowMO;
import com.bwanms.mo.snmp.SNMPTableMO;
import com.bwanms.rb.gui.configuration.FiltersPanel;
import com.bwanms.rb.gui.configuration.L2FiltersTablePanelController;
import com.bwanms.rb.gui.configuration.L3L4FiltersTablePanelController;
import com.bwanms.rb.mo.RbInterfaceFilteringTable;
import com.bwanms.rb.mo.RbL2FilteringRuleEntry;
import com.bwanms.rb.mo.RbL2FilteringRuleTable;
import com.bwanms.rb.mo.RbL3L4FilteringRuleEntry;
import com.bwanms.rb.mo.RbL3L4FilteringRuleTable;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.ROTableModel;
import com.bwanms.ui.components.SimpleRowTable;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.ui.components.SimpleRowTableModelPanelController;
import com.bwanms.util.FormUtil;
import com.bwanms.util.MacAddress;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FiltersConfigForm
extends ManagedObjectsConfigForm<FiltersPanel> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(FiltersConfigForm.class);
    private static final Logger logger = Logger.getLogger(FiltersConfigForm.class);
    private DefaultTableCellRenderer toolTipCellRenderer = new DefaultTableCellRenderer(){

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent comp = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            StringBuilder sb = new StringBuilder("<html>");
            String safeString = String.valueOf(value);
            for (String s : safeString.split(";")) {
                sb.append(s).append("<br>");
            }
            comp.setToolTipText(sb.toString());
            return comp;
        }
    };
    private static long negativeId = -1L;

    private static synchronized long getNextNegativeId() {
        return negativeId--;
    }

    public FiltersPanel initUIComponent() {
        FiltersPanel form = new FiltersPanel();
        Object[] columns = new Object[]{i18n.translateString("Name"), i18n.translateString("MAC/IP"), i18n.translateString("Mask"), i18n.translateString("direction"), i18n.translateString("details")};
        SortedTableModel networkTableModel = new SortedTableModel((TableModel)new DefaultTableModel(columns, 0){

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        }, form.getTblNetworkIfActiveRules().getTableHeader());
        SortedTableModel wirelessTableModel = new SortedTableModel((TableModel)new DefaultTableModel(columns, 0){

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        }, form.getTblWirelessIfActiveRules().getTableHeader());
        form.setTblNetworkIfActiveRulesModel(networkTableModel);
        form.setTblWirelessIfActiveRulesModel(wirelessTableModel);
        form.getTblNetworkIfActiveRules().setBackground(new Color(240, 240, 240));
        form.getTblNetworkIfActiveRules().getColumnModel().getColumn(networkTableModel.getColumnCount() - 1).setCellRenderer(this.toolTipCellRenderer);
        form.getTblWirelessIfActiveRules().setBackground(new Color(240, 240, 240));
        form.getTblWirelessIfActiveRules().getColumnModel().getColumn(networkTableModel.getColumnCount() - 1).setCellRenderer(this.toolTipCellRenderer);
        ComboItem[] items = new ComboItem[]{new ComboItem((Object)0, i18n.translateString("none")), new ComboItem((Object)1, i18n.translateString("wireless")), new ComboItem((Object)2, i18n.translateString("network")), new ComboItem((Object)3, i18n.translateString("both"))};
        ComboItem[] directions = new ComboItem[]{new ComboItem((Object)0, i18n.translateString("both")), new ComboItem((Object)1, i18n.translateString("source")), new ComboItem((Object)2, i18n.translateString("destination"))};
        this.initL34RulesTable(form, items, directions);
        this.initL2RulesTable(form, items, directions);
        return form;
    }

    private void initL2RulesTable(FiltersPanel form, ComboItem[] items, ComboItem[] directions) {
        final L2FiltersTablePanelController l2Controller = form.getL2Controller();
        ComboItem[] etherTypes = new ComboItem[L2FiltersTablePanelController.ethernetTypes.size()];
        int j = 0;
        for (String etherType : L2FiltersTablePanelController.ethernetTypes.keySet()) {
            etherTypes[j++] = new ComboItem((Object)etherType, L2FiltersTablePanelController.ethernetTypes.get(etherType));
        }
        SimpleRowTableModel.ColumnDefinition[] columnsDefinition = new SimpleRowTableModel.ColumnDefinition[]{new SimpleRowTableModel.ColumnDefinition(i18n.translateString("Name"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("MACAddress"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("L2Mask"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("direction"), String.class, directions), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("Ethertype"), String.class, etherTypes), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("interface"), String.class, items)};
        form.setTblL2RulesModel(new ROTableModel(columnsDefinition, form.getTblL2Rules().getTableHeader()));
        form.getTblL2Rules().setModel((TableModel)form.getTblL2RulesModel());
        for (int i = 0; i < columnsDefinition.length - 1; ++i) {
            form.getTblL2RulesModel().setColumnReadonly(i, true);
        }
        form.getTblL2RulesModel().setNewRowReadOnlyOverride(true);
        form.getTblL2RulesModel().setColumnComparator(Integer.valueOf(1), SimpleRowTableModel.MAC_ADDRESS_COMPARATOR);
        form.getTblL2RulesModel().setColumnComparator(Integer.valueOf(2), SimpleRowTableModel.MAC_ADDRESS_COMPARATOR);
        SimpleRowTable srL2Table = new SimpleRowTable(form.getTblL2Rules(), (SimpleRowTableModel)form.getTblL2RulesModel(), (SimpleRowTableModelPanelController)l2Controller);
        JComboBox combo = new JComboBox();
        JComboBox macDirectionCombo = new JComboBox();
        macDirectionCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                l2Controller.updateMac();
            }
        });
        combo.setEditable(true);
        srL2Table.setFormattedTextCellEditor(1, new RegexFormatter("(\\p{XDigit}{2}-){0,5}(\\p{XDigit}{0,2})"), Pattern.compile("((\\p{XDigit}{2}-){5}(\\p{XDigit}{2}))?"));
        srL2Table.setFormattedTextCellEditor(2, new RegexFormatter("(?i)(ff-){0,5}(f[fec80]?|[ec8]0?)?|(ff-){0,4}(f[fec80]|[ec80]0)-0{0,2}|(ff-){0,3}(f[ec80]|[ec80]0)(-00)?-0{0,2}|(ff-){0,2}(f[ec80]|[ec80]0)(-00){0,2}-0{0,2}|ff-(f[fec80]|[ec80]0)(-00){0,3}-0{0,2}|(f[fec80]|[ec80]0)(-00){0,4}-0{0,2}"), Pattern.compile("(?i)((ff-){5}(f[fec80]|[ec80]0)|(ff-){4}(f[fec80]|[ec80]0)-00|(ff-){3}(f[fec80]|[ec80]0)(-00){2}|(ff-){2}(f[fec80]|[ec80]0)(-00){3}|ff-(f[fec80]|[ec80]0)(-00){4}|(f[fec80]|[ec8]0)(-00){5})?"));
        srL2Table.setComboCellEditor(3, macDirectionCombo);
        srL2Table.setComboCellEditor(4, combo);
        srL2Table.setComboCellEditor(5);
    }

    private void initL34RulesTable(FiltersPanel form, ComboItem[] items, ComboItem[] directions) {
        final L3L4FiltersTablePanelController l34Controller = form.getL34Controller();
        ComboItem[] protocols = new ComboItem[L3L4FiltersTablePanelController.protocolTypes.size()];
        int j = 0;
        for (String protocol : L3L4FiltersTablePanelController.protocolTypes.keySet()) {
            protocols[j++] = new ComboItem((Object)protocol, L3L4FiltersTablePanelController.protocolTypes.get(protocol));
        }
        ComboItem[] ports = new ComboItem[L3L4FiltersTablePanelController.portTypes.size()];
        j = 0;
        Set<String> keySet = L3L4FiltersTablePanelController.portTypes.keySet();
        String lastKey = L3L4FiltersTablePanelController.portTypes.lastKey();
        ports[j++] = new ComboItem((Object)lastKey, L3L4FiltersTablePanelController.portTypes.get(lastKey));
        for (String port : keySet) {
            if (port.equals(lastKey)) continue;
            ports[j++] = new ComboItem((Object)port, L3L4FiltersTablePanelController.portTypes.get(port));
        }
        SimpleRowTableModel.ColumnDefinition[] columnsDefinition = new SimpleRowTableModel.ColumnDefinition[]{new SimpleRowTableModel.ColumnDefinition(i18n.translateString("Name"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("IP"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("Mask"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("direction"), String.class, directions), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("IPProtocol"), String.class, protocols), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("Port"), String.class, ports), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("portDirection"), String.class, directions), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("interface"), String.class, items)};
        form.setTblL34RulesModel(new ROTableModel(columnsDefinition, form.getTblL34Rules().getTableHeader()));
        form.getTblL34Rules().setModel((TableModel)form.getTblL34RulesModel());
        form.getTblL34RulesModel().setColumnComparator(Integer.valueOf(1), SimpleRowTableModel.IP_ADDRESS_COMPARATOR);
        form.getTblL34RulesModel().setColumnComparator(Integer.valueOf(2), SimpleRowTableModel.IP_ADDRESS_COMPARATOR);
        for (int i = 0; i < columnsDefinition.length - 1; ++i) {
            form.getTblL34RulesModel().setColumnReadonly(i, true);
        }
        form.getTblL34RulesModel().setNewRowReadOnlyOverride(true);
        SimpleRowTable srL34Table = new SimpleRowTable(form.getTblL34Rules(), (SimpleRowTableModel)form.getTblL34RulesModel(), (SimpleRowTableModelPanelController)l34Controller);
        JComboBox editableCombo = new JComboBox();
        editableCombo.setEditable(true);
        JFormattedTextField ip = new JFormattedTextField((JFormattedTextField.AbstractFormatter)new RegexFormatter("(([0-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])){0,2}(\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])?)?|254\\.255\\.255\\.255|[1-9]?|[aA]|[aA][nN]|[aA][nN][yY])"));
        ip.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                JFormattedTextField source = (JFormattedTextField)evt.getSource();
                String value = (String)source.getValue();
                l34Controller.updateIp(1, value);
            }
        });
        JComboBox ipProtocolCombo = new JComboBox();
        ipProtocolCombo.setEditable(true);
        ipProtocolCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                l34Controller.updateIpProtocol(4);
            }
        });
        JComboBox ipDirectionCombo = new JComboBox();
        ipDirectionCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                l34Controller.updateDirection();
            }
        });
        JComboBox portDirectionCombo = new JComboBox();
        portDirectionCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                l34Controller.updatePort(6);
            }
        });
        srL34Table.setFormattedTextCellEditor(1, ip);
        srL34Table.setFormattedTextCellEditor(2, new RegexFormatter("(255\\.){0,3}(2(5[245]?)?|2(4[08]?)?|2(24?)?|1(92?)?|1(28?)?|0)?|(255\\.){0,2}(25[24]|24[08]|224|192|128|0)\\.0?|255\\.(25[24]|24[08]|224|192|128|0)\\.0\\.0?|(25[24]|24[08]|224|192|128|0)(\\.0){0,2}\\.0?"), Pattern.compile("((255\\.){3}(25[245]|24[08]|224|192|128|0)|(255\\.){2}(25[24]|24[08]|224|192|128|0)\\.0|255\\.(25[24]|24[08]|224|192|128|0)(\\.0){2}|(25[24]|24[08]|224|192|128|0)(\\.0){3})?"));
        srL34Table.setComboCellEditor(3, ipDirectionCombo);
        srL34Table.setComboCellEditor(4, ipProtocolCombo);
        srL34Table.setComboCellEditor(5, editableCombo);
        srL34Table.setComboCellEditor(6, portDirectionCombo);
        srL34Table.setComboCellEditor(7);
    }

    protected void createBinders(ArrayList<Binder> binders, List<Object> managedObjects) {
        TableRowMO nbean;
        RbL2FilteringRuleTable l2Table = (RbL2FilteringRuleTable)((Object)managedObjects.get(0));
        RbL3L4FilteringRuleTable l34Table = (RbL3L4FilteringRuleTable)((Object)managedObjects.get(1));
        RbInterfaceFilteringTable ifFilteringTable = (RbInterfaceFilteringTable)((Object)managedObjects.get(2));
        TableRowMO wbean = ifFilteringTable.findEntry("1.1");
        if (null != wbean) {
            DefaultBinder wirelessBinder = new DefaultBinder((Object)this.getUI(), (Object)wbean);
            this.addBindings((Binder)wirelessBinder, "cmbWireless");
            binders.add((Binder)wirelessBinder);
        }
        if (null != (nbean = ifFilteringTable.findEntry("2.2"))) {
            DefaultBinder networkBinder = new DefaultBinder((Object)this.getUI(), (Object)nbean);
            this.addBindings((Binder)networkBinder, "cmbNetwork");
            binders.add((Binder)networkBinder);
        }
        binders.add((Binder)new TableBinder(i18n, (SimpleRowTableModel)((FiltersPanel)this.getUI()).getTblL2RulesModel(), (SNMPTableMO)l2Table));
        binders.add((Binder)new TableBinder(i18n, (SimpleRowTableModel)((FiltersPanel)this.getUI()).getTblL34RulesModel(), (SNMPTableMO)l34Table));
    }

    private void addBindings(Binder binder, String componentPrefix) {
        String[] componetsSuffix;
        String propertiesPrefix = "rbInterfaceFiltering";
        for (String componetSuffix : componetsSuffix = new String[]{"AdminStatus", "ActiveFilterType", "Action"}) {
            binder.add((Binding)new JComboBoxBinding(i18n, componentPrefix + componetSuffix, "rbInterfaceFiltering" + componetSuffix));
        }
    }

    public List<ConfigFormManagedObjectRequest> getManagedObjectRequests() {
        ArrayList<ConfigFormManagedObjectRequest> ret = new ArrayList<ConfigFormManagedObjectRequest>();
        ret.add(this.ctx.createRequest("BS", RbL2FilteringRuleTable.class));
        ret.add(this.ctx.createRequest("BS", RbL3L4FilteringRuleTable.class));
        ret.add(this.ctx.createRequest("BS", RbInterfaceFilteringTable.class));
        return ret;
    }

    public void fillUI(List<Object> managedObjects) {
        int directionIdx;
        int col;
        RbL2FilteringRuleTable l2Table = (RbL2FilteringRuleTable)((Object)managedObjects.get(0));
        RbL3L4FilteringRuleTable l34Table = (RbL3L4FilteringRuleTable)((Object)managedObjects.get(1));
        String[] directions = new String[]{i18n.translateString("both"), i18n.translateString("source"), i18n.translateString("destination")};
        ((DefaultTableModel)((FiltersPanel)this.getUI()).getTblWirelessIfActiveRulesModel().getTableModel()).setRowCount(0);
        ((DefaultTableModel)((FiltersPanel)this.getUI()).getTblNetworkIfActiveRulesModel().getTableModel()).setRowCount(0);
        ROTableModel model = ((FiltersPanel)this.getUI()).getTblL2RulesModel();
        FormUtil.cancelTableEditing((JTable)((FiltersPanel)this.getUI()).getTblL2Rules());
        model.clearTable();
        int row = 0;
        for (DynamicTableRowMO entry : l2Table.getEntries()) {
            col = 0;
            directionIdx = 0;
            Object[] macs = new Object[]{i18n.translateString("any"), MacAddress.fromOctetString((String)entry.getRbL2FilteringRuleSrcMacAddress()).toDashedString(), MacAddress.fromOctetString((String)entry.getRbL2FilteringRuleDestMacAddress()).toDashedString()};
            Object[] masks = new Object[]{i18n.translateString("notApplicable"), MacAddress.fromOctetString((String)entry.getRbL2FilteringRuleSrcMask()).toDashedString(), MacAddress.fromOctetString((String)entry.getRbL2FilteringRuleDestMask()).toDashedString()};
            if (!macs[1].equals("00-00-00-00-00-00")) {
                directionIdx = 1;
            } else if (!macs[2].equals("00-00-00-00-00-00")) {
                directionIdx = 2;
            }
            Vector<Object> ifRowData = new Vector<Object>();
            model.addNewRow(entry.getRowKey(), true);
            ifRowData.add(entry.getRbL2FilteringRuleName());
            model.setInitialValueAt((Object)entry.getRbL2FilteringRuleName(), row, col++);
            ifRowData.add(macs[directionIdx]);
            model.setInitialValueAt(macs[directionIdx], row, col++);
            ifRowData.add(masks[directionIdx]);
            model.setInitialValueAt(masks[directionIdx], row, col++);
            ifRowData.add(directions[directionIdx]);
            model.setInitialValueAt((Object)directionIdx, row, col++);
            String hexEthType = Integer.toHexString(entry.getRbL2FilteringRuleEthType()).toUpperCase();
            String ethType = L2FiltersTablePanelController.ethernetTypes.get(hexEthType);
            ifRowData.add(model.getColumnName(col) + ": " + (ethType == null ? hexEthType : ethType));
            model.setInitialValueAt((Object)hexEthType, row, col++);
            model.setInitialValueAt((Object)entry.getRbInterface(), row++, col++);
            if (((ComboItem)((FiltersPanel)this.getUI()).getCmbNetworkActiveFilterType().getSelectedItem()).getValue().equals(1) && (entry.getRbInterface() & 2) > 0) {
                this.addToSummaryTableNetwork(ifRowData);
            }
            if (!((ComboItem)((FiltersPanel)this.getUI()).getCmbWirelessActiveFilterType().getSelectedItem()).getValue().equals(1) || (entry.getRbInterface() & 1) <= 0) continue;
            this.addToSummaryTableWireless(ifRowData);
        }
        if (l2Table.getSize() < L2FiltersTablePanelController.MAX_FILTERS_NUMBER) {
            ((FiltersPanel)this.getUI()).getBtnL2Add().setEnabled(true);
        }
        model.sort();
        model.sort();
        model = ((FiltersPanel)this.getUI()).getTblL34RulesModel();
        FormUtil.cancelTableEditing((JTable)((FiltersPanel)this.getUI()).getTblL34Rules());
        model.clearTable();
        row = 0;
        for (DynamicTableRowMO entry : l34Table.getEntries()) {
            col = 0;
            directionIdx = 0;
            int portDirectionIdx = 0;
            Object[] ports = new Object[]{"65535", entry.getRbL34FilteringRuleSrcUdpTcpPort(), entry.getRbL34FilteringRuleDestUdpTcpPort()};
            Object[] ips = new Object[]{i18n.translateString("any"), entry.getRbL34FilteringRuleSrcIpAddress(), entry.getRbL34FilteringRuleDestIpAddress()};
            Object[] masks = new Object[]{i18n.translateString("notApplicable"), entry.getRbL34FilteringRuleSrcMask(), entry.getRbL34FilteringRuleDestMask()};
            if (!ips[1].equals("254.255.255.255")) {
                directionIdx = 1;
            } else if (!ips[2].equals("254.255.255.255")) {
                directionIdx = 2;
            }
            if (!ports[1].equals(65535)) {
                portDirectionIdx = 1;
            } else if (!ports[2].equals(65535)) {
                portDirectionIdx = 2;
            }
            Vector<Object> ifRowData = new Vector<Object>();
            model.addNewRow(entry.getRowKey(), true);
            ifRowData = new Vector();
            StringBuffer details = new StringBuffer();
            model.setInitialValueAt((Object)entry.getRbL34FilteringRuleName(), row, col++);
            ifRowData.add(entry.getRbL34FilteringRuleName());
            model.setInitialValueAt(ips[directionIdx], row, col++);
            ifRowData.add(ips[directionIdx]);
            model.setInitialValueAt(masks[directionIdx], row, col++);
            ifRowData.add(masks[directionIdx]);
            model.setInitialValueAt((Object)directionIdx, row, col++);
            ifRowData.add(directions[directionIdx]);
            details.append(model.getColumnName(col));
            details.append(": ");
            String protocol = L3L4FiltersTablePanelController.protocolTypes.get(entry.getRbL34FilteringRuleIpProtocol().toString());
            details.append(protocol == null ? entry.getRbL34FilteringRuleIpProtocol() : protocol);
            model.setInitialValueAt((Object)entry.getRbL34FilteringRuleIpProtocol().toString(), row, col++);
            details.append("; ");
            details.append(model.getColumnName(col));
            details.append(": ");
            String port = L3L4FiltersTablePanelController.portTypes.get(ports[portDirectionIdx].toString());
            details.append(port == null ? ports[portDirectionIdx] : port);
            model.setInitialValueAt((Object)ports[portDirectionIdx].toString(), row, col++);
            details.append("; ");
            details.append(model.getColumnName(col));
            details.append(": ");
            details.append(directions[portDirectionIdx]);
            model.setInitialValueAt((Object)portDirectionIdx, row, col++);
            ifRowData.add(details);
            model.setInitialValueAt((Object)entry.getRbInterface(), row++, col++);
            if (((ComboItem)((FiltersPanel)this.getUI()).getCmbNetworkActiveFilterType().getSelectedItem()).getValue().equals(2) && (entry.getRbInterface() & 2) > 0) {
                this.addToSummaryTableNetwork(ifRowData);
            }
            if (!((ComboItem)((FiltersPanel)this.getUI()).getCmbWirelessActiveFilterType().getSelectedItem()).getValue().equals(2) || (entry.getRbInterface() & 1) <= 0) continue;
            this.addToSummaryTableWireless(ifRowData);
        }
        ((FiltersPanel)this.getUI()).getTblNetworkIfActiveRules().setBackground(new Color(240, 240, 240));
        ((FiltersPanel)this.getUI()).getTblWirelessIfActiveRules().setBackground(new Color(240, 240, 240));
        if (l34Table.getSize() < L3L4FiltersTablePanelController.MAX_FILTERS_NUMBER) {
            ((FiltersPanel)this.getUI()).getBtnL34Add().setEnabled(true);
        }
        model.sort();
    }

    private void addToSummaryTableNetwork(Vector<Object> ifRowData) {
        DefaultTableModel summaryTablesModel = (DefaultTableModel)((FiltersPanel)this.getUI()).getTblNetworkIfActiveRulesModel().getTableModel();
        summaryTablesModel.addRow(ifRowData);
    }

    private void addToSummaryTableWireless(Vector<Object> ifRowData) {
        DefaultTableModel summaryTablesModel = (DefaultTableModel)((FiltersPanel)this.getUI()).getTblWirelessIfActiveRulesModel().getTableModel();
        summaryTablesModel.addRow(ifRowData);
    }

    protected void configureMOs(List<Object> managedObjects, List<InvalidValue> invalidValues) {
        Object direction;
        String ruleName;
        DynamicTableRowMO entry;
        RbL2FilteringRuleTable l2Table = (RbL2FilteringRuleTable)((Object)managedObjects.get(0));
        for (RbL2FilteringRuleEntry entry2 : l2Table.getEntries()) {
            if (entry2.getRbL2FilteringRuleIdx() >= 0L) continue;
            l2Table.removeEntry(entry2.getRowKey());
        }
        ROTableModel model = ((FiltersPanel)this.getUI()).getTblL2RulesModel();
        FormUtil.stopTableEditing((JTable)((FiltersPanel)this.getUI()).getTblL2Rules());
        block27: for (int i = 0; i < model.getRowCount(); ++i) {
            String key = model.getRowKey(i);
            logger.debug((Object)("Key is :" + key));
            switch (model.getRowState(i)) {
                case 1: {
                    l2Table.removeEntry(key);
                    continue block27;
                }
                case 2: {
                    boolean errorOccurred = false;
                    int col = 0;
                    String macAddress = null;
                    String mask = null;
                    entry = new RbL2FilteringRuleEntry();
                    entry.setRbL2FilteringRuleIdx(FiltersConfigForm.getNextNegativeId());
                    ruleName = (String)model.getValueAt(i, col++);
                    if (ruleName == null || ruleName.trim().length() == 0 || ruleName.length() > 32) {
                        invalidValues.add(new InvalidValue(i18n.translateString("NameLengthBetwen1And32"), RbL3L4FilteringRuleEntry.class, i18n.translateString("rbL2FilteringRuleName"), (Object)ruleName, null));
                        errorOccurred = true;
                    }
                    entry.setRbL2FilteringRuleName(ruleName);
                    Object mac = model.getValueAt(i, col++);
                    Object macMask = model.getValueAt(i, col++);
                    direction = model.getValueAt(i, col++);
                    Object ethType = model.getValueAt(i, col++);
                    Integer interfaceIdx = (Integer)model.getValueAt(i, col++);
                    try {
                        int type = Integer.parseInt(ethType.toString(), 16);
                        entry.setRbL2FilteringRuleEthType(type);
                        if (type < 0 || type > 65535) {
                            invalidValues.add(new InvalidValue(i18n.translateString("GenericValueBetween", new Object[]{0, Integer.toHexString(65535).toUpperCase()}), RbL2FilteringRuleEntry.class, i18n.translateString("rbL2FilteringRuleEthType"), (Object)ethType.toString(), null));
                            errorOccurred = true;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        invalidValues.add(new InvalidValue(i18n.translateString("GenericValueBetween", new Object[]{0, Integer.toHexString(65535).toUpperCase()}), RbL2FilteringRuleEntry.class, i18n.translateString("rbL2FilteringRuleEthType"), (Object)ethType.toString(), null));
                        errorOccurred = true;
                    }
                    catch (NullPointerException npe) {
                        invalidValues.add(new InvalidValue(i18n.translateString("EmptyValue"), RbL2FilteringRuleEntry.class, i18n.translateString("rbL2FilteringRuleEthType"), ethType, null));
                        errorOccurred = true;
                    }
                    if (direction == null) {
                        invalidValues.add(new InvalidValue(i18n.translateString("EmptyValue"), RbL2FilteringRuleEntry.class, i18n.translateString("L2Direction"), null, null));
                        errorOccurred = true;
                    } else if (!direction.equals(0)) {
                        if (mac == null || mac.toString().trim().length() == 0) {
                            mac = "00-00-00-00-00-00";
                        }
                        try {
                            macAddress = MacAddress.fromDashedString((String)mac.toString()).toOctetString();
                        }
                        catch (NumberFormatException nfe) {
                            invalidValues.add(new InvalidValue(i18n.translateString("EmptyValue"), RbL2FilteringRuleEntry.class, i18n.translateString("MacAddress"), mac, null));
                            errorOccurred = true;
                        }
                        if (macMask == null || macMask.toString().trim().length() == 0) {
                            macMask = "ff-ff-ff-ff-ff-ff";
                        } else if (macAddress.equals("00:00:00:00:00:00")) {
                            invalidValues.add(new InvalidValue(i18n.translateString("ForMACAnyTheMaskIsNotApplicable"), RbL2FilteringRuleEntry.class, i18n.translateString("Mask"), macMask, null));
                            errorOccurred = true;
                        }
                        try {
                            mask = MacAddress.fromDashedString((String)macMask.toString()).toOctetString();
                        }
                        catch (NumberFormatException nfe) {
                            invalidValues.add(new InvalidValue(i18n.translateString("EmptyValue"), RbL2FilteringRuleEntry.class, i18n.translateString("Mask"), macMask, null));
                            errorOccurred = true;
                        }
                        if (direction.equals(1)) {
                            entry.setRbL2FilteringRuleSrcMacAddress(macAddress);
                            entry.setRbL2FilteringRuleSrcMask(mask);
                        } else if (direction.equals(2)) {
                            entry.setRbL2FilteringRuleDestMacAddress(macAddress);
                            entry.setRbL2FilteringRuleDestMask(mask);
                        }
                    }
                    if (interfaceIdx == null) {
                        invalidValues.add(new InvalidValue(i18n.translateString("EmptyValue"), RbL2FilteringRuleEntry.class, i18n.translateString("L2Interface"), (Object)interfaceIdx, null));
                        errorOccurred = true;
                    }
                    try {
                        entry.setRbInterface(interfaceIdx);
                    }
                    catch (NullPointerException npe) {
                        invalidValues.add(new InvalidValue(i18n.translateString("EmptyValue"), RbL2FilteringRuleEntry.class, i18n.translateString("L2Interface"), null, null));
                        errorOccurred = true;
                    }
                    if (!(entry.getRbL2FilteringRuleDestMacAddress() != null && !entry.getRbL2FilteringRuleDestMacAddress().equals("00:00:00:00:00:00") || entry.getRbL2FilteringRuleSrcMacAddress() != null && !entry.getRbL2FilteringRuleSrcMacAddress().equals("00:00:00:00:00:00") || entry.getRbL2FilteringRuleEthType() != null && !entry.getRbL2FilteringRuleEthType().equals(0))) {
                        invalidValues.add(new InvalidValue(i18n.translateString("MACAddressAndEthTypeAreANY"), RbL2FilteringRuleEntry.class, "", (Object)i18n.translateString("any"), null));
                        errorOccurred = true;
                    }
                    if (null != macAddress && !macAddress.matches("^(\\p{XDigit}{2}:){5}(\\p{XDigit}{2})$") && !macAddress.equals(i18n.translateString("any"))) {
                        invalidValues.add(new InvalidValue(i18n.translateString("MacAddresWrongFormat"), RbL2FilteringRuleEntry.class, "", (Object)macAddress, null));
                        errorOccurred = true;
                    }
                    if (null != mask && !mask.matches("(?i)^((ff:){5}(f[fec80]|[ec80]0)|(ff:){4}(f[ec80]|[ec80]0):00|(ff:){3}(f[ec80]|[ec80]0)(:00){2}|(ff:){2}(f[ec80]|[ec80]0)(:00){3}|ff:(f[ec80]|[ec80]0)(:00){4}|(f[fec80]|[ec8]0)(:00){5})$") && !mask.equals(i18n.translateString("notApplicable"))) {
                        invalidValues.add(new InvalidValue(i18n.translateString("MacMaskWrongFormat"), RbL2FilteringRuleEntry.class, "", (Object)mask, null));
                        errorOccurred = true;
                    }
                    if (!errorOccurred && !this.checkIfL2EntryIsUnique(l2Table, (RbL2FilteringRuleEntry)entry, direction)) {
                        invalidValues.add(new InvalidValue(i18n.translateString("RuleMustBeUnique"), RbL2FilteringRuleEntry.class, "", (Object)entry.getRbL2FilteringRuleName(), null));
                        errorOccurred = true;
                    }
                    if (errorOccurred) continue block27;
                    l2Table.addEntry((TableRowMO)entry);
                    model.setRowState(i, 0);
                    continue block27;
                }
                case 3: {
                    entry = (RbL2FilteringRuleEntry)l2Table.findEntry(key);
                    if (entry.getRbInterface().intValue() == ((Integer)model.getValueAt(i, model.getColumnCount() - 1)).intValue()) continue block27;
                    entry.setRbInterface((Integer)model.getValueAt(i, model.getColumnCount() - 1));
                }
            }
        }
        RbL3L4FilteringRuleTable l34Table = (RbL3L4FilteringRuleTable)((Object)managedObjects.get(1));
        for (RbL3L4FilteringRuleEntry entry3 : l34Table.getEntries()) {
            if (entry3.getRbL34FilteringRuleIdx() >= 0L) continue;
            l34Table.removeEntry(entry3.getRowKey());
        }
        model = ((FiltersPanel)this.getUI()).getTblL34RulesModel();
        FormUtil.stopTableEditing((JTable)((FiltersPanel)this.getUI()).getTblL34Rules());
        block29: for (int i = 0; i < model.getRowCount(); ++i) {
            String key = model.getRowKey(i);
            logger.debug((Object)("Key is :" + key));
            switch (model.getRowState(i)) {
                case 1: {
                    l34Table.removeEntry(key);
                    continue block29;
                }
                case 2: {
                    boolean errorOccurred = false;
                    int col = 0;
                    entry = new RbL3L4FilteringRuleEntry();
                    entry.setRbL34FilteringRuleIdx(FiltersConfigForm.getNextNegativeId());
                    ruleName = (String)model.getValueAt(i, col++);
                    if (ruleName == null || ruleName.trim().length() == 0 || ruleName.length() > 32) {
                        invalidValues.add(new InvalidValue(i18n.translateString("NameLengthBetwen1And32"), RbL3L4FilteringRuleEntry.class, i18n.translateString("rbL34FilteringRuleName"), (Object)ruleName, null));
                        errorOccurred = true;
                    }
                    entry.setRbL34FilteringRuleName(ruleName);
                    String ip = (String)model.getValueAt(i, col++);
                    String mask = (String)model.getValueAt(i, col++);
                    direction = model.getValueAt(i, col++);
                    Object protocol = model.getValueAt(i, col++);
                    Object portNo = model.getValueAt(i, col++);
                    Object portDirection = model.getValueAt(i, col++);
                    Integer port = new Integer(0);
                    try {
                        entry.setRbL34FilteringRuleIpProtocol(Integer.valueOf(protocol.toString()));
                    }
                    catch (NumberFormatException nfe) {
                        invalidValues.add(new InvalidValue(i18n.translateString("GenericValueBetween", new Object[]{0, 255}), RbL3L4FilteringRuleEntry.class, i18n.translateString("rbL34FilteringRuleIpProtocol"), protocol, null));
                        errorOccurred = true;
                    }
                    catch (NullPointerException npe) {
                        if (null == portNo || !portNo.equals("65535") && !portDirection.equals(0)) {
                            invalidValues.add(new InvalidValue(i18n.translateString("EmptyValue"), RbL3L4FilteringRuleEntry.class, i18n.translateString("rbL34FilteringRuleIpProtocol"), protocol, null));
                            errorOccurred = true;
                        }
                        entry.setRbL34FilteringRuleIpProtocol(255);
                        logger.debug((Object)("NullPointerException.\nAsume protocol is null in which case is set as any.\nHere is the error:\n" + npe.getMessage()));
                    }
                    Integer interfaceIdx = (Integer)model.getValueAt(i, col++);
                    if (null != ip && ip.equalsIgnoreCase("any")) {
                        ip = "254.255.255.255";
                    }
                    if (direction == null) {
                        invalidValues.add(new InvalidValue(i18n.translateString("EmptyValue"), RbL3L4FilteringRuleEntry.class, i18n.translateString("L34Direction"), null, null));
                        errorOccurred = true;
                    } else if (direction.equals(1)) {
                        entry.setRbL34FilteringRuleSrcIpAddress(ip);
                        entry.setRbL34FilteringRuleSrcMask(mask);
                    } else if (direction.equals(2)) {
                        entry.setRbL34FilteringRuleDestIpAddress(ip);
                        entry.setRbL34FilteringRuleDestMask(mask);
                    }
                    if (mask == null || mask.equals("")) {
                        invalidValues.add(new InvalidValue(i18n.translateString("EmptyValue"), RbL3L4FilteringRuleEntry.class, i18n.translateString("Mask"), (Object)mask, null));
                        errorOccurred = true;
                    }
                    if (ip == null || ip.equals("")) {
                        invalidValues.add(new InvalidValue(i18n.translateString("EmptyValue"), RbL3L4FilteringRuleEntry.class, i18n.translateString("Ip"), (Object)ip, null));
                        errorOccurred = true;
                    }
                    if (portDirection == null) {
                        invalidValues.add(new InvalidValue(i18n.translateString("EmptyValue"), RbL3L4FilteringRuleEntry.class, i18n.translateString("PortDirection"), portDirection, null));
                        errorOccurred = true;
                    } else if (!portDirection.equals(0)) {
                        try {
                            port = Integer.valueOf(String.valueOf(portNo));
                        }
                        catch (NumberFormatException nfe) {
                            invalidValues.add(new InvalidValue(i18n.translateString("EmptyValue"), RbL3L4FilteringRuleEntry.class, i18n.translateString("Port"), portNo, null));
                            errorOccurred = true;
                        }
                        if (portDirection.equals(1)) {
                            entry.setRbL34FilteringRuleSrcUdpTcpPort(port);
                        } else if (portDirection.equals(2)) {
                            entry.setRbL34FilteringRuleDestUdpTcpPort(port);
                        }
                    } else {
                        entry.setRbL34FilteringRuleSrcUdpTcpPort(65535);
                    }
                    if (interfaceIdx == null) {
                        invalidValues.add(new InvalidValue(i18n.translateString("EmptyValue"), RbL2FilteringRuleEntry.class, i18n.translateString("L34Interface"), (Object)interfaceIdx, null));
                        errorOccurred = true;
                    }
                    try {
                        entry.setRbInterface(interfaceIdx);
                    }
                    catch (Exception e) {
                        invalidValues.add(new InvalidValue(i18n.translateString("EmptyValue"), RbL2FilteringRuleEntry.class, i18n.translateString("L34Interface"), null, null));
                        errorOccurred = true;
                    }
                    if (!(entry.getRbL34FilteringRuleDestIpAddress() != null && !entry.getRbL34FilteringRuleDestIpAddress().equals("254.255.255.255") || entry.getRbL34FilteringRuleSrcIpAddress() != null && !entry.getRbL34FilteringRuleSrcIpAddress().equals("254.255.255.255") || entry.getRbL34FilteringRuleIpProtocol() != null && !entry.getRbL34FilteringRuleIpProtocol().equals(255))) {
                        invalidValues.add(new InvalidValue(i18n.translateString("IPAddressAndIPProtocolAreANY"), RbL3L4FilteringRuleEntry.class, "", (Object)i18n.translateString("any"), null));
                        errorOccurred = true;
                    }
                    if (null != ip && (!ip.matches("^(([0-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])){3}|254\\.255\\.255\\.255)$") && !ip.equalsIgnoreCase("any") || ip.equals("0.0.0.0") || ip.equals("255.255.255.255"))) {
                        invalidValues.add(new InvalidValue(i18n.translateString("IpAddresWrongFormat"), RbL3L4FilteringRuleEntry.class, i18n.translateString("IP"), (Object)ip, null));
                        errorOccurred = true;
                    }
                    if (!(null == mask || mask.equals("") || mask.matches("^255\\.255\\.255\\.(255|254|252|248|240|224|192|128|0)$|^255\\.255\\.(254|252|248|240|224|192|128|0)\\.0$|^255\\.(254|252|248|240|224|192|128|0)\\.0\\.0$|^(254|252|248|240|224|192|128|0)\\.0\\.0\\.0$") || mask.equals(i18n.translateString("notApplicable")))) {
                        invalidValues.add(new InvalidValue(i18n.translateString("IpMaskWrongFormat"), RbL3L4FilteringRuleEntry.class, i18n.translateString("Mask"), (Object)mask, null));
                        errorOccurred = true;
                    }
                    if (!errorOccurred && !this.checkIfL34EntryIsUnique(l34Table, (RbL3L4FilteringRuleEntry)entry, direction, portDirection)) {
                        invalidValues.add(new InvalidValue(i18n.translateString("L34RuleMustBeUnique"), RbL3L4FilteringRuleEntry.class, "", (Object)entry.getRbL34FilteringRuleName(), null));
                        errorOccurred = true;
                    }
                    if (errorOccurred) continue block29;
                    l34Table.addEntry((TableRowMO)entry);
                    model.setRowState(i, 0);
                    continue block29;
                }
                case 3: {
                    entry = (RbL3L4FilteringRuleEntry)l34Table.findEntry(key);
                    if (entry.getRbInterface().intValue() == ((Integer)model.getValueAt(i, model.getColumnCount() - 1)).intValue()) continue block29;
                    entry.setRbInterface((Integer)model.getValueAt(i, model.getColumnCount() - 1));
                }
            }
        }
    }

    private boolean checkIfL2EntryIsUnique(RbL2FilteringRuleTable l2Table, RbL2FilteringRuleEntry entry, Object direction) {
        block4: {
            block5: {
                block3: {
                    if (!direction.equals(0)) break block3;
                    for (RbL2FilteringRuleEntry rule : l2Table.getEntries()) {
                        if (!rule.getRbL2FilteringRuleEthType().equals(entry.getRbL2FilteringRuleEthType()) || rule.getRbL2FilteringRuleSrcMacAddress() != null && !rule.getRbL2FilteringRuleSrcMacAddress().equals("00:00:00:00:00:00") || rule.getRbL2FilteringRuleDestMacAddress() != null && !rule.getRbL2FilteringRuleDestMacAddress().equals("00:00:00:00:00:00")) continue;
                        return false;
                    }
                    break block4;
                }
                if (!direction.equals(1)) break block5;
                for (RbL2FilteringRuleEntry rule : l2Table.getEntries()) {
                    if (rule.getRbL2FilteringRuleDestMacAddress() == null || !rule.getRbL2FilteringRuleEthType().equals(entry.getRbL2FilteringRuleEthType()) || !rule.getRbL2FilteringRuleSrcMacAddress().equalsIgnoreCase(entry.getRbL2FilteringRuleSrcMacAddress()) || !rule.getRbL2FilteringRuleSrcMask().equalsIgnoreCase(entry.getRbL2FilteringRuleSrcMask())) continue;
                    return false;
                }
                break block4;
            }
            if (!direction.equals(2)) break block4;
            for (RbL2FilteringRuleEntry rule : l2Table.getEntries()) {
                if (rule.getRbL2FilteringRuleDestMacAddress() == null || !rule.getRbL2FilteringRuleEthType().equals(entry.getRbL2FilteringRuleEthType()) || !rule.getRbL2FilteringRuleDestMacAddress().equalsIgnoreCase(entry.getRbL2FilteringRuleDestMacAddress()) || !rule.getRbL2FilteringRuleDestMask().equalsIgnoreCase(entry.getRbL2FilteringRuleDestMask())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkIfL34EntryIsUnique(RbL3L4FilteringRuleTable l34Table, RbL3L4FilteringRuleEntry entry, Object direction, Object portDirection) {
        block17: {
            block19: {
                block21: {
                    block20: {
                        block15: {
                            block18: {
                                block16: {
                                    if (!direction.equals(0)) break block15;
                                    if (!portDirection.equals(0)) break block16;
                                    for (RbL3L4FilteringRuleEntry rule : l34Table.getEntries()) {
                                        if (rule.getRbL34FilteringRuleSrcIpAddress() != null && !rule.getRbL34FilteringRuleSrcIpAddress().equals("254.255.255.255") || rule.getRbL34FilteringRuleSrcMask() != null && !rule.getRbL34FilteringRuleSrcMask().equals("255.255.255.255") || rule.getRbL34FilteringRuleDestIpAddress() != null && !rule.getRbL34FilteringRuleDestIpAddress().equals("254.255.255.255") || rule.getRbL34FilteringRuleDestMask() != null && !rule.getRbL34FilteringRuleDestMask().equals("255.255.255.255") || !rule.getRbL34FilteringRuleIpProtocol().equals(entry.getRbL34FilteringRuleIpProtocol()) || !rule.getRbL34FilteringRuleSrcUdpTcpPort().equals(65535) && !rule.getRbL34FilteringRuleDestUdpTcpPort().equals(65535)) continue;
                                        return false;
                                    }
                                    break block17;
                                }
                                if (!portDirection.equals(1)) break block18;
                                for (RbL3L4FilteringRuleEntry rule : l34Table.getEntries()) {
                                    if (rule.getRbL34FilteringRuleSrcIpAddress() != null && !rule.getRbL34FilteringRuleSrcIpAddress().equals("254.255.255.255") || rule.getRbL34FilteringRuleSrcMask() != null && !rule.getRbL34FilteringRuleSrcMask().equals("255.255.255.255") || rule.getRbL34FilteringRuleDestIpAddress() != null && !rule.getRbL34FilteringRuleDestIpAddress().equals("254.255.255.255") || rule.getRbL34FilteringRuleDestMask() != null && !rule.getRbL34FilteringRuleDestMask().equals("255.255.255.255") || !rule.getRbL34FilteringRuleIpProtocol().equals(entry.getRbL34FilteringRuleIpProtocol()) || !rule.getRbL34FilteringRuleSrcUdpTcpPort().equals(entry.getRbL34FilteringRuleSrcUdpTcpPort())) continue;
                                    return false;
                                }
                                break block17;
                            }
                            if (!portDirection.equals(2)) break block17;
                            for (RbL3L4FilteringRuleEntry rule : l34Table.getEntries()) {
                                if (rule.getRbL34FilteringRuleSrcIpAddress() != null && !rule.getRbL34FilteringRuleSrcIpAddress().equals("254.255.255.255") || rule.getRbL34FilteringRuleSrcMask() != null && !rule.getRbL34FilteringRuleSrcMask().equals("255.255.255.255") || rule.getRbL34FilteringRuleDestIpAddress() != null && !rule.getRbL34FilteringRuleDestIpAddress().equals("254.255.255.255") || rule.getRbL34FilteringRuleDestMask() != null && !rule.getRbL34FilteringRuleDestMask().equals("255.255.255.255") || !rule.getRbL34FilteringRuleIpProtocol().equals(entry.getRbL34FilteringRuleIpProtocol()) || !rule.getRbL34FilteringRuleDestUdpTcpPort().equals(entry.getRbL34FilteringRuleDestUdpTcpPort())) continue;
                                return false;
                            }
                            break block17;
                        }
                        if (!direction.equals(1)) break block19;
                        if (!portDirection.equals(0)) break block20;
                        for (RbL3L4FilteringRuleEntry rule : l34Table.getEntries()) {
                            if (rule.getRbL34FilteringRuleSrcIpAddress() == null || !rule.getRbL34FilteringRuleSrcIpAddress().equals(entry.getRbL34FilteringRuleSrcIpAddress()) || !rule.getRbL34FilteringRuleSrcMask().equalsIgnoreCase(entry.getRbL34FilteringRuleSrcMask()) || !rule.getRbL34FilteringRuleIpProtocol().equals(entry.getRbL34FilteringRuleIpProtocol()) || !rule.getRbL34FilteringRuleSrcUdpTcpPort().equals(65535) && !rule.getRbL34FilteringRuleDestUdpTcpPort().equals(65535)) continue;
                            return false;
                        }
                        break block17;
                    }
                    if (!portDirection.equals(1)) break block21;
                    for (RbL3L4FilteringRuleEntry rule : l34Table.getEntries()) {
                        if (rule.getRbL34FilteringRuleSrcIpAddress() == null || !rule.getRbL34FilteringRuleSrcIpAddress().equals(entry.getRbL34FilteringRuleSrcIpAddress()) || !rule.getRbL34FilteringRuleSrcMask().equalsIgnoreCase(entry.getRbL34FilteringRuleSrcMask()) || !rule.getRbL34FilteringRuleIpProtocol().equals(entry.getRbL34FilteringRuleIpProtocol()) || !rule.getRbL34FilteringRuleSrcUdpTcpPort().equals(entry.getRbL34FilteringRuleSrcUdpTcpPort())) continue;
                        return false;
                    }
                    break block17;
                }
                if (!portDirection.equals(2)) break block17;
                for (RbL3L4FilteringRuleEntry rule : l34Table.getEntries()) {
                    if (rule.getRbL34FilteringRuleSrcIpAddress() == null || !rule.getRbL34FilteringRuleSrcIpAddress().equals(entry.getRbL34FilteringRuleSrcIpAddress()) || !rule.getRbL34FilteringRuleSrcMask().equalsIgnoreCase(entry.getRbL34FilteringRuleSrcMask()) || !rule.getRbL34FilteringRuleIpProtocol().equals(entry.getRbL34FilteringRuleIpProtocol()) || !rule.getRbL34FilteringRuleDestUdpTcpPort().equals(entry.getRbL34FilteringRuleDestUdpTcpPort())) continue;
                    return false;
                }
                break block17;
            }
            if (direction.equals(2)) {
                if (portDirection.equals(0)) {
                    for (RbL3L4FilteringRuleEntry rule : l34Table.getEntries()) {
                        if (rule.getRbL34FilteringRuleDestIpAddress() == null || !rule.getRbL34FilteringRuleDestIpAddress().equals(entry.getRbL34FilteringRuleDestIpAddress()) || !rule.getRbL34FilteringRuleDestMask().equalsIgnoreCase(entry.getRbL34FilteringRuleDestMask()) || !rule.getRbL34FilteringRuleIpProtocol().equals(entry.getRbL34FilteringRuleIpProtocol()) || !rule.getRbL34FilteringRuleSrcUdpTcpPort().equals(65535) && !rule.getRbL34FilteringRuleDestUdpTcpPort().equals(65535)) continue;
                        return false;
                    }
                } else if (portDirection.equals(1)) {
                    for (RbL3L4FilteringRuleEntry rule : l34Table.getEntries()) {
                        if (rule.getRbL34FilteringRuleDestIpAddress() == null || !rule.getRbL34FilteringRuleDestIpAddress().equals(entry.getRbL34FilteringRuleDestIpAddress()) || !rule.getRbL34FilteringRuleDestMask().equalsIgnoreCase(entry.getRbL34FilteringRuleDestMask()) || !rule.getRbL34FilteringRuleIpProtocol().equals(entry.getRbL34FilteringRuleIpProtocol()) || !rule.getRbL34FilteringRuleSrcUdpTcpPort().equals(entry.getRbL34FilteringRuleSrcUdpTcpPort())) continue;
                        return false;
                    }
                } else if (portDirection.equals(2)) {
                    for (RbL3L4FilteringRuleEntry rule : l34Table.getEntries()) {
                        if (rule.getRbL34FilteringRuleDestIpAddress() == null || !rule.getRbL34FilteringRuleDestIpAddress().equals(entry.getRbL34FilteringRuleDestIpAddress()) || !rule.getRbL34FilteringRuleDestMask().equalsIgnoreCase(entry.getRbL34FilteringRuleDestMask()) || !rule.getRbL34FilteringRuleIpProtocol().equals(entry.getRbL34FilteringRuleIpProtocol()) || !rule.getRbL34FilteringRuleDestUdpTcpPort().equals(entry.getRbL34FilteringRuleDestUdpTcpPort())) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public String getTitle() {
        return "Filters";
    }

    public String getHelpTopic() {
        if (VersionFactory.getInstance().createVersion(this.ctx.getEquipment().getRunningSoftwareVersion()).isOlderThan((Version)new DefaultVersion("4.0"))) {
            return "ngnms.rb.help.filters";
        }
        return "ngnms.rb.help.tdd_filters";
    }
}

